''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  144 LED GAME CONSOLE AND MESSAGE SCROLLER - Art 2010  '
'                                                        '
'   Compiled With MicroEngineering Labs PicBasic Pro     '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                                                        '
' Version 3 - 21/02/10                                   '
' Fixed speed of sine wave text message scroller effect. '
' Improved Serial Message programming mode to accept     '
' both upper case, and lower case characters as input.   '
' Optimised a lot of code to accomodate the tables in    '
' program memory again, and free up on-chip memory for   '
' the scrolling text message. Most of this feature was   '
' done in my solar powered technology tent in the bush!  '
' Improved random shape routines for the Tetris clone,   '
' Added sound support for both of the classic games.     '
' Implemented Pong Screensaver demo from old test code.  '
'                                                        '
' Version 2 - 16/02/10                                   '
' Fixed Flashing Snake bug. Snake would not flash if it  '
' collided with top, bottom, or left walls for end game. '
' Improved Tetris scoring system. One point is awarded   '
' for every shape placement, and multiple points are     '
' awarded for completing rows. Points increase if the    '
' player completes multiple rows simultaneously.         '
' Condensed code and made room for sprite test routine.  '
' Improved message scroller to work without an EEPROM.   '
' Re-implemented serial message programming mode.        '
'                                                        '
' Version 1 - 15/02/10                                   '
' First release version features Snake and Tetris Games. '
'                                                        '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
@ DEVICE LVP_OFF,BOD_OFF,HS_OSC					'set device configuration
DEFINE OSC 20							'hardware is using a 20MHz crystal
'
DATA @$00," " : DATA @$01," " : DATA @$02," " : DATA @$03,"A"	'default text message for scroller
DATA @$04,"R" : DATA @$05,"T" : DATA @$06," " : DATA @$07,"2"	'
DATA @$08,"0" : DATA @$09,"1" : DATA @$0A,"0" : DATA @$0B,"!"	'
DATA @$0C," " : DATA @$0D," " : DATA @$0E," " : DATA @$0F," "	'
'
DATA @$FC,12							'text message length
DATA @$FD,49 : DATA @$FE,125 : DATA @$FF,0			'set initial high scores for games
'
segs var byte [96]					'snake cells
cols var byte [18]					'
digits var byte [4]					'
C0 var cols[0] : C1 var cols[1]				'
C2 var cols[2] : C3 var cols[3]				'
C4 var cols[4] : C5 var cols[5]				'
C6 var cols[6] : C7 var cols[7]				'
C8 var cols[8] : C9 var cols[9]				'
C10 var cols[10] : C11 var cols[11]			'
C12 var cols[12] : C13 var cols[13]			'
C14 var cols[14] : C15 var cols[15]			'
C16 var cols[16] : C17 var cols[17]			'
D0 var digits[0] : D1 var digits[1]			'
D2 var digits[2] : D3 var digits[3]			'
epin var byte						'eeprom index
length var word						'
cntr var byte						'counter
speed var byte						'speed counter
W0 var byte						'work variable
W2 var byte						'work variable
W3 var byte						'
mode var bit						'
wchar var bit						'
fun var bit						'
demo var bit						'
snake var bit						'
dirx var bit						'demo screen variables
diry var bit						'
anim var bit						'invader frame select
ix var byte						'
iy var byte						'
sspd var byte						'
balx var byte						'
baly var byte						'
bata var byte						'
batb var byte						'
si var byte						'sin wave index
cntt var byte						'snake variables
cntx var byte						'
cnti var byte						'
ii var byte						'array index
segment var byte					'
sx var byte						'
sy var byte						'
px var byte						'
py var byte						'
direction var byte					'
slen var byte						'
tscore var word						'
thiscore var word					'
rnd var byte						'random variables
rndx var byte						'
trypel var bit						'
gameover var bit					'
sndcnt var byte						'
sndout var byte						'send sound code flag
death var byte						'
cntq var byte						'counter
cntp var byte						'counter
cntw var byte						'counter
cntn var byte						'counter
cntz var byte						'tetris counter
tetx var byte						'tetris x coordinate
tety var byte						'tetris y coordinate
tetr var byte						'tetris rotation
blocksx var byte [4]					'current shape coordinates
blocksy var byte [4]					'
blockax var blocksx[0]					'
blockbx var blocksx[1]					'
blockcx var blocksx[2]					'
blockdx var blocksx[3]					'
blockay var blocksy[0]					'
blockby var blocksy[1]					'
blockcy var blocksy[2]					'
blockdy var blocksy[3]					'
tetrisc var byte					'
tetrisd var byte					'
cntj var byte						'
lcnt var byte						'
rnds var byte						'frame counter used for random function
newshape var bit					'new shape flag
norot var bit						'rotation collision flag
'
shape var slen						'set aliases for Tetris game
W1 var ii						'
hitfloor var trypel					'
hitroof var dirx					'
olddir var px						'
ttimer var py						'
tetrisa var ix						'
tetrisb var iy						'
fbit var diry						'
'
hiscore var thiscore.byte0				'set aliases for Snake game
hiscorex var thiscore.byte1				'
score var tscore.byte0					'
'
up CON 0						'direction constants
down CON 1						'
left CON 2						'
right CON 3						'
'
'************************************* Startup ******************************************
'
pause 100						'stabilise power supply
ADCON1 = %00000110					'set all pins digital
trisb = 0 : trise = 0					'set inputs / outputs
trisa.0 = 0 : trise.1 = 1				'
trisa.1 = 1 : trisa.4 = 1				'
trisa.2 = 1 : trisa.3 = 1				'
trisa.5 = 1 : trise.0 = 1				'
trisc = $FF : trisd = $FF				'
epin = 0						'set initial variable values
sndout = 80						'set sound frequency
sndcnt = 20						'set sound length
fun = 0 : demo = 0					'
snake = 0 : speed = 0					'
wchar = 0 : sspd = 3					'
bata = 0 : batb = 0					'
dirx = 0 : diry = 0					'
rnd = 0 : rndx = 0					'
'
FOR cntr = 0 TO 17					'
cols[cntr] = 0						'
NEXT cntr						'
pause 10						'
'
mode = 1						'
IF porta.1 = 1 THEN mode = 0				'check DIP switch 1
fun = 1							'
IF porta.4 = 1 THEN fun = 0				'check DIP switch 2
demo = 0						'
IF porta.2 = 1 THEN demo = 1				'check DIP switch 3
snake = 0						'
IF porte.0 = 1 THEN snake = 1				'check DIP switch 4
'
IF snake = 1 THEN snakegamest				'start Snake game
IF fun = 1 THEN tetrisgamest				'start Tetris game
IF demo = 1 AND mode = 1 THEN graphics			'start Pong screensaver
IF demo = 1 THEN graphicsB				'start sprite demo
IF mode = 1 THEN program				'start serial programming mode
'
prgx:							'read message length
PAUSE 100						'
READ $FC,length						'
length = length + 3					'add length for lead in spaces
epin = $0						'set to lead in
gosub getmessage					'
norot = 0						'
'
'******************************** Message Scroller **************************************
'
cycle:
speed = speed + 1					'
IF norot = 0 THEN speed = $FF				'
IF speed > sspd-1 THEN					'
speed = 0						'reset counter
lcnt = lcnt + 1						'
IF lcnt = 6 THEN					'
lcnt = 0						'
epin = epin + 1						'advance eeprom address
ENDIF							'
IF epin = length THEN					'check for end address
epin = 0						'set restart address
norot = 1						'
ENDIF							'
gosub getmessage					'
'
'
trypel = 1						'
IF porta.4 = 1 THEN					'
trypel = 0						'
ENDIF							'
'
IF porta.2 = 1 THEN					'check for DIP switch 3
FOR balx = 0+lcnt TO 17+lcnt				'sine wave effect
LOOKUP si,[0,0,1,1,2,2,2,3,3,4,4,3,3,2,2,2,1,1,0,0],baly'
tetr = segs[balx]					'
IF baly = 0 THEN					'
tetr = tetr >> 2					'
tetr.bit7 = trypel					'
tetr.bit6 = trypel					'
ENDIF							'
IF baly = 1 THEN					'
tetr = tetr >> 1					'
tetr.bit7 = trypel					'
ENDIF							'
IF baly = 3 THEN					'
tetr = tetr << 1					'
tetr.bit0 = trypel					'
ENDIF							'
IF baly = 4 THEN					'
tetr = tetr << 2					'
tetr.bit0 = trypel					'
tetr.bit1 = trypel					'
ENDIF							'
segs[balx] = tetr					'
si = si + 1						'
IF si > 19 THEN						'
si = 0							'
ENDIF							'
NEXT balx						'
ENDIF							'
'
ENDIF							'
'
FOR ix = 0 TO 17					'
cols[ix] = segs[ix+lcnt]				'
NEXT ix							'
'
call fixdat						'invert and reverse bits
'
IF porte.0 = 1 THEN					'check for DIP switch 4
IF dirx = 0 THEN					'bounce effect
FOR batb = 0 TO bata					'
call rotbitsright					'
NEXT batb						'
IF diry = 0 THEN					'
IF wchar = 0 THEN					'
bata = bata + 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 3 THEN diry = 1				'
ELSE							'
IF wchar = 0 THEN					'
bata = bata - 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 0 THEN					'
dirx = 1						'
diry = 0						'
ENDIF							'
ENDIF							'
ELSE							'
FOR batb = 0 TO bata					'
call rotbitsleft					'
NEXT batb						'
IF diry = 0 THEN					'
IF wchar = 0 THEN					'
bata = bata + 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 3 THEN diry = 1				'
ELSE							'
IF wchar = 0 THEN					'
bata = bata - 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 0 THEN					'
dirx = 0						'
diry = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
ENDIF							'
'
IF norot = 1 THEN					'
gosub drawscreen					'
ENDIF							'
'
IF porta.1 = 0 THEN					'check DIP switch 1
sspd = 1						'
ELSE							'
sspd = 3						'
ENDIF							'
'
goto cycle						'
'
getmessage:
cntn = 0
FOR W3 = 0 TO 3
READ epin+W3,W0
gosub getchar						'
C5 = 0
FOR cntw = 0 TO 5
segs[cntn] = cols[cntw]					'
cntn = cntn + 1
NEXT cntw
NEXT W3
return							'
'
'****************************** Shared Graphics Routines ********************************
'
fixdat:
IF (porta.4 = 1) OR (fun = 1) OR (snake = 1) OR (demo = 1) THEN
@ comf _C0						;
@ comf _C1						;
@ comf _C2						;
@ comf _C3						;
@ comf _C4						;
@ comf _C5						;
@ comf _C6						;
@ comf _C7						;
@ comf _C8						;
@ comf _C9						;
@ comf _C10						;
@ comf _C11						;
@ comf _C12						;
@ comf _C13						;
@ comf _C14						;
@ comf _C15						;
@ comf _C16						;
@ comf _C17						;
ENDIF							'
'
FOR cntj = 0 TO 17
cols[cntj] = cols[cntj] REV 8
NEXT cntj
return							'
'
error:
FOR cntr = 0 TO 5					'
porta.0 = 1						'
pause 500						'
porta.0 = 0						'
pause 500						'
NEXT cntr						'
return							'
'
rotbitsright:
@  rrf 		_C0		,F			;bitwise rotate right
@  bcf		_C0		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C0		,7			;
@  rrf 		_C1		,F			;
@  bcf		_C1		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C1		,7			;
@  rrf 		_C2		,F			;
@  bcf		_C2		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C2		,7			;
@  rrf 		_C3		,F			;
@  bcf		_C3		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C3		,7			;
@  rrf 		_C4		,F			;
@  bcf		_C4		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C4		,7			;
@  rrf 		_C5		,F			;
@  bcf		_C5		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C5		,7			;
@  rrf 		_C6		,F			;
@  bcf		_C6		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C6		,7			;
@  rrf 		_C7		,F			;
@  bcf		_C7		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C7		,7			;
@  rrf 		_C8		,F			;
@  bcf		_C8		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C8		,7			;
@  rrf 		_C9		,F			;
@  bcf		_C9		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C9		,7			;
@  rrf 		_C10		,F			;
@  bcf		_C10		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C10		,7			;
@  rrf 		_C11		,F			;
@  bcf		_C11		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C11		,7			;
@  rrf 		_C12		,F			;
@  bcf		_C12		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C12		,7			;
@  rrf 		_C13		,F			;
@  bcf		_C13		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C13		,7			;
@  rrf 		_C14		,F			;
@  bcf		_C14		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C14		,7			;
@  rrf 		_C15		,F			;
@  bcf		_C15		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C15		,7			;
@  rrf 		_C16		,F			;
@  bcf		_C16		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C16		,7			;
@  rrf 		_C17		,F			;
@  bcf		_C17		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C17		,7			;
return							'
'
rotbitsleft:
@  rlf 		_C0		,F			;bitwise rotate left
@  bcf		_C0		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C0		,0			;
@  rlf 		_C1		,F			;
@  bcf		_C1		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C1		,0			;
@  rlf 		_C2		,F			;
@  bcf		_C2		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C2		,0			;
@  rlf 		_C3		,F			;
@  bcf		_C3		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C3		,0			;
@  rlf 		_C4		,F			;
@  bcf		_C4		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C4		,0			;
@  rlf 		_C5		,F			;
@  bcf		_C5		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C5		,0			;
@  rlf 		_C6		,F			;
@  bcf		_C6		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C6		,0			;
@  rlf 		_C7		,F			;
@  bcf		_C7		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C7		,0			;
@  rlf 		_C8		,F			;
@  bcf		_C8		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C8		,0			;
@  rlf 		_C9		,F			;
@  bcf		_C9		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C9		,0			;
@  rlf 		_C10		,F			;
@  bcf		_C10		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C10		,0			;
@  rlf 		_C11		,F			;
@  bcf		_C11		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C11		,0			;
@  rlf 		_C12		,F			;
@  bcf		_C12		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C12		,0			;
@  rlf 		_C13		,F			;
@  bcf		_C13		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C13		,0			;
@  rlf 		_C14		,F			;
@  bcf		_C14		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C14		,0			;
@  rlf 		_C15		,F			;
@  bcf		_C15		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C15		,0			;
@  rlf 		_C16		,F			;
@  bcf		_C16		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C16		,0			;
@  rlf 		_C17		,F			;
@  bcf		_C17		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C17		,0			;
return							'
'
drawbit:
IF balx > 17 THEN return				'
IF baly > 7 THEN return					'
W0 = cols[balx]						'
W0.0(7-baly) = 1
cols[balx] = W0						'
return							'
'
vdrawbit:
IF balx > 7 THEN return					'
IF baly > 17 THEN return				'
W0 = cols[baly]						'
W0.0(balx) = 1
cols[baly] = W0						'
return							'
'
drawscreen:						'draw screen
porta.0 = 1						'
portb = C17 : high portd.7 : gosub sendx : low portd.7	'
portb = C16 : high portd.6 : gosub sendx : low portd.6	'
portb = C15 : high portd.5 : gosub sendx : low portd.5	'
portb = C14 : high portd.4 : gosub sendx : low portd.4	'
portb = C13 : high portd.3 : gosub sendx : low portd.3	'
portb = C12 : high portd.2 : gosub sendx : low portd.2	'
portb = C11 : high portd.1 : gosub sendx : low portd.1	'
portb = C10 : high portd.0 : gosub sendx : low portd.0	'
portb = C9 : high portc.7 : gosub sendx : low portc.7	'
portb = C8 : high portc.6 : gosub sendx : low portc.6	'
portb = C7 : high portc.5 : gosub sendx : low portc.5	'
portb = C6 : high portc.4 : gosub sendx : low portc.4	'
drawchar:
portb = C5 : high portc.3 : gosub sendx : low portc.3	'draw character
portb = C4 : high portc.2 : gosub sendx : low portc.2	'
portb = C3 : high portc.1 : gosub sendx : low portc.1	'
portb = C2 : high portc.0 : gosub sendx : low portc.0	'
portb = C1 : high porta.5 : gosub sendx : low porta.5	'
portb = C0 : high porta.3 : gosub sendx : low porta.3	'
'
IF sndcnt != 0 THEN					'
sndcnt = sndcnt - 1					'
ENDIF							'
'
trise.2 = 1						'
rnds = rnds + 1						'
return							'
'
clrscreen:
FOR cntq = 0 TO 17					'clear screen
cols[cntq] = 0						'
NEXT cntq						'
return							'
'
'*********************************** Snake Game *****************************************
'
snakegamest:
WHILE porte.0 = 1					'wait for finger off button
gosub loadtitle						'load snake title screen
call fixdat						'
call drawscreen						'
@ incf	_cntq						;
@ clrwdt						;
WEND							'
'
FOR cntp = 0 TO 36					'delay title screen display
gosub loadtitle						'
call fixdat						'
call drawscreen						'
NEXT cntp						'
gosub randomise						'randomise initial pellet location
'
snakegame:
READ $FD,hiscore						'
speed = 0						'
sx = 0							'
sy = 0							'
balx = 0						'
baly = 0						'
bata = 0						'
batb = 0						'
sspd = 21						'initial game speed
cntp = 0						'speed increase timer
death = $FF						'
gosub clrsnake						'initialise game
'
gfxc:							'
gosub clrscreen						'
speed = speed + 1					'
'
IF porta.4 = 0 THEN					'UP
direction = up						'
ENDIF							'
IF porte.0 = 1 THEN					'DOWN
direction = down					'
ENDIF							'
IF porta.2 = 1 THEN					'LEFT
direction = left					'
ENDIF							'
IF porta.1 = 0 THEN					'RIGHT
direction = right					'
ENDIF							'
'
IF speed > sspd THEN					'
speed = 0						'
IF death = $FF THEN					'death
gosub movesnake						'
ENDIF							'death
ENDIF							'
'
IF gameover = 1 THEN					'restart game
death = death + 1					'
IF death = 5 THEN					'
sndout = 50						'set sound frequency
sndcnt = 50						'set sound length
ENDIF							'
sspd = 21						'reset game speed
ENDIF							'
'
IF death = 160 THEN					'
gosub showscore						'
IF score > hiscore THEN					'
hiscore = score						'
WRITE $FD, score					'
ENDIF							'
goto snakegame						'
ENDIF							'
'
IF death.bit4 = 1 THEN					'flash snake if dead
FOR cnti = 0 TO slen					'draw snake
segment = segs[cnti]					'
gosub decodesegment					'
balx = sx : baly = sy					'
gosub drawbit						'
NEXT cnti						'
balx = px : baly = py					'draw pellet
gosub drawbit						'
ENDIF							'
'
call fixdat						'
call drawscreen						'
goto gfxc						'
'
'
rotatesnake:
ii = 95							'
FOR cntx = 1 to 95					'
segs[ii] = segs[ii - 1]					'
ii = ii - 1						'
NEXT cntx						'
segs[0] = segment					'
return							'
'
encodesegment:
segment = sy						'
segment = segment << 5					'
segment = segment + sx					'
return							'
'
decodesegment:
@ clrf _sy						;
@ clrf _sx						;
sx.bit0 = segment.bit0					'
sx.bit1 = segment.bit1					'
sx.bit2 = segment.bit2					'
sx.bit3 = segment.bit3					'
sx.bit4 = segment.bit4					'
sy.bit0 = segment.bit5					'
sy.bit1 = segment.bit6					'
sy.bit2 = segment.bit7					'
return							'
'
clrsnake:
FOR cntt = 0 to 95					'
segs[cntt] = $FF					'
NEXT cntt						'
segs[0] = %10000101					'y=4,x=5 start head position
segs[1] = %10000100					'y=4,x=4
segs[2] = %10000011					'y=4,x=3 start tail position
direction = 9						'set invalid start direction
slen = 2						'set start snake length
retry:
gosub newpellet						'get new pellet coordinates
IF trypel = 1 THEN					'check if new pellet is a snake cell
goto retry						'get another set of coords
ENDIF							'
'
score = 0						'reset score
gameover = 0						'reset game over flag
return							'
'
movesnake:
IF direction > 3 THEN					'
direction = direction - 1				'
return							'
ENDIF							'
'
segment = segs[0]					'
gosub decodesegment					'
'
IF direction = up THEN					'check for new direction
sy = sy - 1						'
ENDIF							'
IF direction = down THEN				'
sy = sy + 1						'
ENDIF							'
IF direction = left THEN				'
sx = sx - 1						'
ENDIF							'
IF direction = right THEN				'
sx = sx + 1						'
ENDIF							'
'
IF (sx = px) AND (sy = py) THEN				'check for got pellet
IF slen < 95 THEN					'
slen = slen + 1						'
sndout = 75						'set sound frequency
sndcnt = 5						'set sound length
ENDIF							'
score = score + 1					'increment player score
cntp = cntp + 1						'increment speed increase counter
IF cntp = 3 THEN					'every six pellets eaten
IF sspd > 1 THEN sspd = sspd - 1			'increase speed by one factor
ENDIF							'
retryx:
gosub newpellet						'
IF trypel = 1 THEN					'check if new pellet is a snake cell
goto retryx						'get another set of coords
ENDIF							'
ENDIF							'
'
IF sx = $FF THEN					'check for wall collision
sx = 0
gameover = 1						'
ENDIF							'
IF sy = $FF THEN					'
sy = 0
gameover = 1						'
ENDIF							'
IF sx = 18 THEN						'
sx = 17
gameover = 1						'
ENDIF							'
IF sy = 8 THEN						'
sy = 7
gameover = 1						'
ENDIF							'
'
FOR cnti = 0 TO slen					'check for cell collision
segment = segs[cnti]					'
@ clrf _baly						;
@ clrf _balx						;
balx.bit0 = segment.bit0				'
balx.bit1 = segment.bit1				'
balx.bit2 = segment.bit2				'
balx.bit3 = segment.bit3				'
balx.bit4 = segment.bit4				'
baly.bit0 = segment.bit5				'
baly.bit1 = segment.bit6				'
baly.bit2 = segment.bit7				'
IF (baly = sy) AND (balx = sx) THEN			'
gameover = 1						'
ENDIF							'
NEXT cnti						'
'
gosub encodesegment					'
IF gameover = 0 THEN					'
gosub rotatesnake					'
ENDIF							'
return							'
'
newpellet:
rnd = rnd + 1						'
rndx = rndx + 1						'
IF rnd = 29 THEN					'
rnd = 0							'
ENDIF							'
IF rndx = 30 THEN					'
rndx = 0						'
ENDIF							'
LOOKUP rnd,[12,5,1,16,3,2,10,9,3,14,15,4,17,2,6,13,2,11,8,7,14,10,5,11,6,15,7,9,7,16,0],px
LOOKUP rndx,[3,6,2,5,7,4,0,2,1,5,0,3,7,2,6,0,1,5,3,4,0,4,3,4,2,1,5,0,3,7,6,1],py
gosub checkpellet					'
return							'
'
checkpellet:
trypel = 0						'
FOR cnti = 0 TO slen					'check for cell collision
segment = segs[cnti]					'
@ clrf _baly						;
@ clrf _balx						;
balx.bit0 = segment.bit0				'
balx.bit1 = segment.bit1				'
balx.bit2 = segment.bit2				'
balx.bit3 = segment.bit3				'
balx.bit4 = segment.bit4				'
baly.bit0 = segment.bit5				'
baly.bit1 = segment.bit6				'
baly.bit2 = segment.bit7				'
IF (baly = py) AND (balx = px) THEN			'
trypel = 1						'
ENDIF							'
NEXT cnti						'
return							'
'
'
showscore:
W0 = score DIG 0					'
W0 = W0 + $30						'
gosub getchar						'
C10 = C0						'
C11 = C1						'
C12 = C2						'
C13 = C3						'
C14 = C4						'
W0 = score DIG 1					'
W0 = W0 + $30						'
gosub getchar						'
C7 = C4							'
C6 = C3							'
C5 = C2							'
C4 = C1							'
C3 = C0							'
C2 = 0							'
C1 = 0							'
C0 = 0							'
'
IF score > hiscore THEN					'"!" for highest score
C16 = $79						'
ENDIF							'
'
call fixdat						'
FOR ii = 0 TO 160					'
call drawscreen						'
IF ii > 151 THEN					'
gosub rotbitsright
ENDIF							'
NEXT ii							'
return							'
'
loadtitle:
FOR rndx = 0 TO 17					'
rnd = rndx						'
IF fun = 0 THEN						'
LOOKUP rnd,[$74,$54,$5C,$00,$7C,$40,$7C,$00,$7C,$50,$7C,$00,$7C,$10,$6C,$00,$7C,$54],rnd
ELSE							'
LOOKUP rnd,[$7C,$40,$00,$7C,$54,$00,$7C,$40,$00,$7C,$50,$2C,$00,$7C,$00,$74,$54,$5C],rnd
ENDIF							'
cols[rndx] = rnd					'
NEXT rndx						'
rnd = 0 : rndx = 0					'
return							'
'
randomise:
@ clrf	_rnd						'
@ clrf	_rndx						'
rnd.bit0 = cntq.bit0					'
rnd.bit1 = cntq.bit1					'
rnd.bit2 = cntq.bit2					'
rnd.bit3 = cntq.bit3					'
rndx.bit0 = cntq.bit3					'
rndx.bit1 = cntq.bit0					'
rndx.bit2 = cntq.bit2					'
rndx.bit3 = cntq.bit1					'
return							'
'
'
'*********************************** Tetris Game ****************************************
'
tetrisgamest:
'
WHILE porta.4 = 0					'wait for finger off button
gosub loadtitle						'load tetris title screen
call fixdat						'
call drawscreen						'
@ incf	_cntq						;
@ clrwdt						;
IF cntq > 12 THEN cntq = 0				'
WEND							'
'
FOR cntp = 0 TO 36					'delay title screen display
gosub loadtitle						'
call fixdat						'
call drawscreen						'
NEXT cntp						'
gosub randomise
'
tetrisgame:
READ $FE,hiscore					'
READ $FF,hiscorex					'
speed = 0						'
shape = $FF						'
tetr = 0						'
sx = 0							'
sy = 0							'
rnd = 0							'
rndx = cntq						'
tetx = $02						'
tety = $FF						'
balx = 0						'
baly = 0						'
bata = 0						'
batb = 0						'
sspd = 25						'initial game speed
cntp = 0						'speed increase timer
cnti = 0						'button timer
death = $FF						'
'
gosub clrtetris						'initialise game
'
gfxd:							'
gosub clrscreen						'
speed = speed + 1					'
olddir = direction					'set old direction
direction = 9						'direction will be none unless changed
IF gameover = 0 THEN					'disable controls when game is over
IF porta.4 = 0 THEN					'UP
direction = up						'
ENDIF							'
IF porte.0 = 1 THEN					'DOWN
direction = down					'
IF ttimer = 3 THEN					'
speed = sspd						'
ttimer = 0						'
ENDIF							'
ENDIF							'
IF porta.2 = 1 THEN					'LEFT
direction = left					'
IF cnti = 10 THEN					'
IF ttimer = 8 THEN					'
gosub slideshape					'
ttimer = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
IF porta.1 = 0 THEN					'RIGHT
direction = right					'
IF cnti = 10 THEN					'
IF ttimer = 8 THEN					'
gosub slideshape					'
ttimer = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
ENDIF							'gameover
'
IF olddir != direction THEN				'
cnti = 0						'
IF direction = up THEN					'
gosub rotateshape					'
ENDIF							'
IF direction = left OR direction = right THEN		'
gosub slideshape					'
ENDIF							'
IF direction = down THEN				'
gosub moveshape						'
ttimer = 0						'
ENDIF							'
ELSE							'
IF direction = left OR direction = right THEN		'
IF cnti < 10 THEN cnti = cnti + 1			'
IF cnti = 9 THEN ttimer = 0				'
ENDIF							'
ENDIF							'
'
IF speed > sspd THEN					'
speed = 0						'
IF death = $FF THEN					'death
gosub moveshape						'move the shape down
ENDIF							'death
ENDIF							'
'
IF gameover = 1 THEN					'restart game
death = death + 1					'
IF death = 5 THEN					'
sndout = 50						'set sound frequency
sndcnt = 50						'set sound length
ENDIF							'
sspd = 25						'reset game speed
ENDIF							'
'
IF death = 160 THEN					'
gosub tshowscore					'
IF tscore > thiscore THEN				'
thiscore = tscore					'
WRITE $FE, hiscore					'
WRITE $FF, hiscorex					'
ENDIF							'
goto tetrisgame						'
ENDIF							'
'
IF death.bit4 = 1 THEN					'flash screen if game over
gosub drawwell						'draw the frame
ENDIF							'
'
call fixdat						'
call drawscreen						'
ttimer = ttimer + 1					'increment timer
goto gfxd						'
'
'
flashrows:
lcnt = 0						'
FOR tetrisd = 0 TO 76					'
gosub clrscreen						'
FOR tetrisc = 0 TO 17					'
cols[tetrisc] = segs[tetrisc]				'
IF cols[tetrisc] = $FF THEN				'
'
IF tetrisd = 0 THEN					'
IF lcnt = 0 THEN
tscore = tscore + 5					'
sndout = 100						'set sound frequency
sndcnt = 18						'set sound length
ENDIF							'
IF lcnt = 1 THEN tscore = tscore + 10			'
IF lcnt = 2 THEN tscore = tscore + 15			'
IF lcnt = 3 THEN tscore = tscore + 20			'
lcnt = lcnt + 1						'
ENDIF							'
IF tetrisd.bit4 = 1 THEN				'
cols[tetrisc] = 0					'
ENDIF							'
ENDIF							'
NEXT tetrisc						'
call fixdat						'
call drawscreen						'
NEXT tetrisd						'
'
cntp = cntp + 1						'increment speed increase counter
IF cntp = 2 THEN					'
IF sspd > 1 THEN sspd = sspd - 1			'increase speed by one factor
ENDIF							'
IF cntp > 1 THEN cntp = 0				'
return							'
'
'
rndshape:
rnd = rnd + 1						'pseudo random shape generator
rndx = rndx + 1						'
IF rnd = 60 THEN					'
rnd = 0							'
ENDIF							'
IF rndx = 15 THEN					'
rndx = 0						'
ENDIF							'
IF rnds.bit1 != rnds.bit0 THEN				'
IF rnds.bit0 = 1 THEN					'
gosub rnddotorg						'read from random shape table 1
ELSE							'
LOOKUP rndx,[5,2,0,5,3,5,4,1,6,4,1,4,5,3,2],shape	'random shape table 2
ENDIF							'
ELSE							'
IF ttimer.bit0 = 1 THEN					'
gosub rnddotorg						'
ELSE							'
LOOKUP rndx,[0,3,5,4,6,2,1,3,5,0,5,2,1,4,5],shape	'random shape table 3
ENDIF							'
ENDIF							'
return							'
'
rnddotorg:
LOOKUP rnd,[1,3,2,4,1,0,6,0,2,1,2,6,3,2,3,2,3,4,5,1_	'www.random.org
,0,2,1,6,6,0,5,6,4,0,2,4,3,0,1,5,6,3,2,2,5,3,1,4,6,_	'
3,0,1,5,6,4,2,1,2,6,1,5,6,3,2],shape			'	
return							'
'
slideshape:
norot = 0						'
IF direction = left THEN				'direction is left
tetx = tetx - 1						'
gosub lwall						'
ELSE							'direction is right
tetx = tetx + 1						'
gosub rwall						'
ENDIF							'direction
'
cntz = tety + blockay					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockby					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockcy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockdy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
norot = 1						'
ENDIF							'
'
IF direction = left THEN				'
IF norot = 1 THEN tetx = tetx + 1			'
ELSE							'
IF norot = 1 THEN tetx = tetx - 1			'
ENDIF							'
return							'
'
'
lwall:
IF tetx + blockax = $FF THEN norot = 1			'
IF tetx + blockbx = $FF THEN norot = 1			'
IF tetx + blockcx = $FF THEN norot = 1			'
IF tetx + blockdx = $FF THEN norot = 1			'
return							'
'
rwall:
IF tetx + blockax = $08 THEN norot = 1			'
IF tetx + blockbx = $08 THEN norot = 1			'
IF tetx + blockcx = $08 THEN norot = 1			'
IF tetx + blockdx = $08 THEN norot = 1			'
return							'
'
'
rotateshape:
IF shape < 3 THEN					'
tetr = tetr + 1						'rotate any of first three shapes
IF tetr > 3 THEN tetr = 0				'
ENDIF							'
IF shape > 2 THEN					'
IF shape != 6 THEN					'
IF tetr = 0 THEN					'rotate any of shapes 3,4 & 5.
tetr = 1						'
ELSE							'
tetr = 0						'
ENDIF							'
ENDIF							'
ENDIF							'note the square shape does not need rotating
'
gosub getshape						'retrieve shape from table
'
norot = 0						'reset rotation collision flag
cntz = tety + blockay					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockby					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockcy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockdy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
norot = 1						'
ENDIF							'
'
gosub lwall						'check for collision with well walls
gosub rwall						'
'
IF norot = 1 THEN					'rotate shape in reverse if it collided
IF shape < 3 THEN					'
tetr = tetr - 1						'rotate any of first three shapes
IF tetr = $FF THEN tetr = $03				'
ENDIF							'
IF shape > 2 THEN					'
IF shape != 6 THEN					'
IF tetr = 0 THEN					'rotate any of shapes 3,4 & 5.
tetr = 1						'
ELSE							'
tetr = 0						'
ENDIF							'
ENDIF							'
ENDIF							'note the square shape does not need rotating
gosub getshape						'retrieve shape from table
ENDIF							'
return							'
'
'
drawwell:
IF newshape = 1 THEN					'set new shape coordinates
gosub rndshape						'get random shape type
'
tetx = $02 : tety = $FF					'
IF shape = 3 THEN					'
tetx = $02 : tety = $FE					'
ENDIF							'
IF shape = 6 THEN					'
tetx = $03 : tety = $00					'
ENDIF							'
ENDIF							'
'
FOR cntz = 0 TO 17					'paste well to screen buffer
cols[cntz] = segs[cntz]					'
NEXT cntz						'
'
gosub getshape						'retrieve shape from table
'
balx = tetx + blockax : baly = tety + blockay		'
gosub vdrawbit						'
balx = tetx + blockbx : baly = tety + blockby		'
gosub vdrawbit						'
balx = tetx + blockcx : baly = tety + blockcy		'
gosub vdrawbit						'
balx = tetx + blockdx : baly = tety + blockdy		'
gosub vdrawbit						'
'
IF newshape = 1 THEN					'one of two end game checks
cntz = tety + blockay+1					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockby+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockcy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockdy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
gameover = 1						'
ENDIF							'
ENDIF							'
'
newshape = 0						'
return							'
'
'
moveshape:
hitfloor = 0						'
IF tety + blockay = 17 THEN hitfloor = 1		'check for any blocks on the floor
IF tety + blockby = 17 THEN hitfloor = 1		'
IF tety + blockcy = 17 THEN hitfloor = 1		'
IF tety + blockdy = 17 THEN hitfloor = 1		'
'
cntz = tety + blockay+1					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockby+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockcy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockdy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
'
IF hitfloor = 1 THEN					'
newshape = 1						'
gosub lockin						'lock shape into well
fbit = 1						'
tscore = tscore + 1					'
gosub checkrows						'check for completed rows
gosub checkrows						'
gosub checkrows						'
gosub checkrows						'
tetr = 0						'
'
hitroof = 0						'two of two end game checks
IF tety + blockay = 0 THEN hitroof = 1			'check for any blocks on the roof
IF tety + blockby = 0 THEN hitroof = 1			'
IF tety + blockcy = 0 THEN hitroof = 1			'
IF tety + blockdy = 0 THEN hitroof = 1			'
IF hitroof = 1 THEN					'
newshape = 0						'
gameover = 1						'
ENDIF							'
'
ELSE							'
tety = tety + 1						'
ENDIF							'
return							'
'
'
checkrows:
tetrisb = 99						'
FOR tetrisa = 0 TO 17					'
IF segs[tetrisa] = $FF THEN				'
IF fbit = 1 THEN					'
gosub flashrows						'
fbit = 0						'
ENDIF							'
tetrisb = tetrisa					'
ENDIF							'
NEXT tetrisa						'
IF tetrisb != 99 THEN					'
W1 = tetrisb						'
FOR tetrisa = 0 TO tetrisb				'
segs[W1] = segs[W1-1]					'
W1 = W1 - 1						'
NEXT tetrisa						'
segs[0] = 0						'
ENDIF							'
return							'
'
'
lockin:
FOR lcnt = 0 TO 3					'
cntz = tety + blocksy[lcnt]				'
W1 = segs[cntz]						'
FOR cntj = 0 TO 7
IF tetx + blocksx[lcnt] = cntj THEN
ii.0(cntj) = 1
ENDIF
NEXT cntj
segs[cntz] = W1						'
NEXT lcnt						'
'
IF tetx = $FF THEN					'fix for problem shape rotation combinations
IF tetr = 3 THEN					'
IF shape = 1 THEN					'
cntz = tety + blockdy					'
gosub memsave						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockby					'
W1 = segs[cntz]						'
W1.bit0 = 1						'
W1.bit1 = 1						'
segs[cntz] = W1						'
ENDIF							'shape
IF shape = 2 THEN					'
cntz = tety + blockdy					'
W1 = segs[cntz]						'
W1.bit0 = 1						'
W1.bit1 = 1						'
segs[cntz] = W1						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockay					'
gosub memsave						'
ENDIF							'shape
ENDIF							'tetr
IF tetr = 1 THEN					'
IF shape = 3 THEN					'
cntz = tety + blockdy					'
gosub memsave						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockby					'
gosub memsave						'
cntz = tety + blockay					'
gosub memsave						'
ENDIF							'shape
ENDIF							'tetr
ENDIF							'tetx
sndout = 250						'set sound frequency
sndcnt = 2						'set sound length
return							'
'
memsave:
W1 = segs[cntz]						'just a few lines that get repeated
W1.bit0 = 1						'saving space putting it here
segs[cntz] = W1						'
return							'
'
getshape						'
IF shape = 0 THEN					'copy current rotated shape to buffer
LOOKUP tetr,[0,4,8,12],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 1 THEN					'
LOOKUP tetr,[16,20,24,28],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 2 THEN					'
LOOKUP tetr,[32,36,40,44],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 3 THEN					'
LOOKUP tetr,[48,52],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 4 THEN					'
LOOKUP tetr,[56,60],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 5 THEN					'
LOOKUP tetr,[64,68],cntz				'
gosub loadsh						'load shape
ENDIF							'
IF shape = 6 THEN					'
cntz = 72						'set address
gosub loadsh						'load shape
ENDIF							'
return							'
'
loadsh:
segment = segs[cntz + 20]				'
gosub decodesegment					'
blockax = sx						'
blockay = sy						'
segment = segs[cntz + 21]				'
gosub decodesegment					'
blockbx = sx						'
blockby = sy						'
segment = segs[cntz + 22]				'
gosub decodesegment					'
blockcx = sx						'
blockcy = sy						'
segment = segs[cntz + 23]				'
gosub decodesegment					'
blockdx = sx						'
blockdy = sy						'
return							'
'
'
clrtetris:
FOR cntt = 0 to 19					'clear well
segs[cntt] = $00					'
NEXT cntt						'
'
cnti = $00						'load table of shapes from on-chip EEPROM ($40)
FOR cntt = 20 TO 95					'
LOOKUP cnti,[$20,$21,$22,$40,$00,$20,$40,$41,$20,$21,$22,$02,$00,$01,$21,$41,$20,$21,_
$22,$42,$01,$21,$41,$40,$00,$20,$21,$22,$01,$02,$21,$41,$20,$21,$22,$41,_
$20,$01,$21,$41,$20,$21,$22,$01,$01,$21,$41,$22,$40,$41,$42,$43,$01,$21,_
$41,$61,$20,$21,$41,$42,$01,$20,$21,$40,$40,$21,$41,$22,$00,$20,$21,$41,_
$00,$01,$20,$21],cntw
segs[cntt] = cntw
cnti = cnti + 1						'
NEXT cntt						'
'
direction = 9						'set invalid start direction
olddir = 9						'set initial old direction
shape = 0						'set start shape
tetr = 0						'reset shape rotation
tscore = 0						'reset score
newshape = 1						'set introduce new shape flag
gameover = 0						'reset game over flag
hitroof = 0						'reset hit roof flag
ttimer = 0						'reset button timer
return							'
'
tshowscore:
FOR ix = 0 TO 95					'delete array
segs[ix] = 0						'
NEXT ix							'
ix = 20							'
W0 = tscore DIG 3					'
gosub printchar						'
W0 = tscore DIG 2					'
gosub printchar						'
W0 = tscore DIG 1					'
gosub printchar						'
W0 = tscore DIG 0					'
gosub printchar						'
'
FOR ix = 0 TO 56					'
FOR ii = 0 TO 17					'
cols[ii] = segs[ii+ix]					'
NEXT ii							'
'
IF tscore < thiscore THEN				'
call fixdat						'
ELSE							'
IF ix.bit0 = 0 THEN					'
FOR ii = 0 TO 17					'
cols[ii] = $FF						'
NEXT ii							'
ELSE							'
call fixdat						'
ENDIF							'
ENDIF							'
'
FOR ii = 0 TO 4						'speed of Tetris high score scroll
call drawscreen						'
NEXT ii							'
NEXT ix							'
return							'
'
'********************************** Sprite Test *****************************************
'
graphicsB:
speed = 0						'
ix = 0							'
iy = 0							'
balx = 0						'
baly = 0						'
bata = 0						'
batb = 0						'
'
WHILE porta.2 = 1					'wait for button release
@ clrwdt						;
WEND							'
'
gfxb:							'
gosub clrscreen						'
'
speed = speed + 1					'
@ clrwdt						'
IF speed > sspd THEN					'
batb = batb + 1						'increment anim counter
IF batb = 10 THEN					'
batb = 0						'
IF anim = 0 THEN					'
anim = 1						'
ELSE							'
anim = 0						'
ENDIF							'
ENDIF							'
speed = 0						'
'
IF porta.4 = 0 THEN					'UP
iy = iy - 1						'
ENDIF							'
IF porte.0 = 1 THEN					'DOWN
iy = iy + 1						'
ENDIF							'
IF porta.2 = 1 THEN					'LEFT
ix = ix - 1						'
ENDIF							'
IF porta.1 = 0 THEN					'RIGHT
ix = ix + 1						'
ENDIF							'
'
IF ix = 18 THEN ix = 17					'
IF iy = 8 THEN iy = 7					'
IF ix = $F5 THEN ix = $F6				'
IF iy = $F8 THEN iy = $F9				'
'
ENDIF							'
'
FOR cntr = 0 TO 10
IF anim = 0 THEN					'
LOOKUP cntr,[$0E,$18,$BE,$6D,$3D,$3C,$3D,$6D,$BE,$18,$0E],bata
ELSE							'
LOOKUP cntr,[$78,$1D,$BE,$6C,$3C,$3C,$3C,$6C,$BE,$1D,$78],bata
ENDIF							'
gosub blit						'
NEXT cntr
call fixdat						'
gosub drawscreen					'
goto gfxb						'
'
blit:
tetx = 0						'
FOR epin = 0 TO 7
gosub blitx						'
IF bata.bit7 = 1 THEN gosub drawbit			'
bata = bata << 1
NEXT epin
return							'
'
blitx
balx = ix + cntr : baly = iy + tetx			'
tetx = tetx + 1						'
return							'
'
'************************ Serial Text Message Programming *******************************
'
program:
portb = $FF						'
porta.0 = 1						'
epin = 3						'
WRITE 0,$20 : WRITE 1,$20 : WRITE 2,$20			'* in case the lead in is edited
prx:							'
serin2 porte.1,16416,[W0]				'19200 baud
lcnt = W0						'
IF W0 = $0D THEN					'
gosub leadout						'
goto prgx						'
ENDIF							'
gosub getchar						'
IF wchar = 1 THEN					'
sndout = 90						'set sound frequency
sndcnt = 1						'set sound length
C5 = $00						'
WRITE epin,lcnt						'
epin = epin + 1						'
IF epin = $F9 THEN					'
gosub leadout						'
goto prgx						'check limit
ENDIF							'
wchar = 0						'
porta.0 = 1						'
ENDIF							'
'
call fixdat						'
gosub drawchar						'
gosub drawchar						'
gosub clrscreen						'
goto prx						'
'
leadout:
WRITE $FC,epin						'
WRITE epin," " : WRITE epin+1," " : WRITE epin+2," "	'
pause 12						'
return							'
'
'*********************************** Shared Routines ************************************
'
getchar:
W2 = $41						'
gosub checkchar						'check upper case
W2 = $61						'
gosub checkchar						'check lower case
'
if (W0 = $20) THEN ' SPACE
C0 = $00'
C1 = $00'
C2 = $00'
C3 = $00'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $2D) THEN ' -
C0 = $08'
C1 = $08'
C2 = $08'
C3 = $08'
C4 = $08'
wchar = 1
ENDIF'
if (W0 = $21) THEN ' !
C0 = $00'
C1 = $00'
C2 = $79'
C3 = $00'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $30) THEN ' 0
C0 = $3E'
C1 = $45'
C2 = $49'
C3 = $51'
C4 = $3E'
wchar = 1
ENDIF'
if (W0 = $31) THEN ' 1
C0 = $00'
C1 = $21'
C2 = $7F'
C3 = $01'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $32) THEN ' 2
C0 = $21'
C1 = $43'
C2 = $45'
C3 = $49'
C4 = $31'
wchar = 1
ENDIF'
if (W0 = $33) THEN ' 3
C0 = $42'
C1 = $41'
C2 = $51'
C3 = $69'
C4 = $46'
wchar = 1
ENDIF'
if (W0 = $34) THEN ' 4
C0 = $0C'
C1 = $14'
C2 = $24'
C3 = $7F'
C4 = $04'
wchar = 1
ENDIF'
if (W0 = $35) THEN ' 5
C0 = $72'
C1 = $51'
C2 = $51'
C3 = $51'
C4 = $4E'
wchar = 1
ENDIF'
if (W0 = $36) THEN ' 6
C0 = $1E'
C1 = $29'
C2 = $49'
C3 = $49'
C4 = $06'
wchar = 1
ENDIF'
if (W0 = $37) THEN ' 7
C0 = $60'
C1 = $40'
C2 = $47'
C3 = $48'
C4 = $70'
wchar = 1
ENDIF'
if (W0 = $38) THEN ' 8
C0 = $36'
C1 = $49'
C2 = $49'
C3 = $49'
C4 = $36'
wchar = 1
ENDIF'
if (W0 = $39) THEN ' 9
C0 = $30'
C1 = $49'
C2 = $49'
C3 = $4A'
C4 = $3C'
wchar = 1
ENDIF'
if (W0 = $24) THEN ' $
C0 = $12'
C1 = $2A'
C2 = $7F'
C3 = $2A'
C4 = $24'
wchar = 1
ENDIF'
if (W0 = $2E) THEN ' .
C0 = $00'
C1 = $03'
C2 = $03'
C3 = $00'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $2C) THEN ' ,
C0 = $00'
C1 = $05'
C2 = $06'
C3 = $00'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $23) THEN ' ,
C0 = $FF'
C1 = $FF'
C2 = $FF'
C3 = $FF'
C4 = $FF'
wchar = 1
ENDIF'
return'
'
checkchar:
if (W0 = W2) THEN					'A a
C0 = $1F						'
C1 = $24						'
C2 = $44						'
C3 = $24						'
C4 = $1F						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' B b
C0 = $7F						'
C1 = $49						'
C2 = $49						'
C3 = $49						'
C4 = $36						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' C c
C0 = $3E						'
C1 = $41						'
C2 = $41						'
C3 = $41						'
C4 = $22						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' D d
C0 = $7F						'
C1 = $41						'
C2 = $41						'
C3 = $22						'
C4 = $1C						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' E e
C0 = $7F						'
C1 = $49						'
C2 = $49						'
C3 = $49						'
C4 = $41						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' F f
C0 = $7F						'
C1 = $48						'
C2 = $48						'
C3 = $48						'
C4 = $40						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' G g
C0 = $3E						'
C1 = $41						'
C2 = $49						'
C3 = $49						'
C4 = $2F						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' H h
C0 = $7F						'
C1 = $08						'
C2 = $08						'
C3 = $08						'
C4 = $7F						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' I i
C0 = $00						'
C1 = $41						'
C2 = $7F						'
C3 = $41						'
C4 = $00						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' J j
C0 = $02						'
C1 = $01						'
C2 = $41						'
C3 = $7E						'
C4 = $40						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' K k
C0 = $7F						'
C1 = $08						'
C2 = $14						'
C3 = $22						'
C4 = $41						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' L l
C0 = $7F						'
C1 = $01						'
C2 = $01						'
C3 = $01						'
C4 = $01						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' M m
C0 = $7F						'
C1 = $20						'
C2 = $18						'
C3 = $20						'
C4 = $7F						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' N n
C0 = $7F						'
C1 = $10						'
C2 = $08						'
C3 = $04						'
C4 = $7F						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' O o
C0 = $3E						'
C1 = $41						'
C2 = $41						'
C3 = $41						'
C4 = $3E						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' P p
C0 = $7F						'
C1 = $48						'
C2 = $48						'
C3 = $48						'
C4 = $30						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' Q q
C0 = $3E						'
C1 = $41						'
C2 = $45						'
C3 = $42						'
C4 = $3D						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' R r
C0 = $7F						'
C1 = $48						'
C2 = $4C						'
C3 = $4A						'
C4 = $31						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' S s
C0 = $32						'
C1 = $49						'
C2 = $49						'
C3 = $49						'
C4 = $26						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' T t
C0 = $40						'
C1 = $40						'
C2 = $7F						'
C3 = $40						'
C4 = $40						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' U u
C0 = $7E						'
C1 = $01						'
C2 = $01						'
C3 = $01						'
C4 = $7E						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' V v
C0 = $7C						'
C1 = $02						'
C2 = $01						'
C3 = $02						'
C4 = $7C						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' W w
C0 = $7E						'
C1 = $01						'
C2 = $0E						'
C3 = $01						'
C4 = $7E						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' X x
C0 = $63						'
C1 = $14						'
C2 = $08						'
C3 = $14						'
C4 = $63						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' Y y
C0 = $70						'
C1 = $08						'
C2 = $07						'
C3 = $08						'
C4 = $70						'
wchar = 1						'
ENDIF							'
W2 = W2 + 1						'
if (W0 = W2) THEN					' Z z
C0 = $43						'
C1 = $45						'
C2 = $49						'
C3 = $51						'
C4 = $61						'
wchar = 1						'
ENDIF							'
return							'
'
sendx:
IF sndcnt = 0 THEN					'
PAUSEUS 1000						'
ELSE							'
FREQOUT porte.2,1,sndout				'
ENDIF							'
porta.0 = 0						'
return							'
'
printchar:
W0 = W0 + $30						'
gosub getchar						'
FOR iy = 0 TO 7						'
W0 = 0							'
W0.bit1 = C0.bit7					'
W0.bit2 = C1.bit7					'
W0.bit3 = C2.bit7					'
W0.bit4 = C3.bit7					'
W0.bit5 = C4.bit7					'
segs[ix] = W0						'
ix = ix + 1						'
gosub rotbitsleft					'
NEXT iy							'
return							'
'
'******************************** Pong ScreenSaver **************************************
'
graphics:
dirx = 0						'
diry = 0						'
balx = 4						'
baly = 4						'
bata = 2						'
batb = 2						'
'
WHILE porta.4 = 0					'wait for button release
@ clrwdt						;
WEND							'
'
gfx:							'
gosub clrscreen						'
'
speed = speed + 1					'
IF speed > sspd+1 THEN					'
'
IF dirx = 1 THEN					'move ball
balx = balx + 1						'
 IF balx = 17 THEN					'
 dirx = 0						'
'sound
 ENDIF							'
'
 IF (batb+2) > baly THEN				'
 IF batb > 0 THEN					'
 batb = batb - 1					'
 goto daa						'
 ENDIF							'
 ENDIF							'
 IF (batb+2) < baly THEN				'
 IF batb < 4 THEN					'
 batb = batb + 1					'
 ENDIF							'
 ENDIF							'
daa:
'
ELSE							'
balx = balx - 1						'
 IF balx = 0 THEN					'
 dirx = 1						'
'sound
 ENDIF							'
'
 IF (bata+2) > baly THEN				'
 IF bata > 0 THEN					'
 bata = bata - 1					'
 goto dbb						'
 ENDIF							'
 ENDIF							'
 IF (bata+2) < baly THEN				'
 IF bata < 4 THEN					'
 bata = bata + 1					'
 ENDIF							'
 ENDIF							'
dbb:
'
ENDIF							'
'
IF diry = 1 THEN					'
baly = baly + 1						'
 IF baly = 7 THEN					'
 diry = 0						'
 ENDIF							'
ELSE							'
baly = baly - 1						'
 IF baly = 0 THEN					'
 diry = 1						'
 ENDIF							'
ENDIF							'
'
'
speed = 0						'reset counter
ENDIF							'speed
'
IF baly = 0 THEN					'draw ball
cols[balx] = %00000001					'
ENDIF							'
IF baly = 1 THEN					'
cols[balx] = %00000010					'
ENDIF							'
IF baly = 2 THEN					'
cols[balx] = %00000100					'
ENDIF							'
IF baly = 3 THEN					'
cols[balx] = %00001000					'
ENDIF							'
IF baly = 4 THEN					'
cols[balx] = %00010000					'
ENDIF							'
IF baly = 5 THEN					'
cols[balx] = %00100000					'
ENDIF							'
IF baly = 6 THEN					'
cols[balx] = %01000000					'
ENDIF							'
IF baly = 7 THEN					'
cols[balx] = %10000000					'
ENDIF							'
'
IF bata = 4 THEN					'draw bats
cols[0] = %11110000					'
ENDIF							'
IF bata = 3 THEN					'
cols[0] = %01111000					'
ENDIF							'
IF bata = 2 THEN					'
cols[0] = %00111100					'
ENDIF							'
IF bata = 1 THEN					'
cols[0] = %00011110					'
ENDIF							'
IF bata = 0 THEN					'
cols[0] = %00001111					'
ENDIF							'
IF batb = 4 THEN					'
cols[17] = %11110000					'
ENDIF							'
IF batb = 3 THEN					'
cols[17] = %01111000					'
ENDIF							'
IF batb = 2 THEN					'
cols[17] = %00111100					'
ENDIF							'
IF batb = 1 THEN					'
cols[17] = %00011110					'
ENDIF							'
IF batb = 0 THEN					'
cols[17] = %00001111					'
ENDIF							'
'
call fixdat						'
gosub drawscreen					'
IF porta.1 = 0 THEN					'check DIP switch 2
sspd = 0						'
ELSE							'
sspd = 3						'
ENDIF							'
goto gfx						'
'
'****************************************************************************************
'
