'
' 144 LED GAMES CONSOLE AND MESSAGE SCROLLER - Art 2010
'
'bushprogrammer@gmail.com
'bmar8190@bigpond.net.au
'
'
@ DEVICE LVP_OFF,BOD_OFF,HS_OSC				'set device configuration
DEFINE OSC 20						'hardware is using a 20MHz crystal
'DEFINE NO_CLRWDT					'prevent PBP inserting cltwdt commands
'
DATA @00,10						'set initial zero high score for Snake
DATA @01,03						'set initial zero high score for Tetris
DATA @02,0						'
'
DATA @03,5						'random shape table 1 (for Tetris clone)
DATA @04,4						'www.random.org
DATA @05,5						'
DATA @06,1						'
DATA @07,5						'
DATA @08,3						'
DATA @09,4						'
DATA @10,2						'
DATA @11,6						'
DATA @12,0						'
DATA @13,0						'
DATA @14,3						'
DATA @15,0						'
DATA @16,2						'
DATA @17,4						'
DATA @18,1						'
DATA @19,1						'
DATA @20,5						'
DATA @21,2						'
DATA @22,4						'
DATA @23,2						'
DATA @24,4						'
DATA @25,6						'
DATA @26,6						'
DATA @27,2						'
DATA @28,6						'
DATA @29,2						'
DATA @30,5						'
DATA @31,1						'
DATA @32,4						'
DATA @33,0						'
DATA @34,5						'
DATA @35,0						'
DATA @36,6						'
DATA @37,5						'
DATA @38,3						'
DATA @39,2						'
DATA @40,3						'
DATA @41,5						'
DATA @42,3						'
DATA @43,1						'
DATA @44,6						'
DATA @45,2						'
DATA @46,0						'
DATA @47,5						'
DATA @48,3						'
DATA @49,2						'
DATA @50,6						'
DATA @51,6						'
DATA @52,3						'
DATA @53,2						'
DATA @54,3						'
DATA @55,0						'
DATA @56,5						'
DATA @57,2						'
DATA @58,6						'
DATA @59,5						'
DATA @60,6						'
DATA @61,3						'
DATA @62,4						'
'
segs var byte [96]					'snake cells
cols var byte [18]					'
digits var byte [4]					'
C0 var cols[0] : C1 var cols[1]				'
C2 var cols[2] : C3 var cols[3]				'
C4 var cols[4] : C5 var cols[5]				'
C6 var cols[6] : C7 var cols[7]				'
C8 var cols[8] : C9 var cols[9]				'
C10 var cols[10] : C11 var cols[11]			'
C12 var cols[12] : C13 var cols[13]			'
C14 var cols[14] : C15 var cols[15]			'
C16 var cols[16] : C17 var cols[17]			'
D0 var digits[0]					'
D1 var digits[1]					'
D2 var digits[2]					'
D3 var digits[3]					'
epin var word						'eeprom index
length var word						'
cntr var byte						'counter
speed var byte						'speed counter
W0 var byte						'
mode var bit						'
wchar var bit						'
fun var bit						'
demo var bit						'
snake var bit						'
dirx var bit						'demo screen variables
diry var bit						'
anim var bit						'invader frame select
ix var byte						'
iy var byte						'
sspd var byte						'
balx var byte						'
baly var byte						'
bata var byte						'
batb var byte						'
si var byte						'sin wave index
cntt var byte						'snake variables
cntx var byte						'
cnti var byte						'
ii var byte						'array index
segment var byte					'
sx var byte						'
sy var byte						'
px var byte						'
py var byte						'
direction var byte					'
slen var byte						'
tscore var word						'
thiscore var word					'
score var tscore.byte0					'
rnd var byte						'random variables
rndx var byte						'
trypel var bit						'
gameover var bit					'
sndout var byte						'send sound code flag
death var byte						'
cntq var byte						'counter
cntp var byte						'counter
cntz var byte						'tetris counter
tetx var byte						'tetris x coordinate
tety var byte						'tetris y coordinate
tetr var byte						'tetris rotation
blockax var byte					'current shape coordinates
blockay var byte					'
blockbx var byte					'
blockby var byte					'
blockcx var byte					'
blockcy var byte					'
blockdx var byte					'
blockdy var byte					'
tetrisc var byte					'
tetrisd var byte					'
newshape var bit					'new shape flag
norot var bit						'rotation collision flag
'
shape var slen						'set aliases for Tetris game
W1 var ii						'
hitfloor var trypel					'
hitroof var dirx					'
olddir var px						'
ttimer var py						'
tetrisa var ix						'
tetrisb var iy						'
fbit var diry						'
'
hiscore var thiscore.byte0				'set aliases for Snake game
hiscorex var thiscore.byte1				'
'
up CON 0						'direction constants
down CON 1						'
left CON 2						'
right CON 3						'
'
call startup						'startup code
'
'******************************** Message Scroller***************************************
'
cycle:
speed = speed + 1					'
IF speed > sspd-1 THEN					'
I2CREAD porte.1,porte.2,%10100000,epin,[STR cols\18],error
call fixdat						'invert and reverse bits
'
IF porte.0 = 1 THEN					'check for DIP switch 4
IF dirx = 0 THEN					'bounce effect
FOR batb = 0 TO bata					'
call rotbitsright					'
NEXT batb						'
IF diry = 0 THEN					'
IF wchar = 0 THEN					'
bata = bata + 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 3 THEN diry = 1				'
ELSE							'
IF wchar = 0 THEN					'
bata = bata - 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 0 THEN					'
dirx = 1						'
diry = 0						'
ENDIF							'
ENDIF							'
ELSE							'
FOR batb = 0 TO bata					'
call rotbitsleft					'
NEXT batb						'
IF diry = 0 THEN					'
IF wchar = 0 THEN					'
bata = bata + 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 3 THEN diry = 1				'
ELSE							'
IF wchar = 0 THEN					'
bata = bata - 1						'
wchar = 1						'
ELSE							'
wchar = 0						'
ENDIF							'
IF bata = 0 THEN					'
dirx = 0						'
diry = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
ENDIF							'
'
trypel = 0						'
IF porta.4 = 1 THEN					'
trypel = 1						'
ENDIF							'
'
IF porta.2 = 1 THEN					'check for DIP switch 3
FOR balx = 0 TO 17					'sine wave effect
LOOKUP si,[0,0,1,1,2,2,2,3,3,4,4,3,3,2,2,2,1,1,0,0],baly'
W0 = cols[balx]						'
IF baly = 0 THEN					'
W0 = W0 >> 2						'
W0.bit7 = trypel					'
W0.bit6 = trypel					'
ENDIF							'
IF baly = 1 THEN					'
W0 = W0 >> 1						'
W0.bit7 = trypel					'
ENDIF							'
IF baly = 3 THEN					'
W0 = W0 << 1						'
W0.bit0 = trypel					'
ENDIF							'
IF baly = 4 THEN					'
W0 = W0 << 2						'
W0.bit0 = trypel					'
W0.bit1 = trypel					'
ENDIF							'
cols[balx] = W0						'
si = si + 1						'
IF si > 19 THEN						'
si = 0							'
ENDIF							'
NEXT balx						'
ENDIF							'
'
epin = epin + 1						'advance eeprom address
speed = 0						'reset counter
IF epin = length THEN					'check for end address
epin = 10						'set restart address
ENDIF							'
ENDIF							'
'
gosub drawscreen					'
'
IF porta.1 = 0 THEN					'check DIP switch 1
sspd = 1						'
ELSE							'
sspd = 3						'
ENDIF							'
'
goto cycle
'
'************************************* Startup ******************************************
'
startup:
pause 10						'stabilise power supply
ADCON1 = %00000110					'set all pins digital
trise = 0						'
trisb = 0						'
trisa.0 = 0						'serial port
trisa.1 = 1						'set DIP switch inputs 1, 2 & 3
trisa.4 = 1						'
trisa.2 = 1						'
trisa.3 = 1						'set inputs
trisa.5 = 1						'
trisc = $FF						'
trisd = $FF						'
trise.0 = 1						'
epin = 0						'
fun = 0							'
demo = 0						'
snake = 0						'
speed = 0						'
wchar = 0						'
sspd = 3						'
bata = 0						'
batb = 0						'
dirx = 0						'
diry = 0						'
rnd = 0							'
rndx = 0						'
sndout = 0						'
FOR cntr = 0 TO 17					'
cols[cntr] = 0						'
NEXT cntr						'
pause 10						'
'
mode = 1						'
IF porta.1 = 1 THEN					'check DIP switch 1
mode = 0						'
ENDIF							'
'
fun = 1							'
IF porta.4 = 1 THEN					'check DIP switch 2
fun = 0							'
ENDIF							'
'
demo = 0						'
IF porta.2 = 1 THEN					'check DIP switch 3
demo = 1						'
ENDIF							'
'
snake = 0						'
IF porte.0 = 1 THEN					'check DIP switch 4
snake = 1						'
ENDIF							'
'
'
IF snake = 1 THEN					'
goto snakegamest					'
ENDIF							'
'
IF fun = 1 THEN						'
goto tetrisgamest					'
ENDIF							'
'
IF demo = 1 THEN					'
ENDIF							'
'
IF mode = 1 THEN					'
goto prgx						'
ENDIF							'
'
'
prgx:							'
'
I2CREAD porte.1,porte.2,%10100000,epin,[STR digits\4],error
epin = 10						'
length = D0 * 1000					'
length = length + (D1 * 100)				'
length = length + (D2 * 10)				'
length = length + D3					'
@ clrwdt						;
return							'
'
fixdat:
'
IF (porta.4 = 1) OR (fun = 1) OR (snake = 1) OR (demo = 1) THEN
@ comf _C0						;
@ comf _C1						;
@ comf _C2						;
@ comf _C3						;
@ comf _C4						;
@ comf _C5						;
@ comf _C6						;
@ comf _C7						;
@ comf _C8						;
@ comf _C9						;
@ comf _C10						;
@ comf _C11						;
@ comf _C12						;
@ comf _C13						;
@ comf _C14						;
@ comf _C15						;
@ comf _C16						;
@ comf _C17						;
ENDIF							'
'
halfix:
C0 = C0 REV 8						'
C1 = C1 REV 8						'
C2 = C2 REV 8						'
C3 = C3 REV 8						'
C4 = C4 REV 8						'
C5 = C5 REV 8						'
C6 = C6 REV 8						'
C7 = C7 REV 8						'
C8 = C8 REV 8						'
C9 = C9 REV 8						'
C10 = C10 REV 8						'
C11 = C11 REV 8						'
C12 = C12 REV 8						'
C13 = C13 REV 8						'
C14 = C14 REV 8						'
C15 = C15 REV 8						'
C16 = C16 REV 8						'
C17 = C17 REV 8						'
return							'
'
error:
FOR cntr = 0 TO 5					'
porta.0 = 1						'
pause 500						'
porta.0 = 0						'
pause 500						'
NEXT cntr						'
return							'
'
'
rotbitsright:
@  rrf 		_C0		,F			;bitwise rotate right
@  bcf		_C0		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C0		,7			;
@  rrf 		_C1		,F			;
@  bcf		_C1		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C1		,7			;
@  rrf 		_C2		,F			;
@  bcf		_C2		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C2		,7			;
@  rrf 		_C3		,F			;
@  bcf		_C3		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C3		,7			;
@  rrf 		_C4		,F			;
@  bcf		_C4		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C4		,7			;
@  rrf 		_C5		,F			;
@  bcf		_C5		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C5		,7			;
@  rrf 		_C6		,F			;
@  bcf		_C6		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C6		,7			;
@  rrf 		_C7		,F			;
@  bcf		_C7		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C7		,7			;
@  rrf 		_C8		,F			;
@  bcf		_C8		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C8		,7			;
@  rrf 		_C9		,F			;
@  bcf		_C9		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C9		,7			;
@  rrf 		_C10		,F			;
@  bcf		_C10		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C10		,7			;
@  rrf 		_C11		,F			;
@  bcf		_C11		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C11		,7			;
@  rrf 		_C12		,F			;
@  bcf		_C12		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C12		,7			;
@  rrf 		_C13		,F			;
@  bcf		_C13		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C13		,7			;
@  rrf 		_C14		,F			;
@  bcf		_C14		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C14		,7			;
@  rrf 		_C15		,F			;
@  bcf		_C15		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C15		,7			;
@  rrf 		_C16		,F			;
@  bcf		_C16		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C16		,7			;
@  rrf 		_C17		,F			;
@  bcf		_C17		,7			;
@  btfsc	PORTA		,4			;
@  bsf		_C17		,7			;
return							'
'
rotbitsleft:
@  rlf 		_C0		,F			;bitwise rotate left
@  bcf		_C0		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C0		,0			;
@  rlf 		_C1		,F			;
@  bcf		_C1		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C1		,0			;
@  rlf 		_C2		,F			;
@  bcf		_C2		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C2		,0			;
@  rlf 		_C3		,F			;
@  bcf		_C3		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C3		,0			;
@  rlf 		_C4		,F			;
@  bcf		_C4		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C4		,0			;
@  rlf 		_C5		,F			;
@  bcf		_C5		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C5		,0			;
@  rlf 		_C6		,F			;
@  bcf		_C6		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C6		,0			;
@  rlf 		_C7		,F			;
@  bcf		_C7		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C7		,0			;
@  rlf 		_C8		,F			;
@  bcf		_C8		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C8		,0			;
@  rlf 		_C9		,F			;
@  bcf		_C9		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C9		,0			;
@  rlf 		_C10		,F			;
@  bcf		_C10		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C10		,0			;
@  rlf 		_C11		,F			;
@  bcf		_C11		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C11		,0			;
@  rlf 		_C12		,F			;
@  bcf		_C12		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C12		,0			;
@  rlf 		_C13		,F			;
@  bcf		_C13		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C13		,0			;
@  rlf 		_C14		,F			;
@  bcf		_C14		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C14		,0			;
@  rlf 		_C15		,F			;
@  bcf		_C15		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C15		,0			;
@  rlf 		_C16		,F			;
@  bcf		_C16		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C16		,0			;
@  rlf 		_C17		,F			;
@  bcf		_C17		,0			;
@  btfsc	PORTA		,4			;
@  bsf		_C17		,0			;
return							'
'
drawbit:
IF balx > 17 THEN return				'
IF baly > 7 THEN return					'
W0 = cols[balx]						'
gosub dobit						'
cols[balx] = W0						'
return							'
'
dobit:
IF baly = 0 THEN W0.bit7 = 1				'
IF baly = 1 THEN W0.bit6 = 1				'
IF baly = 2 THEN W0.bit5 = 1				'
IF baly = 3 THEN W0.bit4 = 1				'
IF baly = 4 THEN W0.bit3 = 1				'
IF baly = 5 THEN W0.bit2 = 1				'
IF baly = 6 THEN W0.bit1 = 1				'
IF baly = 7 THEN W0.bit0 = 1				'
return							'
'
vdrawbit:
IF balx > 7 THEN return					'
IF baly > 17 THEN return				'
W0 = cols[baly]						'
gosub vdobit						'
cols[baly] = W0						'
return							'
'
vdobit:
IF balx = 0 THEN W0.bit0 = 1				'
IF balx = 1 THEN W0.bit1 = 1				'
IF balx = 2 THEN W0.bit2 = 1				'
IF balx = 3 THEN W0.bit3 = 1				'
IF balx = 4 THEN W0.bit4 = 1				'
IF balx = 5 THEN W0.bit5 = 1				'
IF balx = 6 THEN W0.bit6 = 1				'
IF balx = 7 THEN W0.bit7 = 1				'
return							'
'
blit:
balx = ix + cntr : baly = iy				'
IF bata.bit7 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+1				'
IF bata.bit6 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+2				'
IF bata.bit5 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+3				'
IF bata.bit4 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+4				'
IF bata.bit3 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+5				'
IF bata.bit2 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+6				'
IF bata.bit1 = 1 THEN gosub drawbit			'
balx = ix + cntr : baly = iy+7				'
IF bata.bit0 = 1 THEN gosub drawbit			'
return							'
'
'*********************************** Snake Game *****************************************
'
snakegamest:
WHILE porte.0 = 1					'wait for finger off button
gosub loadtitle						'load snake title screen
call fixdat						'
call drawscreen						'
@ incf	_cntq						;
@ clrwdt						;
WEND							'
'
FOR cntp = 0 TO 36					'delay title screen display
gosub loadtitle						'
call fixdat						'
call drawscreen						'
NEXT cntp						'
'
gosub randomise						'randomise initial pellet location
'
snakegame:
READ 0,hiscore						'
speed = 0						'
sx = 0							'
sy = 0							'
balx = 0						'
baly = 0						'
bata = 0						'
batb = 0						'
sspd = 21						'initial game speed
cntp = 0						'speed increase timer
death = $FF						'
'
gosub clrsnake						'initialise game
'
gfxc:							'
gosub clrscreen						'
'
speed = speed + 1					'
'
IF porta.4 = 0 THEN					'UP
direction = up						'
ENDIF							'
IF porte.0 = 1 THEN					'DOWN
direction = down					'
ENDIF							'
IF porta.2 = 1 THEN					'LEFT
direction = left					'
ENDIF							'
IF porta.1 = 0 THEN					'RIGHT
direction = right					'
ENDIF							'
'
IF speed > sspd THEN					'
speed = 0						'
IF death = $FF THEN					'death
gosub movesnake						'
ENDIF							'death
ENDIF							'
'
IF gameover = 1 THEN					'restart game
death = death + 1					'
sndout = 2						'
sspd = 21						'reset game speed
ENDIF							'
'
IF death = 160 THEN					'
gosub showscore						'
IF score > hiscore THEN					'
hiscore = score						'
WRITE 0, score						'
ENDIF							'
goto snakegame						'
ENDIF							'
'
IF death.bit4 = 1 THEN					'flash snake if dead
FOR cnti = 0 TO slen					'draw snake
segment = segs[cnti]					'
gosub decodesegment					'
balx = sx : baly = sy					'
gosub drawbit						'
NEXT cnti						'
balx = px : baly = py					'draw pellet
gosub drawbit						'
ENDIF							'
'
call fixdat						'
call drawscreen						'
goto gfxc						'
'
drawscreen:
portb = C0						'draw screen
high porta.3
pauseus 901
low porta.3
portb = C1						'
high porta.5
pauseus 901
low porta.5
portb = C2						'
high portc.0
pauseus 901
low portc.0
portb = C3						'
high portc.1
pauseus 901
low portc.1
portb = C4						'
high portc.2
pauseus 901
low portc.2
portb = C5						'
high portc.3
pauseus 901
low portc.3
portb = C6						'
high portc.4
pauseus 901
low portc.4
portb = C7						'
high portc.5
pauseus 901
low portc.5
portb = C8						'
high portc.6
pauseus 901
low portc.6
portb = C9						'
high portc.7
pauseus 901
low portc.7
portb = C10						'
high portd.0
pauseus 901
low portd.0
portb = C11						'
high portd.1
pauseus 901
low portd.1
portb = C12						'
high portd.2
pauseus 901
low portd.2
portb = C13						'
high portd.3
pauseus 901
low portd.3
portb = C14						'
high portd.4
pauseus 901
low portd.4
portb = C15						'
high portd.5
pauseus 901
low portd.5
portb = C16						'
high portd.6
pauseus 901
low portd.6
portb = C17						'
high portd.7
pauseus 901
low portd.7
porta.0 = 1						'
portb = $FF						'
IF sndout != 0 THEN					'
gosub sendsound						'
ELSE							'
pauseus 901						'
ENDIF							'
porta.0 = 0						'
return							'
'
clrscreen:
FOR cntq = 0 TO 17					'clear screen
cols[cntq] = 0						'
NEXT cntq						'
return							'
'
rotatesnake:
ii = 95							'
FOR cntx = 1 to 95					'
segs[ii] = segs[ii - 1]					'
ii = ii - 1						'
NEXT cntx						'
segs[0] = segment					'
return							'
'
encodesegment:
segment = sy						'
segment = segment << 5					'
segment = segment + sx					'
return							'
'
decodesegment:
@ clrf _sy						;
@ clrf _sx						;
sx.bit0 = segment.bit0					'
sx.bit1 = segment.bit1					'
sx.bit2 = segment.bit2					'
sx.bit3 = segment.bit3					'
sx.bit4 = segment.bit4					'
sy.bit0 = segment.bit5					'
sy.bit1 = segment.bit6					'
sy.bit2 = segment.bit7					'
return							'
'
clrsnake:
FOR cntt = 0 to 95					'
segs[cntt] = $FF					'
NEXT cntt						'
segs[0] = %10000101					'y=4,x=5 start head position
segs[1] = %10000100					'y=4,x=4
segs[2] = %10000011					'y=4,x=3 start tail position
direction = 9						'set invalid start direction
slen = 2						'set start snake length
retry:
gosub newpellet						'get new pellet coordinates
IF trypel = 1 THEN					'check if new pellet is a snake cell
goto retry						'get another set of coords
ENDIF							'
'
score = 0						'reset score
gameover = 0						'reset game over flag
return							'
'
movesnake:
IF direction > 3 THEN					'
direction = direction - 1				'
return							'
ENDIF							'
'
segment = segs[0]					'
gosub decodesegment					'
'
IF direction = up THEN					'check for new direction
sy = sy - 1						'
ENDIF							'
IF direction = down THEN				'
sy = sy + 1						'
ENDIF							'
IF direction = left THEN				'
sx = sx - 1						'
ENDIF							'
IF direction = right THEN				'
sx = sx + 1						'
ENDIF							'
'
IF (sx = px) AND (sy = py) THEN				'check for got pellet
IF slen < 95 THEN					'
slen = slen + 1						'

sndout = 1						'set sound out flag

ENDIF							'
score = score + 1					'increment player score
cntp = cntp + 1						'increment speed increase counter
IF cntp = 3 THEN					'every six pellets eaten
IF sspd > 1 THEN sspd = sspd - 1			'increase speed by one factor
ENDIF							'
retryx:
gosub newpellet						'
IF trypel = 1 THEN					'check if new pellet is a snake cell
goto retryx						'get another set of coords
ENDIF							'
ENDIF							'
'
IF sx = $FF THEN					'check for wall collision
gameover = 1						'
ENDIF							'
IF sy = $FF THEN					'
gameover = 1						'
ENDIF							'
IF sx = 18 THEN						'
gameover = 1						'
ENDIF							'
IF sy = 8 THEN						'
gameover = 1						'
ENDIF							'
'
FOR cnti = 0 TO slen					'check for cell collision
segment = segs[cnti]					'
@ clrf _baly						;
@ clrf _balx						;
balx.bit0 = segment.bit0				'
balx.bit1 = segment.bit1				'
balx.bit2 = segment.bit2				'
balx.bit3 = segment.bit3				'
balx.bit4 = segment.bit4				'
baly.bit0 = segment.bit5				'
baly.bit1 = segment.bit6				'
baly.bit2 = segment.bit7				'
IF (baly = sy) AND (balx = sx) THEN			'
gameover = 1						'
ENDIF							'
NEXT cnti						'
'
gosub encodesegment					'
IF gameover = 0 THEN					'
gosub rotatesnake					'
ENDIF							'
return							'
'
newpellet:
rnd = rnd + 1						'
rndx = rndx + 1						'
IF rnd = 29 THEN					'
rnd = 0							'
ENDIF							'
IF rndx = 30 THEN					'
rndx = 0						'
ENDIF							'
LOOKUP rnd,[12,5,1,16,3,2,10,9,3,14,15,4,17,2,6,13,2,11,8,7,14,10,5,11,6,15,7,9,7,16,0],px
LOOKUP rndx,[3,6,2,5,7,4,0,2,1,5,0,3,7,2,6,0,1,5,3,4,0,4,3,4,2,1,5,0,3,7,6,1],py
gosub checkpellet					'
return							'
'
checkpellet:
trypel = 0						'
FOR cnti = 0 TO slen					'check for cell collision
segment = segs[cnti]					'
@ clrf _baly						;
@ clrf _balx						;
balx.bit0 = segment.bit0				'
balx.bit1 = segment.bit1				'
balx.bit2 = segment.bit2				'
balx.bit3 = segment.bit3				'
balx.bit4 = segment.bit4				'
baly.bit0 = segment.bit5				'
baly.bit1 = segment.bit6				'
baly.bit2 = segment.bit7				'
IF (baly = py) AND (balx = px) THEN			'
trypel = 1						'
ENDIF							'
NEXT cnti						'
return							'
'
'
showscore:
W0 = score DIG 0					'
W0 = W0 + $30						'
gosub getchar						'
C10 = C0						'
C11 = C1						'
C12 = C2						'
C13 = C3						'
C14 = C4						'
W0 = score DIG 1					'
W0 = W0 + $30						'
gosub getchar						'
C7 = C4							'
C6 = C3							'
C5 = C2							'
C4 = C1							'
C3 = C0							'
C2 = 0							'
C1 = 0							'
C0 = 0							'
'
IF score > hiscore THEN					'"!" for highest score
C16 = $79						'
ENDIF							'
'
call fixdat						'
FOR ii = 0 TO 160					'
call drawscreen						'
'
IF ii > 151 THEN					'
@ rrf _C16						;
@ rrf _C7						;
@ rrf _C6						;
@ rrf _C5						;
@ rrf _C4						;
@ rrf _C3						;
@ rrf _C10						;
@ rrf _C11						;
@ rrf _C12						;
@ rrf _C13						;
@ rrf _C14						;
C16.bit7 = 1						'
C7.bit7 = 1						'
C6.bit7 = 1						'
C5.bit7 = 1						'
C4.bit7 = 1						'
C3.bit7 = 1						'
C10.bit7 = 1						'
C11.bit7 = 1						'
C12.bit7 = 1						'
C13.bit7 = 1						'
C14.bit7 = 1						'
ENDIF							'
'
NEXT ii							'
return							'
'
loadtitle:
FOR rndx = 0 TO 17					'
rnd = rndx						'
IF fun = 0 THEN						'
LOOKUP rnd,[$74,$54,$5C,$00,$7C,$40,$7C,$00,$7C,$50,$7C,$00,$7C,$10,$6C,$00,$7C,$54],rnd
ELSE							'
LOOKUP rnd,[$7C,$40,$00,$7C,$54,$00,$7C,$40,$00,$7C,$50,$2C,$00,$7C,$00,$74,$54,$5C],rnd
ENDIF							'
cols[rndx] = rnd					'
NEXT rndx						'
rnd = 0 : rndx = 0					'
return							'
'
randomise:
@ clrf	_rnd						'
@ clrf	_rndx						'
rnd.bit0 = cntq.bit0					'
rnd.bit1 = cntq.bit1					'
rnd.bit2 = cntq.bit2					'
rnd.bit3 = cntq.bit3					'
rndx.bit0 = cntq.bit3					'
rndx.bit1 = cntq.bit0					'
rndx.bit2 = cntq.bit2					'
rndx.bit3 = cntq.bit1					'
return							'
'
'
'*********************************** Tetris Game ****************************************
'
tetrisgamest:
'
WHILE porta.4 = 0					'wait for finger off button
gosub loadtitle						'load tetris title screen
call fixdat						'
call drawscreen						'
@ incf	_cntq						;
@ clrwdt						;
IF cntq > 12 THEN cntq = 0				'
WEND							'
'
FOR cntp = 0 TO 36					'delay title screen display
gosub loadtitle						'
call fixdat						'
call drawscreen						'
NEXT cntp						'
'
tetrisgame:
READ 1,hiscore						'
READ 2,hiscorex						'
speed = 0						'
shape = $FF						'
tetr = 0						'
sx = 0							'
sy = 0							'
rnd = 0							'
rndx = cntq						'
tetx = $02						'
tety = $FF						'
balx = 0						'
baly = 0						'
bata = 0						'
batb = 0						'
sspd = 25						'initial game speed
cntp = 0						'speed increase timer
cnti = 0						'button timer
death = $FF						'
'
gosub clrtetris						'initialise game
'
gfxd:							'
gosub clrscreen						'
speed = speed + 1					'
olddir = direction					'set old direction
direction = 9						'direction will be none unless changed
IF gameover = 0 THEN					'disable controls when game is over
IF porta.4 = 0 THEN					'UP
direction = up						'
ENDIF							'
IF porte.0 = 1 THEN					'DOWN
direction = down					'
IF ttimer = 3 THEN					'
speed = sspd						'
ttimer = 0						'
ENDIF							'
ENDIF							'
IF porta.2 = 1 THEN					'LEFT
direction = left					'
IF cnti = 10 THEN					'
IF ttimer = 8 THEN					'
gosub slideshape					'
ttimer = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
IF porta.1 = 0 THEN					'RIGHT
direction = right					'
IF cnti = 10 THEN					'
IF ttimer = 8 THEN					'
gosub slideshape					'
ttimer = 0						'
ENDIF							'
ENDIF							'
ENDIF							'
ENDIF							'gameover
'
IF olddir != direction THEN				'
cnti = 0						'
IF direction = up THEN					'
gosub rotateshape					'
ENDIF							'
IF direction = left OR direction = right THEN		'
gosub slideshape					'
ENDIF							'
IF direction = down THEN				'
gosub moveshape						'
ttimer = 0						'
ENDIF							'
ELSE							'
IF direction = left OR direction = right THEN		'
IF cnti < 10 THEN cnti = cnti + 1			'
IF cnti = 9 THEN ttimer = 0				'
ENDIF							'
ENDIF							'
'
IF speed > sspd THEN					'
speed = 0						'
IF death = $FF THEN					'death
gosub moveshape						'move the shape down
ENDIF							'death
ENDIF							'
'
IF gameover = 1 THEN					'restart game
death = death + 1					'
sndout = 2						'
sspd = 25						'reset game speed
ENDIF							'
'
IF death = 160 THEN					'
gosub tshowscore					'
IF tscore > thiscore THEN				'
thiscore = tscore					'
WRITE 1, hiscore					'
WRITE 2, hiscorex					'
ENDIF							'
goto tetrisgame						'
ENDIF							'
'
IF death.bit4 = 1 THEN					'flash screen if game over
gosub drawwell						'draw the frame
ENDIF							'
'
call fixdat						'
call drawscreen						'
ttimer = ttimer + 1					'increment timer
goto gfxd						'
'
'
flashrows:
FOR tetrisd = 0 TO 76					'
gosub clrscreen						'
FOR tetrisc = 0 TO 17					'
cols[tetrisc] = segs[tetrisc]				'
IF cols[tetrisc] = $FF THEN				'
IF tetrisd.bit4 = 1 THEN				'
cols[tetrisc] = 0					'
ENDIF							'
ENDIF							'
NEXT tetrisc						'
call fixdat						'
call drawscreen						'
NEXT tetrisd						'
'
cntp = cntp + 1						'increment speed increase counter
IF cntp = 2 THEN					'
IF sspd > 1 THEN sspd = sspd - 1			'increase speed by one factor
ENDIF							'
IF cntp > 1 THEN cntp = 0				'
return							'
'
'
rndshape:
rnd = rnd + 1						'pseudo random shape generator
rndx = rndx + 1						'
IF rnd = 60 THEN					'
rnd = 0							'
ENDIF							'
IF rndx = 15 THEN					'
rndx = 0						'
ENDIF							'
IF ttimer.bit1 != ttimer.bit0 THEN			'
IF ttimer.bit0 = 1 THEN					'
READ rnd+3,shape					'read from random shape table 1
ELSE							'
LOOKUP rndx,[5,2,0,5,3,5,4,1,6,4,1,4,5,3,2],shape	'random shape table 2
ENDIF							'
ELSE							'
IF ttimer.bit0 = 1 THEN					'
READ rnd+3,shape					'read from random shape table 1
ELSE							'
LOOKUP rndx,[0,3,5,4,6,2,1,3,5,0,5,2,1,4,5],shape	'random shape table 3
ENDIF							'
ENDIF							'
return							'
'
'
slideshape:
norot = 0						'
IF direction = left THEN				'direction is left
tetx = tetx - 1						'
gosub lwall						'
ELSE							'direction is right
tetx = tetx + 1						'
gosub rwall						'
ENDIF							'direction
'
cntz = tety + blockay					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockby					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockcy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockdy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
norot = 1						'
ENDIF							'
'
IF direction = left THEN				'
IF norot = 1 THEN tetx = tetx + 1			'
ELSE							'
IF norot = 1 THEN tetx = tetx - 1			'
ENDIF							'
return							'
'
'
lwall:
IF tetx + blockax = $FF THEN norot = 1			'
IF tetx + blockbx = $FF THEN norot = 1			'
IF tetx + blockcx = $FF THEN norot = 1			'
IF tetx + blockdx = $FF THEN norot = 1			'
return							'
'
rwall:
IF tetx + blockax = $08 THEN norot = 1			'
IF tetx + blockbx = $08 THEN norot = 1			'
IF tetx + blockcx = $08 THEN norot = 1			'
IF tetx + blockdx = $08 THEN norot = 1			'
return							'
'
'
rotateshape:
IF shape < 3 THEN					'
tetr = tetr + 1						'rotate any of first three shapes
IF tetr > 3 THEN tetr = 0				'
ENDIF							'
IF shape > 2 THEN					'
IF shape != 6 THEN					'
IF tetr = 0 THEN					'rotate any of shapes 3,4 & 5.
tetr = 1						'
ELSE							'
tetr = 0						'
ENDIF							'
ENDIF							'
ENDIF							'note the square shape does not need rotating
'
gosub getshape						'retrieve shape from table
'
norot = 0						'reset rotation collision flag
cntz = tety + blockay					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockby					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockcy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
norot = 1						'
ENDIF							'
cntz = tety + blockdy					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
norot = 1						'
ENDIF							'
'
gosub lwall						'check for collision with well walls
gosub rwall						'
'
IF norot = 1 THEN					'rotate shape in reverse if it collided
IF shape < 3 THEN					'
tetr = tetr - 1						'rotate any of first three shapes
IF tetr = $FF THEN tetr = $03				'
ENDIF							'
IF shape > 2 THEN					'
IF shape != 6 THEN					'
IF tetr = 0 THEN					'rotate any of shapes 3,4 & 5.
tetr = 1						'
ELSE							'
tetr = 0						'
ENDIF							'
ENDIF							'
ENDIF							'note the square shape does not need rotating
gosub getshape						'retrieve shape from table
ENDIF							'
return							'
'
'
drawwell:
IF newshape = 1 THEN					'set new shape coordinates
gosub rndshape						'get random shape type
'
tetx = $02 : tety = $FF					'
IF shape = 3 THEN					'
tetx = $02 : tety = $FE					'
ENDIF							'
IF shape = 6 THEN					'
tetx = $03 : tety = $00					'
ENDIF							'
ENDIF							'
'
FOR cntz = 0 TO 17					'paste well to screen buffer
cols[cntz] = segs[cntz]					'
NEXT cntz						'
'
gosub getshape						'retrieve shape from table
'
balx = tetx + blockax : baly = tety + blockay		'
gosub vdrawbit						'
balx = tetx + blockbx : baly = tety + blockby		'
gosub vdrawbit						'
balx = tetx + blockcx : baly = tety + blockcy		'
gosub vdrawbit						'
balx = tetx + blockdx : baly = tety + blockdy		'
gosub vdrawbit						'
'
IF newshape = 1 THEN					'one of two end game checks
cntz = tety + blockay+1					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockby+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockcy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
gameover = 1						'
ENDIF							'
cntz = tety + blockdy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
gameover = 1						'
ENDIF							'
ENDIF							'
'
newshape = 0						'
return							'
'
'
moveshape:
hitfloor = 0						'
IF tety + blockay = 17 THEN hitfloor = 1		'check for any blocks on the floor
IF tety + blockby = 17 THEN hitfloor = 1		'
IF tety + blockcy = 17 THEN hitfloor = 1		'
IF tety + blockdy = 17 THEN hitfloor = 1		'
'
cntz = tety + blockay+1					'check for collision with other blocks
D0 = segs[cntz]						'
IF D0.0(tetx + blockax) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockby+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockbx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockcy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockcx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
cntz = tety + blockdy+1					'
D0 = segs[cntz]						'
IF D0.0(tetx + blockdx) = 1 THEN			'
hitfloor = 1						'
ENDIF							'
'
IF hitfloor = 1 THEN					'
newshape = 1						'
gosub lockin						'lock shape into well
fbit = 1						'
gosub checkrows						'check for completed rows
gosub checkrows						'
gosub checkrows						'
gosub checkrows						'
tetr = 0						'
'
hitroof = 0						'two of two end game checks
IF tety + blockay = 0 THEN hitroof = 1			'check for any blocks on the roof
IF tety + blockby = 0 THEN hitroof = 1			'
IF tety + blockcy = 0 THEN hitroof = 1			'
IF tety + blockdy = 0 THEN hitroof = 1			'
IF hitroof = 1 THEN					'
newshape = 0						'
gameover = 1						'
ENDIF							'
'
ELSE							'
tety = tety + 1						'
ENDIF							'
return							'
'
'
checkrows:
tetrisb = 99						'
FOR tetrisa = 0 TO 17					'
IF segs[tetrisa] = $FF THEN				'
IF fbit = 1 THEN					'
gosub flashrows						'
fbit = 0						'
ENDIF							'
tetrisb = tetrisa					'
tscore = tscore + 1					'
ENDIF							'
NEXT tetrisa						'
IF tetrisb != 99 THEN					'
W1 = tetrisb						'
FOR tetrisa = 0 TO tetrisb				'
segs[W1] = segs[W1-1]					'
W1 = W1 - 1						'
NEXT tetrisa						'
segs[0] = 0						'
ENDIF							'
return							'
'
'
lockin:
cntz = tety + blockay					'
W1 = segs[cntz]						'
IF tetx + blockax = 0 THEN W1.bit0 = 1			'
IF tetx + blockax = 1 THEN W1.bit1 = 1			'
IF tetx + blockax = 2 THEN W1.bit2 = 1			'
IF tetx + blockax = 3 THEN W1.bit3 = 1			'
IF tetx + blockax = 4 THEN W1.bit4 = 1			'
IF tetx + blockax = 5 THEN W1.bit5 = 1			'
IF tetx + blockax = 6 THEN W1.bit6 = 1			'
IF tetx + blockax = 7 THEN W1.bit7 = 1			'
segs[cntz] = W1						'
cntz = tety + blockby					'
W1 = segs[cntz]						'
IF tetx + blockbx = 0 THEN W1.bit0 = 1			'
IF tetx + blockbx = 1 THEN W1.bit1 = 1			'
IF tetx + blockbx = 2 THEN W1.bit2 = 1			'
IF tetx + blockbx = 3 THEN W1.bit3 = 1			'
IF tetx + blockbx = 4 THEN W1.bit4 = 1			'
IF tetx + blockbx = 5 THEN W1.bit5 = 1			'
IF tetx + blockbx = 6 THEN W1.bit6 = 1			'
IF tetx + blockbx = 7 THEN W1.bit7 = 1			'
segs[cntz] = W1						'
cntz = tety + blockcy					'
W1 = segs[cntz]						'
IF tetx + blockcx = 0 THEN W1.bit0 = 1			'
IF tetx + blockcx = 1 THEN W1.bit1 = 1			'
IF tetx + blockcx = 2 THEN W1.bit2 = 1			'
IF tetx + blockcx = 3 THEN W1.bit3 = 1			'
IF tetx + blockcx = 4 THEN W1.bit4 = 1			'
IF tetx + blockcx = 5 THEN W1.bit5 = 1			'
IF tetx + blockcx = 6 THEN W1.bit6 = 1			'
IF tetx + blockcx = 7 THEN W1.bit7 = 1			'
segs[cntz] = W1						'
cntz = tety + blockdy					'
W1 = segs[cntz]						'
IF tetx + blockdx = 0 THEN W1.bit0 = 1			'
IF tetx + blockdx = 1 THEN W1.bit1 = 1			'
IF tetx + blockdx = 2 THEN W1.bit2 = 1			'
IF tetx + blockdx = 3 THEN W1.bit3 = 1			'
IF tetx + blockdx = 4 THEN W1.bit4 = 1			'
IF tetx + blockdx = 5 THEN W1.bit5 = 1			'
IF tetx + blockdx = 6 THEN W1.bit6 = 1			'
IF tetx + blockdx = 7 THEN W1.bit7 = 1			'
segs[cntz] = W1						'
'
IF tetx = $FF THEN					'fix for problem shape rotation combinations
IF tetr = 3 THEN					'
IF shape = 1 THEN					'
cntz = tety + blockdy					'
gosub memsave						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockby					'
W1 = segs[cntz]						'
W1.bit0 = 1						'
W1.bit1 = 1						'
segs[cntz] = W1						'
ENDIF							'shape
IF shape = 2 THEN					'
cntz = tety + blockdy					'
W1 = segs[cntz]						'
W1.bit0 = 1						'
W1.bit1 = 1						'
segs[cntz] = W1						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockay					'
gosub memsave						'
ENDIF							'shape
ENDIF							'tetr
IF tetr = 1 THEN					'
IF shape = 3 THEN					'
cntz = tety + blockdy					'
gosub memsave						'
cntz = tety + blockcy					'
gosub memsave						'
cntz = tety + blockby					'
gosub memsave						'
cntz = tety + blockay					'
gosub memsave						'
ENDIF							'shape
ENDIF							'tetr
ENDIF							'tetx
return							'
'
memsave:
W1 = segs[cntz]						'just a few lines that get repeated
W1.bit0 = 1						'saving space putting it here
segs[cntz] = W1						'
return							'
'
getshape						'
IF shape = 0 THEN					'copy current rotated shape to buffer
IF tetr = 0 THEN					'
cntz = 0						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 4						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 2 THEN					'
cntz = 8						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 3 THEN					'
cntz = 12						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 1 THEN					'
IF tetr = 0 THEN					'
cntz = 16						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 20						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 2 THEN					'
cntz = 24						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 3 THEN					'
cntz = 28						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 2 THEN					'
IF tetr = 0 THEN					'
cntz = 32						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 36						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 2 THEN					'
cntz = 40						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 3 THEN					'
cntz = 44						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 3 THEN					'
IF tetr = 0 THEN					'
cntz = 48						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 52						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 4 THEN					'
IF tetr = 0 THEN					'
cntz = 56						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 60						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 5 THEN					'
IF tetr = 0 THEN					'
cntz = 64						'set address
gosub loadsh						'load shape
ENDIF							'
IF tetr = 1 THEN					'
cntz = 68						'set address
gosub loadsh						'load shape
ENDIF							'
ENDIF							'
'
IF shape = 6 THEN					'
cntz = 72						'set address
gosub loadsh						'load shape
ENDIF							'
return							'
'
'
loadsh:
segment = segs[cntz + 20]				'
gosub decodesegment					'
blockax = sx						'
blockay = sy						'
segment = segs[cntz + 21]				'
gosub decodesegment					'
blockbx = sx						'
blockby = sy						'
segment = segs[cntz + 22]				'
gosub decodesegment					'
blockcx = sx						'
blockcy = sy						'
segment = segs[cntz + 23]				'
gosub decodesegment					'
blockdx = sx						'
blockdy = sy						'
return							'
'
'
clrtetris:
FOR cntt = 0 to 19					'clear well
segs[cntt] = $00					'
NEXT cntt						'
cntt = 20						'set index
sx = 0 : sy = 1						'000
gosub encodestore					'XXX
							'X00
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 0						'X00
gosub encodestore					'X00
							'XX0
sx = 0 : sy = 1						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'00X
gosub encodestore					'XXX
							'000
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 0						'
gosub encodestore					'
							'
sx = 0 : sy = 0						'XX0
gosub encodestore					'0X0
							'0X0
sx = 1 : sy = 0						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'000
gosub encodestore					'XXX
							'00X
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 2						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'0X0
gosub encodestore					'0X0
							'XX0
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 0						'X00
gosub encodestore					'XXX
							'000
sx = 0 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'0XX
gosub encodestore					'0X0
							'0X0
sx = 2 : sy = 0						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'000
gosub encodestore					'XXX
							'0X0
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'0X0
gosub encodestore					'XX0
							'0X0
sx = 1 : sy = 0						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'0X0
gosub encodestore					'XXX
							'000
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'0X0
gosub encodestore					'0XX
							'0X0
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'0000
gosub encodestore					'0000
							'XXXX
sx = 1 : sy = 2						'0000
gosub encodestore					'
							'
sx = 2 : sy = 2						'
gosub encodestore					'
							'
sx = 3 : sy = 2						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'0X00
gosub encodestore					'0X00
							'0X00
sx = 1 : sy = 1						'0X00
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 1 : sy = 3						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'000
gosub encodestore					'XX0
							'0XX
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 2 : sy = 2						'
gosub encodestore					'
							'
sx = 1 : sy = 0						'0X0
gosub encodestore					'XX0
							'X00
sx = 0 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 2						'000
gosub encodestore					'0XX
							'XX0
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 2 : sy = 1						'
gosub encodestore					'
							'
sx = 0 : sy = 0						'X00
gosub encodestore					'XX0
							'0X0
sx = 0 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 1						'
gosub encodestore					'
							'
sx = 1 : sy = 2						'
gosub encodestore					'
							'
sx = 0 : sy = 0						'XX0
gosub encodestore					'XX0
							'000
sx = 1 : sy = 0						'
gosub encodestore					'
							'
sx = 0 : sy = 1						'
gosub encodestore
sx = 1 : sy = 1						'
gosub encodesegment					'
segs[cntt] = segment					'
direction = 9						'set invalid start direction
olddir = 9						'set initial old direction
shape = 0						'set start shape
tetr = 0						'reset shape rotation
tscore = 0						'reset score
newshape = 1						'set introduce new shape flag
gameover = 0						'reset game over flag
hitroof = 0						'reset hit roof flag
ttimer = 0						'reset button timer
return							'
'
encodestore:
gosub encodesegment					'
segs[cntt] = segment : cntt = cntt + 1			'
return							'
'
getchar:
if (W0 = $21) THEN ' !
C0 = $00'
C1 = $00'
C2 = $79'
C3 = $00'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $30) THEN ' 0
C0 = $3E'
C1 = $45'
C2 = $49'
C3 = $51'
C4 = $3E'
wchar = 1
ENDIF'
if (W0 = $31) THEN ' 1
C0 = $00'
C1 = $21'
C2 = $7F'
C3 = $01'
C4 = $00'
wchar = 1
ENDIF'
if (W0 = $32) THEN ' 2
C0 = $21'
C1 = $43'
C2 = $45'
C3 = $49'
C4 = $31'
wchar = 1
ENDIF'
if (W0 = $33) THEN ' 3
C0 = $42'
C1 = $41'
C2 = $51'
C3 = $69'
C4 = $46'
wchar = 1
ENDIF'
if (W0 = $34) THEN ' 4
C0 = $0C'
C1 = $14'
C2 = $24'
C3 = $7F'
C4 = $04'
wchar = 1
ENDIF'
if (W0 = $35) THEN ' 5
C0 = $72'
C1 = $51'
C2 = $51'
C3 = $51'
C4 = $4E'
wchar = 1
ENDIF'
if (W0 = $36) THEN ' 6
C0 = $1E'
C1 = $29'
C2 = $49'
C3 = $49'
C4 = $06'
wchar = 1
ENDIF'
if (W0 = $37) THEN ' 7
C0 = $60'
C1 = $40'
C2 = $47'
C3 = $48'
C4 = $70'
wchar = 1
ENDIF'
if (W0 = $38) THEN ' 8
C0 = $36'
C1 = $49'
C2 = $49'
C3 = $49'
C4 = $36'
wchar = 1
ENDIF'
if (W0 = $39) THEN ' 9
C0 = $30'
C1 = $49'
C2 = $49'
C3 = $4A'
C4 = $3C'
wchar = 1
ENDIF'
return							'
'
'
sendsound:
IF sndout = 1 THEN					'
serout2 portd.2,16416,["J"]				'19200 baud Talkbot code
ELSE							'
serout2 portd.2,16416,["I"]				'19200 baud Talkbot code
ENDIF							'
trisd.2 = 1						'
sndout = 0						'clear sound out flag
return							'
'
tshowscore:
FOR ix = 0 TO 95					'delete array
segs[ix] = 0						'
NEXT ix							'
ix = 20							'
W0 = tscore DIG 3					'
W0 = W0 + $30						'
gosub getchar						'
gosub printchar						'
W0 = tscore DIG 2					'
W0 = W0 + $30						'
gosub getchar						'
gosub printchar						'
W0 = tscore DIG 1					'
W0 = W0 + $30						'
gosub getchar						'
gosub printchar						'
W0 = tscore DIG 0					'
W0 = W0 + $30						'
gosub getchar						'
gosub printchar						'
'
FOR ix = 0 TO 56					'
FOR ii = 0 TO 17					'
cols[ii] = segs[ii+ix]					'
NEXT ii							'
'
IF tscore < thiscore THEN				'
call fixdat						'
ELSE							'
IF ix.bit0 = 0 THEN					'
FOR ii = 0 TO 17					'
cols[ii] = $FF						'
NEXT ii							'
ELSE							'
call fixdat						'
ENDIF							'
ENDIF							'
'
FOR ii = 0 TO 4						'speed of Tetris high score scroll
call drawscreen						'
NEXT ii							'
NEXT ix							'
return							'
'
'
printchar:
W0 = 0							'
W0.bit1 = C0.bit7					'
W0.bit2 = C1.bit7					'
W0.bit3 = C2.bit7					'
W0.bit4 = C3.bit7					'
W0.bit5 = C4.bit7					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit6					'
W0.bit2 = C1.bit6					'
W0.bit3 = C2.bit6					'
W0.bit4 = C3.bit6					'
W0.bit5 = C4.bit6					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit5					'
W0.bit2 = C1.bit5					'
W0.bit3 = C2.bit5					'
W0.bit4 = C3.bit5					'
W0.bit5 = C4.bit5					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit4					'
W0.bit2 = C1.bit4					'
W0.bit3 = C2.bit4					'
W0.bit4 = C3.bit4					'
W0.bit5 = C4.bit4					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit3					'
W0.bit2 = C1.bit3					'
W0.bit3 = C2.bit3					'
W0.bit4 = C3.bit3					'
W0.bit5 = C4.bit3					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit2					'
W0.bit2 = C1.bit2					'
W0.bit3 = C2.bit2					'
W0.bit4 = C3.bit2					'
W0.bit5 = C4.bit2					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit1					'
W0.bit2 = C1.bit1					'
W0.bit3 = C2.bit1					'
W0.bit4 = C3.bit1					'
W0.bit5 = C4.bit1					'
segs[ix] = W0						'
ix = ix + 1						'
W0 = 0							'
W0.bit1 = C0.bit0					'
W0.bit2 = C1.bit0					'
W0.bit3 = C2.bit0					'
W0.bit4 = C3.bit0					'
W0.bit5 = C4.bit0					'
segs[ix] = W0						'
ix = ix + 1						'
return							'
'
'

