﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Runtime.InteropServices; // Clase para importar DLL

namespace picHID
{
    unsafe public class easyHID
    {
        [DllImport("mcHID.dll", EntryPoint = "Connect", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidConnect(int pHostWin);
        [DllImport("mcHID.dll", EntryPoint = "Disconnect", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidDisconnect();
        [DllImport("mcHID.dll", EntryPoint = "GetItem", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetItem(int pIndex);
        [DllImport("mcHID.dll", EntryPoint = "GetItemCount", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetItemCount();
        [DllImport("mcHID.dll", EntryPoint = "Read", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidRead(int pHandle, ref byte pData);
        [DllImport("mcHID.dll", EntryPoint = "Write", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidWrite(int pHandle, ref byte pData);
        [DllImport("mcHID.dll", EntryPoint = "ReadEx", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidReadEx(int pVendorID, int pProductID, ref byte pData);
        [DllImport("mcHID.dll", EntryPoint = "WriteEx", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidWriteEx(int pVendorID, int pProductID, ref byte pData);
        [DllImport("mcHID.dll", EntryPoint = "GetHandle", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetHandle(int pVendoID, int pProductID);
        [DllImport("mcHID.dll", EntryPoint = "GetVendorID", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetVendorID(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "GetProductID", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetProductID(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "GetVersion", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetVersion(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "GetVendorName", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetVendorName(int pHandle, string pText, int pLen);
        [DllImport("mcHID.dll", EntryPoint = "GetProductName", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetProductName(int pHandle, string pText, int pLen);
        [DllImport("mcHID.dll", EntryPoint = "GetSerialNumber", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetSerialNumber(int pHandle, string pText, int pLen);
        [DllImport("mcHID.dll", EntryPoint = "GetInputReportLength", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetInputReportLength(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "GetOutputReportLength", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int hidGetOutputReportLength(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "SetReadNotify", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern void hidSetReadNotify(int pHandle, bool pValue);
        [DllImport("mcHID.dll", EntryPoint = "IsReadNotifyEnabled", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidIsReadNotifyEnabled(int pHandle);
        [DllImport("mcHID.dll", EntryPoint = "IsAvailable", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern bool hidIsAvailable(int pVendorID, int pProductID);
        [DllImport("user32", EntryPoint = "CallWindowProcA", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int CallWindowProc(int lpPrevWndFunc, int hwnd, int Msg, int wParam, int lParam);
        [DllImport("user32", EntryPoint = "SetWindowLongA", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int SetWindowLong(int hwnd, int nIndex, int dwNewLong);
        //Declaramos todas las funciones.


        public delegate int SubClassProcDelegate(int hwnd, int msg, int wParam, int lParam);
        [DllImport("USER32.DLL", EntryPoint = "SetWindowLongA", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = true)]
        public static extern int DelegateSetWindowLong(int hwnd, int attr, SubClassProcDelegate lval);

        // Constantes de la aplicación.
        public const int WM_APP = 32768;
        public const short GWL_WNDPROC = -4;

        // Constantes de mensajes de easyHID.
        private const decimal WM_HID_EVENT = WM_APP + 200;
        private const short NOTIFY_PLUGGED = 1;
        private const short NOTIFY_UNPLUGGED = 2;
        private const short NOTIFY_CHANGED = 3;
        private const short NOTIFY_READ = 4;

        // Variables locales.
        private static int FPrevWinProc;
        private static int FWinHandle;
        private static SubClassProcDelegate Ref_WinProc = new SubClassProcDelegate(WinProc);
        private static object HostForm;

        //Espera a recibir un mensaje del controlador HOST y luego se conecta a el mediante la librería de
        //Funciones.
        public static bool ConnectToHID(ref Form targetForm)
        {
            long pHostWin = targetForm.Handle.ToInt32;
            FWinHandle = pHostWin;
            pHostWin = hidConnect(FWinHandle);
            FPrevWinProc = DelegateSetWindowLong(FWinHandle, GWL_WNDPROC, Ref_WinProc);
            HostForm = targetForm;
        }

        // Se desconecta del HOST.
        public static bool DisconnectFromHID()
        {
            bool functionReturnValue = false;
            functionReturnValue = hidDisconnect;
            SetWindowLong(FWinHandle, GWL_WNDPROC, FPrevWinProc);
            return functionReturnValue;
        }

        private static int WinProc(int pHWnd, int pMsg, int wParam, int lParam)
    {
        if (pMsg == WM_HID_EVENT) {
            switch (wParam) {
               
                // Mensaje de que un dispositivo se ha conectado al host.
                case // ERROR: Case labels with binary operators are unsupported : Equality NOTIFY_PLUGGED:
                HostForm.OnPlugged(lParam):
                    break;
                // Mensaje de que un dispositivo se ha desconectado del host.
                case // ERROR: Case labels with binary operators are unsupported : Equality NOTIFY_UNPLUGGED:
                HostForm.OnUnplugged(lParam):
                    break;
                // El controlador ha cambiado.
                case // ERROR: Case labels with binary operators are unsupported : Equality NOTIFY_CHANGED:
                HostForm.OnChanged():
                    break;
                // Se he recibido un dato.
                case // ERROR: Case labels with binary operators are unsupported : Equality NOTIFY_READ:
                HostForm.OnRead(lParam):
                    break;
            }
        }
           
        return CallWindowProc(FPrevWinProc, pHWnd, pMsg, wParam, lParam);
    }

    }
}