'****************************************************************
'*  Name    : ENC.BAS                                           *
'*  Author  : B. Reynolds                                       *
'*  Notice  : Copyright (c) 2009 Reynolds Electronics           *
'*          : All Rights Reserved                               *
'*  Date    : 11/15/2009                                        *
'*  Version : 1.0                                               *
'*  Notes   : 4-BIT ENCODER IC FOR RF REMOTE CONTROL            *
'*          : USING THE PIC12F635                               *
'****************************************************************
@ DEVICE PIC12F635,MCLR_OFF,INTRC_OSC_NOCLKOUT,WDT_OFF,BOD_OFF
@ DEVICE PWRT_ON,FCMEN_OFF,IESO_OFF,WUREN_OFF,PROTECT_OFF
    
    DEFINE OSC 4
    DEFINE NO_CLRWDT 1
    
    SYMBOL  MODE = GPIO.3  ' baud select. 1=4800, 0=2400
    SYMBOL  E_OUT = GPIO.5 ' Encoder data out pin
    
    DAT_OUT VAR BYTE    ' Holds 8-bit data byte
    LOOPS   VAR BYTE    ' Loop var
    CHK_SUM VAR BYTE    ' Holds calculated checksum of outbound data
    BAUD    VAR WORD    ' Holds baud rate
    
    ' Constants
    PreAmble CON $A5    ' 10100101 preamble
    Synch    CON "~"    ' 01111110 synch byte
    N2400    CON 16780  ' 2400 bps inverted
    N4800    CON 16572  ' 4800 bps inverted
    GUARD    CON 5      ' 5mS guard time pause
    
     ' hardware init
    E_OUT = 0           ' Data out to RF transmitter=0 (transmiter off)
    TRISIO = %00011111  ' GPIO.0,1,2,3,4 inputs
    WPUDA = %00000000   ' Internal pull-ups OFF, use external 100K pull-downs   
    VRCON = 0           ' Disable internal Vref
    CMCON0 = 7          ' Disable comparators
    OSCCON = %01100000  ' Internal 4MHz select
    OPTION_REG = 128    ' Pull-ups off
    IOCA = %00010111    ' Interrupt on change on for GPIO.0, 1, 2, 4
    INTCON = %00001000  ' Enable port change wakeup from sleep
      
Main:
    IF MODE = 1 THEN    ' Set pin-selected data rate
       BAUD = N4800     ' MODE = 1 so use N4800
    ELSE                ' Else
       BAUD = N2400     ' MODE = 0 so use N2400
    ENDIF
    
    ' Read port to clear missmatch, if no buttons pressed, then
    ' clear int-on-change flag & snooze until wake up on change

    IF (GPIO & %00010111) = 0 THEN  ' GPIO=0 only when no buttons are pressed
       INTCON.0 = 0    ' No buttons down, so clear int on change flag
       @ SLEEP         ' and start snoozin..zzzzzzzzzzz
       @ NOP           ' Do nothing for 1st instruction on wake-up    
    ENDIF  
    ' if GPIO is not = 0 a button was pressed (or being held down), so keep going   

Encode:  
    ' Only DAT_OUT bits 0, 1, 2, and 4 are used. We add a few 1's in
    ' bit positions 6 & 3 to help balance the data packet being sent.

    DAT_OUT = %01001000
    ' Get data on button inputs
    DAT_OUT.0[0]=GPIO.0
    DAT_OUT.0[1]=GPIO.1
    DAT_OUT.0[2]=GPIO.2
    DAT_OUT.0[4]=GPIO.4
    INTCON.0 = 0  ' Clear int on change flag
      
    ' Build checksum of 2 data bytes
    CHK_SUM = (DAT_OUT * 2)
    
Transmit:
    SEROUT2 E_OUT,BAUD,[PreAmble,Synch,DAT_OUT,DAT_OUT,CHK_SUM]
    E_OUT = 0   ' TX out to RF transmitter stays at 0 during idle periods
    PAUSE GUARD ' 5mS guard time gives decoder time to respond,calculate,change,etc.
    
    GOTO Main
        
    END
