; Ver:  0 alpha 2
; Date: 26.Jan.1999

; This is a basic DCC decoder with the 12c508/9
; It uses the internal osc. Execution cycle is 1us.
; Implemented is speed28 control only in this coding
; It incorporates ideas from D.Probst DCC decoder project

;    Copyright (C) 1998/99  Heiko Schroeter
;    Parts copyright (C) Dean Probst

;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.

;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.

;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;    Contact :
;    Dipl.-Ing. Schroeter
;    Labor ELNU
;    Hochschule Bremen
;    Neustadtswall 30
;    28199 Bremen /GERMANY
;    schroete@etech.hs-bremen.de

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
; NOTICE: In ALPHA stadium, this is experimental code.
; Its purpose is to discuss further developments into
; the decoder
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        LIST       p=12c508a             ; target processor
        #include   "P12c508a.inc"        ; include Header file

       __CONFIG   _CP_OFF & _WDT_OFF & _MCLRE_OFF & _IntRC_OSC

;******************************************************
MYADRESS        equ     0x44   ; DECODER ADDRESS because there is no EEPROM yet

;******************************************************
; RAM locations

CONFIG  	equ     0x07    ; Contains various bits to test
MOTMASK 	equ     0x08    ; Motormask for direction
PWM     	equ     0x09    ; How long is motor on
PRECOUNT    	equ     0x0B    ; Preamble counter
STATE   	equ     0x0C    ; Where are we in the DCC package
DATA1   	equ     0X0D    ; First transm. byte
DATA2   	equ     0x0E    ; Second trans. byte
DATA3   	equ     0x0F    ; Third transm. byte
DATA5   	equ     0x10    ; Scratch Register
SAMPLES 	equ     0x11    ; How many samples taken for one or zero
DAT2OLD 	equ     0x12    ; Save previous DATA to compare

;******************************************************
; VARIABLES

FORWARD     equ     B'00000010'     ; Masks for Direction of MOTMASK
BACKWARD    equ     B'00000100'     ; GPIO 1 and GPIO 2 are the outputs
                                    ; hence GPIO 1 is FORWARD Output

NOPREAMB    equ     D'19'   ; No. of preamble bits = 20
MAXCOUNT    equ     D'250'  ; Motor on for max 250*128us=32ms

GP3         equ     D'3'    ; GP3 is INPUT

;******************************************************
; Bit Positions in config

BITREC  	equ     0       ; What value has just rec. bit

;******************************************************
; speed is the PWM output takes 9 cycl. TMR0 wraps
; around after 0xFF

speed   macro   jumpto
        local   on,off

        bcf     STATUS,C        ; clear carry because we use it
        movf    TMR0,W
        subwf   PWM,W
        btfss   STATUS,C
        goto    off

on:     movf    MOTMASK,W       ;direction in motormask
        movwf   GPIO
        nop
        nop
        nop
        goto    jumpto

off:    clrf    GPIO
        nop
        nop
        nop
        goto    jumpto

        endm

;******************************************************
;       Here we start !
        org     0x000
;******************************************************
; init sets all what is ness.

init:   
	movwf   OSCCAL
	clrf    CONFIG
      clrf    MOTMASK
      clrf    PWM
      clrf    STATE
      clrf    DATA1
      clrf    DATA2
      clrf    DATA3
      clrf    DATA5
      clrf    SAMPLES
      clrf    DAT2OLD

; Pin connection of 12C508
; GP1 = Motor out
; GP2 = Motor out
;
; GP3 = Data input
      movlw   B'11111001'
      tris    GPIO

; OPTION        Bit5 = TOCS (Timer clock source)
;       		Bit4 = TOSE (Timer source edge )
;       		Bit3 = Prescaler assignement to TMR0
;       		BIT2-0 = Prescaler rate
      movlw   B'11000110'
      option

      clrf    GPIO    ; turn motor off for the first time
      movlw   NOPREAMB
      movwf   PRECOUNT

;******************************************************
; Main loop is here. Track is sampled every 22us
; 0 sample -> error
; 1-2 samples -> one received
; > 2 samples -> zero received

starthi:        call    Value
conthi: btfss   GPIO,GP3
        goto    startlo
        btfss   SAMPLES,7
        incf    SAMPLES,F
        bcf     CONFIG,BITREC
        bcf     STATUS,C
        movlw   0xFD
        addwf   SAMPLES,W
        btfss   STATUS,C
        bsf     CONFIG,BITREC
        speed   conthi
;
;
startlo:        call    Value
contlo: btfsc   GPIO,GP3
        goto    starthi
        btfss   SAMPLES,7
        incf    SAMPLES,F
        bcf     CONFIG,BITREC
        bcf     STATUS,C
        movlw   0xFD
        addwf   SAMPLES,W
        btfss   STATUS,C
        bsf     CONFIG,BITREC
        speed   contlo

;******************************************************
; reset here after error

resetv: movlw   NOPREAMB
        movwf   PRECOUNT
        clrf    STATE
        clrf    SAMPLES
        retlw   0
;******************************************************
; decoder reset

decreset:       movlw   NOPREAMB
        movwf   PRECOUNT
        clrf    STATE
        clrf    DATA1
        clrf    DATA2
        clrf    DATA3
        clrf    DATA5
        clrf    SAMPLES
        clrf    CONFIG
        clrf    DAT2OLD
        retlw 0

;******************************************************
; Value checks for correct bit and jumps to where we are
; in DCC package
; 5 cycl. to here

Value:  movf    SAMPLES,W
        btfsc   STATUS,Z        ; if m=0 then error
        goto    resetv  ; event. waitn n cycles
        clrf    SAMPLES
        movf    STATE,W
        addwf   PCL,F   ; 10 cycl to here

; Jump table to routines from where we do a RETURN !
        goto    waitn   ; 13 cycl. to here -> 9 cycl for rout.
        goto    waitlo
        goto    testlo
; First byte
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv   ; First byte received here

        goto    end11
        goto    end12

; Second byte
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv   ; Second byte received here

        goto    end21
        goto    end22

; Third byte
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv
        goto    bitset
        goto    lastv   ; Third byte received here

        goto    end31
        goto    end32

;******************************************************
; waitn waits for 20 half bits of the preamble

waitn:  btfss   CONFIG,BITREC   ; there are only ones in preamble
        goto    waitn1
        decfsz  PRECOUNT,F
        goto    ret4
        movlw   NOPREAMB
        movwf   PRECOUNT
        incf    STATE,F
        retlw   0                  ; 9 cycl.
ret4:   nop
        nop
        retlw   0                  ; 9 cycl.

waitn1: movlw   NOPREAMB
        movwf   PRECOUNT
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; waitlo waits for low half bit after preamble

waitlo: btfsc   CONFIG,BITREC   ; must be a zero
        goto    ret5            ; might be long preamble
        incf    STATE,F
ret5:   nop
        nop
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; testlo test second half bit of start bit

testlo: btfsc   CONFIG,BITREC   ; must be a zero
        goto    decreset
        incf    STATE,F
        nop
        nop
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; bitset takes first half bit of a bit in the byte

bitset: incf    STATE,F
        bcf     STATUS,C
        btfsc   CONFIG,BITREC
        bsf     STATUS,C
        rlf     DATA5,F
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; lastv checks that first half bit = second half bit

lastv:  incf    STATE,F
        btfss   CONFIG,BITREC
        goto    lastv1
        btfss   DATA5,0
        goto    decreset        ; error if not equal
        nop
        nop
        retlw   0                  ; 9 cycl.

lastv1: btfsc   DATA5,0
        goto    decreset        ; error if not equal
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; end11 end of first byte there must be zero
; end11 first half bit. end12 second half bit

end11:  btfsc   CONFIG,BITREC
        goto    decreset
        incf    STATE,F
        nop
        nop
        nop
        nop
        retlw   0                  ; 9 cycl.

end12:  btfsc   CONFIG,BITREC
        goto    decreset
        incf    STATE,F ; get ready for next byte to receive
        movf    DATA5,W
        movwf   DATA1
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; end21 end of second byte there must be zero
; end22 first half bit. end22 second half bit

end21:  btfsc   CONFIG,BITREC
        goto    decreset
        incf    STATE,F
        nop
        nop
        nop
        nop
        retlw   0                  ; 9 cycl.

end22:  btfsc   CONFIG,BITREC
        goto    decreset
        incf    STATE,F ; get ready for next byte to receive
        movf    DATA5,W
        movwf   DATA2
        nop
        nop
        retlw   0                  ; 9 cycl.

;******************************************************
; end31 end of third byte there must be a one
; end32 first half bit. end32 second half bit

end31:  btfss   CONFIG,BITREC
        goto    decreset
        incf    STATE,F
        nop
        nop
        nop
        nop
        retlw   0                  ; 9 cycl.

end32:  btfss   CONFIG,BITREC
        goto    decreset
        movf    DATA5,W
        movwf   DATA3
        clrf    STATE   ; reset STATE for next preamble

;******************************************************
; now we can start to decode the package
decode:
        bcf     STATUS,Z
        movf    DATA1,W
        xorwf   DATA2,W
        xorwf   DATA3,W
        btfss   STATUS,Z
        goto    exitsoft

        bcf     STATUS,Z
        movlw   MYADRESS
        xorwf   DATA1,W
        btfss   STATUS,Z
        goto    testrest

        bcf     STATUS,Z        ;address = 0 ?
        movf    DATA1,W
        btfsc   STATUS,Z
        goto    exitsoft

output:
        bcf     STATUS,Z
        movf    DATA2,W
        xorwf   DAT2OLD,W
        btfsc   STATUS,Z
        goto    exitsoft
        bcf     STATUS,Z
        movf    DATA2,W
        btfsc   STATUS,Z
        goto    exitsoft

        movwf   DAT2OLD
        movwf   PWM
        movlw   0x0F
        andwf   PWM,F

        btfss   DATA2,5 ; forward backward ?
        goto    back

        movlw   FORWARD
        movwf   MOTMASK
        goto    carryon

back:   movlw   BACKWARD
        movwf   MOTMASK

carryon:        bcf     STATUS,C
        rlf     PWM,F
        rlf     PWM,F
        rlf     PWM,F
        rlf     PWM,F

exitsoft:
        clrf    DATA1
        clrf    DATA2
        clrf    DATA3
        clrf    DATA5
        retlw   0                  ; 9 cycl.

testrest:       movf    DATA1,W
        btfss   STATUS,Z
        goto    exitsoft
        bcf     STATUS,Z
        movf    DATA2,W
        xorlw   0xFF
        btfss   STATUS,Z
        goto    exitsoft
        movf    DATA3,W
        btfss   STATUS,Z
        goto    exitsoft
        goto    decreset

;******************************************************
        END
