
; PicBasic Pro Compiler 2.45a, (c) 1998, 2004 microEngineering Labs, Inc. All Rights Reserved.  
_USED			EQU	1

	INCLUDE	"C:\PBP\12F675.INC"

RAM_START       		EQU	00020h
RAM_END         		EQU	0005Fh
RAM_BANKS       		EQU	00001h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0005Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

; C:\PBP\PBPPIC14.RAM      	00012	R0      VAR     WORD BANK0 SYSTEM       ' System Register
R0              		EQU	RAM_START + 000h
; C:\PBP\PBPPIC14.RAM      	00013	R1      VAR     WORD BANK0 SYSTEM       ' System Register
R1              		EQU	RAM_START + 002h
; C:\PBP\PBPPIC14.RAM      	00014	R2      VAR     WORD BANK0 SYSTEM       ' System Register
R2              		EQU	RAM_START + 004h
; C:\PBP\PBPPIC14.RAM      	00015	R3      VAR     WORD BANK0 SYSTEM       ' System Register
R3              		EQU	RAM_START + 006h
; C:\PBP\PBPPIC14.RAM      	00016	R4      VAR     WORD BANK0 SYSTEM       ' System Register
R4              		EQU	RAM_START + 008h
; C:\PBP\PBPPIC14.RAM      	00017	R5      VAR     WORD BANK0 SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ah
; C:\PBP\PBPPIC14.RAM      	00018	R6      VAR     WORD BANK0 SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Ch
; C:\PBP\PBPPIC14.RAM      	00019	R7      VAR     WORD BANK0 SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Eh
; C:\PBP\PBPPIC14.RAM      	00020	R8      VAR     WORD BANK0 SYSTEM       ' System Register
R8              		EQU	RAM_START + 010h
; C:\PBP\PBPPIC14.RAM      	00026	FLAGS   VAR     BYTE BANK0 SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 012h
; C:\PBP\PBPPIC14.RAM      	00025	GOP     VAR     BYTE BANK0 SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC14.RAM      	00022	RM1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC14.RAM      	00024	RM2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC14.RAM      	00021	RR1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC14.RAM      	00023	RR2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP\12F675.BAS        	00018	PORTL   VAR     GPIO
_PORTL           		EQU	 GPIO
; C:\PBP\12F675.BAS        	00019	PORTH   VAR     GPIO
_PORTH           		EQU	 GPIO
; C:\PBP\12F675.BAS        	00020	TRISL   VAR     TRISIO
_TRISL           		EQU	 TRISIO
; C:\PBP\12F675.BAS        	00021	TRISH   VAR     TRISIO
_TRISH           		EQU	 TRISIO
	INCLUDE	"ONTSTE~1.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


; C:\PBP\12F675.BAS        	00012	BANK0   $0020, $005F
; C:\PBP\12F675.BAS        	00013	EEPROM  $2100, $217F
; C:\PBP\12F675.BAS        	00014	LIBRARY "PBPPIC14"

; C:\PBP\12F675.BAS        	00016	        include "PIC14EXT.BAS"

; C:\PBP\12F675.BAS        	00023	        include "PBPPIC14.RAM"

; C:\PBP\PICPRO~1\ONT\ONTSTE~1.PBP	00011	asm

	ASM?

    org 0x00
;*************************Set up the Constants**********************************
TMR0            EQU 01h         ;waarde van Timer0 staat hierin
PCL             EQU 02h         ;PROGRAM COUNTER
STATUS          EQU 03h         ;STATUS register Carry bit enz staan hierin
FSR             EQU 04h         ;Indirect Data Memory Adress Pointer
GPIO            EQU 05h         ;GPIO Register

PCLATH          EQU 0Ah         ;PROGRAM COUNTER HIGH BYTE
INTCON          EQU 0Bh         ;Interrupt control register
PIR1            EQU 0Ch         ;Peripheral interrupt register (TMR1)

TMR1L           EQU 0Eh
TMR1H           EQU 0Fh
T1CON           EQU 10h         ;Timer1 control register

CMCON           EQU 19h

ADRESH          EQU 1Eh
ADCON0          EQU 1Fh


SPEED_LOW       EQU 20h         
SPEED_HIGH      EQU 21h

SPEED_TEMP_LOW  EQU 22h
SPEED_TEMP_HIGH EQU 23h

TIME_PULS       EQU 24h

TIME_PULS_COMMA EQU 25h

SPEED_CAL_LOW   EQU 26h
SPEED_CAL_HIGH  EQU 27h

DELAY           EQU 28h

DATAPOINTER     EQU 29h

TEMP            EQU 30h

TEMP_INT        EQU 31h

OVERFLOW_TMR0   EQU 32h

PULS_DELAY      EQU 33h

STATUS_TEMP     EQU 34h

VAR_BITS        EQU 40h         ;Variablele for bit operations
                                ;BIT0: There was a overflow of Timer1
                                ;BIT1: Send puls at External Interrupt
                                ;BIT2: First time overflow Timer0
                                ;BIT3: Calculation ready
                                ;BIT4: Reserve
                                ;BIT5: Interrupt for timer0 is set
                                ;BIT6: Interrupt for timer1 is set
                                ;BIT7: External Interrupt is set

OPTION_REG      EQU 81h         ;Option Register --> hier vindt men alles waar
                                ;waar men de prescaler van tmr0 kunt instellen enz 
;PCL             EQU 82h
;STATUS          EQU 83h
;FSR             EQU 84h
TRISIO          EQU 85h         ;GPIO Tris-State register

;PCLATH          EQU 8Ah
;INTCON          EQU 8Bh
PIE1            EQU 8Ch         ;Peripheral interrupt enable register (TMR1)

PCON            EQU 8Eh         ;Power Control Register

OSCCAL          EQU 90h         ;Oscillator Calibration Register

WPU             EQU 95h         ;Weak Pull-up Register
IOC             EQU 96h         ;Interrupt-on-change GPIO register

VRCON           EQU 99h
EEDATA          EQU 9Ah
EEADR           EQU 9Bh
EECON1          EQU 9Ch
EECON2          EQU 9Dh
ADRESL          EQU 9Eh
ANSEL           EQU 9Fh

            GOTO    INITIAL
            
;****************************Interrupt Routine**********************************            
    org 0x04
            MOVWF TEMP_INT      ;Saving the W register
            MOVF STATUS,0       ;Saving the Status
            MOVWF STATUS_TEMP
            BTFSC INTCON,1      ;Checking wich interrupt has arrived
            BSF VAR_BITS,7
            BTFSC INTCON,2
            BSF VAR_BITS,5
            BTFSC PIR1,0
            BSF VAR_BITS,6
            
            BCF INTCON,1        ;Clearing all interrupt flags
            BCF INTCON,2
            BCF PIR1,0           
            
            BTFSS VAR_BITS,7    ;Checking if the external interrupt is set
            BCF INTCON,5        ;If so the Timer0 enable bit has to turn Low
                                ;Normaly this isn't possible but to be sure.
            BTFSS VAR_BITS,5    ;Checking if the interrupt is from Timer0
            GOTO END_INT        ;Interrupt is not from Timer0
            BTFSS VAR_BITS,3    ;Checking if the calculations are done
            GOTO END_INT        ;Calculations are done
            INCF OVERFLOW_TMR0,1;Calculations aren't done yet
            BCF VAR_BITS,5      ;Clear the Timer0 overflow bit
END_INT:    MOVF STATUS_TEMP,0
            MOVWF STATUS        ;Restore the status
            MOVF TEMP_INT,0     ;Restore the W register
            BSF INTCON,7        ;Enable the general interrupt
            BSF INTCON,6        ;Enable the general pheriheral interrupt
            RETFIE

;**********************************Tables***************************************
;I'm putting the tables at front to be sure that as we will access the table we 
;won't have a crash because the PROGRAM COUNTER isn't set properly. 26
TABLE1:     ADDWF PCL,1
;            RETLW 0x2F              ;3100 tr/min
            RETLW 0x37              ;2650 tr/min
            RETLW 0x47              ;2050 tr/min
            RETLW 0x7A              ;1200 tr/min
            RETLW 0xAC              ;850 tr/min
            RETURN
           
TABLE2:     ADDWF PCL,1
;            RETLW 0x41              ;3100 tr/min
            RETLW 0x47              ;2650 tr/min
            RETLW 0x75              ;2050 tr/min
            RETLW 0x12              ;1200 tr/min
            RETLW 0x56              ;850 tr/min
            RETURN
            
TABLE3:     ADDWF PCL,1
            RETLW 40                ;40
            RETLW 30                ;30
            RETLW 20                ;20
            RETLW 10                ;10
            RETLW 0                 ;0
            RETURN
                        
;**************************Initialisatie Routine********************************
INITIAL:    BSF STATUS,5            ;Select Bank1
            MOVLW b'10000010'       ;Initialize Timer0
            MOVWF OPTION_REG
            
;            MOVLW b'11111100'
;            MOVWF OSCCAL
            
            CLRF ANSEL
            
            MOVLW b'00111100'
            MOVWF TRISIO
            
            BCF STATUS,5            ;Select Bank0
                       
            MOVLW b'00010000'
            MOVWF INTCON
            
            BSF PIE1,0
            
            MOVLW 7
            MOVWF CMCON
            
            CLRF ADCON0
           
            CLRF GPIO
            
            MOVLW b'00110000'       ;Initialize Timer1
            MOVWF T1CON
            
            BSF INTCON,7            ;Enable the general interrupt
            BSF INTCON,6            ;Enable the general pheriheral interrupt
            GOTO MAIN

;******************************Main Routine*************************************
MAIN:       BTFSS GPIO,3            ;If switch at GPIO3 is high then we are going
            GOTO NEXT               ;to check if GPIO2 is high. If so then we 
TUNE:       BCF INTCON,7            ;will set GPIO 1 high.
            BSF GPIO,1            
            BTFSS GPIO,2
            BCF GPIO,1              ;At this pin is connected a led for adjusments
            BTFSC GPIO,3
            GOTO TUNE
            BCF GPIO,1
            BSF INTCON,7                 
NEXT:       BTFSC VAR_BITS,5        ;Checking wich interrupt is generated en 
            CALL TMR0_INT           ;calling the relevant routine
            BTFSC VAR_BITS,6
            CALL TMR1_INT
            BTFSC VAR_BITS,7
            CALL EXT_INT            
            GOTO    MAIN
            
;************************Interrupt Timer0 Routine*******************************
             ;er moet bij SPEED_CAL_HIGH 1 bij opgeteld worden want anders zal er 1x te weinig gesprongen worden
TMR0_INT:   DECFSZ SPEED_HIGH,1     ;If Speed_High is zero the puls may be 
            CALL PULS               ;activated
            BTFSS VAR_BITS,2        ;If bit(2) is cleared then we are going to 
            RETURN                  ;return from the label 
            BCF VAR_BITS,2
            INCF SPEED_HIGH,1
            MOVF SPEED_LOW,0
            MOVWF TMR0               
            RETURN 

;************************Interrupt Timer1 Routine*******************************
TMR1_INT:   BSF VAR_BITS,0      ;Set the first bit(0), to show that there was a 
                                ;overflow off timer1
            RETURN


	ENDASM?


; C:\PBP\PICPRO~1\ONT\ONTSTE~1.PBP	00228	asm

	ASM?

;**********************External Interrupt Routine*******************************
            ;**********1)Getting time between 2 pulses & activate both timers***
EXT_INT:    BCF T1CON,0         ;Turn Off Timer1
            MOVF TMR1L,0        ;Put the value of timer1 in the right registers
            MOVWF SPEED_LOW
            MOVF TMR1H,0        
            MOVWF SPEED_HIGH
            CLRF TMR1H
            CLRF TMR1L          ;We don't need to delay Timer1 because we 
                                ;start Timer0 at the same time 
;            MOVLW 1            ;there are 10 cyclus before timer1 is activated
;                               ;again and the prescaler is set at 1:8 so this 
;                               ;means there was a delay of 1 clock puls
;            MOVWF TMR1L
            CLRF TMR0           ;reset Timer0, i put it before setting Timer1 
                                ;because we want to start the both timers at the 
                                ;same time and Timer0 will have a sync of 
            NOP                 ;2 cycles we also need a NOP for the extra cycle
            BSF T1CON,0         ;Turn Timer1 On
            ;**********2)Activate the puls routine if needed********************                       
            BTFSC VAR_BITS,1    ;If the second bit(1) is High then we go to the  
            CALL PULS           ;Puls subroutine
            BTFSC VAR_BITS,0    ;If the first bit(0) is High then we going to 
            INCF VAR_BITS,1     ;set the next bit(1) high by inc the first bit 
                                ;by this we do a rotate left without influence 
                                ;the other bits and this with one opcode
            BTFSC VAR_BITS,1    ;Now i'm checking of the Second bit is high, if 
            RETURN              ;it does this means there is already a delay off
                                ;0 so there is no meaning to calculate it from 
                                ;timer1. And if we do so there could be 2 pulses 
                                ;next cycle, 1 generated from the overflow off 
                                ;timer1 and 1 calculated from the time after the
                                ;overflow that could have a different delay.   

;We must now check whether there is a speed read, because at the start there 
;will  be no time to be measured. And so therefore it should not be used. 
            MOVF TMR1H,1        ;If there is no value the zero bit is put high
            BTFSC STATUS,2      ;We only need to check it with the high byte
            RETURN              ;because we never get a speed measurment with 
                                ;only the Low byte (147058 tr/min) and a
                                ;overflow is already filtered out.
            ;**********3)Getting the delay**************************************                                
;We need to check between which boundary's the measured times lies.
;1)0tr/min    - 850tr/min       ---> Delay of 0
;2)850tr/min  - 1200tr/min      ---> Delay of 10
;3)1200tr/min - 2050tr/min      ---> Delay of 20
;4)2050tr/min - 2650tr/min      ---> Delay of 30
;5)or faster than 2650tr/min    ---> Delay of 40
;The measured time will be a word format because of timer1. Therefore the 
;equation will be divided at byte level. First we will compare the high byte  
;of the Speed measure with the predefined speed high byte which is located in 
;Table1. We do that by a subtraction (measured speed - predefined speed).
;Then we will compare the LOW byte's at the same manner. We can only get in
;here if the previous equation was zero or "the same" for speaking in terms what 
;we where looking for at the start. And at last we will load the calculated delay.  
            CLRF DATAPOINTER    ;We clearing the register so we can begin with a clean slate
COMP_HIGH:  INCF DATAPOINTER,1  ;Setting the datapointer to the beginning of the table
            MOVF DATAPOINTER,0
            CALL TABLE1         ;Get the high byte from table1
            SUBWF SPEED_HIGH,0  ;comparison for the High byte's
            BTFSC STATUS,2      ;If the equation is equal we compare the Low byte's
            GOTO COMP_LOW
            BTFSS STATUS,0      ;If the equation is negatif we load the Delay
            GOTO GET_DELAY
            MOVLW 5             ;We need to set an end point for the table (5)
            SUBWF DATAPOINTER,0 ;If the End point is reached we know that there
            BTFSC STATUS,2      ;isn't a delay so there is no point in calculating
            BSF VAR_BITS,1      ;any further so we set the VAR_BITS second bit
            BTFSC VAR_BITS,1    ;so that the next cycle there will be a puls at
            RETURN              ;the begin and we leave the subroutine
            GOTO COMP_HIGH             
COMP_LOW:   MOVF DATAPOINTER,0
            CALL TABLE2         ;Get the Low byte from table2
            SUBWF SPEED_LOW,0   ;comparison for the Low byte's
            BTFSC STATUS,0      ;If the result is positif we inc the datapointer
            INCF DATAPOINTER,1
GET_DELAY:  MOVF DATAPOINTER,0
            CALL TABLE3         ;Get the Delay from table3
            MOVWF DELAY

;Now we know for sure that we will activate the puls via Timer0 so we can 
;activated the Interrupt bit for Timer0
            BSF INTCON,5
            ;**********4)Measured time/360*************************************
;We are going to divide the measured time via Timer1 with 360, that way we know
;the time that's needed for 1. Because we work with an 8-bit processor it's
;easier to divide by 180 (it's a byte format and 360 isn't), and divide the 
;result afterwards by 2!
;We don't have any multiply or divide opcode so i had to write one myself.
;Basically we are going to add 180 over and over in the same register until the
;result is the same or greater than the measured time. At the same time we are
;going to increment a register (TIME_PULS) wich will be the result of the division.
;If the calculated time is greater then the measured time we have to subbtract
;180 of the caltulated time and decrement TIME_PULS with one. If it is equal the
;calculation is over.
            MOVF SPEED_HIGH,0       ;We are setting & clearing the register so       
            MOVWF SPEED_TEMP_HIGH   ;we can begin with a clean slate 
            CLRF SPEED_TEMP_LOW
            CLRF TIME_PULS
DIVIDE:     INCF TIME_PULS,1        ;The actual result of the division
            MOVLW 180
            ADDWF SPEED_TEMP_LOW,1
            BTFSS STATUS,0          ;Continue Loop2 until a overflow             
            GOTO DIVIDE
            DECFSZ SPEED_TEMP_HIGH,1;Continue loop2 until the high byte reaches zero
            GOTO DIVIDE
            MOVF SPEED_LOW,0        ;Check if the result is the same, greater or  
            SUBWF SPEED_TEMP_LOW,0  ;smaller than the measured time.
            BTFSC STATUS,2          ;Ignore next line if Speed_Low is different
            GOTO DIV_END            ;of Speed_Temp_Low. If they are the same we 
                                    ;know there isn't a number after the comma.
            BTFSC STATUS,0          ;If the equation is positif then we have to
            GOTO DEC_DIV            ;subtract 180 of the total number.
            
            ;If the equation is negatif we are going to add another 180 and check
            ;it again.
            INCF TIME_PULS,1
            MOVLW 180
            ADDWF SPEED_TEMP_LOW,1
            BTFSC STATUS,0
            GOTO DEC_DIV
            MOVF SPEED_LOW,0
            SUBWF SPEED_TEMP_LOW,0
            BTFSC STATUS,2          
            GOTO DIV_END
            BTFSC STATUS,0
            GOTO COMMA
DEC_DIV:    DECF TIME_PULS,1
            MOVLW 180
            SUBWF SPEED_TEMP_LOW,1



	ENDASM?


; C:\PBP\PICPRO~1\ONT\ONTSTE~1.PBP	00361	asm 

	ASM?
 
;For a better accuracy we will also calculate 1 digit after the comma. We do 
;this by multiplying the difference of the measured time with the time 
;calculated by 10. And divide the obtained result with 180 like before.           
COMMA:      MOVF SPEED_TEMP_LOW,0   ;Since the difference can't be greater than 
            SUBWF SPEED_LOW,0       ;180 there is no need to subtract the high 
            MOVWF SPEED_TEMP_LOW    ;byte
            
            MOVLW 5
            MOVWF TEMP
;X10:        RLF SPEED_TEMP_LOW,1    ;We are going to multiply the difference with
;            BTFSC STATUS,0          ;10 so we can find the number after the comma.
;            INCF SPEED_TEMP_HIGH,1  ;We do this by a Rotate Left and this 5 times.
;            DECFSZ TEMP,1
;            GOTO X10
            ;This is practically the same as loop2
            CLRF TIME_PULS_COMMA
            CLRF SPEED_CAL_LOW
DIV_COMMA:  INCF TIME_PULS_COMMA,1
            MOVLW 18
            ADDWF SPEED_CAL_LOW,1
            BTFSS STATUS,0            
            GOTO DIV_COMMA
            DECFSZ SPEED_TEMP_HIGH,1
            GOTO DIV_COMMA
            MOVF SPEED_TEMP_LOW,0  
            SUBWF SPEED_CAL_LOW,0
            BTFSC STATUS,2          ;Ignore next line if Speed_Low is different
            GOTO DIV_END                      
            BTFSC STATUS,0          ;If the equation is positif then we have to
            GOTO DEC_COMMA          ;subtract 18 of the total number.

DIV_COMMA_L:INCF TIME_PULS_COMMA,1
            MOVLW 18
            ADDWF SPEED_CAL_LOW,1
            BTFSC STATUS,0
            GOTO DEC_COMMA
            MOVF SPEED_TEMP_LOW,0
            SUBWF SPEED_CAL_LOW,0
            BTFSC STATUS,2
            GOTO DIV_END
            BTFSC STATUS,0
            GOTO DIV_COMMA_L
DEC_COMMA:  DECF TIME_PULS_COMMA,1
            ;We need to divide the result with 2, because we used 180 as 
            ;reference and not 360
DIV_END:    RRF TIME_PULS_COMMA,1   ;A Rotate Right is the same as a division   
            RRF TIME_PULS,1         ;by 2.
            BTFSS STATUS,0          ;If the carry bit is set, that means the
            GOTO MUL_SETTING        ;first bit of Time_puls was high. Therefore
            MOVLW 5                 ;we need to add 0,5 --> 5 at the comma byte.
            ADDWF TIME_PULS_COMMA,1 
            
            ;**********5)(Measured time/360)*Delay*****************************
;
MUL_SETTING:MOVF DELAY,0            ;We are setting & clearing the register so
            MOVWF TEMP              ;we can begin with a clean slate
            CLRF SPEED_CAL_LOW
            CLRF SPEED_CAL_HIGH
MULTIPLY:   MOVF TIME_PULS,0        
            ADDWF SPEED_CAL_LOW,1
            BTFSC STATUS,0          ;At each overflow we will increment 
            INCF SPEED_CAL_HIGH,1   ;SPEED_CAL_HIGH until TEMP reaches zero this
            DECFSZ TEMP,1           ;means the multiplying is over.
            GOTO MULTIPLY
MUL_COMMA:  MOVF TIME_PULS_COMMA,0  ;This is the same as above, but every time
            ADDWF TEMP,1            ;the result exceeds 10 we have to add 1 by
            MOVLW 10                ;the result above and subtract 1 for the 
            SUBWF TEMP,0            ;the result here.
            BTFSC STATUS,0
            GOTO MUL_END
            MOVWF TEMP
            INCF SPEED_TEMP_LOW,1
MUL_END:    DECFSZ DELAY,1
            GOTO MUL_COMMA
            MOVF SPEED_TEMP_LOW,0
            ADDWF SPEED_CAL_LOW,1
            BTFSC STATUS,0
            INCF SPEED_CAL_HIGH,1

            ;**********6)Measured time-((Measured time/360)*Delay)*************
            MOVF SPEED_CAL_LOW,0
            SUBWF SPEED_LOW,1
            BTFSS STATUS,0            
            INCF SPEED_CAL_HIGH,1
            MOVF SPEED_CAL_HIGH,0
            SUBWF SPEED_HIGH,1
                        
            MOVF SPEED_LOW,0        ;TMR0 = (256-SPEED_LOW), but 256 is the same                                       
            SUBLW 0                 ;as zero.  
            MOVFW SPEED_LOW
            
            BSF VAR_BITS,2          ;Set bit so that with the next overflow of
                                    ;timer0 the Low byte of the calculated time
                                    ;will be placed in timer0 his register.
            BSF VAR_BITS,3          ;The calculations are done
            MOVF OVERFLOW_TMR0,0    ;Subtract the times timer0 has have a overflow
            SUBWF SPEED_HIGH,1      ;during the calculations with the high word 
                                    ;of the calculated time.
            
;interrupt van timer0 inschakelen  mss in het begin inschakelen en telkens wnn er een interrupt is zien of de berekening al afgelopen is 
;en dan hier een bit setten timer0 berekent ofzo. Is de berekening nog niet afgelopen in het interrupt routine telkens 
;een varabele 1 laten optellen en uiteindelijk aftrekken van het eindresultaat high woord van timer0 dus!! 
;Eerst puls hoog maken en dan pas bit setten berekening klaar want anders is het mogelijk dat er juist op de overgang 
;van de intterrupt enzo en dan is er een error van 256!!!         
            RETURN
;******************************Output Routine***********************************            
PULS:       BSF GPIO,0          ;Set the Puls Pin High
            MOVLW 15            ;We need to pull the pin high for a certain 
            MOVWF PULS_DELAY    ;amount of time.
PULS_LOOP:  DECFSZ PULS_DELAY,1 ;With this we delay the Pin for 9400ns
            GOTO PULS_LOOP      
            BCF GPIO,0          ;Set the Puls Pin Low  
            BCF VAR_BITS,1      ;Clear Puls at external interrupt
            BCF VAR_BITS,3      ;Clear calculation bit
            BCF INTCON,5        ;Clear the Timer0 interrupt
            RETURN


	ENDASM?


; C:\PBP\PICPRO~1\ONT\ONTSTE~1.PBP	00479	END
	END?	

	END
