

#define	EP0_BUFF_SIZE			64				; 8, 16, 32, or 64
#define	MAX_NUM_INT			1				; For tracking Alternate Setting
#define	MAX_EP_NUMBER			1				; UEP1
#define	NUM_CONFIGURATIONS	        1
#define	NUM_INTERFACES		1

#define	MODE_PP			_PPBM0
#define	UCFG_VAL			_PUEN | _TRINT | _FS | MODE_PP	; Full-speed

#define USB_USE_HID		       	; Inform the rest of the library subroutines that we're using a HID interface

; HID
; Endpoints Allocation
#define	HID_INTF_ID			0
#define	HID_UEP			UEP1
#define	HID_BD_OUT			ep1Bo
#define	HID_INT_OUT_EP_SIZE	        64
#define	HID_BD_IN			ep1Bi
#define	HID_INT_IN_EP_SIZE	        64
#define	HID_NUM_OF_DSC		1

; ------------------------------------------------------------------------------
; This table is polled by the host immediately after USB Reset has been released.
; The table defines the maximum packet size EP0 can take.
; See section 9.6.1 of the Rev 1.0 USB specification.
; These fields are application dependent to be modified to meet your specifications.
;
DeviceDescriptor
	retlw	(EndDeviceDescriptor - DeviceDescriptor) / 2	; bLength Length of this descriptor
	retlw	DSC_DEV						; bDescType This is a DEVICE descriptor
	dt	0x10, 0x01						; bcdUSB Revision 1.10 low byte, high byte
	retlw	0x00							; bDeviceClass zero means each interface operates independently
	retlw	0x00							; bDeviceSubClass
	retlw	0x00							; bDeviceProtocol
	retlw	EP0_BUFF_SIZE						; bMaxPacketSize for EP0

        ; idVendor low byte, high byte
	dt	0x81, 0x17
        ; idProduct low byte, high byte
	dt	0xD0, 0x07

	dt	0x00, 0x00						; bcdDevice low byte, high byte
	retlw	0x01							; iManufacturer
	retlw	0x02							; iProduct

        ; iSerialNumber index
	retlw	0x03

	retlw	NUM_CONFIGURATIONS 				        ; bNumConfigurations
EndDeviceDescriptor

; ------------------------------------------------------------------------------
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application dependent to be modified to meet your specifications.
;
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low _Config1, high _Config1
	db	low _Config1, high _Config1

; Configuration Descriptor
_Config1
	retlw	(Interface1-_Config1) / 2	; bLength Length of this descriptor
	retlw	DSC_CFG						; bDescType 2 = CONFIGURATION
Config1Len
	retlw	low ((EndConfig1 - _Config1) / 2)	; Length of this configuration
	retlw	high ((EndConfig1 - _Config1) / 2)
	retlw	0x01							; bNumInterfaces Number of interfaces
	retlw	0x01							; bConfigValue Configuration Value
	retlw	0x04							; iConfig String Index for this config = #01
	retlw	0xA0							; bmAttributes attributes - bus powered

        ; Max power consumption (2X mA)
	retlw	0x32
Interface1
	retlw	(HIDDescriptor1 - Interface1) / 2	; length of descriptor
	retlw	DSC_INTF
	retlw	0x00							; number of interface, 0 based array
	retlw	0x00							; alternate setting
	retlw	0x02							; number of endpoints used in this interface
	retlw	0x03							; interface CLASS - assigned by the USB
	retlw	0x00							; boot device
	retlw	0x00							; interface protocol - mouse
	retlw 	0x00							; index to string descriptor that describes this interface
HIDDescriptor1
	retlw	(Endpoint1In - HIDDescriptor1) / 2	; descriptor size (9 bytes)
  	retlw	0x21							; descriptor type (HID)
	dt		0x00, 0x00						; HID CLASS release number (1.00) low byte, high byte
   	retlw	0x00							; Localised country code (none)
 	retlw	0x01							; Number of HID CLASS descriptor to follow (1)
 	retlw	0x22							; Report descriptor type (HID)
ReportDescriptor1Len
	retlw	low ((EndReportDescriptor1 - ReportDescriptor1) / 2)
	retlw	high ((EndReportDescriptor1 - ReportDescriptor1) / 2)
Endpoint1In
	retlw	(EndPoint1Out - Endpoint1In) / 2	; length of descriptor
	retlw	DSC_EP
	retlw	0x81							; EP1, IN
	retlw	0x03							; Interrupt
	dt	0x40, 0x00						; This should be the size of the endpoint buffer low byte, high byte
	retlw	0x0A							; Polling interval
EndPoint1Out
	retlw	(EndConfig1 - EndPoint1Out) / 2	; Length of this Endpoint Descriptor
	retlw	DSC_EP						; bDescriptorType = 5 for Endpoint Descriptor
	retlw	0x01							; Endpoint number & direction
	retlw	0x03							; Transfer type supported by this Endpoint
	dt	0x40, 0x00						; This should be the size of the endpoint buffer low byte, high byte
	retlw	0x0A							; Polling interval 
EndConfig1

ReportDescriptor1
;Throttle,Rudder X/Y/Axis 4 Buttons
;5bytes

    retlw	0x05
    retlw	0x01	 ; USAGE_PAGE (Generic Desktop)
    retlw	0x09
    retlw	0x04	; USAGE (joystck)
    retlw	0xa1
    retlw	0x01		; COLLECTION (Application)
    retlw	0x09
    retlw	0x01		; USAGE (Pointer)
    retlw	0xa1
    retlw	0x00		; COLLECTION (Physical)
    retlw	0x05
    retlw	0x02		; USAGE_PAGE (Simulation Controls)
    retlw	0x09
    retlw	0xc4		    ; USAGE (accelerator)
    retlw       0x15
    retlw	0x00			; LOGICAL_MINIMUM (0)
    retlw       0x25
    retlw	0xff                	; LOGICAL_MAXIMUM (255)
    retlw	0x35			
    retlw	0x00  			; Physical Minimum (0)
    retlw	0x45			
    retlw	0xff 			; Physical Maximum (255)
    retlw       0x75
    retlw	0x08                	; REPORT_SIZE (8)
    retlw       0x95
    retlw	0x01                	; REPORT_COUNT (1)
    retlw       0x81
    retlw	0x02                	; INPUT (Data,Var,Abs)
    retlw	0x09
    retlw	0xc8                ; USAGE (steering)
    retlw       0x15
    retlw	0x00			; LOGICAL_MINIMUM (0)
    retlw       0x25
    retlw	0xff                	; LOGICAL_MAXIMUM (255)
    retlw	0x35			
    retlw	0x00  			; Physical Minimum (0)
    retlw	0x45			
    retlw	0xFF 			; Physical Maximum (255)
    retlw       0x75
    retlw	0x08                	; REPORT_SIZE (8)
    retlw       0x95
    retlw	0x01                	; REPORT_COUNT (1)
    retlw       0x81
    retlw	0x02                	; INPUT (Data,Var,Abs)
    retlw	0xc0               ; END_COLLECTION
    retlw	0x05
    retlw	0x09                ;   USAGE_PAGE (Button)
    retlw	0x19
    retlw	0x01                ;   USAGE_MINIMUM (Button 1)
    retlw	0x29
    retlw	0x02                ;   USAGE_MAXIMUM (Button 2)
    retlw	0x15
    retlw	0x00                ;   LOGICAL_MINIMUM (0)
    retlw	0x25
    retlw	0x01                ;   LOGICAL_MAXIMUM (1)
    retlw	0x75
    retlw	0x01                ;   REPORT_SIZE (1)
    retlw	0x95
    retlw	0x02                ;   REPORT_COUNT (2)
    retlw	0x81
    retlw	0x02                ;   INPUT (Data,Var,Abs)
    retlw	0x75
    retlw	0x01                ;   REPORT_SIZE (1)
    retlw	0x95
    retlw	0x06                ;   REPORT_COUNT (6)
    retlw	0x81
    retlw	0x03                ;   INPUT (Constant,Var,Abs)
    retlw	0xc0		; END_COLLECTION

EndReportDescriptor1

; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	low String1, high String1
	db	low String2, high String2
	db	low String3, high String3
	db	low String4, high String4

String0
	retlw	(String1 - String0) / 2		; Length of string 
	retlw	DSC_STR						; Descriptor type 3
	dt   0x09, 0x04    						; Language ID (0x0409 as defined by MS)

;company name
String1
	retlw	(String2 - String1) / 2
	retlw	DSC_STR
	
        retlw   'K'
        retlw   0x00
        retlw   'G'
        retlw   0x00
        retlw   'E'
        retlw   0x00


;product name
String2
	retlw	(String3 - String2) / 2
	retlw	DSC_STR
	
        	retlw   'R'
        retlw   0x00
        	retlw   'A'
        retlw   0x00
        	retlw   'C'
        retlw   0x00
        	retlw   'E'
        retlw   0x00
        	retlw   ' '
        retlw   0x00
        	retlw   'W'
        retlw   0x00
        	retlw   'H'
        retlw   0x00
        	retlw   'E'
        retlw   0x00
		retlw   'E'
        retlw   0x00
        	retlw   'L'
        retlw   0x00

; serial number
String3
	retlw	(String4 - String3) / 2
	retlw	DSC_STR
	
        retlw   '0'
        retlw   0x00
        retlw   '0'
        retlw   0x00
        retlw   '0'
        retlw   0x00
        
String4
	retlw	(String5 - String4) / 2
	retlw	DSC_STR
	dt	0
String5
 
 
