// Project: Rotary speed indicator
// Authors: Nedjeljko Lekic, Zoran Mijanovic
// Tool: MPLAB IDE with CC5 compiler
// Device: PIC10F200
// Configuration: MCLRE internally tied to VDD, Watchdog timer enabled

unsigned char pulses, timeSlot, UpperLeds, MiddleLeds, LowerLeds;
signed char level;
#define HYSTERESIS 25

void IncomingPulseCounting()
{  	// Incoming pulse debounsing and counting
	if(GP3){
		if(++level==0) { ++pulses; level = HYSTERESIS; }
		if(level > 100) level=100; // Upper limiter
	}
	else {
		if(--level==0) { ++pulses; level = -HYSTERESIS; }
		if(level<-100) level=-100; // Lower limiter
	}
}

void DriveLeds()
{
	TRISGPIO=7; // Until new port state is set, all ports are turned off.
	switch(timeSlot){
	case 0: GPIO=7; TRISGPIO= ~UpperLeds; break;
	case 1:	GPIO=0; TRISGPIO= ~LowerLeds; break;
	case 2: if(MiddleLeds & 1) 	{ GPIO=1; TRISGPIO= ~3; } break;
	case 3: if(MiddleLeds & 2) 	{ GPIO=2; TRISGPIO= ~3; } break;
	case 4: if(MiddleLeds & 4) 	{ GPIO=1; TRISGPIO= ~5; } break;
	case 5: if(MiddleLeds & 8) 	{ GPIO=4; TRISGPIO= ~5; } break;
	case 6: if(MiddleLeds & 16) 	{ GPIO=2; TRISGPIO= ~6; } break;
	default: if(MiddleLeds & 32) 	{ GPIO=4; TRISGPIO= ~6; } break;
	}
}

void main( void)
{
	unsigned char k;
	// INITIALISATION
	OPTION = 0b.1101.0000;  
		/// Wake-up and pull-ups disabled
		// TMR0 clock source internal, Prescaler 1:2 is assigned to the TMR0
	while(1){ // Main endless loop
		clrwdt(); // watchdog reset
		while(TMR0 < 0x80)IncomingPulseCounting();
		while(TMR0 > 0x80)IncomingPulseCounting();
		DriveLeds();
		if(++timeSlot >= 8) timeSlot=0;
		if(++k < 200) continue;
		k=0;
		// Set LED pattern versus pulse count
		// TWO LEDS SPOT
		switch(pulses){
		case 0: LowerLeds=1+2; MiddleLeds=0; UpperLeds=0; break;
		case 1: LowerLeds=2+4; MiddleLeds=0; UpperLeds=0; break;
		case 2: LowerLeds=4; MiddleLeds=1; UpperLeds=0; break;
		case 3: LowerLeds=0; MiddleLeds=1+2; UpperLeds=0; break;
		case 4: LowerLeds=0; MiddleLeds=2+4; UpperLeds=0; break;
		case 5: LowerLeds=0; MiddleLeds=4+8;  UpperLeds=0; break;
		case 6: LowerLeds=0; MiddleLeds=8+16; UpperLeds=0; break;
		case 7: LowerLeds=0; MiddleLeds=16+32; UpperLeds=0; break;
		case 8: LowerLeds=0; MiddleLeds=32; UpperLeds=1; break;
		case 9: LowerLeds=0; MiddleLeds=0; UpperLeds=1+2; break;
		default: LowerLeds=0; MiddleLeds=0; UpperLeds=2+4; break;
		}
		pulses=0;
	}
}
