;********************************************************************************************************************************************************
;                                                                                                             											*
;    Filename: PWM variable using A/D Continuous Loop mode.                                                                                   											*
;    Date: 8/06/2009                                                                                         											*
;    File Version: 1.0.0                                                                                      											*
;                                                                                                             											*
;    Author: Toms Robles Romo                                                                                											*
;    Company: ITSON			                                      				      						  											*
;                                                                                                             											*	 
;********************************************************************************************************************************************************

			LIST P=18F2431,	F=INHX32		; Directive to define processor
			#include <P18F2431.INC>			; Processor specific variable definitions

;********************************************************************************************************************************************************
;Configuration bits

			CONFIG 	OSC = HSPLL, WDTEN = OFF, LVP = OFF, PWMPIN = ON, HPOL = HIGH, LPOL = HIGH, MCLRE = OFF

;********************************************************************************************************************************************************

RESET_VECTOR ORG	0x0000
			 GOTO 	MAIN
			
;********************************************************************************************************************************************************

;High priority interrupt vector

HIGH_VECTOR	ORG		0x0008
			GOTO	HighInt					; Go to high priority interrupt routine

;********************************************************************************************************************************************************
			ORG		0x0020			
		
MAIN		CALL	INIT_PORT				; Ports Configuration
			CALL	INIT_ADC				; A/D Configuration
			CALL    INIT_INTERRUPT			; A/D Interrupt
			CALL	INIT_PWM				; PWM Configuration
			BSF		ADCON0, GO				; GO/DONE: A/D Conversion Status bit (1st conversion)

			GOTO 	$						

;********************************************************************************************************************************************************

INIT_PORT

			CLRF 	PORTA					; Initialize PORTA by clearing output data latches

			MOVLW 	0x10					; Configure  A/D converter inputs, AN<4> as Analog input , AN<3:0> as Digital I/O
			MOVWF	ANSEL0

			MOVLW	0x10					; Set RA<4> as input, RA<3:0> as outputs
			MOVWF	TRISA

;********************************************************************************************************************************************************

INIT_ADC	
			
ADCR1		MOVLW	0x10					; A/D CONTROL REGISTER 1, Voltage reference
			MOVWF	ADCON1		

ADCH		BCF		ADCHS, GASEL1 			; A/D CHANNEL SELECT REGISTER, Input channel
			BSF		ADCHS, GASEL0

ADCR0		MOVLW	0x20					; A/D CONTROL REGISTER 0, Auto-Conversion mode = Single-Shot & Single Channel Mode
			MOVWF	ADCON0

ADCR2		MOVLW	0x8A					; A/D CONTROL REGISTER 2, A/D Conversion Clock
			MOVWF	ADCON2

ADCR3		MOVLW	0x40					; A/D CONTROL REGISTER 3 All triggers disabled
			MOVWF	ADCON3	
			
			BSF		ADCON0, ADON			; Turn on ADC

			RETURN

;********************************************************************************************************************************************************

INIT_INTERRUPT
	
			BSF		RCON, IPEN				; RESET CONTROL REGISTER
			BSF		INTCON, GIE 	    	; INTERRUPT CONTROL REGISTER
			BSF		INTCON, PEIE
		
			BSF		PIE1, ADIE				; PERIPHERAL INTERRUPT ENABLE REGISTER 1 (ADC Interrupt Enable)
			BCF		PIR1, ADIF
			BSF		IPR1, ADIP				; PERIPHERAL INTERRUPT PRIORITY REGISTER 1 (ADC Interrupt Enable)
			
			RETURN

;********************************************************************************************************************************************************

INIT_PWM
			
TMRCR0		MOVLW	0x00					; PWM Timer Control Register 0 (PTCON0)
			MOVWF	PTCON0

TMRCR1		MOVLW	0x80
			MOVWF	PTCON1					; PWM Timer Control Register 1 (PTCON1)

PCTRL0		MOVLW	0x17					; PWM Control Register 0 (PWMCON0)
			MOVWF	PWMCON0

PCTRL1		MOVLW	0x08					; PWM Control Register 1 (PWMCON1)
			MOVWF	PWMCON1

PTPER		MOVLW	0x00					; PTPERH
			MOVWF	PTPERH
			MOVLW	0xFF					; PTPERL
			MOVWF	PTPERL

			RETURN

;********************************************************************************************************************************************************
			
HighInt	

ADC_INTERRUPT

		   ;MOVFF	ADRESL, PDC0L 			
		   ;MOVFF 	ADRESH,	PDC0H	
			NOP
			MOVF	ADRESL, W
			MOVWF	PDC0L
			MOVF	ADRESH, W
			MOVWF	PDC0H
			
			BCF		PIR1, ADIF
			
			;BSF		ADCON0, GO				; GO/DONE: A/D Conversion Status bit	 

			retfie	FAST

;********************************************************************************************************************************************************

			END

;********************************************************************************************************************************************************

