;********************************************************************************************************************************************************
;                                                                                                             											*
;    Filename: Variable PWM                                                                                   											*
;    Date: 28/05/2009                                                                                         											*
;    File Version: 1.0.0                                                                                      											*
;                                                                                                             											*
;    Author: Toms Robles Romo                                                                                											*
;    Company: ITSON			                                      				      						  											*
;                                                                                                             											*	 
;********************************************************************************************************************************************************

			LIST P=18F2431,	F=INHX32		; Directive to define processor
			#include <P18F2431.INC>			; Processor specific variable definitions

;********************************************************************************************************************************************************
;Configuration bits

			CONFIG 	OSC = HSPLL, WDTEN = OFF, LVP = OFF, PWMPIN = ON, HPOL = HIGH, LPOL = HIGH, MCLRE = OFF

;********************************************************************************************************************************************************

RESET_VECTOR ORG	0x0000
			 GOTO 	MAIN
			
;********************************************************************************************************************************************************

;High priority interrupt vector

HIGH_VECTOR	ORG		0x0008
			bra		HighInt					; Go to high priority interrupt routine

;********************************************************************************************************************************************************
			ORG		0x0020			
		
MAIN		CALL	INIT_ADC				; A/D Configuration
			CALL 	INIT_PWM				; PWM Configuration
			CALL    INIT_INTERRUPT			; PWM Interrupt

			GOTO 	$						

;********************************************************************************************************************************************************

INIT_ADC	CLRF 	PORTA					; Initialize PORTA by clearing output data latches

			MOVLW 	0x1F					; Configure  A/D converter inputs
			MOVWF	ANSEL0

			MOVLW	0x1F					; SET RA<5:0> as inputs
			MOVWF	TRISA
			
ADCR1		MOVLW	0x18					; A/D CONTROL REGISTER 1
			MOVWF	ADCON1		

ADCR0		MOVLW	0x00					; A/D CONTROL REGISTER 0 
			MOVWF	ADCON0

ADCH		MOVLW	0x00					; A/D CHANNEL SELECT REGISTER 
			MOVWF	ADCHS

ADCR2		MOVLW	0x02					; A/D CONTROL REGISTER 2
			MOVWF	ADCON2

ADCR3		MOVLW	0xC0					; A/D CONTROL REGISTER 3 All triggers disabled
			MOVWF	ADCON3	
			
			BSF		RCON, 7					; RESET CONTROL REGISTER

			BSF		INTCON, 7  			    ; INTERRUPT CONTROL REGISTER
			BSF		INTCON, 6

			BSF		PIE1, 6					; PERIPHERAL INTERRUPT ENABLE REGISTER 1 (ADC Interrupt Enable)
			BSF		IPR1, 6					; PERIPHERAL INTERRUPT PRIORITY REGISTER 1 (ADC Interrupt Enable)
			
			BSF		ADCON0, ADON			; Turn on ADC

			MOVLW	0x0A					; A/D CONTROL REGISTER 2
			MOVWF	ADCON2

			RETURN

;********************************************************************************************************************************************************

HighInt		
			BTFSC 	PIR3,PTIF				
			BRA		PWM_INTERRUPT			
			
PWM_INTERRUPT
			BSF		ADCON0, GO				; GO/DONE: A/D Conversion Status bit
			
WAIT_FOR_CONVERSION	
			BTFSC   ADCON0, GO
			BRA	WAIT_FOR_CONVERSION

			;LOADING A/D RESULT TO PWM DUTY CYCLE REGISTERS
			
			MOVFF	ADRESL, PDC0L 			
			MOVFF 	ADRESH,	PDC0H
			BCF		PIR1, ADIF				; 
			BCF 	PIR3,PTIF				; DISABLE PWM INTERRUPT 

			retfie	FAST
								

;********************************************************************************************************************************************************

			
INIT_INTERRUPT
	
			;BSF		RCON, 7					; RESET CONTROL REGISTER
	
			;BSF		INTCON, 7  			    ; INTERRUPT CONTROL REGISTER
			;BSF		INTCON, 6
			
			BSF		PIE3, 4					; PERIPHERAL INTERRUPT ENABLE REGISTER 3 (PWM)
			BSF		IPR3, 4				    ; PERIPHERAL INTERRUPT PRIORITY REGISTER 3 (PWM)
			;BSF		PIR3, 4					; PERIPHERAL INTERRUPT REQUEST (FLAG) REGISTER 3 (PWM)
			;BTFSC		PIR3, 4
			

			RETURN

;********************************************************************************************************************************************************

INIT_PWM
			
TMRCR0		MOVLW	0x00					; PWM Timer Control Register 0 (PTCON0)
			MOVWF	PTCON0

TMRCR1		MOVLW	0x80
			MOVWF	PTCON1					; PWM Timer Control Register 1 (PTCON1)

PCTRL0		MOVLW	0x17					; PWM Control Register 0 (PWMCON0)
			MOVWF	PWMCON0

PCTRL1		MOVLW	0x08					; PWM Control Register 1 (PWMCON1)
			MOVWF	PWMCON1

PTPER		MOVLW	0x00					; PTPERH
			MOVWF	PTPERH
			MOVLW	0xFF					; PTPERL
			MOVWF	PTPERL

			;BSF		PIE3, 4					; PERIPHERAL INTERRUPT ENABLE REGISTER 3 (PWM)
			;BSF		IPR3, 4				    ; PERIPHERAL INTERRUPT PRIORITY REGISTER 3 (PWM)

			RETURN

;********************************************************************************************************************************************************

			END

;********************************************************************************************************************************************************

