
@ __CONFIG _XT_OSC & _WDT_ON & _LVP_OFF & _CP_OFF

DEFINE  OSC 4
DEFINE	ADC_BITS 10     ' Set number of bits in result
DEFINE	ADC_CLOCK 3     ' Set clock source /32
DEFINE	ADC_SAMPLEUS 50 ' Set sampling time in uS

ADval  VAR WORD         ' Variable for 10-bit A/D result
Loops  VAR BYTE
Quanta CON 1251
Switch VAR PORTB.0      ' simulated switch input
LED    VAR PORTB.1      ' simulated LED output

   TRISA = 1            ' Set PORTA.0 = input
   ADCON1 = %10001110   ' Set PORTA.0 = analog , right justify result for 10-bit
   RCSTA = $90          ' Enable USART receive
   TXSTA = $24          ' Set USART parameters
   SPBRG = 25           ' Set baud rate to 9600
   
   OPTION_REG.7 = 0     ' RB0 pull-up on
   PORTB = 0
   TRISB = %00000001    ' RB0 is switch input, rest outputs
    
loop:     
   'WHILE Switch         ' simulated switch on RB0 triggers everything when grounded
   'WEND                 ' un-comment this to see how the switch input works.
   FOR Loops = 1 TO 3
    HIGH LED             ' LED for MPSIM logic analyzer
    PAUSE 5
    LOW LED
    PAUSE 5
   NEXT Loops

   ADCIN 0,ADval		' Read A/D channel 0 into ADval variable
   HSEROUT ["Raw value = ",IHEX4 ADval,13,10] ' displays values passed from stimulus file
   ADval = ADval */ Quanta
   HSEROUT ["V = ",DEC ADval DIG 3,".",DEC3 ADval," V",13,10] ' displays converted A/D values
   GOTO loop            ' Do it forever
   END

