
; PICBASIC PRO(TM) Compiler 2.47, (c) 1998, 2006 microEngineering Labs, Inc. All Rights Reserved.  
MPASMWIN_USED			EQU	1

	INCLUDE	"C:\PBP\16F877A.INC"


; Define statements.
; C:\PBP\16F877A.BAS       	00018	DEFINE  CODE_SIZE 8
#define		CODE_SIZE		 8
; C:\PBP\SIMTST\MPSIM_TST.BAS	00004	DEFINE  OSC 4
#define		OSC		 4
; C:\PBP\SIMTST\MPSIM_TST.BAS	00005	DEFINE	ADC_BITS 10     ' Set number of bits in result
#define		ADC_BITS		 10     
; C:\PBP\SIMTST\MPSIM_TST.BAS	00006	DEFINE	ADC_CLOCK 3     ' Set clock source /32
#define		ADC_CLOCK		 3     
; C:\PBP\SIMTST\MPSIM_TST.BAS	00007	DEFINE	ADC_SAMPLEUS 50 ' Set sampling time in uS
#define		ADC_SAMPLEUS		 50 

RAM_START       		EQU	00020h
RAM_END         		EQU	001EFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00110h
BANK2_END       		EQU	0016Fh
BANK3_START     		EQU	00190h
BANK3_END       		EQU	001EFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

; C:\PBP\PBPPIC14.RAM      	00012	R0      VAR     WORD BANK0 SYSTEM       ' System Register
R0              		EQU	RAM_START + 000h
; C:\PBP\PBPPIC14.RAM      	00013	R1      VAR     WORD BANK0 SYSTEM       ' System Register
R1              		EQU	RAM_START + 002h
; C:\PBP\PBPPIC14.RAM      	00014	R2      VAR     WORD BANK0 SYSTEM       ' System Register
R2              		EQU	RAM_START + 004h
; C:\PBP\PBPPIC14.RAM      	00015	R3      VAR     WORD BANK0 SYSTEM       ' System Register
R3              		EQU	RAM_START + 006h
; C:\PBP\PBPPIC14.RAM      	00016	R4      VAR     WORD BANK0 SYSTEM       ' System Register
R4              		EQU	RAM_START + 008h
; C:\PBP\PBPPIC14.RAM      	00017	R5      VAR     WORD BANK0 SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ah
; C:\PBP\PBPPIC14.RAM      	00018	R6      VAR     WORD BANK0 SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Ch
; C:\PBP\PBPPIC14.RAM      	00019	R7      VAR     WORD BANK0 SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Eh
; C:\PBP\PBPPIC14.RAM      	00020	R8      VAR     WORD BANK0 SYSTEM       ' System Register
R8              		EQU	RAM_START + 010h
; C:\PBP\PBPPIC14.RAM      	00026	FLAGS   VAR     BYTE BANK0 SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 012h
; C:\PBP\PBPPIC14.RAM      	00025	GOP     VAR     BYTE BANK0 SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC14.RAM      	00022	RM1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC14.RAM      	00024	RM2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC14.RAM      	00021	RR1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC14.RAM      	00023	RR2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP\SIMTST\MPSIM_TST.BAS	00009	ADval  VAR WORD         ' Variable for 10-bit A/D result
_ADval           		EQU	RAM_START + 018h
; C:\PBP\SIMTST\MPSIM_TST.BAS	00001	
T1              		EQU	RAM_START + 01Ah
; C:\PBP\SIMTST\MPSIM_TST.BAS	00010	Loops  VAR BYTE
_Loops           		EQU	RAM_START + 01Ch
; C:\PBP\16F877A.BAS       	00022	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\16F877A.BAS       	00023	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP\16F877A.BAS       	00024	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\16F877A.BAS       	00025	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
#define _Switch          	_PORTB??0
#define _LED             	_PORTB??1
#define _PORTB??0        	 PORTB, 000h
#define _PORTB??1        	 PORTB, 001h
#define _OPTION_REG??7   	 OPTION_REG, 007h

; Constants.
_Quanta          		EQU	004E3h
	INCLUDE	"MPSIM_TST.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


; C:\PBP\16F877A.BAS       	00012	BANK0   $0020, $007F
; C:\PBP\16F877A.BAS       	00013	BANK1   $00A0, $00EF
; C:\PBP\16F877A.BAS       	00014	BANK2   $0110, $016F
; C:\PBP\16F877A.BAS       	00015	BANK3   $0190, $01EF
; C:\PBP\16F877A.BAS       	00016	EEPROM  $2100, $21FF
; C:\PBP\16F877A.BAS       	00017	LIBRARY "PBPPIC14"
; C:\PBP\16F877A.BAS       	00018	DEFINE  CODE_SIZE 8

; C:\PBP\16F877A.BAS       	00020	        include "PIC14EXT.BAS"

; C:\PBP\16F877A.BAS       	00027	        include "PBPPIC14.RAM"

; C:\PBP\SIMTST\MPSIM_TST.BAS	00002	@ __CONFIG _XT_OSC & _WDT_ON & _LVP_OFF & _CP_OFF

	ASM?
 __CONFIG _XT_OSC & _WDT_ON & _LVP_OFF & _CP_OFF

	ENDASM?

; C:\PBP\SIMTST\MPSIM_TST.BAS	00004	DEFINE  OSC 4
; C:\PBP\SIMTST\MPSIM_TST.BAS	00005	DEFINE	ADC_BITS 10     ' Set number of bits in result
; C:\PBP\SIMTST\MPSIM_TST.BAS	00006	DEFINE	ADC_CLOCK 3     ' Set clock source /32
; C:\PBP\SIMTST\MPSIM_TST.BAS	00007	DEFINE	ADC_SAMPLEUS 50 ' Set sampling time in uS
; C:\PBP\SIMTST\MPSIM_TST.BAS	00011	Quanta CON 1251

; C:\PBP\SIMTST\MPSIM_TST.BAS	00015	   TRISA = 1            ' Set PORTA.0 = input
	MOVE?CB	001h, TRISA

; C:\PBP\SIMTST\MPSIM_TST.BAS	00016	   ADCON1 = %10001110   ' Set PORTA.0 = analog , right justify result for 10-bit
	MOVE?CB	08Eh, ADCON1

; C:\PBP\SIMTST\MPSIM_TST.BAS	00017	   RCSTA = $90          ' Enable USART receive
	MOVE?CB	090h, RCSTA

; C:\PBP\SIMTST\MPSIM_TST.BAS	00018	   TXSTA = $24          ' Set USART parameters
	MOVE?CB	024h, TXSTA

; C:\PBP\SIMTST\MPSIM_TST.BAS	00019	   SPBRG = 25           ' Set baud rate to 9600
	MOVE?CB	019h, SPBRG

; C:\PBP\SIMTST\MPSIM_TST.BAS	00021	   OPTION_REG.7 = 0     ' RB0 pull-up on
	MOVE?CT	000h, _OPTION_REG??7

; C:\PBP\SIMTST\MPSIM_TST.BAS	00022	   PORTB = 0
	MOVE?CB	000h, PORTB

; C:\PBP\SIMTST\MPSIM_TST.BAS	00023	   TRISB = %00000001    ' RB0 is switch input, rest outputs
	MOVE?CB	001h, TRISB

; C:\PBP\SIMTST\MPSIM_TST.BAS	00025	loop:     

	LABEL?L	_loop	

; C:\PBP\SIMTST\MPSIM_TST.BAS	00028	   FOR Loops = 1 TO 3
	MOVE?CB	001h, _Loops
	LABEL?L	L00001	
	CMPGT?BCL	_Loops, 003h, L00002

; C:\PBP\SIMTST\MPSIM_TST.BAS	00029	    HIGH LED             ' LED for MPSIM logic analyzer
	HIGH?T	_LED

; C:\PBP\SIMTST\MPSIM_TST.BAS	00030	    PAUSE 5
	PAUSE?C	005h

; C:\PBP\SIMTST\MPSIM_TST.BAS	00031	    LOW LED
	LOW?T	_LED

; C:\PBP\SIMTST\MPSIM_TST.BAS	00032	    PAUSE 5
	PAUSE?C	005h

; C:\PBP\SIMTST\MPSIM_TST.BAS	00033	   NEXT Loops
	NEXT?BCL	_Loops, 001h, L00001
	LABEL?L	L00002	

; C:\PBP\SIMTST\MPSIM_TST.BAS	00035	   ADCIN 0,ADval		' Read A/D channel 0 into ADval variable
	ADCIN?CW	000h, _ADval

; C:\PBP\SIMTST\MPSIM_TST.BAS	00036	   HSEROUT ["Raw value = ",IHEX4 ADval,13,10] ' displays values passed from stimulus file
	HSEROUT?C	052h
	HSEROUT?C	061h
	HSEROUT?C	077h
	HSEROUT?C	020h
	HSEROUT?C	076h
	HSEROUT?C	061h
	HSEROUT?C	06Ch
	HSEROUT?C	075h
	HSEROUT?C	065h
	HSEROUT?C	020h
	HSEROUT?C	03Dh
	HSEROUT?C	020h
	HSEROUTCOUNT?C	004h
	HSEROUTNUM?W	_ADval
	HSEROUTIHEX?	
	HSEROUT?C	00Dh
	HSEROUT?C	00Ah

; C:\PBP\SIMTST\MPSIM_TST.BAS	00037	   ADval = ADval */ Quanta
	MULMID?WCW	_ADval, _Quanta, _ADval

; C:\PBP\SIMTST\MPSIM_TST.BAS	00038	   HSEROUT ["V = ",DEC ADval DIG 3,".",DEC3 ADval," V",13,10] ' displays converted A/D values
	HSEROUT?C	056h
	HSEROUT?C	020h
	HSEROUT?C	03Dh
	HSEROUT?C	020h
	HSEROUTCOUNT?C	000h
	DIG?WCW	_ADval, 003h, T1
	HSEROUTNUM?W	T1
	HSEROUTDEC?	
	HSEROUT?C	02Eh
	HSEROUTCOUNT?C	003h
	HSEROUTNUM?W	_ADval
	HSEROUTDEC?	
	HSEROUT?C	020h
	HSEROUT?C	056h
	HSEROUT?C	00Dh
	HSEROUT?C	00Ah

; C:\PBP\SIMTST\MPSIM_TST.BAS	00039	   GOTO loop            ' Do it forever
	GOTO?L	_loop

; C:\PBP\SIMTST\MPSIM_TST.BAS	00040	   END
	END?	

	END
