'*********************************************
'      Thermometer 2 Zone &   Thermostat 
'          with Nokia 3310 display
'       DEVICE 16F628A AND DS18B20 x 2
'                   ver.2.1
'        Thanks to all members from  : 
'       http://www.picbasic.co.uk/forum
'  by Niculescu Dan : niculescu_dann@yahoo.com
'**********************************************
'@ DEVICE pic16F628A, INTosc_osc, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_OFF, LVP_OFF, CPD_OFF, PROTECT_OFF     ' for PBP 2.4
@ DEVICE pic16F628A, INTRC_osc, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_OFF, LVP_OFF, CPD_OFF, PROTECT_OFF       ' for PBP 2.5
Define  NO_CLRWDT 1
DEFINE  OSC 4                            

        TRISB = %00001110        'portB configuration  0=out 1=in
        TRISA = %10100010        'portA configuration

        PortA = %11100010        
        CMCON = 7                'for P16F628
        VRCON = 0                'for P16F628
        INTCON = 0              
        OPTION_REG = %10000111       
                    
RST         var  PortA.4   'pin 3   Output   reset display
SDIN        var  PortA.3   'pin 2   Output   master data out        
SCK         var  PortA.2   'pin 1   Output   Spi clock
DQ          var  PortA.1   'pin 18  I/O      DQ DS18b20    
D_C         var  PortB.0   'pin 6   Output   command/data sel. register

            
            temperature     var  Word	
            TempC           var  byte
            Float           var  byte
            temperature2    Var  Word
            Dummy           var  byte
            TempC2          var  byte
            Float2          var  byte
            Bitovi          var  byte
            Bitovi2         var  byte            
            Predznak        var  Bitovi.0
            Predznak2       var  Bitovi2.0
            Minus           var  Byte                   
            LcdReg          var  byte        
            x               var  byte
            y               var  byte
            Offset          var  byte
            Char            var  byte
            a               var  byte
            PosX            VAR  Byte
            PosY            VAR  Byte
            Chr             VAR  Byte
            LcdData         VAR  Byte
		TargetTemp	    Var	Word		' Desired Temperature
            Hyst		    Var	Word		' Hystereris
            V		    Var	Word		' Var. for display
            V2		    Var	Word		' Var. for display
            B1              Var  Byte   ' Byte for TargetTemp calculation 
            B2              Var  Byte   ' Byte for TargetTemp calculation
            Mode 		    Var  Byte   ' 0=Temp. display, 1=Set Temp, 2=Set Hysteresis
            Sign            Var  Byte
            Sign2           Var  Byte

DS18B20_1_12bit 	CON %01111111 ; 750ms,   0.0625C  
DS18B20_2_12bit 	CON %01111111 ; 750ms,   0.0625C  

DATA 46, 224, 10                        ' Temp MSB, TEMP LSB, Hysteresis DIV 10

PORTb.6=0                               ' Warm Output Low
PORTb.7=0                               ' Cold Output Low
Mode=0                                  ' Temperature display mode  
Read 0, B1                              ' Read TargetTemp MSB
Read 1, B2                              ' Read TargetTemp LSB
TargetTemp=B1*256+B2                    ' Calculate TargetTemp value (Default=20.0 C.)
Read 2, B1                              ' Read Hysteresis 
Hyst=10*B1                               ' Calculate Hysteresis value (Default= 2.0 C.)  

'-------------------------------------------------------------------------------            
                
                   DATA @10,$3E,$51,$49,$45,$3E,_       ';// 0    2              
                            $00,$42,$7F,$40,$00,_       ';// 1    3
                            $42,$61,$51,$49,$46,_       ';// 2    4 
                            $21,$41,$45,$4B,$31,_       ';// 3    5
                            $18,$14,$12,$7F,$10,_       ';// 4    6
                            $27,$45,$45,$45,$39,_       ';// 5    7
                            $3C,$4A,$49,$49,$30,_       ';// 6    8
                            $01,$71,$09,$05,$03,_       ';// 7    9
                            $36,$49,$49,$49,$36,_       ';// 8    10
                            $06,$49,$49,$29,$1E,_       ';// 9    11
                            $08,$08,$3E,$08,$08,_       ';// +    12
                            $08,$08,$08,$08,$08,_       ';// -    13
                            $00,$60,$60,$00,$00,_       ';// .    14
                            $01,$01,$7F,$01,$01,_       ' T       15
                            $7F,$49,$49,$49,$41,_       ' E       16
                            $7F,$02,$0C,$02,$7F,_       ' M       17
                            $7F,$09,$09,$09,$06,_       ' P       18
                            $00,$41,$7F,$41,$00,_       ' I       19
                            $7F,$04,$08,$10,$7F,_       ' N       20
                            $63,$14,$08,$14,$63,_       ' X       21
                            $03,$04,$78,$04,$03,_       ' Y       22
                            $26,$49,$49,$49,$32,_       ' S       23
                            $7F,$08,$08,$08,$7F         ' H       24 

'-------------------------------------------------------------------------------            
                pause 100
                RST = 1
                PortB = 0                      
                LcdReg  =  %00100001          'LCD Extended Commands.
                call    PrintCtrlLcd
                LcdReg  =  $C8                'Set LCD Vop (Contrast).    initial a fost $c5
                call    PrintCtrlLcd
                LcdReg  =  %00000110          'Set Temp coefficent.
                call    PrintCtrlLcd
                LcdReg  =  %00010011          'LCD bias mode 1:48.
                call    PrintCtrlLcd
                LcdReg  =  %00100000          'LCD Standard Commands, Horizontal addressing mode.
                call    PrintCtrlLcd
                LcdReg  =  $0C                'LCD in normal mode.  $0D inverse

Call    PrintCtrlLcd                 
Call CursorHome
                
Gosub LCD_Clear

' Init Sensor 1
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $4E, $FF, $FF, $7F] 
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $48] 
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $B8] 
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $BE] 
Pause 50
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]
Pause 50
'------------------------------------------

' Init Sensor 2
 OWOut DQ, 1, [$55, $28,  $EB, $EA, $48, $1, $0, $0, $FF, $4E, $FF, $FF, $7F] 
 OWOut DQ, 1, [$55, $28,  $EB, $EA, $48, $1, $0, $0, $FF, $48] 
 OWOut DQ, 1, [$55, $28,  $EB, $EA, $48, $1, $0, $0, $FF, $B8] 
 OWOut DQ, 1, [$55, $28,  $EB, $EA, $48, $1, $0, $0, $FF, $BE] 
Pause 50
 OWIn DQ, 2, [temperature2.byte0, temperature2.byte1] 
Pause 50
'------------------------------------------

MainLoop:
If PORTB.3=0 then
Pause 50
Gosub LCD_Clear
Call Apel

  If PORTB.3=0 then MainLoop            ' Wait until button is released  
  Mode=Mode+1                           ' Increment mode
  If Mode=2 then                        ' Save Target Temperature (Mode1 -> Mode2)
   Write 0, TargetTemp / 256		    ' TargetTemp MSB
   Write 1, TargetTemp MOD 256          ' TargetTemp LSB
  EndIf
  If Mode > 2 Then                      ' Save Hysteresis (Mode 2 -> Mode 0) 
   Mode=0               		    ' Only 0, 1, 2 are valid
   Write 2, Hyst / 10                   ' Divide Hyst value to fit in Byte
  EndIf
Endif

 If Mode =1 then
                LcdReg  =  %10000000 + 12        ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000010             ' cursor  Y
                call    PrintCtrlLcd              
                Char = 15
                call    PrintChar  
		    Char = 16
                call    PrintChar  
                Char = 17
                call    PrintChar                
		    Char = 18
                call    PrintChar  


  V=TargetTemp                          ' TargetTemp in V  
  Gosub SelectSign                      ' Select +/blank/- 
  Gosub DTemp                           ' Display Target Temperature
  If (PORTB.1=0) Or (PORTB.2=0) then   ' Up or Down button pushed
   If PORTB.2=0 then                   ' Down button 
    If TargetTemp > 7500 then          ' Not lower than -25 C. (10000-MinTemp * 100)
     TargetTemp=TargetTemp-10           ' Decrease temperature with 0.25 C.
    EndIf
   EndIf
   If PORTB.1=0 then                   ' Up button
    If TargetTemp < 17500 then         ' Not higher than 75 C. (10000+MaxTemp * 100)
     TargetTemp=TargetTemp+10           ' Increase temperature with 0.25 C.
    EndIf
   EndIf
   GoSub SetTargetTemp                  ' Display TargetTemp and delay 0.25 Sec.
  EndIf
 EndIf


 If Mode=2 then                         ' Set Hysteresis  
                LcdReg  =  %10000000 + 12        ' cursor  X  
                call    PrintCtrlLcd
                LcdReg  =  %01000011            ' cursor  Y 
                call    PrintCtrlLcd          
                Char = 24
                call    PrintChar 
                Char = 22
                call    PrintChar  
                Char = 23
                call    PrintChar  
                Char = 15
                call    PrintChar  
    
  Sign=" "                              ' No sign  
  V= 10000+Hyst                         ' Set value for V  
  Gosub DTemp                           ' Display Hysteresis
  If (PORTB.1=0) Or (PORTB.2=0) then    ' Up or down button pushed  
   Sign=" "                             ' No sign for Hysteresis
   If PORTB.1=0 then                    ' Down button
    If Hyst > 10 then Hyst=Hyst-10      ' Not less than 0.1 C.
   EndIf
   If PORTB.2=0 then                    ' Up button
    If Hyst < 1000 then Hyst=Hyst+10    ' Not more than 10.0 C.
   EndIf 
   V= 10000+Hyst                        ' Set value for V
   Gosub DTemp                          ' Display Hysteresis 
   Pause 250                            ' Delay 0.25 Sec.
  EndIf
 EndIf 

 If Mode > 0 then Mainloop         ' Setting TargetTemperature or Hysteresis



Output DQ             			' Make Pin Output
 DQ=0					      ' OneWire line Low
 PauseUs 480                        ' Keep down for 480 S  
 Input DQ                           ' Make Pin Input
 PauseUs 70                         ' Wait 70 S
 If DQ=1 then                       ' No presence pulse from DS1820   
 Pause 500                          ' Wait 0.5 Sec. 
 Goto MainLoop                      ' Check again
EndIf


Main:                
'----------------------------------------
Call BorderLine

Part1:	
' Start temp.conv.Sensor1
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $44] 
 WaitLoop:
 While not DQ
 Wend
 
 OWOut DQ, 1, [$55, $28,  $DD, $06, $49, $1, $0, $0, $D4, $BE]
 Pause 500
 OWIn DQ, 2, [temperature.byte0, temperature.byte1]             
                Predznak = 0
                if  temperature.15 then  
                    temperature  = ~ temperature + 1 
                    Predznak = 1 
                endif  
                
Dummy = 625 * Temperature
TempC = DIV32 10
TempC = (Temperature & $7FF) >> 4
Float = ((Temperature.Lowbyte & $0F ) * 25 )>>2
Temperature=TempC*100 + Float         
 If Predznak then
  V= 10000 - Temperature               ' 25 C=12500  0 C=10000  -10 C=9000 
  Predznak = 0
 else
  V= 10000 + Temperature
 EndIf
 If V >= 10000 then                     ' Above 0 C.      
  Temperature=V-10000                   
 Else                                   
  Temperature=10000-V                  ' Below 0 C. 
 EndIf
 
  If V < TargetTemp - Hyst then          ' Below Target temperature - Hysteresis
  PORTB.6=1                             ' Activate   Warm Output
  PORTB.7=0                             ' Deactivate Cold Output
 EndIf

 If V > TargetTemp + Hyst then          ' Above Target temperature + Hysteresis
  PORTB.6=0                             ' Deactivate Warm output
  PORTB.7=1                             ' Activate   Cold Output
 EndIf
 
 
 GoSub SelectSign                       ' +/blank/- Sign 
  If V >= 10000 then                     ' Above 0 C.      
  Temperature=V-10000                   
 Else                                   
  Temperature=10000-V                   ' Below 0 C. 
 EndIf                       
'---------------setting cursor for text "TEMP.INT :"  
                LcdReg  =  %10000000            ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000001            ' cursor  Y
                call    PrintCtrlLcd              

                Char = 15
                call    PrintChar           
                Char = 16
                call    PrintChar
                Char = 17
                call    PrintChar                
                Char = 18
                call    PrintChar
                Char = 14
                call    PrintChar                
                Char = 19
                call    PrintChar
                Char = 20
                call    PrintChar                
                Char = 15
                call    PrintChar


'---------------setting cursor for display the temperature 1
                LcdReg  =  %10100000 + 22       ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000010            ' cursor  Y
                call    PrintCtrlLcd
'---------------now display temperature 1
                    if TempC > 99 then             
                        Char = 3                
                        call    PrintChar
                    endif
                    
                    If sign ="-"   then 
                        Char = 13
                        call PrintChar                       
                        else 
                        Char = 12                       
                        call    PrintChar
                    endif
                    
                Char = (temperature dig 3) + 2            
                call    PrintChar
                Char = (temperature dig 2) + 2           
                call    PrintChar
                Char = 14                       
                call    PrintChar
                Char = (temperature dig 1) + 2      
                Call    PrintChar 
'                Char = (temperature dig 0) + 2      
'                Call    PrintChar 
'-----------------------------------
Part2 :	
' Start temp. conv.Sensor2
OWOut DQ, 1, [$55, $28, $EB, $EA, $48, $1, $0, $0, $FF, $44]  

WaitLoop2:
While not DQ
Wend

OWOut DQ, 1, [$55, $28, $EB, $EA, $48, $1, $0, $0, $FF, $BE]
Pause 500
OWIn DQ, 2, [Temperature2.Byte0, Temperature2.Byte1]          
                
                Predznak2 = 0
                if  temperature2.15 then  
                    temperature2  = ~ temperature2 + 1 
                    Predznak2 = 1 
                endif  
                
Dummy = 625 * Temperature2
TempC2 = DIV32 10
TempC2 = (Temperature2 & $7FF) >> 4
Float2 = ((Temperature2.Lowbyte & $0F ) * 25 )>>2
Temperature2=TempC2*100 + Float2  

 If Predznak2 then
  V2= 10000 - Temperature2               
  Predznak2 = 0
 else
  V2= 10000 + Temperature2
 EndIf
 If V2 >= 10000 then                     ' Above 0 C.      
  Temperature2=V2-10000                   
 Else                                   
  Temperature2=10000-V2                  ' Below 0 C. 
 Endif 
  
  
 GoSub SelectSign 
 If V2 >= 10000 then                     ' Above 0 C.      
  Temperature2=V2-10000                   
 Else                                   
  Temperature2=10000-V2                   ' Below 0 C. 
 EndIf
'---------------setting cursor for text "TEMP.EXT :"    
                LcdReg  =  %10000000            ' cursor  X  
                call    PrintCtrlLcd
                LcdReg  =  %01000011            ' cursor  Y 
                call    PrintCtrlLcd

                Char = 15
                call    PrintChar              
                Char = 16
                call    PrintChar                
                Char = 17
                call    PrintChar                
                Char = 18
                call    PrintChar
                Char = 14
                call    PrintChar
                Char = 16
                call    PrintChar
                Char = 21
                call    PrintChar
                Char = 15
                call    PrintChar
'---------------setting cursor for display the temperature 2
                LcdReg  =  %10100000 + 22       ' cursor  X  
                call    PrintCtrlLcd
                LcdReg  =  %01000100            ' cursor  Y
                call    PrintCtrlLcd
'---------------now display temperature 2
                    if TempC2 > 99 then             
                        Char = 3                
                        call    PrintChar
                    endif
                    
                    If sign2 ="-"   THEN 
                        Char = 13
                        call PrintChar                       
                        else 
                        Char = 12                       
                        call    PrintChar
                    endif                  
                
                Char = (temperature2 dig 3) + 2            
                call    PrintChar
                Char = (temperature2 dig 2) + 2            
                call    PrintChar
                Char = 14                       
                call    PrintChar
                Char = (temperature2 dig 1) + 2      
                Call    PrintChar
'                Char = (temperature2 dig 0) + 2      
'                Call    PrintChar 
'--------------- display target
                LcdReg  =  %10000000           ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000101            ' cursor  Y
                call    PrintCtrlLcd
                Char = 23
                call    PrintChar
                Char = 16
                call    PrintChar
                Char = 15
                call    PrintChar

                LcdReg  =  %10000000  + 24      ' cursor  X
                call    PrintCtrlLcd
                LcdReg  =  %01000101            ' cursor  Y
                call    PrintCtrlLcd
                Char = (TargetTemp dig 3) + 2            
                call    PrintChar
                Char = (TargetTemp dig 2) + 2           
                call    PrintChar
                Char = 14                       
                call    PrintChar
                Char = (TargetTemp DIG 1) + 2      
                Call    PrintChar
goto MainLoop              
             
'-------------------------------------------------------------                

CursorHome:     LcdReg  =  %10000000            ' cursor Home
                call    PrintCtrlLcd
                LcdReg  =  %01000000            ' cursor Home
                call    PrintCtrlLcd
                return

PrintChar:   offset = Char * 5          
             
                for a = 1 to 5                
                    read offset, LcdReg
                    call  PrintDataLcd
                    offset = offset + 1
                next a
                LcdReg = 0
                call    PrintDataLcd
                return
                                    
PrintCtrlLcd:   D_C = 0                             

PrintDataLcd:   for x = 1 to 8                
                    SDIN = LcdReg.7              
                    SCK = 1
                    LcdReg = LcdReg << 1
                    SCK = 0
                next x               
                D_C = 1
                return               
                
LCD_Clear:
  PosX=0:PosY=0:GOSUB LCD_GotoXY
  HIGH D_C
  FOR Chr=1 TO 252
      LcdData=0:GOSUB LCD_ByteOut
      LcdData=0:GOSUB LCD_ByteOut
  NEXT Chr
RETURN

LCD_GotoXY:
  LOW D_C
  LcdData=%01000000 | PosY :GOSUB LCD_ByteOut
  LcdData=%10000000 | PosX :GOSUB LCD_ByteOut
RETURN

LCD_ByteOut:
  SHIFTOUT SDIN,SCK,1,[LcdData]
RETURN         


'====================================================================
SetTargetTemp:
 V=TargetTemp
 Gosub SelectSign
 Gosub DTemp 
 Pause 250
Return
'====================================================================

DTemp :
 If V >= 10000 then                     ' Above 0 C.      
  Temperature=V-10000                   
 Else                                   
  Temperature=10000-V                   ' Below 0 C. 
 EndIf
                LcdReg  =  %10100000 + 14       ' cursor  X  
                call    PrintCtrlLcd
                LcdReg  =  %01000100            ' cursor  Y
                call    PrintCtrlLcd        
                
                Char = (temperature dig 3) + 2            
                call    PrintChar
                Char = (temperature dig 2) + 2            
                call    PrintChar
                Char = 14                       
                call    PrintChar
                Char = (temperature dig 1) + 2     
                Call    PrintChar
Return

'====================================================================
SelectSign:
 If v = 10000 then         ' Temperature = 0 C.
  Sign=" " 				          ' No sign
 Else 
  If v < 10000 then              	    ' <> 0
   Sign="-"				          ' Temperature below 0 C.	
  Else
   Sign="+"				          ' Temperature above 0 C.
  EndIf
 EndIf

 If v2 = 10000 then        ' Temperature = 0 C.
  Sign2=" " 				          ' No sign
 Else 
  If v2 < 10000 then              	    ' <> 0
   Sign2="-"				          ' Temperature below 0 C. 	
  Else
   Sign2="+"				          ' Temperature above 0 C.
  EndIf
 EndIf
Return


BorderLine: 
'=================================== UP
                LcdReg  =  %10000000            ' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000000            ' cursor  Y
               call    PrintCtrlLcd
                 for y = 0 to 73                   
      LOokup y, [$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$3F,$3F,$21,$21,$3F,$1E,$00,$3F,$3F,$00,_
		         $1E,$3F,$21,$29,$3B,$1A,$00,$3F,$3F,$00,_
                 $01,$01,$3F,$3F,$01,$01,$00,$3E,$3F,$09,$09,$3F,$3E,$00,_
                 $3F,$3F,$20,$20,$20,_
                 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,_
		         $18,$27,$27,$18,$00,$00,$00,$00,$06,$06,_
		         $00,$1E,$3F,$21,$21] ,LcdReg   

'                 for y = 0 to 83                   
'      LOokup y, [$01,$01,$01,$01,$01,$01,$01,$01,_
'                 $01,$01,$01,$01,$01,$01,$7F,$7F,$43,$43,$7F,$3D,$01,$7F,$7F,$01,_            'DI
'                 $3D,$7F,$43,$53,$77,$35,$01,$7F,$7F,$01,$03,$03,$7F,$7F,$03,$03,$01,_        'GIT
'                 $7D,$7F,$13,$13,$7F,$7D,$01,$7F,$7F,$41,$41,$41,$01,$01,$01,$01,$01,_        'AL
'  		          $01,$01,$01,$31,$4F,$4F,$31,$01,$01,$01,$0D,$0D,$01,$3D,$7F,$43,$43,$43,_
'		          $01,$01,$01,$01,$01,$01,$01,01] ,LcdReg       
   
                   call    PrintDataLcd
                   next y

 
'===================================  DOWN                
'		    LcdReg  =  %10000000            ' cursor  X  
'               call    PrintCtrlLcd
'                LcdReg  =  %01000101            ' cursor  Y
'               call    PrintCtrlLcd
'                 for y = 0 to 83 
'      LOokup y, [$80,$80,$80,$80,$80,$80,$FE,$CA,$CA,$B4,$80,$8E,$D0,$D0,$BE,_          'BY      
'		          $80,$80,$80,$80,$FE,$88,$90,$FE,$80,$FE,$80,$BC,$C2,$C2,$A4,_          'NIC
'                 $80,$BE,$C0,$C0,$BE,$80,$FE,$C0,$C0,$C0,$80,$FE,$CA,$CA,$C2,_          'ULE
'	              $80,$A4,$CA,$CA,$B0,$80,$BC,$C2,$C2,$A4,$80,$BE,$C0,$C0,$BE,_          'SCU
'		          $80,$80,$80,$80,$FE,$C2,$C2,$BC,$80,$FC,$92,$92,$FC,$80,$FE,_          'DAN
'		          $88,$90,$FE,$80,$80,$80,$80,$80,$80] ,LcdReg             
'
'                   call    PrintDataLcd
'                    next y 
       return

 '=================================== end of BorderLine



Apel:
                LcdReg  =  %10000000            ' cursor  X  
               call    PrintCtrlLcd
                LcdReg  =  %01000000            ' cursor  Y
               call    PrintCtrlLcd
                Char = 23
                call    PrintChar              
                Char = 16
                call    PrintChar                
                Char = 15
                call    PrintChar                
Return
'------------------------------------------------
 
End        'of program         
