
; PICBASIC PRO(TM) Compiler 2.50b, (c) 1998, 2008 microEngineering Labs, Inc. All Rights Reserved.  
PM_USED			EQU	1

	INCLUDE	"16F628A.INC"


; Define statements.
#define		NO_CLRWDT		 1
#define		OSC		 4                            

RAM_START       		EQU	00020h
RAM_END         		EQU	0014Fh
RAM_BANKS       		EQU	00003h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0014Fh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

R0              		EQU	RAM_START + 000h
R1              		EQU	RAM_START + 002h
R2              		EQU	RAM_START + 004h
R3              		EQU	RAM_START + 006h
R4              		EQU	RAM_START + 008h
R5              		EQU	RAM_START + 00Ah
R6              		EQU	RAM_START + 00Ch
R7              		EQU	RAM_START + 00Eh
R8              		EQU	RAM_START + 010h
FLAGS           		EQU	RAM_START + 012h
GOP             		EQU	RAM_START + 013h
RM1             		EQU	RAM_START + 014h
RM2             		EQU	RAM_START + 015h
RR1             		EQU	RAM_START + 016h
RR2             		EQU	RAM_START + 017h
_Hyst            		EQU	RAM_START + 018h
T1              		EQU	RAM_START + 01Ah
T2              		EQU	RAM_START + 01Ch
_TargetTemp      		EQU	RAM_START + 01Eh
_temperature     		EQU	RAM_START + 020h
_temperature2    		EQU	RAM_START + 022h
_V               		EQU	RAM_START + 024h
_V2              		EQU	RAM_START + 026h
_a               		EQU	RAM_START + 028h
_B1              		EQU	RAM_START + 029h
_B2              		EQU	RAM_START + 02Ah
_Bitovi          		EQU	RAM_START + 02Bh
_Bitovi2         		EQU	RAM_START + 02Ch
_Char            		EQU	RAM_START + 02Dh
_Chr             		EQU	RAM_START + 02Eh
_Dummy           		EQU	RAM_START + 02Fh
_Float           		EQU	RAM_START + 030h
_Float2          		EQU	RAM_START + 031h
_LcdData         		EQU	RAM_START + 032h
_LcdReg          		EQU	RAM_START + 033h
_Minus           		EQU	RAM_START + 034h
_Mode            		EQU	RAM_START + 035h
_Offset          		EQU	RAM_START + 036h
_PosX            		EQU	RAM_START + 037h
_PosY            		EQU	RAM_START + 038h
_Sign            		EQU	RAM_START + 039h
_Sign2           		EQU	RAM_START + 03Ah
_TempC           		EQU	RAM_START + 03Bh
_TempC2          		EQU	RAM_START + 03Ch
_x               		EQU	RAM_START + 03Dh
_y               		EQU	RAM_START + 03Eh
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
_temperature??BYTE0		EQU	_temperature
_temperature??BYTE1		EQU	_temperature + 001h
_temperature2??BYTE0		EQU	_temperature2
_temperature2??BYTE1		EQU	_temperature2 + 001h
_temperature??LOWBYTE		EQU	_temperature
_temperature2??LOWBYTE		EQU	_temperature2
#define _RST             	_PORTA??4
#define _SDIN            	_PORTA??3
#define _SCK             	_PORTA??2
#define _DQ              	_PORTA??1
#define _D_C             	_PORTB??0
#define _Predznak        	_Bitovi??0
#define _Predznak2       	_Bitovi2??0
#define _PORTA??4        	 PORTA, 004h
#define _PORTA??3        	 PORTA, 003h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??1        	 PORTA, 001h
#define _PORTB??0        	 PORTB, 000h
#define _Bitovi??0       	_Bitovi, 000h
#define _Bitovi2??0      	_Bitovi2, 000h
#define _PORTB??6        	 PORTB, 006h
#define _PORTB??7        	 PORTB, 007h
#define _PORTB??3        	 PORTB, 003h
#define _PORTB??1        	 PORTB, 001h
#define _PORTB??2        	 PORTB, 002h
#define _temperature??15 	_temperature + 001h, 007h
#define _temperature2??15	_temperature2 + 001h, 007h
#define _LcdReg??7       	_LcdReg, 007h

; Constants.
_DS18B20_1_12bit 		EQU	0007Fh
_DS18B20_2_12bit 		EQU	0007Fh

; EEPROM data.
	ORG EEPROM_START

	DE	02Eh
	DE	0E0h
	DE	00Ah
	ORG EEPROM_START + 0000Ah
	DE	03Eh
	DE	051h
	DE	049h
	DE	045h
	DE	03Eh
	DE	000h
	DE	042h
	DE	07Fh
	DE	040h
	DE	000h
	DE	042h
	DE	061h
	DE	051h
	DE	049h
	DE	046h
	DE	021h
	DE	041h
	DE	045h
	DE	04Bh
	DE	031h
	DE	018h
	DE	014h
	DE	012h
	DE	07Fh
	DE	010h
	DE	027h
	DE	045h
	DE	045h
	DE	045h
	DE	039h
	DE	03Ch
	DE	04Ah
	DE	049h
	DE	049h
	DE	030h
	DE	001h
	DE	071h
	DE	009h
	DE	005h
	DE	003h
	DE	036h
	DE	049h
	DE	049h
	DE	049h
	DE	036h
	DE	006h
	DE	049h
	DE	049h
	DE	029h
	DE	01Eh
	DE	008h
	DE	008h
	DE	03Eh
	DE	008h
	DE	008h
	DE	008h
	DE	008h
	DE	008h
	DE	008h
	DE	008h
	DE	000h
	DE	060h
	DE	060h
	DE	000h
	DE	000h
	DE	001h
	DE	001h
	DE	07Fh
	DE	001h
	DE	001h
	DE	07Fh
	DE	049h
	DE	049h
	DE	049h
	DE	041h
	DE	07Fh
	DE	002h
	DE	00Ch
	DE	002h
	DE	07Fh
	DE	07Fh
	DE	009h
	DE	009h
	DE	009h
	DE	006h
	DE	000h
	DE	041h
	DE	07Fh
	DE	041h
	DE	000h
	DE	07Fh
	DE	004h
	DE	008h
	DE	010h
	DE	07Fh
	DE	063h
	DE	014h
	DE	008h
	DE	014h
	DE	063h
	DE	003h
	DE	004h
	DE	078h
	DE	004h
	DE	003h
	DE	026h
	DE	049h
	DE	049h
	DE	049h
	DE	032h
	DE	07Fh
	DE	008h
	DE	008h
	DE	008h
	DE	07Fh

	INCLUDE	"T2Z&TH~1.MAC"
	INCLUDE	"PBPPIC14.LIB"


	ASM?
 DEVICE pic16F628A, INTRC_osc, WDT_OFF, PWRT_OFF, BOD_OFF, MCLR_OFF, LVP_OFF, CPD_OFF, PROTECT_OFF       

	ENDASM?

	MOVE?CB	00Eh, TRISB
	MOVE?CB	0A2h, TRISA
	MOVE?CB	0E2h, PORTA
	MOVE?CB	007h, CMCON
	MOVE?CB	000h, VRCON
	MOVE?CB	000h, INTCON
	MOVE?CB	087h, OPTION_REG
	MOVE?CT	000h, _PORTB??6
	MOVE?CT	000h, _PORTB??7
	MOVE?CB	000h, _Mode
	READ?CB	000h, _B1
	READ?CB	001h, _B2
	MUL?BCW	_B1, 00100h, T1
	ADD?WBW	T1, _B2, _TargetTemp
	READ?CB	002h, _B1
	MUL?CBW	00Ah, _B1, _Hyst
	PAUSE?C	064h
	MOVE?CT	001h, _RST
	MOVE?CB	000h, PORTB
	MOVE?CB	021h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	0C8h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	006h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	013h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	020h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	00Ch, _LcdReg
	CALL?L	_PrintCtrlLcd
	CALL?L	_CursorHome
	GOSUB?L	_LCD_Clear
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	04Eh
	OWOUT?C	0FFh
	OWOUT?C	0FFh
	OWOUT?C	07Fh
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	048h
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	0B8h
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	0BEh
	OWEND?	
	PAUSE?C	032h
	OWPIN?T	_DQ
	OWMODE?C	002h
	OWIN?B	_temperature??BYTE0
	OWIN?B	_temperature??BYTE1
	OWEND?	
	PAUSE?C	032h
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	04Eh
	OWOUT?C	0FFh
	OWOUT?C	0FFh
	OWOUT?C	07Fh
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	048h
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	0B8h
	OWEND?	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	0BEh
	OWEND?	
	PAUSE?C	032h
	OWPIN?T	_DQ
	OWMODE?C	002h
	OWIN?B	_temperature2??BYTE0
	OWIN?B	_temperature2??BYTE1
	OWEND?	
	PAUSE?C	032h

	LABEL?L	_MainLoop	
	CMPNE?TCL	_PORTB??3, 000h, L00002
	PAUSE?C	032h
	GOSUB?L	_LCD_Clear
	CALL?L	_Apel
	CMPEQ?TCL	_PORTB??3, 000h, _MainLoop
	ADD?BCB	_Mode, 001h, _Mode
	CMPNE?BCL	_Mode, 002h, L00004
	DIV?WCW	_TargetTemp, 00100h, T1
	WRITE?CW	000h, T1
	MOD?WCW	_TargetTemp, 00100h, T1
	WRITE?CW	001h, T1
	LABEL?L	L00004	
	CMPLE?BCL	_Mode, 002h, L00006
	MOVE?CB	000h, _Mode
	DIV?WCW	_Hyst, 00Ah, T1
	WRITE?CW	002h, T1
	LABEL?L	L00006	
	LABEL?L	L00002	
	CMPNE?BCL	_Mode, 001h, L00008
	MOVE?CB	08Ch, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	042h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	011h, _Char
	CALL?L	_PrintChar
	MOVE?CB	012h, _Char
	CALL?L	_PrintChar
	MOVE?WW	_TargetTemp, _V
	GOSUB?L	_SelectSign
	GOSUB?L	_DTemp
	CMPEQ?TCB	_PORTB??1, 000h, T1
	CMPEQ?TCB	_PORTB??2, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00010
	CMPNE?TCL	_PORTB??2, 000h, L00012
	CMPLE?WCL	_TargetTemp, 01D4Ch, L00014
	SUB?WCW	_TargetTemp, 00Ah, _TargetTemp
	LABEL?L	L00014	
	LABEL?L	L00012	
	CMPNE?TCL	_PORTB??1, 000h, L00016
	CMPGE?WCL	_TargetTemp, 0445Ch, L00018
	ADD?WCW	_TargetTemp, 00Ah, _TargetTemp
	LABEL?L	L00018	
	LABEL?L	L00016	
	GOSUB?L	_SetTargetTemp
	LABEL?L	L00010	
	LABEL?L	L00008	
	CMPNE?BCL	_Mode, 002h, L00020
	MOVE?CB	08Ch, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	043h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	018h, _Char
	CALL?L	_PrintChar
	MOVE?CB	016h, _Char
	CALL?L	_PrintChar
	MOVE?CB	017h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	020h, _Sign
	ADD?CWW	02710h, _Hyst, _V
	GOSUB?L	_DTemp
	CMPEQ?TCB	_PORTB??1, 000h, T1
	CMPEQ?TCB	_PORTB??2, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00022
	MOVE?CB	020h, _Sign
	CMPNE?TCL	_PORTB??1, 000h, L00024
	CMPLE?WCL	_Hyst, 00Ah, L00026
	SUB?WCW	_Hyst, 00Ah, _Hyst
	LABEL?L	L00026	
	LABEL?L	L00024	
	CMPNE?TCL	_PORTB??2, 000h, L00028
	CMPGE?WCL	_Hyst, 003E8h, L00030
	ADD?WCW	_Hyst, 00Ah, _Hyst
	LABEL?L	L00030	
	LABEL?L	L00028	
	ADD?CWW	02710h, _Hyst, _V
	GOSUB?L	_DTemp
	PAUSE?C	0FAh
	LABEL?L	L00022	
	LABEL?L	L00020	
	CMPGT?BCL	_Mode, 000h, _MainLoop
	OUTPUT?T	_DQ
	MOVE?CT	000h, _DQ
	PAUSEUS?C	001E0h
	INPUT?T	_DQ
	PAUSEUS?C	046h
	CMPNE?TCL	_DQ, 001h, L00032
	PAUSE?C	001F4h
	GOTO?L	_MainLoop
	LABEL?L	L00032	

	LABEL?L	_Main	
	CALL?L	_BorderLine

	LABEL?L	_Part1	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	044h
	OWEND?	

	LABEL?L	_WaitLoop	
	LABEL?L	L00034	
	CMPT?TL	_DQ, L00035
	GOTO?L	L00034
	LABEL?L	L00035	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0DDh
	OWOUT?C	006h
	OWOUT?C	049h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0D4h
	OWOUT?C	0BEh
	OWEND?	
	PAUSE?C	001F4h
	OWPIN?T	_DQ
	OWMODE?C	002h
	OWIN?B	_temperature??BYTE0
	OWIN?B	_temperature??BYTE1
	OWEND?	
	MOVE?CT	000h, _Predznak
	CMPF?TL	_temperature??15, L00036
	NOT?WW	_temperature, T1
	ADD?WCW	T1, 001h, _temperature
	MOVE?CT	001h, _Predznak
	LABEL?L	L00036	
	MUL?CWB	00271h, _temperature, _Dummy
	DIV32?CB	00Ah, _TempC
	AND?WCW	_temperature, 007FFh, T1
	SHIFTR?WCB	T1, 004h, _TempC
	AND?BCW	_temperature??LOWBYTE, 00Fh, T1
	MUL?WCW	T1, 019h, T1
	SHIFTR?WCB	T1, 002h, _Float
	MUL?BCW	_TempC, 064h, T1
	ADD?WBW	T1, _Float, _temperature
	CMPF?TL	_Predznak, L00038
	SUB?CWW	02710h, _temperature, _V
	MOVE?CT	000h, _Predznak
	GOTO?L	L00039
	LABEL?L	L00038	
	ADD?CWW	02710h, _temperature, _V
	LABEL?L	L00039	
	CMPLT?WCL	_V, 02710h, L00040
	SUB?WCW	_V, 02710h, _temperature
	GOTO?L	L00041
	LABEL?L	L00040	
	SUB?CWW	02710h, _V, _temperature
	LABEL?L	L00041	
	SUB?WWW	_TargetTemp, _Hyst, T1
	CMPGE?WWL	_V, T1, L00042
	MOVE?CT	001h, _PORTB??6
	MOVE?CT	000h, _PORTB??7
	LABEL?L	L00042	
	ADD?WWW	_TargetTemp, _Hyst, T1
	CMPLE?WWL	_V, T1, L00044
	MOVE?CT	000h, _PORTB??6
	MOVE?CT	001h, _PORTB??7
	LABEL?L	L00044	
	GOSUB?L	_SelectSign
	CMPLT?WCL	_V, 02710h, L00046
	SUB?WCW	_V, 02710h, _temperature
	GOTO?L	L00047
	LABEL?L	L00046	
	SUB?CWW	02710h, _V, _temperature
	LABEL?L	L00047	
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	041h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	011h, _Char
	CALL?L	_PrintChar
	MOVE?CB	012h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	MOVE?CB	013h, _Char
	CALL?L	_PrintChar
	MOVE?CB	014h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	0B6h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	042h, _LcdReg
	CALL?L	_PrintCtrlLcd
	CMPLE?BCL	_TempC, 063h, L00048
	MOVE?CB	003h, _Char
	CALL?L	_PrintChar
	LABEL?L	L00048	
	CMPNE?BCL	_Sign, 02Dh, L00050
	MOVE?CB	00Dh, _Char
	CALL?L	_PrintChar
	GOTO?L	L00051
	LABEL?L	L00050	
	MOVE?CB	00Ch, _Char
	CALL?L	_PrintChar
	LABEL?L	L00051	
	DIG?WCW	_temperature, 003h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature, 002h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature, 001h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar

	LABEL?L	_Part2	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	044h
	OWEND?	

	LABEL?L	_WaitLoop2	
	LABEL?L	L00052	
	CMPT?TL	_DQ, L00053
	GOTO?L	L00052
	LABEL?L	L00053	
	OWPIN?T	_DQ
	OWMODE?C	001h
	OWOUT?C	055h
	OWOUT?C	028h
	OWOUT?C	0EBh
	OWOUT?C	0EAh
	OWOUT?C	048h
	OWOUT?C	001h
	OWOUT?C	000h
	OWOUT?C	000h
	OWOUT?C	0FFh
	OWOUT?C	0BEh
	OWEND?	
	PAUSE?C	001F4h
	OWPIN?T	_DQ
	OWMODE?C	002h
	OWIN?B	_temperature2??BYTE0
	OWIN?B	_temperature2??BYTE1
	OWEND?	
	MOVE?CT	000h, _Predznak2
	CMPF?TL	_temperature2??15, L00054
	NOT?WW	_temperature2, T1
	ADD?WCW	T1, 001h, _temperature2
	MOVE?CT	001h, _Predznak2
	LABEL?L	L00054	
	MUL?CWB	00271h, _temperature2, _Dummy
	DIV32?CB	00Ah, _TempC2
	AND?WCW	_temperature2, 007FFh, T1
	SHIFTR?WCB	T1, 004h, _TempC2
	AND?BCW	_temperature2??LOWBYTE, 00Fh, T1
	MUL?WCW	T1, 019h, T1
	SHIFTR?WCB	T1, 002h, _Float2
	MUL?BCW	_TempC2, 064h, T1
	ADD?WBW	T1, _Float2, _temperature2
	CMPF?TL	_Predznak2, L00056
	SUB?CWW	02710h, _temperature2, _V2
	MOVE?CT	000h, _Predznak2
	GOTO?L	L00057
	LABEL?L	L00056	
	ADD?CWW	02710h, _temperature2, _V2
	LABEL?L	L00057	
	CMPLT?WCL	_V2, 02710h, L00058
	SUB?WCW	_V2, 02710h, _temperature2
	GOTO?L	L00059
	LABEL?L	L00058	
	SUB?CWW	02710h, _V2, _temperature2
	LABEL?L	L00059	
	GOSUB?L	_SelectSign
	CMPLT?WCL	_V2, 02710h, L00060
	SUB?WCW	_V2, 02710h, _temperature2
	GOTO?L	L00061
	LABEL?L	L00060	
	SUB?CWW	02710h, _V2, _temperature2
	LABEL?L	L00061	
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	043h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	011h, _Char
	CALL?L	_PrintChar
	MOVE?CB	012h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	015h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	0B6h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	044h, _LcdReg
	CALL?L	_PrintCtrlLcd
	CMPLE?BCL	_TempC2, 063h, L00062
	MOVE?CB	003h, _Char
	CALL?L	_PrintChar
	LABEL?L	L00062	
	CMPNE?BCL	_Sign2, 02Dh, L00064
	MOVE?CB	00Dh, _Char
	CALL?L	_PrintChar
	GOTO?L	L00065
	LABEL?L	L00064	
	MOVE?CB	00Ch, _Char
	CALL?L	_PrintChar
	LABEL?L	L00065	
	DIG?WCW	_temperature2, 003h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature2, 002h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature2, 001h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	045h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	017h, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	MOVE?CB	098h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	045h, _LcdReg
	CALL?L	_PrintCtrlLcd
	DIG?WCW	_TargetTemp, 003h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	DIG?WCW	_TargetTemp, 002h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	DIG?WCW	_TargetTemp, 001h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	GOTO?L	_MainLoop

	LABEL?L	_CursorHome	
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	040h, _LcdReg
	CALL?L	_PrintCtrlLcd
	RETURN?	

	LABEL?L	_PrintChar	
	MUL?BCB	_Char, 005h, _Offset
	MOVE?CB	001h, _a
	LABEL?L	L00066	
	CMPGT?BCL	_a, 005h, L00067
	READ?BB	_Offset, _LcdReg
	CALL?L	_PrintDataLcd
	ADD?BCB	_Offset, 001h, _Offset
	NEXT?BCL	_a, 001h, L00066
	LABEL?L	L00067	
	MOVE?CB	000h, _LcdReg
	CALL?L	_PrintDataLcd
	RETURN?	

	LABEL?L	_PrintCtrlLcd	
	MOVE?CT	000h, _D_C

	LABEL?L	_PrintDataLcd	
	MOVE?CB	001h, _x
	LABEL?L	L00068	
	CMPGT?BCL	_x, 008h, L00069
	MOVE?TT	_LcdReg??7, _SDIN
	MOVE?CT	001h, _SCK
	SHIFTL?BCB	_LcdReg, 001h, _LcdReg
	MOVE?CT	000h, _SCK
	NEXT?BCL	_x, 001h, L00068
	LABEL?L	L00069	
	MOVE?CT	001h, _D_C
	RETURN?	

	LABEL?L	_LCD_Clear	
	MOVE?CB	000h, _PosX
	MOVE?CB	000h, _PosY
	GOSUB?L	_LCD_GotoXY
	HIGH?T	_D_C
	MOVE?CB	001h, _Chr
	LABEL?L	L00070	
	CMPGT?BCL	_Chr, 0FCh, L00071
	MOVE?CB	000h, _LcdData
	GOSUB?L	_LCD_ByteOut
	MOVE?CB	000h, _LcdData
	GOSUB?L	_LCD_ByteOut
	NEXT?BCL	_Chr, 001h, L00070
	LABEL?L	L00071	
	RETURN?	

	LABEL?L	_LCD_GotoXY	
	LOW?T	_D_C
	OR?CBB	040h, _PosY, _LcdData
	GOSUB?L	_LCD_ByteOut
	OR?CBB	080h, _PosX, _LcdData
	GOSUB?L	_LCD_ByteOut
	RETURN?	

	LABEL?L	_LCD_ByteOut	
	SHIFTDATA?T	_SDIN
	SHIFTCLOCK?T	_SCK
	SHIFTMODE?C	001h
	SHIFTOUT?BC	_LcdData, 008h
	RETURN?	

	LABEL?L	_SetTargetTemp	
	MOVE?WW	_TargetTemp, _V
	GOSUB?L	_SelectSign
	GOSUB?L	_DTemp
	PAUSE?C	0FAh
	RETURN?	

	LABEL?L	_DTemp	
	CMPLT?WCL	_V, 02710h, L00072
	SUB?WCW	_V, 02710h, _temperature
	GOTO?L	L00073
	LABEL?L	L00072	
	SUB?CWW	02710h, _V, _temperature
	LABEL?L	L00073	
	MOVE?CB	0AEh, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	044h, _LcdReg
	CALL?L	_PrintCtrlLcd
	DIG?WCW	_temperature, 003h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature, 002h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Eh, _Char
	CALL?L	_PrintChar
	DIG?WCW	_temperature, 001h, T1
	ADD?WCB	T1, 002h, _Char
	CALL?L	_PrintChar
	RETURN?	

	LABEL?L	_SelectSign	
	CMPNE?WCL	_V, 02710h, L00074
	MOVE?CB	020h, _Sign
	GOTO?L	L00075
	LABEL?L	L00074	
	CMPGE?WCL	_V, 02710h, L00076
	MOVE?CB	02Dh, _Sign
	GOTO?L	L00077
	LABEL?L	L00076	
	MOVE?CB	02Bh, _Sign
	LABEL?L	L00077	
	LABEL?L	L00075	
	CMPNE?WCL	_V2, 02710h, L00078
	MOVE?CB	020h, _Sign2
	GOTO?L	L00079
	LABEL?L	L00078	
	CMPGE?WCL	_V2, 02710h, L00080
	MOVE?CB	02Dh, _Sign2
	GOTO?L	L00081
	LABEL?L	L00080	
	MOVE?CB	02Bh, _Sign2
	LABEL?L	L00081	
	LABEL?L	L00079	
	RETURN?	

	LABEL?L	_BorderLine	
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	040h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	000h, _y
	LABEL?L	L00082	
	CMPGT?BCL	_y, 049h, L00083
	LOOKUP?BCLB	_y, 04Ah, L00001, _LcdReg
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	03Fh
	LURET?C	03Fh
	LURET?C	021h
	LURET?C	021h
	LURET?C	03Fh
	LURET?C	01Eh
	LURET?C	000h
	LURET?C	03Fh
	LURET?C	03Fh
	LURET?C	000h
	LURET?C	01Eh
	LURET?C	03Fh
	LURET?C	021h
	LURET?C	029h
	LURET?C	03Bh
	LURET?C	01Ah
	LURET?C	000h
	LURET?C	03Fh
	LURET?C	03Fh
	LURET?C	000h
	LURET?C	001h
	LURET?C	001h
	LURET?C	03Fh
	LURET?C	03Fh
	LURET?C	001h
	LURET?C	001h
	LURET?C	000h
	LURET?C	03Eh
	LURET?C	03Fh
	LURET?C	009h
	LURET?C	009h
	LURET?C	03Fh
	LURET?C	03Eh
	LURET?C	000h
	LURET?C	03Fh
	LURET?C	03Fh
	LURET?C	020h
	LURET?C	020h
	LURET?C	020h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	018h
	LURET?C	027h
	LURET?C	027h
	LURET?C	018h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	000h
	LURET?C	006h
	LURET?C	006h
	LURET?C	000h
	LURET?C	01Eh
	LURET?C	03Fh
	LURET?C	021h
	LURET?C	021h

	LABEL?L	L00001	
	CALL?L	_PrintDataLcd
	NEXT?BCL	_y, 001h, L00082
	LABEL?L	L00083	
	RETURN?	

	LABEL?L	_Apel	
	MOVE?CB	080h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	040h, _LcdReg
	CALL?L	_PrintCtrlLcd
	MOVE?CB	017h, _Char
	CALL?L	_PrintChar
	MOVE?CB	010h, _Char
	CALL?L	_PrintChar
	MOVE?CB	00Fh, _Char
	CALL?L	_PrintChar
	RETURN?	
	END?	

	END
