;lasser.asm: firmware for the microcontroller in a capacitor based welder.
;The intelligence of the trigger circuit is inhere; modify to change the 
;trigger-behaviour.
;This software is licensed under the GNU GPL.
;(c) 2006 Jeroen Domburg <capwelder@jeroen.ietsmet.nl>

;We're using a tiny13 here.
.device ATTiny13
;You might want to include the ATTiny2313-definitions included with
;your assembler. I use gavrasm, which doesn't need them.
;.include "tn13def.h"

;The fuses should be configured as follows:
;FUSE_L=0x3a
;FUSE_H=0xff

;Port declarations
.equ sense	=	1
.equ fire	=	2

.def temp	=	R16 	;The temp register
.def temp2	=	R17 	;Second temp register
.def temp3	=	R18
.def temp4	=	R19


	rjmp start		; reset vector
	reti			; External Int 0 not enabled
	reti			; Pin Change int 0 not enabled
	reti			; Timer 0 Overflow Int not enabled
	reti			; Eeprom ready not enabled
	reti			; Anacomp interrupt Not enabled
	reti			; Timer 0 comparator A not enabled
	reti			; Timer 0 comparator B not enabled
	reti			; ADC conversion complete Not enabled


start:
	ldi temp,RAMEND		; top of memory
	out SPL,temp		; init stack pointer
	ldi temp,0b00100	; Port B direction options
	out DDRB,temp		; Setup port direction
	
reset:
	;Wait a moment
	rcall wait
	;Check if the welding connection is closed continuously for some time.
	;If an open circuit is detected, we retry this all from the start.
	ldi temp,0
l1:
	ldi temp2,0
l2:
	ldi temp3,20
l3:
	sbis pinb,sense
	 rjmp reset
	dec temp3
	brne l3
	dec temp2
	brne l2
	dec temp
	brne l1
	rcall wait


	;Open floodgates, wait a sec, close again
	sbi portb,fire
	rcall wait
	rcall wait
	rcall wait
	rcall wait
	cbi portb,fire

	;Wait a sec for the caps to reload...
	rcall wait
	rcall wait
	rcall wait
	rcall wait
	rcall wait
	rcall wait

	;Make sure we don't immediate retrigger; wait for the electrodes
	;to make no circuit first
waitloaded:
	sbic pinb,sense
	 rjmp waitloaded
	 
	rjmp reset
	
;Routine to wait some time
wait:
	ldi temp,0
w1:
	ldi temp2,0
w2:
	dec temp2
	brne w2
	dec temp
	brne w1
	ret