
    ; Notes: This is similar to what you had previously, but with /MCLR enabled.
    ; Use a push-button switch to ground /MCLR. This will reset and let code execute
    ; once before it goes into low-power sleep mode.

    ; Multiple calls have been replaced with a single variable being loaded with the
    ; number of 'times' to execute the Delay routine.

    ; Power-up timer is enabled so you're relatively sure you get a clean power-up.
    
    ; Config line changed so you can actually see what each option is set to & make
    ; easy changes as needed.

    LIST  p=16F628          ;tell assembler what chip we are using
    include "P16F628.inc"   ;include the defaults for the chip
    
    ;__config 0x3D18         ;config settings (osc. type etc.)

    ; similar to above with /MCLR enabled (for reset), power-up timer on,
    ; and now you know at a glance what your config settings are.

    __CONFIG _CP_OFF & _BODEN_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _LVP_OFF & _INTRC_OSC_NOCLKOUT

    cblock 0x20  ;start of general purpose registers
      count1     ;used in delay routine
      counta     ;used in delay routine 
      countb     ;used in delay routine
      times      ;number of times to execute Delay loop
    endc

LEDA0	    Equ  0     ;set constant LED = 0
LEDPORTA0   Equ  PORTA ;set constant LEDPORT = 'PORTA'
LEDA1	    Equ  1     ;set constant LED = 1
LEDPORTA1   Equ  PORTA ;set constant LEDPORT = 'PORTA'
LEDA2	    Equ  2     ;set constant LED = 2
LEDPORTA2   Equ  PORTA ;set constant LEDP0RT = 'PORTA'
LEDA3	    Equ  3     ;set constant LED = 3
LEDPORTA3   Equ  PORTA ;set constant LEDPORT = 'PORTA'
LEDA4	    Equ  4     ;set constant LED = 4
LEDPORTA4   Equ  PORTA ;set constant LEDPORT = 'PORTA'

; NOTE: Removed below because RA5 = INPUT only on 16F628
; LEDA5	    Equ  5     ;set constant LED = 5 
; LEDPORTA5   Equ  PORTA ;set constant LEDPORT = 'PORTA'

LEDB0	    Equ  0     ;set constant LED = 0
LEDPORTB0   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB1	    Equ  1     ;set constant LED = 1
LEDPORTB1   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB2	    Equ  2     ;set constant LED = 2
LEDPORTB2   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB3	    Equ  3     ;set constant LED = 3
LEDPORTB3   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB4	    Equ  4     ;set constant LED = 4
LEDPORTB4   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB5	    Equ  5     ;set constant LED = 5
LEDPORTB5   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB6	    Equ  6     ;set constant LED = 6
LEDPORTB6   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDB7	    Equ  7     ;set constant LED = 7
LEDPORTB7   Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDPORT     Equ  PORTB ;set constant LEDPORT = 'PORTB'
LEDTRIS     Equ  TRISB ;set constant for TRIS register
	
   org     0x0000   ;org 0 for the 16F628

   banksel PORTB    ;select bank 0
   movlw   0x07
   movwf   CMCON    ;turn comparators off (make it like a 16F84)
   clrf    PORTB    ;clear all port latches before setting TRIS regs
   clrf    PORTA

   banksel TRISA    ;select bank 1
   movlw   b'00100000'
   movwf   TRISA    ;set PortA outputs, RA5 = /MCLR input
   clrf    TRISB    ;set PortB all outputs

   banksel PORTB    ;select bank 0

;----------------------------------------------------------------------

Loop
   BSF    LEDPORTA0, LEDA0  ; RA0 ON
   movlw  d'7'    ; execute delay this number of times
   movwf  times    
   call   Delay

   movlw  b'11111111'
   movwf  LEDPORT
   movlw  d'4'    ; execute delay this number of times
   movwf  times    
   call   Delay

   movlw  b'00000000'
   movwf  LEDPORT
   movlw  d'4'     
   movwf  times
   call   Delay

   movlw  b'11111111'
   movwf  LEDPORT
   movlw  d'5'
   movwf  times    
   call	  Delay
   
   movlw  b'00000000'
   movwf  LEDPORT
   movlw  d'4'
   movwf  times    
   call	  Delay

   movlw  b'11111111'
   movwf  LEDPORT
   movlw  d'4'
   movwf  times    
   call	  Delay

   movlw  b'00000000'
   movwf  LEDPORT
   movlw  d'4'
   movwf  times   
   call	  Delay

   movlw  b'11111111'
   movwf  LEDPORT
   movlw  d'4'
   movwf  times    
   call	  Delay

   movlw  b'00000000'
   movwf  LEDPORT
   movlw  d'2'
   movwf  times    
   call	  Delay

   movlw  b'00010000'
   movwf  LEDPORT
   movlw  d'1'
   movwf  times    
   call	  Delay

   movlw  b'00001000'
   movwf  LEDPORT	
   movlw  d'1'
   movwf  times   
   call	  Delay

   movlw  b'00010000'
   movwf  LEDPORT	
   movlw  d'1'
   movwf  times      
   call	  Delay

   movlw  b'00000000'
   movwf  LEDPORT	
   movlw  d'2'
   movwf  times       
   call   Delay	
   bcf    LEDPORTA0,LEDA0  ; RA0 off
   
   ; code above executes once, then PIC enters low-power sleep mode until /MCLR reset.

SleepLoop 
   SLEEP            ; enter low power sleep
   GOTO   SleepLoop ; go back to sleep if it wakes up
;-------------------------------------------------------------------------------------

Delay
   movlw   d'250'    ;delay 250 ms (4 MHz clock)
   movwf   count1

d1
   movlw   0xC7
   movwf   counta
   movlw   0x01
   movwf   countb

Delay_0
   decfsz  counta,f
   goto    $+2
   decfsz  countb,f
   goto    Delay_0
   decfsz  count1,f
   goto    d1
   decfsz  times    ; execute delay this number of times
   goto    Delay

   retlw   0x00
   
   end