' Setting in P18F2550.INC in MPASM Suite
' Commented out default config setting
@   __CONFIG	_CONFIG1L, _PLLDIV_1_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L
@	__CONFIG	_CONFIG1H, _FOSC_XTPLL_XT_1H & _FCMEN_OFF_1H & _IESO_OFF_1H
@	__CONFIG	_CONFIG2L, _PWRT_ON_2L & _BOR_ON_2L  & _BORV_2_2L  & _VREGEN_ON_2L
@	__CONFIG	_CONFIG2H, _WDT_OFF_2H
@	__CONFIG	_CONFIG3H, _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_ON_3H
@	__CONFIG	_CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L & _DEBUG_OFF_4L

DEFINE    OSC 48

' 18F2550
' ****************************** Configure Hardware *********************************************
trisb = %11111100
trisc = %10111111       	' Set TX (PortC.6) to out, rest in
spbrg = 25            		' Calculate ((CPU speed mhz/Baud)/16)- 1  25 = 115200 baud  EX:((48000000/115200)/16)-1
rcsta = %10010000       	' Enable serial port and continuous receive
txsta = %00100000       	' Enable transmit and asynchronous mode/brgh = 0 bit 2
baudcon =%00001000			' Bit3 = 1: High speed usart 16 bit  
'******************************* Configure Oscillator ************************************

Buffer    VAR BYTE[16]
Cnt       VAR BYTE
B0        VAR BYTE
B1        VAR BYTE

ADCON1 = 15               ' Set all I/Os to Digital      
CMCON = 7                 ' Disable Comparators
Cnt = 16

USBInit                   ' Initialize USART

for b0 = 0 to 15
    lookup b0,["USB CONNECTED!",10,13],B1 
    BUFFER(B0) = B1
    NEXT B0

' Main Program Loop
Loop:
    USBService        ' Must service USB regularly
    USBOut 3, Buffer, Cnt, loop
    goto loop
end
