; Buffer Descriptor Byte Aliases
#define	Stat		0		; Buffer Descriptor Status Register
#define	Cnt		1		; Buffer Count
;#define ADR		2		; Buffer Address
#define	ADRL		2		; Buffer Address Low
#define	ADRH		3		; Buffer Address High

; Stat Bit Aliases
#define	BC8		0		; Upper Count Bit
#define	BC9		1		; Upper Count Bit
#define	BSTALL		2		; Buffer Stall Enable
#define	DTSEN		3		; Data Toggle Synch Enable
#define	INCDIS		4		; Address Increment Disable
#define	KEN		5		; BD Keep Enable
#define	DTS		6		; Data Toggle Synch Value
#define	UOWN		7		; USB Ownership
#define	PID		2		; Packet Identifier (4 bits)
;#define PID0		2
;#define PID1		3
;#define PID2		4
;#define PID3		5


SavedOrg equ	$			; Save current org
	org	0x400			; Bank 4

; Buffer Descriptor Table (BDT) RAM

#if(0 <= MAX_EP_NUMBER)			; (See usbmmap.c & usbmmap.h)
ep0Bo		res	4		; Endpoint #0 BD Out
ep0Bi		res	4		; Endpoint #0 BD In
#endif

#if(1 <= MAX_EP_NUMBER)
ep1Bo		res	4		; Endpoint #1 BD Out
ep1Bi		res	4		; Endpoint #1 BD In
#endif

#if(2 <= MAX_EP_NUMBER)
ep2Bo		res	4		; Endpoint #2 BD Out
ep2Bi		res	4		; Endpoint #2 BD In
#endif

#if(3 <= MAX_EP_NUMBER)
ep3Bo		res	4		; Endpoint #3 BD Out
ep3Bi		res	4		; Endpoint #3 BD In
#endif

#if(4 <= MAX_EP_NUMBER)
ep4Bo		res	4		; Endpoint #4 BD Out
ep4Bi		res	4		; Endpoint #4 BD In
#endif

#if(5 <= MAX_EP_NUMBER)
ep5Bo		res	4		; Endpoint #5 BD Out
ep5Bi		res	4		; Endpoint #5 BD In
#endif

#if(6 <= MAX_EP_NUMBER)
ep6Bo		res	4		; Endpoint #6 BD Out
ep6Bi		res	4		; Endpoint #6 BD In
#endif

#if(7 <= MAX_EP_NUMBER)
ep7Bo		res	4		; Endpoint #7 BD Out
ep7Bi		res	4		; Endpoint #7 BD In
#endif

#if(8 <= MAX_EP_NUMBER)
ep8Bo		res	4		; Endpoint #8 BD Out
ep8Bi		res	4		; Endpoint #8 BD In
#endif

#if(9 <= MAX_EP_NUMBER)
ep9Bo		res	4		; Endpoint #9 BD Out
ep9Bi		res	4		; Endpoint #9 BD In
#endif

#if(10 <= MAX_EP_NUMBER)
ep10Bo		res	4		; Endpoint #10 BD Out
ep10Bi		res	4		; Endpoint #10 BD In
#endif

#if(11 <= MAX_EP_NUMBER)
ep11Bo		res	4		; Endpoint #11 BD Out
ep11Bi		res	4		; Endpoint #11 BD In
#endif

#if(12 <= MAX_EP_NUMBER)
ep12Bo		res	4		; Endpoint #12 BD Out
ep12Bi		res	4		; Endpoint #12 BD In
#endif

#if(13 <= MAX_EP_NUMBER)
ep13Bo		res	4		; Endpoint #13 BD Out
ep13Bi		res	4		; Endpoint #13 BD In
#endif

#if(14 <= MAX_EP_NUMBER)
ep14Bo		res	4		; Endpoint #14 BD Out
ep14Bi		res	4		; Endpoint #14 BD In
#endif

#if(15 <= MAX_EP_NUMBER)
ep15Bo		res	4		; Endpoint #15 BD Out
ep15Bi		res	4		; Endpoint #15 BD In
#endif


; General RAM (in bank 4)
usb_temp	res	2		; Temporary storage
pSrc		res	2		; Source pointer
pDst		res	2		; Destination pointer

; (See usbctrltrf.c)
ctrl_trf_state	res	1		; Control Transfer State
ctrl_trf_session_owner res 1		; Current transfer session owner
wCount		res	2		; Data counter
short_pkt_status res	1		; Flag used by Control Transfer Read
trnifcleared	res	1

; (See usbdrv.c)
bTRNIFCount	res	1

; (See usbmmap.c)
usb_device_state res	1		; Device States: DETACHED, ATTACHED, ...
usb_active_cfg	res	1		; Value of current configuration
usb_alt_intf	res	MAX_NUM_INT	; Array to keep track of the current alternate setting for each interface ID
usb_stat	res	1

; usb_stat bit aliases
#define	RemoteWakeup	0		; [0]Disabled [1]Enabled
#define	ctrl_trf_mem	1		; [0]RAM      [1]ROM
#define	cdc_mem_type	2		; [0]RAM      [1]ROM

; Endpoint 0 buffers
SetupPkt	res	EP0_BUFF_SIZE	; (See usbmmap.c & usbdefs_ep0_buff.h - CTRL_TRF_SETUP)
CtrlTrfData	res	EP0_BUFF_SIZE	; (See usbmmap.c & usbdefs_ep0_buff.h - CTRL_TRF_DATA)

; SetupPkt Byte and Bit Aliases
#define	bmRequestType	0
#define	bRequest	1
#define	wValue		2
#define	wIndex		4
#define	wLength		6

#define	Recipient	0		; Device,Interface,Endpoint,Other (5 bits)
#define	RequestType	5		; Standard,Class,Vendor,Reserved (2 bits)
#define	DataDir		7		; Host-to-device,Device-to-host
#define	bFeature	2		; DEVICE_REMOTE_WAKEUP,ENDPOINT_HALT

#define	bReportID	2		; In a SET_REPORT or GET_REPORT request
#define	bReportType	3		; In a SET_REPORT or GET_REPORT request

#define	bDscIndex	2		; For Configuration and String DSC Only
#define	bDscType	3		; Device,Configuration,String
#define	wLangID		4		; Language ID

#define	bDevADR		2		; Device Address 0-127
#define	bDevADRH	3		; Must equal zero

#define	bCfgValue	2		; Configuration Value 0-255
#define	bCfgRSD		3		; Must equal zero (Reserved)

#define	bAltID		2		; Alternate Setting Value 0-255
#define	bAltID_H	3		; Must equal zero (Reserved)
#define	bIntfID		4		; Interface Number Value 0-255
#define	bIntfID_H	5		; Must equal zero

#define	bEPID		4		; Endpoint ID (Number & Direction)
#define	bEPID_H		5		; Must equal zero

#define	EPNum		0		; Endpoint Number 0-15 (4 bits)
#define	EPDir		7		; Endpoint Direction: 0-OUT, 1-IN


; HID RAM (in bank 4)

#ifdef USB_USE_HID
idle_rate	res	1
active_protocol	res	1		; [0] Boot Protocol [1] Report Protocol
#endif


; CDC RAM (in bank 4)

#ifdef USB_USE_CDC			; (See usbmmap.c & usbmmap.h)
line_coding	res	LINE_CODING_LENGTH
control_signal_bitmap res 1
dummy_encapsulated_cmd_response res dummy_length

; line_coding Byte and Bit Aliases
#define	dwDTERate	0		; Complex data structure
#define	bCharFormat	4
#define	bParityType	5
#define	bDataBits	6

; control_signal_bitmap Byte and Bit Aliases
#define	DTE_PRESENT	0		; [0] Not Present  [1] Present
#define	CARRIER_CONTROL	1		; [0] Deactivate   [1] Activate
#endif


; All previous RAM must be in bank 4
; The following buffers may be in any dual-port RAM bank

; HID Buffer RAM

#ifdef USB_USE_HID
hid_report_out	res	HID_INT_OUT_EP_SIZE + 1	; (See usbmmap.c & usbmmap.h)
hid_report_in	res	HID_INT_IN_EP_SIZE + 1	; +1 for size at front
#endif


; CDC Buffer RAM
	
#ifdef USB_USE_CDC			; (See usbmmap.c & usbmmap.h)
cdc_notice	res	CDC_INT_EP_SIZE + 1	; +1 for size at front
cdc_data_rx	res	CDC_BULK_OUT_EP_SIZE + 1	; +1 for size at front
cdc_data_tx	res	CDC_BULK_IN_EP_SIZE + 1	; +1 for size at front
#endif


	org	SavedOrg		; Restore previous org
