; CDCDESC.ASM
;
; This file contains a set of descriptors for CDC.

#define	EP0_BUFF_SIZE		8	; 8, 16, 32, or 64
#define	MAX_NUM_INT		1	; For tracking Alternate Setting
#define	MAX_EP_NUMBER		3	; UEP3
#define	NUM_CONFIGURATIONS	1
#define	NUM_INTERFACES		2

#define	MODE_PP			_PPBM0
#define	UCFG_VAL		_PUEN|_TRINT|_FS|MODE_PP	; Full-speed

;#define USE_SELF_POWER_SENSE_IO
;#define USE_USB_BUS_SENSE_IO

; DEVICE CLASS USAGE
#define USB_USE_CDC

; CDC
#define CDC_COMM_INTF_ID        0x00
#define CDC_COMM_UEP            UEP2
#define CDC_INT_BD_IN           ep2Bi
#define CDC_INT_EP_SIZE         8
#define CDC_DATA_INTF_ID        0x01
#define CDC_DATA_UEP            UEP3
#define CDC_BULK_BD_OUT         ep3Bo
#define CDC_BULK_OUT_EP_SIZE    64
#define CDC_BULK_BD_IN          ep3Bi
#define CDC_BULK_IN_EP_SIZE     64

; ******************************************************************
; This table is polled by the host immediately after USB Reset has been released.
; These fields are application DEPENDENT. Modify these to meet
; your specifications.
; ******************************************************************
DeviceDescriptor
	retlw	(EndDeviceDescriptor-DeviceDescriptor)/2	; bLength Length of this descriptor
	retlw	DSC_DEV		; bDescType DEVICE
	retlw	0x10		; bcdUSBUSB Revision 1.10 (low byte)
	retlw	0x01		; high byte
	retlw	CDC_DEVICE	; bDeviceClass
	retlw	0x00		; bDeviceSubClass
	retlw	0x00		; bDeviceProtocol
	retlw	EP0_BUFF_SIZE	; bMaxPacketSize for EP0
	retlw	0xD8		; idVendor - 0x04D8 is Microchip Vendor ID (low byte)
	retlw	0x04		; (high byte)
	retlw	0x0A		; idProduct Product ID (low byte)
	retlw	0x00		; (high byte)
	retlw	0x00		; bcdDevice Device release number (low byte)
	retlw	0x00		; (high byte)
	retlw	0x01		; iManufacturer Manufacturer string index
	retlw	0x02		; iProduct Product string index
	retlw	0x03		; iSerialNumber Device serial number string index
	retlw	NUM_CONFIGURATIONS	; bNumConfigurations
EndDeviceDescriptor

; ******************************************************************
; This table is retrieved by the host after the address has been set.
; This table defines the configurations available for the device.
; See section 9.6.2 of the Rev 1.0 USB specification (page 184).
; These fields are application DEPENDENT. 
; Modify these to meet your specifications.
; ******************************************************************
; Configuration pointer table
USB_CD_Ptr
Configs
	db	low Config1, high Config1
	db	low Config1, high Config1

; Configuration Descriptor
Config1
	retlw	9		; bLength Length of this descriptor
	retlw	DSC_CFG		; bDescType CONFIGURATION
Config1Len
	retlw	low ((EndConfig1 - Config1)/2)	; Length of this configuration
	retlw	high ((EndConfig1 - Config1)/2)
	retlw	NUM_INTERFACES	; bNumInterfaces Number of interfaces in this configuration
	retlw	0x01		; bConfigValue Configuration Value
	retlw	0x02		; iConfigString Index for this configuration
	retlw	0x80		; bmAttributes
	retlw	0x50		; Max power consumption (2X mA)

; Interface Descriptor
	retlw	9		; bLength Length of this descriptor
	retlw	DSC_INTF	; bDescType INTERFACE
	retlw	0x00		; Interface number
	retlw	0x00		; Alternate setting
	retlw	0x01		; Number of endpoints in this interface
	retlw	COMM_INTF	; Class code
	retlw	ABSTRACT_CONTROL_MODEL	; Subclass code
	retlw	V25TER		; Protocol code
	retlw	0x00		; Interface string index

; CDC Class-Specific Descriptors
	retlw	5		; bFNLength (USB_CDC_HEADER_FN_DSC)
	retlw	CS_INTERFACE	; bDscType
	retlw	DSC_FN_HEADER	; bDscSubType
	retlw	0x10		; bcdCDC (low byte)
	retlw	0x01		; (high byte)

	retlw	4		; bFNLength (USB_CDC_ACM_FN_DSC)
	retlw	CS_INTERFACE	; bDscType
	retlw	DSC_FN_ACM	; bDscSubType
	retlw	0x02		; bmCapabilities

	retlw	5		; bFNLength (USB_CDC_UNION_FN_DSC)
	retlw	CS_INTERFACE	; bDscType
	retlw	DSC_FN_UNION	; bDscSubType
	retlw	CDC_COMM_INTF_ID	; bMasterIntf
	retlw	CDC_DATA_INTF_ID	; bSaveIntf0

	retlw	5		; bFNLength (USB_CDC_CALL_MGT_FN_DSC)
	retlw	CS_INTERFACE	; bDscType
	retlw	DSC_FN_CALL_MGT	; bDscSubType
	retlw	0x00		; bmCapabilities
	retlw	CDC_DATA_INTF_ID	; bDataInterface

; Endpoint Descriptor
	retlw	7		; bLength (USB_EP_DSC)
	retlw	DSC_EP		; bDscType
	retlw	_EP02_IN	; bEPAdr
	retlw	3		; bmAttributes (_INT)
	retlw	low (CDC_INT_EP_SIZE)	; wMaxPktSize
	retlw	high (CDC_INT_EP_SIZE)
	retlw	0x02		; bInterval
    
; Interface Descriptor
	retlw	9		; bLength Length of this descriptor
	retlw	DSC_INTF	; INTERFACE descriptor type
	retlw	1		; Interface Number
	retlw	0		; Alternate Setting Number
	retlw	2		; Number of endpoints in this intf
	retlw	DATA_INTF	; Class code
	retlw	0		; Subclass code
	retlw	NO_PROTOCOL	; Protocol code
	retlw	0		; Interface string index
    
; Endpoint Descriptors
	retlw	7		; bLength (USB_EP_DSC)
	retlw	DSC_EP		; bDscType
	retlw	_EP03_OUT	; bEPAdr
	retlw	2		; bmAttributes (_BULK)
	retlw	low (CDC_BULK_OUT_EP_SIZE)	; wMaxPktSize
	retlw	high (CDC_BULK_OUT_EP_SIZE)
	retlw	0x00		; bInterval
	
	retlw	7		; bLength (USB_EP_DSC)
	retlw	DSC_EP		; bDscType
	retlw	_EP03_IN	; bEPAdr
	retlw	2		; bmAttributes (_BULK)
	retlw	low (CDC_BULK_IN_EP_SIZE)	; wMaxPktSize
	retlw	high (CDC_BULK_IN_EP_SIZE)
	retlw	0x00		; bInterval
EndConfig1


; String pointer table
USB_SD_Ptr
Strings
	db	low String0, high String0
	db	low String1, high String1
	db	low String2, high String2
	db	low String3, high String3
	db	low String4, high String4

String0
	retlw   (String1 - String0)/2	; Length of string 
	retlw   DSC_STR		; Descriptor type 3
	retlw   0x09    	; Language ID (0x0409 as defined by MS)
	retlw   0x04

String1
	retlw   (String2-String1)/2
	retlw   DSC_STR
	retlw   'M'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'r'
	retlw   0x00
	retlw   'o'
	retlw   0x00
	retlw   'c'
	retlw   0x00
	retlw   'h'
	retlw   0x00
	retlw   'i'
	retlw   0x00
	retlw   'p'
	retlw   0x00
String2
	retlw   (String3-String2)/2
	retlw   DSC_STR
	retlw   'P'
	retlw   0x00
	retlw   'I'
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '8'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'U'
	retlw   0x00
	retlw   'S'
	retlw   0x00
	retlw   'B'
	retlw   0x00
	retlw   ' '
	retlw   0x00
	retlw   'C'
	retlw   0x00
	retlw   'D'
	retlw   0x00
	retlw   'C'
	retlw   0x00
String3
	retlw   (String4-String3)/2
	retlw   DSC_STR
	retlw   'V'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw   '.'
	retlw   0x00
	retlw   '1'
	retlw   0x00
	retlw	'F'
	retlw	0x00
	retlw	'S'
	retlw	0x00
String4
	retlw   (String5-String4)/2
	retlw   DSC_STR
	retlw   'C'
	retlw   0x00
	retlw   'f'
	retlw   0x00
	retlw	'g'
	retlw   0x00
	retlw	'1'
	retlw   0x00
String5
