
' Autodemo
' 18F2550
' ****************************** Configure Hardware *********************************************
trisb = %11111100
trisc = %10111111       	' Set TX (PortC.6) to out, rest in
spbrg = 25            		' Calculate ((CPU speed mhz/Baud)/16)- 1  25 = 115200 baud  EX:((48000000/115200)/16)-1
rcsta = %10010000       	' Enable serial port and continuous receive
txsta = %00100000       	' Enable transmit and asynchronous mode/brgh = 0 bit 2
baudcon =%00001000			' Bit3 = 1: High speed usart 16 bit  
'******************************* Configure Oscillator ************************************
' Setting in P18F2550.INC in MPASM Suite
' Commented out default config setting
'asm
  '  __CONFIG    _CONFIG1L, _PLLDIV_1_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L  
                            ;              ;                      ; USB clock source comes from the 96 MHz PLL divided by 2
                            ;              ; [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2] Determines cpu speed 
                            ; No prescale (4 MHz oscillator input drives PLL directly)
  '  __CONFIG    _CONFIG1H, _FOSC_XTPLL_XT_1H & _FCMEN_OFF_1H & _IESO_OFF_1H 
                            ;             ;               ; Oscillator Switchover mode disabled
                            ;             ; Fail-Safe Clock Monitor disabled
                            ; XT oscillator, PLL enabled, XT used by USB
  '  __CONFIG    _CONFIG2L, _PWRT_ON_2L & _BOR_ON_2L  & _BORV_2_2L  & _VREGEN_ON_2L   
  '  __CONFIG    _CONFIG2H, _WDT_OFF_2H 
  '  __CONFIG    _CONFIG3H, _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_ON_3H 
  '  __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L & _DEBUG_OFF_4L 
							; Removed ICPRT_OFF_4L used with 18F4550 
'endasm

'***************************** Variables ******************************************
USBBufferTX Var Byte[4]
USBBufferRX var Byte[3]
USBBufferCount Var Byte
Indexer var byte
Xmit_Start var bit									' Start serial data transmission
Status_Bits var byte								' Status bits to Pc
Data_Delay var word									' Delay for dataout
Data_Out var word									' Data 

Status_Bits = 0
'***************************** Initialize ******************************************
usbinit ' initialise USB...
for Indexer = 0 to 4
	USBBufferRX[Indexer]= 0
next

' ******************************* Main **********************************************
ProgramStart:
	' Signals from pc 
if Xmit_Start = 0 then gosub USB_RX
if USBBufferRX[0] = 77 and USBBufferRX[1] = 88 and USBBufferRX[2] = 56 then Xmit_Start = 1 		' RX "MX8"
if USBBufferRX[0] = 77 and USBBufferRX[1] = 88 and USBBufferRX[2] = 57 then Xmit_Start = 0 		' RX "MX9"
if USBBufferRX[0] = 77 and USBBufferRX[1] = 88 and USBBufferRX[2] = 49 then Status_Bits = 36	' RX "MX1"	
if USBBufferRX[0] = 77 and USBBufferRX[1] = 88 and USBBufferRX[2] = 50 then Status_Bits = 144	' RX "MX2"
if USBBufferRX[0] = 77 and USBBufferRX[1] = 88 and USBBufferRX[2] = 51 then Status_Bits = 0		' RX "MX3"
	
	' Increment data value delay
Data_Delay = Data_Delay + 1
if Data_Delay = 2000 then
	hserout ["Hello "]			' Output serial data thru Usart
	Data_Out = Data_Out + 22
	if Data_Out > 6000 then
		Data_Out = 10
	endif
	Data_Delay = 0
endif 
	' Start transmitting data
if Xmit_Start = 1 then gosub USB_TX
if Xmit_Start = 1 then
	portb.1 = 1
else
	portb.1 = 0
endif

goto ProgramStart

	' Transmit USB Data 
USB_TX:
USBBufferTX[0]= "B"										' ID
USBBufferTX[1]= Status_Bits								
USBBufferTX[2]= Data_Out.highbyte										
USBBufferTX[3]= Data_Out.lowbyte									
USBBufferCount = 4 										' TX buffer size
USBService 
USBOut 3, USBBufferTX, USBBufferCount, USB_RX 			' Transmit data		

	' Receive USB Data 
USB_RX: 
USBBufferCount = 3 										' RX buffer size
USBService 											
USBIn 3, USBBufferRX, USBBufferCount, ExitUSB_RX 		' Receive data if available,then exit
ExitUSB_RX:
return


