' -----[ Title ]-----------------------------------------------------------
'
' File...... 18F2525.bas
' Purpose... Read data from supersentence and display and send waypoint
' MPU ...... Pic 18F2525
' Author.... Tom Gonser
' Updated .. March 19 - moved to 16F876A in prep for 18F part.
' Updated .. March 23 - moved to 18F255
' Updated .. April 10 - added DS275
' 		  		added some variables for other 2 chips
'             	fixed the %age updating tho I still can't really track it
'             	fixed to 38,400 
'             	added external 20mhz osc and changed flag
' 				April 24th - added 4 chips, memory full flag
'				May 23 - fixed TracID
'					added timezone storage - hardwired
' BUGS:
'     			have not gotten altitude working right yet - data not correct
'          		RSSI values are still messed up - radio is responding wrong
'				LCD routine does not work - can't get LCD parameter changes to work - buttons don't do anything
'Program operation:
' 1. wakes up and sets memory locations for storing persistent variables on chip 1 between 0 and 128 which are never used for data storage
' main loop
' 2. listens for valid data from the data link
' 3. if it finds it continue through program, if not report that nothing is found
' 4. main program loop executes with some checked conditions beforehand so they can be used without the data signal blocking them
' 5. compute values from data collected
' 5. conditionally record data or output waypoint data on the serial port
' 6. depending on menu selected, display some data
' 7. if interrupted, show me the menu system
'

' -----[ Fuses ]------------------------------------------------
@ __CONFIG    _CONFIG1H, _OSC_HS_1H
@ __CONFIG    _CONFIG2H, _WDT_ON_2H & _WDTPS_128_2H
@ __CONFIG    _CONFIG3H, _PBADEN_OFF_3H & _MCLRE_OFF_3H 
@ __CONFIG    _CONFIG4L, _LVP_OFF_4L & 0bfh ;_XINST_OFF_4L
' 
' -----[ Includes/Defines ]---------------------------------------------------------
include "modedefs.bas"	'include serout defines
'Define loader_used 1		Used for bootloader only

DEFINE OSC 20
DEFINE LCD_DREG PORTA  		' Set data pin of LCD to
DEFINE LCD_DBIT 0      		' PORTA.0-PORTA.3
DEFINE LCD_RSREG PORTA 		' Set RS bit of LCD to
DEFINE LCD_RSBIT 4     		' PORTA.5
DEFINE LCD_EREG PORTA  		' Set E bit of LCD to
DEFINE LCD_EBIT 5      		' PORTA.4
DEFINE LCD_LINES 4     		' 4 Lines LCD
DEFINE LCD_COMMANDUS 2000 	'Define delay time between sending LCD commands 
DEFINE LCD_DATAUS 50 		'Define delay time between data sent. 

' --------------------------------------------------------------------------------

ADCON0 = 	%00110000	' turn off - select port AN12 (nothing)
ADCON1 = 	%00001111	' turn portA to digital I/O (same as dec 15)

CMCON = 	$07			' turn off
HLVDCON = 	%00000000	' turn off
CVRCON = 	$00000000	' turn off

SSPCON1 = 	%11011100 	' supposed to be turning on I2C
SSPCON2 = 	%01111000	' supposed to be turning on I2C

INTCON = 	%11110000	' TG guess at 2525 interrups for all INT pins
INTCON2= 	%01110100  	' rising edge of INT0,1,2 RB0,1,2
RCON = 		%10000000	' no priority interrups

T1CON = 	%11000000   'Timer1 1:1 prescale. 
T0CON =		1


' Ports -------------------------------------------------------------------

MMenu           var PORTB.0				' what we watch for interrupt
SMenu			var PortB.1				' selector button
CMDPin			var PortB.2				' command on Maxstream radio
Rled			var PortB.3				' recording LCD
HP				var byte
BD				var byte
rChannel		var byte
rbaud			var byte
pgmradio		var byte
Cpinout 		var PortB.4				' reversed for maxstream direct connection - out to radio Pin 4
Cpinin 			var PortB.5				' reversed for maxstream direct connection - in from radio pin 3

CPIN			var PortC.3				' I2C clock
DPIN			var PortC.4				' I2C data
APo 			var PortC.6				' out to GPS/PC via DS275
APi				var PortC.7 			' in from GPS/PC via DS275

Set_item		var	word				' used in settings menu
passthru		var byte				' flag - allows data to pass thru to PC
Set_Wpt			var byte				' flag allows waypoint data to be sent	
wptBD			var word				' baudrate of waypoint	- ie 16572, etc.		'
D_baud			var word				' baudrate of download speed for PC
tempb			var byte
tempc			var byte

'------------------------------EEPROM ------------------------------------

address			var word				' current memory address
cs				var	byte				' chip being used now
Chp				var byte				' cs counter
HCP				var	byte				' highest chip used
mfull			var	byte				' flag for running past all memory
Data_num		var word				' used in # of data points
Chip1			con %10100000			' address of chip1
Chip2   		con %10100010			' address of chip2
Chip3			con %10100110			' address of chip3
Chip4			con %10100100			' address of chip4
PC96			con	84					' baud rate for PC - 9600 WITH DS275

'--------------------------------------------------------------------------

memperc			var word				' percent of memory used
SSMAX       	var byte [36] 			' the big matrix
SSMAX1			var byte [128]			' the BIG one used to collect SSMAX into 108 byte page
Wpt_Array		var byte [37]			' used for creating checksum for waypoint
SSOUT			var byte [128]			' data to store
alt1			var byte				' gpsalt
alt2			var byte
alt3			var byte
gpsalt			var	word
TracID_D		var word				' decimal tracID
TC1				var byte
TC2				var byte
TC3				var byte
t2				var word
TracID1			var byte				' first char
TracID2			var byte				' second char
TracID3			var byte				' third char
Dec_temp	 	var word				' temperature
Dec_tempf	 	var word				' temperature
Dec_mb			var word				' millibars
Dec_lat1		var word				' first part of lat
Dec_lat2		var word				' second part of lat
Dec_long1		var word				' first part of long
Dec_long2		var word				' second part of long
Dec_timeSS		var byte				' time ss
Dec_timeSS1		var byte				'
Dec_timeMM		var byte				' time mm
Dec_timeMM1		var byte
Dec_timeHH		var byte				' time hh
Dec_timeHH1		var byte
Dec_timeHour	var	word
timezone		var	byte
Dec_volt		var word				' volts
Dec_speed		var word				' speed (mph)
TracID			var word				' tracid - used in waypoint 16bits
Cksum			var byte				' aggregator
SSD4        	var byte				' used to convert to decimal
SSD3        	var byte				' used to convert to decimal
SSD2        	var byte				' used to convert to decimal
SSD1        	var byte				' used to convert to decimal
maxalt			var byte
maxtemp			var byte
maxmb			var byte
RSSI			var word
flagbit			var	byte				' [2] contains elements of status ****************************
E_True			var flagbit.0			' see below
S_True			var flagbit.1			' see below
Panic			var flagbit.7			' see below
E_Byte			var byte				' container for the letter
S_Byte			var byte				' container for the letter
										' System Status/Information Flags
										' Bit 7 (most significant) indicates the PANIC input 
										' Bit 6  State of MPU RB7
										' Bit 5  State of MPU RB6 
										' Bit 4  State of MPU RA5
										' Bit 3, if set, indicates GPS Altitude is negative
										' Bit 2, if set, indicates Vertical Speed is negative
										' Bit 1, if set, indicates South Latitude
										' Bit 0, if set, indicates East Longitude
Num_sat			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D
Fix_mod			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D


' ------------------- for interrupt handling ---------------------------
Bmenu    			VAR Byte
Selectit			var byte
Mnu					var byte


' loop variables
p			var word			
x			var word	
wp			var byte			
Timer 		var byte    ' Holds timer ticks. 1 tick = 65,536*Tosc*prescale
stflag		var	byte
rsloop		var byte
ploop		var byte
writeflag	var byte

' --------------------for LCD 2-line serial display------------------------	

Symbol L1 = $80
Symbol L2 = $C0
Symbol L3 = $94
Symbol L4 = $D4
Symbol RB = 28

' ------------ memory eeprom storage locations --------------------------------------
ADR_loc 		var		word		' location to store the address
CHP_loc			var		word		' will only be 1, 2, 3, 4
HCHP_loc		var		word		' will be 1-2-3-4
D_baud_loc		var		word		' download baud rate
pass_loc		var		word		' the flag for passthru - 1 or 0
wpt_loc			var		word		' the flag for waypoints - 1 or 0 - suspect we don't need this
W_baud_loc		var		word		' waypoint baud rate
mfull_loc		var		word		' where memory loop is stored 0=no, 1=yes
timezone_loc	var		word		' where timezone is stored

CLEAR

' -----[ Initialization ]--------------------------------------------------
'
Init:
PORTA = %00000000		'Initialize PortA to all zeros - all output
TRISA = %00000000		'All port A output 
PORTB = %00010011		'Initialize PortB - port 5 for data, port 0 for button interrupt
TRISB = %00010011		'Port 2 inputs are 0 and 5
PORTC = %00010000		' 
TRISC = %01010000		' SCL I2C clock out, port 7 is in from GPS/PC

' -----[ Main Code ]-------------------------------------------------------
	LCDOut $fe, 1
	LCDout $fe, 2
	LCDOut $fe, L1, " Mobile Tracker V1.4"
	LCDOut $fe, L2, " GPSFlight (C) 2005"
	LCDOut $fe, L3, " Use menu to select"
	LCDOut $fe, L4, "     then enter"
	pause 1000

	wp= 0		' cycle for when to send the waypoint sentence
	Timer = 0            ' Clear on start 
	stflag = 0
'	Low PortA.7 	not sure what this was..
	bmenu = 1
	rsloop = 0
	ploop = 0
		
	ADR_loc	= 100				' next usable address
	CHP_loc	= 104				' the chip we are on
	HCHP_loc = 106				' highest chip used
	timezone_loc = 110			' timezone (byte)	
	D_baud_loc = 108			' the download baud value
	pass_loc = 112				' the flag for passthru
	wpt_loc	= 116				' the flag for waypoints - suspect we don't need this
	w_baud_loc = 120			' waypoint baud rate
	mfull_loc = 124				' memory full flag	
	

    I2Cread DPIN, CPIN, Chip1, ADR_loc, [address] 		' get data
    I2Cread DPIN, CPIN, Chip1, CHP_loc, [cs] 			' get data
    I2Cread DPIN, CPIN, Chip1, HCHP_loc, [HCP] 			' get data 
    I2Cread DPIN, CPIN, Chip1, Timezone_loc, [HCP] 		' get data       
    I2Cread DPIN, CPIN, Chip1, D_baud_loc,[D_baud] 		' get data   
    I2Cread DPIN, CPIN, Chip1, Pass_loc,[passthru] 		' get data
	I2Cread DPIN, CPIN, Chip1, wpt_loc,[set_wpt] 		' get data - suspect we don't need this
    I2Cread DPIN, CPIN, Chip1, W_baud_loc, [wptbd] 		' get data
    I2Cread DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' get data
    
    if CS > 4 then gosub dis10
    
' ----- starting here ---------------------------------------------------	          
On Interrupt Goto INT_handle	' unsure if this is working the way I want - this is the ONLY way my buttons work

Smenu = 0

ReStart:
    TMR1H = 0 	 ' Clear time counts before Timer1 re-start
    TMR1L = 0    ' Clear time counts before Timer1 re-start
    PIR1.0 = 0   ' CLear over-flow flag before enable
    T1CON.0 = 1  ' Turn Timer1 back on before entry into MainProcedure

Main:' ****** [Main Program Loop] ****************************************************************

 if bmenu = 5 then 
 	gosub Dis5 
 endif
 
 if bmenu = 6 then 
 	gosub dis6 
 endif
 
  if bmenu = 11 then 
 	gosub settings
 endif

wp=wp+1
	gosub getdata				' go get data from radio
		if stflag = 1 then
			gosub storedata		' store ss data to EEROM if flag is on 
		endif
		gosub calcvalue			' calculate values
		if wp > 15 then
			gosub waypoint		' ALWAYS put out a waypoint signal on the line  (4800b)
		endif
		
	Select Case Bmenu 			' display and act accordingly - driven from interrupts
     case 0
			gosub dis0			' display information
     case 1
			gosub dis1			' display information
     Case 2
			gosub dis2			' display lat/long
	 Case 3
			gosub dis3			' Display Alt
	 Case 4
			gosub dis4			' RSSI - radio strength
	 Case 5
			gosub dis5			' output memory - 9600b - same line as GPS is on
	 Case 6
			gosub dis6			' erase memory, reset address to 0
	 Case 7
			gosub dis7			' Start Recorder - set stflag to 1
	 Case 8
			gosub dis8			' Stop Recorder
	 Case 9
			gosub dis9			' Display Recording
	 Case 10
			gosub dis10			' Reset System
	 Case 11
			gosub settings		' 9600b setup for programming
	 Case 12
	 		gosub LCDsetting	' LCD programming
	 Case 13
	 		Bmenu = 0
     End Select
     
' --------- Interrupt Handler ------------------------------------------------------------
	   IF PIR1.0 THEN       ' IF Timer1 has over-flowed then
        Timer = Timer + 1 	' Increment Timer variable
        PIR1.0 = 0        	' Clear over-flow/int flag
        ' @20MHz 200nS * 65,536 * 8 = 0.1048576 seconds per over-flow
        ' 0.1048576 * 48 = ~5.033 seconds before jump to NextStage
        IF Timer >= 20 and Mnu = 1 THEN NextStage
     ENDIF
goto Main

'*************************************************************************************************
getdata:
		Serin2 Cpinin,84,1000,nodata,[wait($02,$47), STR SSMAX\34]
		if passthru = 1 then serout2 APo, PC96, [$02,$47,STR SSMAX\34]   ' if passthru is set
return
'************************* [No Data from airlink] *****************
nodata:
	LCDOut $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1,$10,$10
	
	for X = 1 to 16
		LCDout "."
	Pause 30
	Next X

	LCDout $fe, L2, "     Searching"
	LCDout $fe, L3, "  No TracIDs Found"
	LCDout $fe, L4, " Check Tranmsitters"
	pause 50
goto main

'--------------------------- store data in eeprom ----------------------------------------------
storedata:
' Store the large sentence of 108 bytes by building it from the last 3
Select Case ploop:
	Case 0
		SSMAX1[0] = $02
		SSMAX1[1] = $47
		for p = 0 to 33
 			SSMAX1[p+2]=SSMAX[p]
 		next p
		writeflag=0
	Case 1
		SSMAX1[36] = $02
		SSMAX1[37] = $47
 		for p = 0 to 33
 			SSMAX1[p+38]=SSMAX[p]
 		next p
 		writeflag = 0
 	Case 2
 		SSMAX1[72] = $02
		SSMAX1[73] = $47
 		for p = 0 to 33
 			SSMAX1[p+74]=SSMAX[p]
 		next p
 		writeflag = 1
 		' we now have an array with 108 bytes
end select
ploop = ploop+1

' Check to see if we have a lock.  If not skip this step

if writeflag = 1 then
	High Rled						' turns on the indicator LED (Howard wants to make this LOW?
	If Address > 63872 then			' only do this stuff if we go over 
		Address = 128				' reset the address
		Select case cs				' change chips
			Case 1
				Chp=2
				HCP=2
			case 2
				Chp=3
				HCP=3
			case 3
				Chp=4
				HCP=4
			case 4
				Chp=1
				HCP=4
				mfull=1
				I2Cwrite DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' store loop flag
				pause 10
				STflag = 0											' stop recording
				bmenu=8
			case else												' never get here
				chp=1
				HCP=4
				mfull=1
				I2Cwrite DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' store loop flag
				pause 10
				STflag = 0											' stop recording
				bmenu=8
				
		end select
		cs=chp				' assign the value to cs
	endif
	

	select case cs	
		case 1
			I2cwrite DPIN, CPIN, Chip1, address,[STR SSMAX1\108],failw
		case 2
			I2cwrite DPIN, CPIN, Chip2, address,[STR SSMAX1\108],failw
		case 3
			I2cwrite DPIN, CPIN, Chip3, address,[STR SSMAX1\108],failw
		case 4
			I2cwrite DPIN, CPIN, Chip4, address,[STR SSMAX1\108],failw
	end select
	pause 10
	address = address + 128	' either way, increment 128 bytes
	
	low rled
	writeflag = 0
	ploop=0
endif

' go to here if no lock.

return

failr:
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " RFail: ",#address
	pause 1000
return

failw:
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " WFail: ",#address
	pause 1000
return

'------------------------------------------------------------------------------------------------

dis0:
'Cycle throgh main events
	wp=wp+1
		gosub getdata			' go get data from radio
		if stflag = 1 then
			gosub storedata		' store ss data to EEROM if flag is on 
		endif
		gosub calcvalue			' calculate values
		if wp > 15 then
			gosub waypoint		' ALWAYS put out a waypoint signal on the line  (4800b)
		endif
		
		for x = 1 to 50
			Gosub dis1
			pause 20
		next x
		
		for x = 1 to 50
			Gosub dis2
			pause 20
		next x
Return

dis1:
' First pass - Sensor and Sat Info
' write to LCD serial screen
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "1-Sensor Data:",TracID1,TracID2,TracID3
	LCDout $FE, L2, "Pressure(MB):",#Dec_mb dig 4,#Dec_mb dig 3, #Dec_mb dig 2,#Dec_mb dig 1, ".",dec1 Dec_mb
	LCDout $fe, L3, "   Temp(F):",#Dec_tempf dig 3, #Dec_tempf dig 2,#Dec_tempf dig 1, ".",dec1 Dec_Tempf
	LCDout $fe, L4, $10, $10
		Select Case Fix_mod
		Case 1
			LCDout "No Lock, Sats:",#Num_sat
		Case 2
			LCDout "2D Lock, Sats:",#Num_sat
		Case 3
			LCDout "3D Lock, Sats:",#Num_sat
		Case Else
			LCDout "Error, Sats:",#Num_sat
	end select
	Pause 20
Return
	
dis2:
' second pass - Sensor and Sat Info
' write to LCD serial screen
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "2-Position:",TracID1,TracID2,TracID3
	LCDout $fe, L2, $10, $10, S_Byte," Lat:",#Dec_lat1,".",#Dec_lat2
	LCDout $fe, L3, $10, $10, E_Byte," Lon:",#Dec_long1,".",#Dec_long2
	LCDout $fe, L4, " Speed:",#Dec_speed dig 3, #Dec_speed dig 2,#Dec_speed dig 1, ".",dec1 Dec_speed
	LCDout "  V:",#Dec_volt dig 1, ".",dec1 Dec_volt
	pause 20
Return

dis3:
' third pass - GPSAlt
' write to LCD serial screen
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "3-Altitude: ",TracID1,TracID2,TracID3
	LCDout $fe, L2, "   GPS Alt: ",#gpsalt dig 4,#gpsalt dig 3,#gpsalt dig 2,#gpsalt dig 1,".",dec1 gpsalt
	LCDout $fe, L3, "   GPS Alt2: ",#alt1,#alt2,#alt3 dig 2,".",#alt3 dig 1
	LCDout $fe, L4,	"Time: ",#Dec_timeHour,":",#Dec_timeMM,#Dec_timeMM1,":",#Dec_timeSS,#Dec_timeSS1
	pause 20
Return

dis4: ' --------------------------- Get RSSI from Radio

' Set radio to binary
'	RSSI=0
'	RSSIB=0
'	Serout2 Cpinout,84,["+++"]
'	Serin2  Cpinin,84,1000,noradio,[Wait ("K")]
'	Serout2 Cpinout,84,["ATRS",10,13]
'	Serin2  Cpinin,84,1000,noradio,[HEX RSSI]
'	serout2 cpinout,84,["ATCN",10,13]
'	serout2 cpinout,84,["ATCN",10,13]
'	rsloop = rsloop+1
'	pause 1000

	high CMDpin
	pause 100
	Serout2 cpinout,84,["9C"]
	low CMDpin	
	Serin2 cpinin,84,1000,noradio,[RSSI]
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "[M4] Signal strength"
	LCDout $fe, L3," RSSB: ",#RSSI
	pause 200

Return

noradio:
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, "No RSSI Seen: ",#RSSI
	pause 100
	Bmenu=4
return



'------------------------------------------------------------------------------------------------------------------

dis5:	' -------------------------- Dump stored data to PC --- go from address ZERO all the way
	I2Cread DPIN, CPIN, Chip1, ADR_loc, [address]				' get the address from our secret location
	I2Cread DPIN, CPIN, Chip1, CHP_loc, [cs]					' get the cs
	I2Cread DPIN, CPIN, Chip1, HCHP_loc, [HCP]					' get the highest one
    I2Cread DPIN, CPIN, Chip1, D_baud_loc, [D_baud] 			' store address pointer
   	I2Cread DPIN, CPIN, Chip1, mfull_loc, [mfull]				' get the highest one
    
    ' now we know the highest chip and the current address
    
If mfull=1 then
	HCP = 4
endif

select case HCP
	case 0 	
		LCDout $fe, 1
		LCDout $fe, 2
		LCDout $fe, L1, " Nothing to download"
 		pause 2000
 		bmenu = 1
		return		' nothing
		
	case 1
		memperc = (address/256)	 
		data_num = ((address/128)*3)
		
	case 2
		memperc = (address/256)	  	
		memperc = memperc + 250
		data_num = ((address/128)*3) + 1500
		
	case 3
		memperc = (address/256)	  	
		memperc = memperc + 500
		data_num = ((address/128)*3) + 3000
		
	case 4
		memperc = (address/256)	  	
		memperc = memperc + 750
		data_num = ((address/128)*3) + 4500
		
	case else						'never use it, but just in case
		LCDout $fe, 1
		LCDout $fe, 2
		LCDout $fe, L1, "ERROR"
		Pause 2000
		bmenu = 1
end select
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "[M5] Download"
	Select Case D_baud
   		 Case 84
   		 	LCDout " 9600b"
   		 Case 6
   		 	LCDout " 38,400b"
   	end select
   	
   	
	LCDout $fe, L2, "Records: "
		If data_num>999 then LCDOut #data_num DIG 4,","
		If data_num>99 then LCDOut #data_num DIG 3
		If data_num>9 then LCDOut #data_num DIG 2
		LCDOut #data_num DIG 1
	
	pause 2000
	Lcdout $fe, L3, " Connect to PC!"
	for x = 10 to 1 step -1
		LCDout $fe, L4, "  Starts in: ",#x
		pause 1000
		LCDout $fe, L4, "  Starts in: ","  "
	next x
	stflag = 0 				' turn off recording
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, "Download to PC"
	LCDout $fe, L2, " Sending ..."
	
' starting with chip 1 address 128
	For address = 128 to 63872 step 128 ' ------------------------  Chip 1 (skip first page for our eeprom data)
		i2cread DPIN, CPIN, Chip1, address,[STR SSOUT\108],failr
		serout2 APo, D_baud, [STR SSOUT\108]		
		memperc = address/256
		LCDout $fe, L3, " Progress: "
			If memperc>999 then LCDOut #memperc DIG 3
			If memperc>99 then LCDOut #memperc DIG 2
			LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
			'LCDout $fe, L4,"     Chp: 1"			' hardwired
	Next address

' next chip i HCP is more than 1
	if HCP >= 2 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 2
			i2cread DPIN, CPIN, Chip2, address,[STR SSOUT\108],failr
			serout2 APo, D_baud, [STR SSOUT\108]					' write to PC 
				memperc = address/256 + 250
			LCDout $fe, L3, " Progress: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"		
			'LCDout $fe, L4,"     Chp: 2"			' hardwired
		Next address
	endif
	
	if HCP >= 3 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 3
			i2cread DPIN, CPIN, Chip3, address,[STR SSOUT\108],failr
			serout2 APo, D_baud, [STR SSOUT\108]					' write to PC 
				memperc = address/256 + 500
			LCDout $fe, L3, " Progress: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"		
			'LCDout $fe, L4,"     Chp: 3"			' hardwired
		Next address
	endif	
	
	if HCP = 4 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 4
			i2cread DPIN, CPIN, Chip4, address,[STR SSOUT\108],failr
			serout2 APo, D_baud, [STR SSOUT\108]					' write to PC 
				memperc = address/256 + 750
			LCDout $fe, L3, " Progress: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"		
			'LCDout $fe, L4,"     Chp: 4"			' hardwired
		Next address
	endif	
	
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, "  Data Transfer"
	LCDout $fe, L3, "    Complete"
	Pause 100		' a really long time so we don't do it again
 	Bmenu=1

Return

dis6: ' --------------------------- Erase Memory Banks --- go from address ZERO all the way
    stflag = 0
    I2Cread DPIN, CPIN, Chip1, ADR_loc, [address]		' get the address from our secret location
	I2Cread DPIN, CPIN, Chip1, CHP_loc, [cs]			' get the cs
	I2Cread DPIN, CPIN, Chip1, HCHP_loc, [HCP]			' get the highest one
	I2Cread DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' get data
	
	if mfull = 1 then
		HCP = 4
	endif

select case HCP
	case 1
		memperc = (address/256)	 
		data_num = ((address/128)*3)
		
	case 2
		memperc = (address/256)	  	
		memperc = memperc + 250
		data_num = ((address/128)*3)+1500
		
	case 3
		memperc = (address/256)	  	
		memperc = memperc + 500
		data_num = ((address/128)*3)+3000
		
	case 4
		memperc = (address/256)	  	
		memperc = memperc + 750
		data_num = ((address/128)*3)+4500
		
	case else
		cs = 4					' erase all - we have a problem
		memperc = (address/256)	  	
		memperc = memperc + 750
		data_num = ((address/128)*3)+4500
		
end select
	for x = 0 to 127
		SSMAX1[x] = "0"
	next x
	
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "[M6] Erase Memory"
	LCDout $fe, L2, "  Memory: "
		If memperc>999 then LCDOut #memperc DIG 3
		If memperc>99 then LCDOut #memperc DIG 2
		LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
'	LCDout $fe, L3, "     Chips used: ",#HCP
	for x = 10 to 1 step -1
		LCDout $fe, L4, "   Starts in: ",#x
		pause 1000
		LCDout $fe, L4, "   Starts in: ","  "
	next x
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " Erasing Memory... "
	
	if HCP = 0 then
		LCDout $fe, L2, " Nothing to Erase"
		Pause 1000		' a really long time so we don't do it again
  	 	Bmenu = 1
 	   	Address = 128
 	   	cs = 1
 	   	I2Cwrite DPIN, CPIN, Chip1, ADR_loc, [address.byte0] ' store address pointer
		pause 10
		I2Cwrite DPIN, CPIN, Chip1, ADR_loc+1, [address.byte1] ' store address pointer
		pause 10
		I2Cwrite DPIN, CPIN, Chip1, CHP_loc, [cs] ' store cs pointer
		pause 10
		goto main
	endif
	
	If HCP >= 1 then
		For address = 128 to 63872 step 128 ' ------------------------  Chip 1
			i2cwrite DPIN, CPIN, Chip1, address,[Str SSMAX1\127],failw
			memperc = address/256
			LCDout $fe, L3, " Erase: "
			If memperc>999 then LCDOut #memperc DIG 3
			If memperc>99 then LCDOut #memperc DIG 2
			LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
			'LCDout " Chp 1" 
			pause 10
		Next address
	endif
	
	if HCP >= 2 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 2
			i2cwrite DPIN, CPIN, Chip2, address,[Str SSMAX1\127],failw
			memperc = address/256 + 250
			LCDout $fe, L3, " Erase: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
			'LCDout " Chp 2"	
			pause 10
		Next address
	endif
	
	if HCP >= 3 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 2
			i2cwrite DPIN, CPIN, Chip3, address,[Str SSMAX1\127],failw
			memperc = address/256 + 500
			LCDout $fe, L3, " Erase: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
		'	LCDout " Chp 3"
			pause 10
		Next address
	endif
	
	if HCP = 4 then
		For address = 0 to 63872 step 128 ' ------------------------  Chip 2
			i2cwrite DPIN, CPIN, Chip4, address,[Str SSMAX1\127],failw
			memperc = address/256 + 750
			LCDout $fe, L3, " Erase: "
				If memperc>999 then LCDOut #memperc DIG 3
				If memperc>99 then LCDOut #memperc DIG 2
				LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
			'LCDout " Chp 4"
			pause 10
		Next address
	endif	
	
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " Done. Press Menu"
	Pause 1000		' a really long time so we don't do it again
    Bmenu = 1
    Address = 128
    cs = 1
    HCP = 0
    mfull=0
    I2Cwrite DPIN, CPIN, Chip1, ADR_loc, [address.byte0] ' store address pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, ADR_loc+1, [address.byte1] ' store address pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, CHP_loc, [cs] ' store cs pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, HCHP_loc, [HCP] ' store cs pointer
	pause 10
	I2cwrite DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' reset looping counter
	pause 10
Return

dis7: ' --------------------------- Start Recorder
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " Starting Recorder"	
	pause 2000
	if HCP = 0 then
		HCP = 1
		I2CWrite DPIN, CPIN, Chip1, HCHP_loc, [HCP]					' Write
		pause 10
	endif
	
	stflag = 1
	I2Cread DPIN, CPIN, Chip1, ADR_loc, [address]				' get the address from our secret location
	I2Cread DPIN, CPIN, Chip1, CHP_loc, [cs]			' get the cs
	I2Cread DPIN, CPIN, Chip1, HCHP_loc, [HCP]					' get the cs
	bmenu=8
Return

dis8: ' ---------------------------- Display Recording session 
' already got the data from memory when we started so no need to look it up again.

select case cs
	case 1
		memperc = (address/256)	  

	case 2
		memperc = (address/256) + 250 	

	case 3
		memperc = (address/256) + 500	 
	
	case 4
		memperc = (address/256) + 750  

end select
	
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "[M8] Recording"
	LCDout $fe, L2, $10,$10
		Select Case Fix_mod
		Case 1
			LCDout "No Lock, Sats:",#Num_sat
		Case 2
			LCDout "2D Lock, Sats:",#Num_sat
		Case 3
			LCDout "3D Lock, Sats:",#Num_sat
		Case Else
			LCDout "Error, Sats:",#Num_sat
	end select
	LCDout $fe, L3, " Speed:",#Dec_speed dig 3, #Dec_speed dig 2,#Dec_speed dig 1, ".",dec1 Dec_speed
	LCDout "  V:",#Dec_volt dig 1, ".",dec1 Dec_volt
	LCDout $fe, L4, "Memory: "
		If memperc>999 then LCDOut #memperc DIG 3
		If memperc>99 then LCDOut #memperc DIG 2
		LCDOut #memperc DIG 1,".",#memperc DIG 0,"%"
	LCDout " Chp:",#cs
Return

dis9: ' --------------------------- Stop Recorder
	if mfull = 1 then
		HCP = 4
	endif
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " Stopping Recorder.."
	pause 1000
    I2Cwrite DPIN, CPIN, Chip1, ADR_loc, [address] 		' store address pointer
    pause 10
	I2Cwrite DPIN, CPIN, Chip1, CHP_loc, [cs] 	' store cs pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, HCHP_loc, [HCP] 		' store high chip pointer	
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' store loop	
	pause 10
	stflag = 0
	Bmenu=8
Return

dis10: ' --------------------------- Sysetm Reset to defaults
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "[10] System Reset  "
	LCDout $fe, L2, "This will erase all"
	LCDout $fe, L3, "memory!(off to stop)"	
	pause 5000
	address = 128
	cs = 1
	HCP = 0
	mfull = 0
	Set_wpt = 1
	passthru = 0
	D_baud = 84
	wptbd = 188
	timezone = 7
	LCDout $fe, L4, "Setting Defaults.."
    I2Cwrite DPIN, CPIN, Chip1, ADR_loc, [address] ' store address pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, CHP_loc, [cs] ' store cs pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, HCHP_loc, [HCP] ' store cs pointer
	pause 10
	I2Cwrite DPIN, CPIN, Chip1, Timezone_loc, [Timezone] ' store cs pointer
	pause 10	
	I2Cwrite DPIN, CPIN, Chip1, wpt_loc, [set_wpt] ' waypoint flag storage
   	pause 10
    I2Cwrite DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage
    pause 10
    I2Cwrite DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer
   	pause 10
   	I2Cwrite DPIN, CPIN, Chip1, W_baud_loc, [wptbd] ' store address pointer
   	pause 10
  	I2cwrite DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' reset looping counter
	pause 10
    LCDout $fe, 1
	LCDout $fe, 2
    LCDout $fe, L1, "Reset Complete"
    LCDout $fe, L2
    LCDout "Wpt:",#set_wpt,"Pass:",#passthru
    LCDout $fe, L3
    LCDout "Dbd:",#d_baud,"Wptbd:",#wptbd
    pause 5000
	stflag = 0
	Bmenu=1
Return
'************************* [Send Waypoint to GPS] *****************
waypoint:
' create checksum '**************                                          Checksum

if set_wpt = 1 then
    WPT_array[0]="$"
	WPT_array[1]="G"
	WPT_array[2]="P"
	WPT_array[3]="W"
	WPT_array[4]="P"
	WPT_array[5]="L"
	WPT_array[6]=","	
	WPT_array[7]=Dec_lat1 DIG 3+"0"
	WPT_array[8]=Dec_lat1 DIG 2+"0"
	WPT_array[9]=Dec_lat1 DIG 1+"0"
	WPT_array[10]=Dec_lat1 DIG 0+"0"
	WPT_array[11]="."
	WPT_array[12]=Dec_lat2 DIG 3+"0"
	WPT_array[13]=Dec_lat2 DIG 2+"0"
	WPT_array[14]=Dec_lat2 DIG 1+"0"
	WPT_array[15]=Dec_lat2 DIG 0+"0"
	WPT_array[16]=","
	WPT_array[17]=S_byte
	WPT_array[18]=","
	WPT_array[19]=Dec_long1 Dig 4+"0"
	WPT_array[20]=Dec_long1 Dig 3+"0"
	WPT_array[21]=Dec_long1 Dig 2+"0"
	WPT_array[22]=Dec_long1 Dig 1+"0"
	WPT_array[23]=Dec_long1 Dig 0+"0"
	WPT_array[24]="."
	WPT_array[25]=Dec_long2 Dig 3+"0"
	WPT_array[26]=Dec_long2 Dig 2+"0"
	WPT_array[27]=Dec_long2 Dig 1+"0"
	WPT_array[28]=Dec_long2 Dig 0+"0"
	WPT_array[29]=","	
	WPT_array[30]=E_byte
	WPT_array[31]=","
	WPT_array[32]=TracID1
	WPT_array[33]=TracID2
	WPT_array[34]=TracID3
	WPT_array[35]=","
	WPT_array[36]="*"	
	cksum=0
	for p = 1 to 35
		cksum = cksum^(WPT_array[p])
	Next P
	Serout2 APo, wptbd, [Str WPT_array\37, HEX Cksum,13,10]
endif
	wp=%0		
Return

'***********************[Calculate values from SS]**************************
calcvalue:

' Calculate the variables from the array

' read data for temperature                                          Temp
	SSD4= (ssmax[24]>>4)
	SSD3= (ssmax[24] & $f) 
	SSD2= (ssmax[23]>>4)
	SSD1= (ssmax[23] & $f) 

	Dec_temp=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

	Dec_tempf=Dec_temp + Dec_temp**52429 + 320			'conv to F
	
' read data for MB Pressure 	                                    Pressure
	SSD4= (ssmax[22]>>4)
	SSD3= (ssmax[22] & $f) 
	SSD2= (ssmax[21]>>4)
	SSD1= (ssmax[21] & $f) 

	Dec_mb=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' read data for long **************

' read data for Long1 - left of decimal
	SSD4= (ssmax[7]>>4)
	SSD3= (ssmax[7] & $f) 
	SSD2= (ssmax[6]>>4)
	SSD1= (ssmax[6] & $f) 

	Dec_long1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data for Long2 - right of decimal
	SSD4= (ssmax[9]>>4)
	SSD3= (ssmax[9] & $f) 
	SSD2= (ssmax[8]>>4)
	SSD1= (ssmax[8] & $f) 

	Dec_long2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data for lat ************

' read data for Lat1 - left of decimal
	SSD4= (ssmax[11]>>4)
	SSD3= (ssmax[11] & $f) 
	SSD2= (ssmax[10]>>4)
	SSD1= (ssmax[10] & $f) 

	Dec_lat1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' read data for Lat2 - right of decimal                                  
	SSD4= (ssmax[13]>>4)
	SSD3= (ssmax[13] & $f) 
	SSD2= (ssmax[12]>>4)
	SSD1= (ssmax[12] & $f) 

	Dec_lat2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' North/South East/West ******                                          North/S/E/W
	flagbit= (ssmax[2])

	Select Case E_True
		Case %1
			E_Byte= "E"
		Case Else
			E_Byte = "W"
	End Select

	Select Case S_true
		Case %1
			S_Byte= "S"
		Case Else
			S_Byte = "N"
	End Select

' read number of sats in view ****                                        Sats, Fix Mode

	Num_sat = (ssmax[14]>>4)
	Fix_mod = (ssmax[14] & $f)
	
	
' read GPS alt																Alt
	Alt1=(ssmax[32])
	Alt2=(ssmax[31])
	Alt3=(ssmax[30])
	
	gpsalt = alt1+alt2+alt3
'	gpsalt = gpsalt/10
	
		
' read TracID *********************                                        TracID
' Read the TracID into the 3 letters represented

	SSD4= (ssmax[1]>>4)
	SSD3= (ssmax[1] & $f) 
	SSD2= (ssmax[0]>>4)
	SSD1= (ssmax[0] & $f) 
	
	TracID_D=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec
	TC1=(TracID_D/1600)
	Select Case TC1
  	  case 0
		TracID1 = " "
  	  case TC1 < 27					'A-Z
		TracID1 = TC1 + 64
  	  case TC1 < 37					'0-9
		TracID1 = TC1  + 21
  	  case 37
		TracID1 = ":"
  	  case 38
		TracID1 = "."
  	 case else
		TracID1 = "$"
	End Select
	
	T2=TracID_D-(TC1*1600)
	TC2=(T2/40)
	Select Case TC2
  	  case 0
		TracID2 = " "
  	  case TC2 < 27					'A-Z
		TracID2 = TC2 + 64
  	  case TC2 < 37					'0-9
		TracID2 = TC2  + 21
  	  case 37
		TracID2 = ":"
  	  case 38
		TracID2 = "."
  	 case else
		TracID2 = "$"
	End Select	
	
	TC3=t2-(TC2*40)
	Select Case TC3
  	  case 0
		TracID3 = " "
  	  case TC3 < 27					'A-Z
		TracID3 = TC3 + 64
  	  case TC3 < 37					'0-9
		TracID3 = TC3  + 21
  	  case 37
		TracID3 = ":"
  	  case 38
		TracID3 = "."
  	 case else
		TracID3 = "$"
	End Select
	
' read data Hspeed - 16 bit *******                                         Speed
	SSD4= (ssmax[18]>>4)
	SSD3= (ssmax[18] & $f) 
	SSD2= (ssmax[17]>>4)
	SSD1= (ssmax[17] & $f) 

	Dec_speed=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data time - 3 bytes ********                                         Time

	Dec_timeSS = (ssmax[3]>>4)			' second1
	Dec_timeSS1= (ssmax[3] & $f)		' second2
	Dec_timeMM = (ssmax[4]>>4)			' MM1
	Dec_timeMM1= (ssmax[4] & $f)		' MM2
	Dec_timeHH = (ssmax[5]>>4)			' H1
	Dec_timeHH1= (ssmax[5] & $f)		' H2

	Dec_timeHour = (Dec_timeHH*10) + (Dec_TimeHH1)
	' set timezone adjustment here
	' -7 is PST DLST
	' -8 is PST STDT
	' Set this via PC and write to memory if mem space allows
	Dec_TimeHour = Dec_TimeHour-timezone
	If Dec_TimeHour >13 then
		Dec_timeHour = Dec_timeHour-12
	Endif
	
' read data volts - 8 bit

	SSD2= (ssmax[25]>>4)
	SSD1= (ssmax[25] & $f) 

	Dec_volt=(ssd2*16)+ssd1		' convert to dec
	
' **************************************************************************************
return

settings:
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L1, "You must use PC to"
	LCDout $fe, L2, "view menu and make"
	LCDout $fe, L3, "changes there."
	LCDout $fe, L4, "Use 9600b to connect"
	serout2 APo, PC96,[27,91,50,74]			' clear screen vt-100	
while Set_Item <> 99
	serout2 APo, PC96,[27,91,#1,59,#1,72]		' 50 = 2 th row, 3rd column
	serout2 APo, PC96,["Key in value:"]
	serout2 APo, PC96,[27,91,#4,59,#4,72]		
	serout2 APo, PC96,["00) Read"]
	serout2 APo, PC96,[27,91,#5,59,#4,72]		
	serout2 APo, PC96,["01) Pass On"]
	serout2 APo, PC96,[27,91,#6,59,#4,72]	
	serout2 APo, PC96,["02) Pass off"]
	serout2 APo, PC96,[27,91,#7,59,#4,72]		
	serout2 APo, PC96,["03) WP:4800"]
	serout2 APo, PC96,[27,91,#8,59,#4,72]	
	serout2 APo, PC96,["04) WP:9600"]
	serout2 APo, PC96,[27,91,#9,59,#4,72]		
	serout2 APo, PC96,["05) DL:38.4k"]
	serout2 APo, PC96,[27,91,#10,59,#4,72]		
	serout2 APo, PC96,["06) DL:9600"]
	serout2 APo, PC96,[27,91,#11,59,#4,72]		
	serout2 APo, PC96,["07) WP On"]
	serout2 APo, PC96,[27,91,#12,59,#4,72]		
	serout2 APo, PC96,["08) WP: Off"]
	serout2 APo, PC96,[27,91,#13,59,#4,72]			
	serout2 APo, PC96,["09) Radio"]	
	serout2 APo, PC96,[27,91,#14,59,#4,72]	
	serout2 APo, PC96,["10) Save"]
	serout2 APo, PC96,[27,91,#15,59,#4,72]	
	serout2 APo, PC96,["55) Reset"]
	serout2 APo, PC96,[27,91,#16,59,#4,72]		
	serout2 APo, PC96,["99) Exit"]
	Serin2 APi, PC96,[DEC2 Set_item]
	' defaults setting in case they don't choose them from the menu
	
	Select case Set_item
		Case 00
			I2Cread DPIN, CPIN, Chip1, wpt_loc, [set_wpt] ' waypoint flag storage
  	 		I2Cread DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage
  	  		I2Cread DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer
    		I2Cread DPIN, CPIN, Chip1, W_baud_loc, [wptbd] ' store address pointer
   			I2Cread DPIN, CPIN, Chip1, ADR_loc, [address] ' store address pointer
    		I2Cread DPIN, CPIN, Chip1, CHP_loc, [cs] ' store address pointer
    		I2Cread DPIN, CPIN, Chip1, HCHP_loc, [HCP] ' store address pointer  
   			I2Cread DPIN, CPIN, Chip1, mfull_loc, [mfull] 		' read full flag
	
  
    		LCDOut $fe, 1
			LCDout $fe, 2
			LCDOut $fe, L1, "D_baud: ",#D_baud
			LCDOut $fe, L2, "W_baud: ",#wptbd
			LCDOut $fe, L3, "Passthru: ",#passthru
			LCDOut $fe, L4, "Wpt Flag: ",#set_wpt
			
			serout2 APo, PC96,[27,91,#18,59,#12,72]
			Select Case D_Baud
				Case 84
					serout2 APo, PC96,["DL96"]
				Case 6
					serout2 APo, PC96,["DL38"]
				Case else
					serout2 APo, PC96,["Err"]
			end select
			
			serout2 APo, PC96,[27,91,#19,59,#12,72]
			Select Case Wptbd
				Case 188
					serout2 APo, PC96,["WP48"]
				Case 84
					serout2 APo, PC96,["WP96"]
				Case else
					serout2 APo, PC96,["Err"]
			end select			
					
			serout2 APo, PC96,[27,91,#20,59,#12,72]
			Select case passthru
				Case 0
					serout2 APo, PC96,["P-"]		
				Case 1
					serout2 APo, PC96,["P+"]
				Case else
					serout2 APo, PC96,["Err"]
			end select
			
			serout2 APo, PC96,[27,91,#21,59,#12,72]
			Select case Set_wpt
				Case 0
					serout2 APo, PC96,["WP- "]		
				Case 1
					serout2 APo, PC96,["WP+"]
				Case else
					serout2 APo, PC96,["Err"]
			end select			
			serout2 APo, PC96,[27,91,#23,59,#12,72]
			serout2 APo, PC96,["LM: ",#address]
			serout2 APo, PC96,[27,91,#24,59,#12,72]
			serout2 APo, PC96,["CC:",#cs," CH: ",#HCP," Mem: ",#mfull]
			
		Case 01
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "PT+"
			serout2 APo, PC96,[27,91,#5,59,#35,72]		
			serout2 APo, PC96,["X"]
			serout2 APo, PC96,[27,91,#6,59,#35,72]		
			serout2 APo, PC96,[" "]
			serout2 APo, PC96,[27,91,#11,59,#35,72]		
			serout2 APo, PC96,[" "]
			serout2 APo, PC96,[27,91,#12,59,#35,72]		
			serout2 APo, PC96,["X"]			
			passthru = 1
			set_wpt=0
		Case 02
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "PT-"
			serout2 APo, PC96,[27,91,#6,59,#35,72]		
			serout2 APo, PC96,["X"]
			serout2 APo, PC96,[27,91,#5,59,#35,72]		
			serout2 APo, PC96,[" "]
			passthru = 0
		Case 03
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "WP48"
			serout2 APo, PC96,[27,91,#7,59,#35,72]		
			serout2 APo, PC96,["X"]
			serout2 APo, PC96,[27,91,#8,59,#35,72]		
			serout2 APo, PC96,[" "]
			wptBD = 188
		Case 04
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "WP96"
			serout2 APo, PC96,[27,91,#7,59,#35,72]		
			serout2 APo, PC96,[" "]
			serout2 APo, PC96,[27,91,#8,59,#35,72]		
			serout2 APo, PC96,["X"]
			wptBD = 84
		Case 05
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "DL38"
			serout2 APo, PC96,[27,91,#9,59,#35,72]		
			serout2 APo, PC96,["X"]
			serout2 APo, PC96,[27,91,#10,59,#35,72]		
			serout2 APo, PC96,[" "]
			D_baud = 6
		Case 06
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "DL96"
			serout2 APo, PC96,[27,91,#9,59,#35,72]		
			serout2 APo, PC96,[" "]
			serout2 APo, PC96,[27,91,#10,59,#35,72]		
			serout2 APo, PC96,["X"]
			D_Baud = 84
		Case 07
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "WP+"
			serout2 APo, PC96,[27,91,#5,59,#35,72]		
			serout2 APo, PC96,[" "]					
			serout2 APo, PC96,[27,91,#6,59,#35,72]		
			serout2 APo, PC96,["X"]			
			serout2 APo, PC96,[27,91,#11,59,#35,72]		
			serout2 APo, PC96,["X"]					
			serout2 APo, PC96,[27,91,#12,59,#35,72]		
			serout2 APo, PC96,[" "]
			set_wpt = 1
			passthru = 0
		Case 08
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "WP-"
			serout2 APo, PC96,[27,91,#12,59,#35,72]		
			serout2 APo, PC96,["X"]
			serout2 APo, PC96,[27,91,#11,59,#35,72]		
			serout2 APo, PC96,[" "]
			set_wpt = 0
			
		case 09
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "Radio"
			serout2 APo, PC96,[27,91,50,74]					' clear screen vt-100	
			serout2 APo, PC96,[27,91,#1,59,#1,72]			' 50 = 2 th row, 3rd column
			serout2 APo, PC96,["Get Radio Info"]
				pause 3000
				Serout2 Cpinout,PC96,["+++"]
				Serin2 Cpinin,PC96,1000,noplus,[Wait ("OK")]
				pause 100
				Serout2 Cpinout,PC96,["ATHP",10,13]
				Serin2 Cpinin,PC96,1000,noplus,[tempc]
				pause 250
				serout2 cpinout,84,["ATCN",10,13]
				serout2 APo, PC96,[27,91,#3,59,#4,72]
				serout2 APo, PC96,["Network: ",tempc]
				serout2 APo, PC96,[27,91,#4,59,#4,72]
				serout2 APo, PC96,["Enter Network(0-6): "]	
				serin2 APi, PC96,[DEC1 Rchannel]	
				serout2 APo, PC96,[#Rchannel]
				serout2 APo, PC96,[27,91,#7,59,#6,72]
				serout2 APo, PC96,["[1=Set, 9=Quit]"]
				serin2 APi, PC96,[DEC1 Pgmradio]	
				select case Pgmradio
				case 1
					pause 3000
					Serout2 Cpinout,PC96,["+++"]
					Serin2  Cpinin,PC96,1000,noplus,[Wait ("OK")]
					pause 100
					Serout2 Cpinout,PC96,["ATHP",#Rchannel,10,13]
					Serin2 Cpinin,PC96,1000,noplus,[Wait ("OK")]			
					pause 1000
					serout2 cpinout,PC96,["ATWR",10,13]
					pause 100
					serout2 cpinout,PC96,["ATCN",10,13]
					pause 200
					serout2 APo, PC96,[27,91,50,74]			' clear screen vt-100	
					bmenu = 11
				case 9
					serout2 APo, PC96,[27,91,50,74]			' clear screen vt-100	
					bmenu =11
				case else
					serout2 APo, PC96,[27,91,50,74]			' clear screen vt-100	
					bmenu = 11
			end select		
		
		case 10
			serout2 APo, PC96,[27,91,#2,59,#15,72]		
			serout2 APo, PC96,["Saving"]
		    I2Cwrite DPIN, CPIN, Chip1, wpt_loc, [set_wpt] ' waypoint flag storage
   			pause 10
    		I2Cwrite DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage
    		pause 10
    		I2Cwrite DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer
    		pause 10
    		I2Cwrite DPIN, CPIN, Chip1, W_baud_loc, [wptbd] ' store address pointer
    		pause 2000
    		serout2 APo, PC96,[27,91,#2,59,#15,72]		
			serout2 APo, PC96,["                 "]
			
		Case 99
			LCDout $fe, 1
			LCDout $fe, 2
			LCDout $fe, L1, "Exiting"
			pause 1000
			bmenu =1

		case 55
			serout2 APo, PC96,[27,91,#2,59,#15,72]		
			serout2 APo, PC96,["*Resetting* "]
			pause 1000
			address = 128
			cs = 1
			Set_wpt = 1
			passthru = 0
			D_baud = 84 ' ds275
			wptbd = 188 ' ds275
			LCDout $fe, L3, "Defaults"
  			I2Cwrite DPIN, CPIN, Chip1, ADR_loc, [address] ' store address pointer
			pause 10
			I2Cwrite DPIN, CPIN, Chip1, CHP_loc, [cs] ' store cs pointer
			pause 10
			I2Cwrite DPIN, CPIN, Chip1, wpt_loc, [set_wpt] ' waypoint flag storage
  		 	pause 10
  			I2Cwrite DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage
   			pause 10
    		I2Cwrite DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer
   			pause 10
   			I2Cwrite DPIN, CPIN, Chip1, W_baud_loc, [wptbd] ' store address pointer
   			pause 10
    		serout2 APo, PC96,[27,91,#2,59,#15,72]		
			serout2 APo, PC96,["                        "]
			
		End Select
wend	

    I2Cwrite DPIN, CPIN, Chip1, wpt_loc, [set_wpt] ' waypoint flag storage
    pause 10
    I2Cwrite DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage
    pause 10
    I2Cwrite DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer
    pause 10
    I2Cwrite DPIN, CPIN, Chip1, W_baud_loc, [wptbd] ' store address pointer
    pause 10
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, " Done with Settings  "
	LCDout $fe, L3, "      Saved"
	pause 1000
    bmenu=1
return

LCDsetting:
	' make the LCD able to program the unit without the PC - for some reason this DOES NOT WORK.. Pushing the buttons has no effect..
	' NEED TO FIX IT .. so we can turn off the PC based setting menue
	I2Cread DPIN, CPIN, Chip1, wpt_loc, [set_wpt] 	' waypoint flag storage 0 or 1
  	I2Cread DPIN, CPIN, Chip1, Pass_loc, [passthru] ' waypoint flag storage 0 ir 1
  	I2Cread DPIN, CPIN, Chip1, D_baud_loc, [D_baud] ' store address pointer 84 for 9600, 6 for 38400
    I2Cread DPIN, CPIN, Chip1, W_baud_loc, [wptbd] 	' store address pointer 84 for 9600, 188 for 4800
    I2Cread DPIN, CPIN, Chip1, wpt_loc,[set_wpt] 	' waypoint flag storage 0 or 1
    
   		LCDout $fe, 1
		LCDout $fe, 2
		LCDout $fe, L1, " Unit Set-up  "
		LCDout $fe, L2+2,"Waypoint:"
			Select case Set_wpt
				Case 0
					LCDout $fe, L2+13,"off"	
				Case else	
					LCDout $fe, L2+13,"Err"
			end select	
			Select Case Wptbd
				Case 188
					LCDout $fe, L2+13,"4800"
				Case 84
					LCDout $fe, L2+13,"9600"
				Case else
					LCDout $fe, L2+13,"Err"
			end select	
		LCDout $fe, L3+2,"Passthru:"
			Select case passthru
				Case 0
					LCDout $fe, L3+13,"off"		
				Case 1
					LCDout $fe, L3+13,"9600"
				Case else
					LCDout $fe, L3+13,"Err"
			end select	
	
		LCDout $fe, L4+2,"Download:"
   			Select Case D_Baud
				Case 84
					LCDout $fe, L4+13,"9600"
				Case 6
					LCDout $fe, L4+13,"38,400"
				Case else
					LCDout $fe, L4+13,"Err"
			end select
			
' menu changes
tempb = 1		' start with 1
If PORTB.0 = 0 then		'first button is pressed - select category
	tempb=tempb+1
	if tempb > 3 then tempb = 1
endif
	Select case tempb
		case 1 ' gpsbaudrate item
			LCDout $fe, L2, "X"   ' indicate selected item on lcd
			LCDout $fe, L3, " "   ' indicate selected item
			LCDout $fe, L4, " "   ' indicate selected item
		Case 2	' passthru mode item
			LCDout $fe, L2, " "   ' indicate selected item
			LCDout $fe, L3, "X"   ' indicate selected item
			LCDout $fe, L4, " "   ' indicate selected item		
		Case 3 ' download baudrate item
			LCDout $fe, L2, " "   ' indicate selected item
			LCDout $fe, L3, " "   ' indicate selected item
			LCDout $fe, L4, "X"   ' indicate selected item	
	end select

while PORTB.0 = 1		' as long as B0 is not pressed to make us move to another line item above:
  If tempb = 1 then
	select case wptbd 		'translate default baudrate
		case 188
			tempc = 1
		case 84
			tempc = 2
		case 0
			tempc = 3
	end select
	select case tempc
		case 1	
			LCDout $fe, L2+13, "4800"   ' display setting
			wptbd=188
			Set_wpt=1
			passthru=0
		Case 2
			LCDout $fe, L2+13, "9600"   ' display setting
			wptbd=84
			set_wpt=1
			passthru=0
		Case 0
			LCDout $fe, L2+13, "off"   ' display setting
			wptbd=84
			set_wpt=0
		Case else
			LCDout $fe, L2+13, "Err"   ' display setting
	end select
	
	If PORTB.1 = 0 then	' second button is pressed - increment options at this level
		tempc=tempc+1
		if tempc > 3 then tempc = 1
	endif
  endif

If tempb = 2 then			' passthru mode
select case passthru 		'translate default passthru
	case 0
		tempc = 1
	case 1
		tempc = 2
end select

	select case tempc
		case 1	
			LCDout $fe, L2+13, "On 9600"   ' display setting
			wptbd=188
			passthru=1
			set_wpt=0
		Case 2
			LCDout $fe, L2+13, "off"   ' display setting
			passthru=0
	end select


	If PORTB.1 = 0 then		' second button is pressed - increment options at this level
		tempc=tempc+1
		if tempc > 2 then tempc = 1
	endif

endif

If tempb = 3 then		' download baudrate

select case D_baud		'translate default dnlspeed
	case 84
		tempc = 1
	case 6
		tempc = 2
end select

	select case tempc
		case 1	
			LCDout $fe, L1+13, "9600"   ' display setting
			D_Baud=84
			
		Case 2
			LCDout $fe, L1+13, "38400"   ' display setting
			D_Baud=6
			
	end select
	If PORTB.1 = 0 then		' second button is pressed - increment options at this level
		tempc=tempc+1
		if tempc > 2 then tempc = 1
	endif
endif
wend		
Return

noplus:
	serout2 APo, PC96,[27,91,#10,59,#20,72]
	Serout2 APo,PC96,["No response from radio"]
	pause 5000
return



NextStage: ' timer routine
	Mnu = 0
    T1CON.0 = 0 ' Turn off Timer1 if you need to here
    Timer = 0   ' Clear Timer var on entry here
    TMR1H = 0
    TMR1L = 0   ' CLear timer count registers as required
	LCDout $fe, 1
	LCDout $fe, 2
	LCDout $fe, L2, "Timer Ran Out"
	pause 1000
    GOTO ReStart ' When you're ready to start all over
    
' Interrupt handler stuff here

Disable                                     ' Disable interrupts in handler
INT_handle:
    Timer = 0   ' Clear Timer var on entry here
    TMR1H = 0
    TMR1L = 0   ' CLear timer count registers as required
	Selectit=0
While selectit = 0
   Mnu=1           								' we are in the menu system
   If Mmenu = 0 then 
    	While  Mmenu = 0                        ' waiting until
    	wend                                    ' push-button is release
    	pause 100                               	' debounce time
   		Bmenu=Bmenu+1 								' increment each time B0 is presseed
   endif       ' bo pressed  go to next menu
   
   LCDout $fe, 1
LCDout $fe, 2
   Select Case Bmenu
         Case 0
			LCDout $fe, L2, " Menu 0: Cycle Menu"
       	Case 1
			LCDout $fe, L2, " Menu 1: Sensors"
       	Case 2
			LCDout $fe, L2, " Menu 2: Lat/Long"
		Case 3
			LCDout $fe, L2, " Menu 3: Altitude"
		Case 4
			LCDout $fe, L2, " Menu 4: RSSI"
		Case 5
			LCDout $fe, L2, " Menu 5: Download"
		Case 6
			LCDout $fe, L2, " Menu 6: Erase"
		Case 7
			LCDout $fe, L2, " Menu 7: Record"
		Case 8
			LCDout $fe, L2, " Menu 8: View Rec"
		Case 9
			LCDout $fe, L2, " Menu 9: Stop Rec"
		Case 10
			LCDout $fe, L2, " Menu 10: Reset"
		Case 11
			LCDout $fe, L2, " Menu 11:PC Setting"
			Set_Item = 0
		Case 12
			LCDout $fe, L2, " Menu 12:LCD"
	   Case 13
	   		Bmenu=0
	   Case 99
	   		return
		end select
	pause 100
     If Smenu = 0 then 							' select button is pressed
     	While MMenu = 0                         ' waiting until
    	wend                                    ' push-button is release
    	pause 100                               ' debounce time
     	selectit = 1                          	' b1 pressed get out of the loop!
     endif
 Wend

Mnu=0  ' turn off menu flag

Here:
    While MMenu = 0                         ' waiting until
    wend                                    ' push-button is release
    pause 100                               ' debounce time
    If MMenu = 0 then here
    PIR1.0 = 0 '  Clear Timer1 over-flow flag
    Timer = 0  ' Clear Timer counts before return
    INTCON.1=0                              ' reset RB0 interrupt flag
Resume                                      ' Return to main program
Enable                                      ' Enable interrupts after
                                            ' handler
                                            
end
