'****************************************************************
'*  Name    : boxetimer.bas                                     *
'*  Author  : Davide Gironi                                     *
'*  Notice  : Copyright (c) 2008 Davide Gironi                  *
'*          : All Rights Reserved                               *
'*  Version : 0.3                                               *
'*  Notes   :                                                   *                  
'*          :                                                   *                             
'****************************************************************
INCLUDE "modedefs.bas"                                                  

DEFINE OSC 4 

W1      Var     WORD
B0      VAR     WORD
B1      VAR     BYTE
i       Var     Byte
  
ticks   var     byte    ' Define pieces of seconds variable
update  var     byte    ' Define variable to indicate update of LCD
timerA  VAR     WORD    ' Constant value for timerA
timerB  VAR     WORD    ' Constant value for timerA
timerAc  VAR    WORD    ' Constant values for timerA
timerBc  VAR    WORD    ' Constant values for timerB
timerN  VAR     WORD    ' Show the program running
timerS  VAR     BYTE    ' Timer mode
reset   VAR     PORTA.4 ' reset button
timersl VAR     PORTB.7 ' timer selection
soundo  VAR     PORTA.3 ' sound out
soundgo VAR     BYTE    ' make sound by piezo - 1:beep, 2:beep, 3:beep
scale   VAR     BYTE    ' pot scale
scale = 16


TRISA = %00001000 'all output - 3 input
TRISB = %10000000 'all output - 7 input


'get the pot scale
'getscale:
'For scale = 1 To 255
'    POT timersl,scale,B0
'    If (B0 > 253) Then calibrated
'Next scale
'W1 = 999
'For i = 1 To 1000
'    GOSUB display3
'Next i 
'Stop
'calibrated:
'    For i = 1 To 1000
'        W1 = scale
'        GOSUB display3
'    Next i  
'    GOTO getscale

'get values for resistors and pot    
'valpot:
'    POT timersl,scale,B1
'    For i = 1 To 1000
'        W1 = B1
'        GOSUB display3
'    Next i
'    PAUSE 500
'    GOTO valpot

'get values for piezo freq
'piezofreq:
'    POT PORTB.7,scale,B1
'    SOUND PORTA.3,[B1,10]
'    PAUSE 500
'    GOTO piezofreq

           
Poke PORTA, $1F	' Turn off digit to prevent ghosting

' Set TMR0 to interrupt every 16.384 milliseconds
OPTION_REG = $55        ' Set TMR0 configuration and enable PORTB pullups
INTCON = $a0            ' Enable TMR0 interrupts
On Interrupt Goto tickint

GOSUB settimer 'set timer the first time


mainloop:
    IF(reset == 0) THEN
        PAUSE 100
        GOSUB settimer
    ENDIF
    IF(timerS == 1) THEN
        W1 = timerA
        GOSUB display3
    ENDIF
    IF(timerS == 2) THEN
        W1 = timerB
        'show only alf time (let know the user we are in timerB)
        IF(ticks < 30) THEN
            GOSUB display3
        ENDIF
    ENDIF
	GOTO mainloop


settimer:
    OPTION_REG = %10000000 ' disable option_reg
    INTCON = $80           ' disable interrupt
    
    B1 = 0
    POT timersl,scale,B1 ' read to clean the pin status
    PAUSE 100            ' wait
    POT timersl,scale,B1 ' read pot
    
    LOOKDOWN2 B1,>[255,242,218,192,166,144,124,105,80,59,49,40,0],B0
    LOOKUP2 B0,[60,600,180,120,60,60,40,30,20,15,10,45,30],timerAc
    LOOKUP2 B0,[61,181,61,61,61,31,41,31,21,16,11,16,16],timerBc
    LOOKUP2 B0,[6,1,2,3,4,5,6,7,8,9,10,11,12],timerN 
    
    For i = 1 To 2000 'show status
        W1 = timerN
        GOSUB display3
    Next i
    PAUSE 500
        
    timerA = timerAc
    timerB = timerBc
    timerS = 1 '1: timerA, 2: timerB
        
    soundgo = 3
    gosub soundgoF
    
    ticks = 0 'reset ticks
    
    OPTION_REG = %01010101 ' enable option_reg
    INTCON = $a0           ' enable interrupt
    RETURN


'beep a sound
soundgoF:
    Poke PORTA, $1F
    for i = 1 to soundgo
        SOUND soundo,[123,10]
        PAUSE 20
    next i
    soundgo = 0
    return
        

' PICBASIC subroutine to send the binary number (0 - 999) in W1 to LEDs
display3:
    B0 = W1 / 1000	' Find number of thousands
	W1 = W1 // 1000	' Remove thousands from W1
	B0 = W1 / 100	' Find number of hundreds
	W1 = W1 // 100	' Remove hundreds from W1
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1B	' Turn on third digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting 
	B0 = W1 / 10	' Find number of tens
	W1 = W1 // 10	' Remove tens from W1
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1D	' Turn on second digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting 
	B0 = W1		    ' Get number of ones
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1E	' Turn on first digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting
	Return		    ' Go back to caller

' Convert binary number in B0 to segments for LED
bin2seg:
    Lookup B0,[$40,$79,$24,$30,$19,$12,$02,$78,$00,$18],B0
	Return

	
	DISABLE
tickint:
    ticks = ticks + 1         ' Count pieces of seconds
    If(ticks < 61)Then tiexit ' 61 ticks per second (16.384ms per tick)
    ' One second elasped - update time
    ticks = 0
    IF(timerS == 1) THEN
        IF(timerA == 0) THEN
            soundgo = 2
            gosub soundgoF
            timerS = 2
            timerA = timerAc
        ELSE
            timerA = timerA - 1
        ENDIF
    ENDIF
    IF(timerS == 2) THEN
        IF(timerB == 0) THEN
            soundgo = 1
            gosub soundgoF
            timerS = 1
            timerB = timerBc
        ELSE
            timerB = timerB - 1
        ENDIF
    ENDIF
tiexit:
    INTCON.2 = 0    ' Reset timer interrupt flag
    Resume
    ENABLE

	
