'programme Pulse_Meter
' 1109 lignes

'*******************************************************************************
'*******************************************************************************
'
'          SERVO PWM_METER USING 16F877A @ 8MHz; EvaryPIC4 And 16x2 LCD
'           Displays PWM Period/Duty-Period And Frequency/Duty-Percent
'                  LCD Screen Toggles Using PORTA.0 Pushbutton
'
'    Code Compiled with PBP 2.50b  for 16F877A @ 8MHz & Default Configs
'                   by Acetronics on October, 3 ,2008
'
'       Demonstrates Use Of Input Capture Feature of CCP1 On Pin RC2
'                   AND Darrel's "instant Interrupts"
'
'                   **********************************************
'					Courtesy Warren Schroeder and MikroElektronika
'                   **********************************************
'                              Courtesy Darrel TAYLOR
'                              **********************
'
'*******************************************************************************
'*******************************************************************************
'Defines

DEFINE LCD_DREG PORTB
DEFINE LCD_DBIT 0
DEFINE LCD_RSREG PORTB
DEFINE LCD_RSBIT 4
DEFINE LCD_EREG PORTB
DEFINE LCD_EBIT 5
DEFINE LCD_BITS  4
DEFINE LCD_LINES 2
'DEFINE OSC 4                                                                       
DEFINE ADC_BITS     8      
DEFINE OSC 8

'*****************************************************************************
'Config

@ __config _HS_OSC & _WDT_ON & _PWRTE_ON & _BODEN_ON & _LVP_OFF & _CP_OFF 

ADCON1     	= 6                          		 ' disable adc's
CMCON      	= 7                          		 ' disable comparators
T1CON       = %00010000 '16                 ' Timer1 prescaler = 2 = 1us
CCP1CON     = %000000101                    ' RC2 is CCP1 Capture Input
TRISC.2     = 1                             ' Tris RC2 var Input
PIE1.2	    = 1                             ' Enable CCP1 interrupt
PIR1.2	    = 0                             ' Clear CCP1 Interrupt Flag
INTCON      = %01000000 '192                ' Global & Peripheral interrupts enabled
T1CON.0		= 1

'*****************************************************************************
'Variables
        
Fu			var Word
Fd			var Word
Du			var Word

CCPR1	   var Word								 '  CCPR1 16 bits value
Period     var Word                       		 '  Rising Edge to Rising Edge value
Dummy 	   var Word
Dummy2 	   var Word
StartEdge  var Word                       		 '  First Rising Edge Timer1 value
DCEdge     var Word                       		 '  Falling Edge Timer1 value
DUTY  	   var Word                        		 	 '  Rising Edge to Falling Edge value

RisingEdge var Bit                     		 	 '  Switch Edge Detection Flag
LCDFlag    var Bit                    		 	 '  Switch LCD Screen Flag
Catched    var Bit

TMR1IF	   var PIR1.0
'*****************************************************************************
' Constantes

Capture_RE con %000000101                   	 ' CCP1CON Value For Rising Edge
Capture_FE con %000000100                 		 ' CCP1CON Value For Falling Edge

'*****************************************************************************
'I/Os

PORTA      = 0
PORTB      = 0
PORTC      = 0
PORTD      = 0
TRISA      = %00000001                  ' RA0 is switch input pulled low active high
TRISB      = 0
TRISC      = %00000100                  ' RC2 is signal input
TRISD	   = 0


'*****************************************************************************
'Preset

RisingEdge = 0
LCDFlag    = 0
Period     = 0
DUTY  	   = 0
StartEdge  = 0
DCEdge     = 0
Catched    = 0
Dummy	   = 10000

'*****************************************************************************
'Includes
'*****************************************************************************

INCLUDE "DT_INTS-14.bas"
INCLUDE "ReEnterPBP.bas"

ASM
INT_LIST  macro    ; IntSource,        Label,  Type, ResetFlag?

     	INT_Handler	   CCP1_INT,  _Capture,       PBP,  yes
       
    endm
	INT_CREATE            ; Creates the interrupt processor
ENDASM


INTCON.7 = 1				' Pour tre sur !!!

GOTO Main

'*****************************************************************************
Capture: ' ISR to manage edge detection
'*****************************************************************************

    If RisingEdge Then
    
        CCP1CON   = Capture_FE                   ' set up to detect next edge
        
        StartEdge = CCPR1L + ( CCPR1H << 8 )     'Compteur Re
        
        
        IF DCEdge <= StartEdge THEN
         
        	Period = StartEdge - DCEdge + DUTY
        	
        ELSE
        
        	PERIOD =  StartEdge + ( 65535 - DCEdge ) + DUTY	+ 1  ' Period en s
  
        ENDIF	
        
    Else
    
        CCP1CON   = Capture_RE                   ' set up to detect next edge
        
        DCEdge    = CCPR1L + ( CCPR1H << 8 )
        
        IF StartEdge <= DCEdge THEN
         
        	DUTY = DCEdge - StartEdge
        	
        ELSE
        
        	DUTY = DCEdge + ( 65535 - StartEdge ) + 1		  ' Duty en s
 
        ENDIF	
        
    EndIf
    
    
    RisingEdge    = Not(RisingEdge)               ' toggle edge detection flag
 
	Catched = 1
	
@ INT_RETURN

'*****************************************************************************
LCD_Output_Manager:               				  ' manage LCD screen output between
												  '   Period/Duty-Period and
    											  '   Frequency/Duty-Percent
'*****************************************************************************

'    LCDOUT $FE,2,"                "               ' clear first line 
'    LCDOUT $FE,$80,"                "             ' clear second line
    
    If Period.15 then 							  ' DIV 32 ... 31/15 bits !
    	Period = Period/2
    	Dummy  = 5000
    Endif
    	
    If LCDFlag  Then
                                  
       LCDOUT $FE,2,"FREQUENCY  DUTY "
       
'*****************************************************************************
' Affichage Frquence

	IF Period THEN
       
       INTCON.7 = 0					'Stop interrupts !
       
       dummy2 = dummy * 100		' 1 000 000 / 500 000
       Fu = DIV32 Period			' Period en s ... t0 en  Hz
       
     
       dummy2 = dummy * 10000		' 100 000 000 / 50 000 000
       Fd = DIV32 Period			' Period en s ... t0 en 1/100 Hz
       
       INTCON.7 = 1					' Enable interrupts
       
       LCDOUT $FE, $C0  ,DEC2 Fu,".", DEC2 Fd," hz"
       
 '****************************************************************************
 ' Affichage Rapport Cyclique 
       
       INTCON.7 = 0					'Stop Interrupts !
            
       dummy2 = DUTY * 1000			' Duty en 1/1000 de s
       Du =  DIV32 Period			' Period en s
       
       INTCON.7 = 1					' Enable interrupts
 
       LCDOUT $FE, $C0 + 9," ",DEC2(Du/10),".",DEC1 Du," %"  
          
  	ENDIF
  	     
'*****************************************************************************
' Affichage Priode
       
    Else
    
       LCDOUT $FE,2," PERIOD   DUTY  "
       
       LCDOUT $FE, $C0 ,DEC5 PERIOD," ",234,"s ",DEC4 DUTY, " ",234,"s"
       
    EndIf
    
 '****************************************************************************
 ' Pas de signal d'entre
       
     IF NOT Catched THEN
     
       LCDOUT $FE, $C0  ,"----- hz   --- %" 
       
     ENDIF
     
     Catched = 0    
Return

'*****************************************************************************
'*****************************************************************************
' Programme principal

main:

PAUSE 500

LCDOUT $FE,1

    While 1
       PAUSE 100                         	 ' LCD screen refresh delay
       GoSub LCD_Output_Manager
       
       If PORTA.0 = 1 Then                   ' RA0 Button Manager;  If 1 Then....
       
           LCDFlag=NOT(LCDFlag)              ' toggle LCD Ouput Flag
           GoSub LCD_Output_Manager          ' toggle LCD Screen
           
           While PORTA.0 = 1                 ' If RA0 still pressed then wait
              PAUSE 5                    	 '    until released
           Wend
           
       EndIf
    Wend

end