'****************************************************************
'*  Name    : UNTITLED.BAS                                      *
'*  Author  : Timothy Box                                       *
'*  Notice  : Copyright (c) 2002 TJB SYSTEMS                    *
'*          : All Rights Reserved                               *
'*  Date    : 05-Jun-02                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
' bootloader and OSC settings
DEFINE     LOADER_USED 1 ' remove if you dont use a bootloader!!
DEFINE     OSC 20         ' set the correct speed here!!



	' This is a demo program that will set up 3 timers and one counter. 
	' 
	
	' TIMER0 will be a 8 bit timer with a 100:1 prescaler that will count down from 200 to 0
	' TIMER1 will be a 16 bit timer with a 50:1 prescaler  and count down from 400 to 0
	' TIMER2 will be a 16 bit timer with no prescaler that will count down from 2000 to 0
	' TIMER3 will be a 16 bit counter with no prescaler counting from  45535 to 65535 and round to 0
	' TIMER4 will be a 16 bit timer with a 10:1 prescaler counting from  2000 to 0
	' It is designed to run on a PIC-X1 so to use on another test board change the LED DEFINES
	'
	
	
	
	
	
	' Define LCD registers and bits
DEFINE  LCD_DREG        PORTD
DEFINE  LCD_DBIT        4
DEFINE  LCD_RSREG       PORTE
DEFINE  LCD_RSBIT       0
DEFINE  LCD_EREG        PORTE
DEFINE  LCD_EBIT        1


	    ADCON1 = 7      ' Set PORTA and PORTE to digital
	    Low PORTE.2     ' LCD R/W line low (W)
	    Pause 100       ' Wait for LCD to start up

'_____________________________________________________________________________________________

	    
	    
        TIMER0 VAR BYTE BANK0                'For 8 BIT timer/counter 
        TIMER1 VAR WORD BANK0                'For 16 BIT timer/counter
        TIMER2 VAR WORD BANK0                'For 16 BIT timer/counter
        TIMER3 VAR WORD BANK0                'For 16 BIT timer/counter
        TIMER4 VAR WORD BANK0                'For 16 BIT timer/counter
      
	    TIMER0_PRE VAR BYTE BANK0
	    TIMER1_PRE VAR BYTE BANK0            ' Prescalers
	    TIMER4_PRE VAR BYTE BANK0
	    TEMP VAR WORD
        TIMERVAL VAR WORD
      
        INCLUDE "T1_INT8K.INC"        ' Include the file
        
	
DEFINE TIMER_0 00000110b              ' 8 bit, 100:1 prescale, timer 
DEFINE TIMER_1 00001100b              ' 16 bit, 50:1 prescale, timer 
DEFINE TIMER_2 00001000b              ' 16 bit, no prescale, timer 
DEFINE TIMER_3 00001001b              ' 16 bit, no prescale, counter 
DEFINE TIMER_4 00001010b              ' 16 bit, 10:1 prescale, timer 

	
	
	
		TIMER0 = 200
		TIMER1 = 400
		TIMER2 = 20000
		TIMER3 = 45535
		TIMER4 = 2000

		
		
		TMRFLAG = 255                   ' Start all timers/counters
		
		
		
		
		
		
loop:


        ' The code below is to prevent falce readings half way though a change

		'TIMERVAL = TIMER2
		'TEMP = TIMER2.byte1 
		'IF TIMERVAL.byte1-TEMP=0 Then calcexit
		'TIMERVAL = TIMER2
		
calcexit:


        ' dispaly the timers           


		LCDOut $FE,1,DEC TIMER0,"  ",DEC TIMER1,"  "
		LCDOut $Fe,$C0,DEC TIMER2,"  ",DEC TIMER3,"  ",DEC TIMER4
		
		Pause 200
		
		GoTo loop
		
		
		
