		
		
  
 ' This timer program allows you to have up to 8 timers running independently in the back ground.
 
 ' The "TICK" of the timer is every 100 hz (100th of a second)
 
 ' Each timer can be 8, 16 or 24 bits wide (0 to 255, 0 to 65535 or 0 to 16777215)
 
 ' These timers can have prescalers attached to them 0:0 (no prescaler) 10:0
 ' 50:1 and 100:1
 '
 ' If a 100:1 prescaler is used the timer counter will decrement 1 every second
 ' if a 50:1 prescaler is used the timer counter will decrement every half a second. 
 ' 10:1 10 times a second.
 
 ' A timer can count down or up
 
 ' The status and control of the timer is via the Variable "TMRFLAG". 
 ' Bit 0 indicates the status of TIMER0, bit 1 TIMER1 etc
 
 ' To start or stop the timer Clear or set the appropriate bit eg "Tmrflag.0 = 1" will start Timer 0
 ' "Tmrflag.0 = 0" will stop the timer.
 
 ' The status of the Bit indicates if the timer is running or stopped
 ' eg if you are checking to see if a timer has timed out and jump to another routine to handle the
 ' event you would write "if Tmrflag.0 = 0 then gosub TIMESUP"
 
 ' When the timer reaches 0 it stops running and sets the appropriate "TMRFLAG" flag to say so.
 ' ie if TIMER0 stops TMRFLAG.0 will be a 0
 
 ' All the timers are configured using a DEFINE TIMER_? command (? is the number of the timer)
 '
 ' The configuration of the timer is as follows: -
 
 'Bit 0 indicates if timer or counter is required
 ' 0 = Timer
 ' 1 = Counter
 'Bits 1 & 2 specify if prescaler is required and if so what prescaling
 ' 0 0 = no prescaler 
 ' 0 1 = 10:1 (10Hz) prescaler
 ' 1 0 = 50:1 (2Hz) prescaler
 ' 1 1 = 100:1 (1Hz) prescaler
 'Bits 3 to 4 specify the size of the counter
 ' 0 0 = 8 bits
 ' 0 1 = 16 bits
 ' 1 0 = 24 bits
 

 
 ' To use this timer program, follow these steps
 
 
 ' 1 Include this file into your program 
 ' 
 '  include "T1_INT4K.INC"
 '
 ' 2  Decide on how many timers/counters you want and how big they are, 8, 16 or 24 bits
 
 ' 3 Next declare the variables. 
 
 '  TIMER0 VAR BYTE BANK0 For 8 BIT, 
 '  TIMER0 VAR WORD BANK0 For 16 BIT 
 '  TIMER0 VAR BYTE[3] BANK0 for 24 bit
 '
 '  eg If you want an 8 bit timer :- 
 '
 '  TIMER0 VAR BYTE BANK0
 ' 
 ' ( You can have up to 8 timers so don't forget to declare all the variables 
 ' 
 '  TIMER1 VAR BYTE, TIMER2 etc.

 ' If a prescaler is required you will also have to declare another variable for that timer:-
 '
 ' TIMER0_PRE VAR BYTE BANK0:  TIMER1_PRE VAR BYTE BANK0 etc
 
 ' Decide if the timer is to be a timer or counter, the prescaler value if required and then 
 
 ' DEFINE the configuration you require:-
 
 ' Example    DEFINE TIMER_0 00001000b (which is an 16 bit timer with no prescaler)
 

 ' Lastly you have to load the timer with the time required and start it running
	
 ' TIMER_0 = 20 	' will give a 10 second timer with a prescaler of 50:1
	
 ' Timerflag.0 = 1	' start the count down.

 ' Note If you have configured the timer as counter it will keep counting till it rolls over
 ' then it will stop
	
	
'****************************************************************************************
'*																						*
'*				Declare variables														*
'*																						*
'****************************************************************************************




	Wsave	VAR	BYTE	$20	SYSTEM	' Save location for the W register in bank-0
	Wsave1	VAR	BYTE	$A0	SYSTEM	' Save location for the W register in bank-1
	Ssave	VAR	BYTE	Bank0	SYSTEM	' Save location for the STATUS register
	Psave	VAR	BYTE	Bank0	SYSTEM	' Save location for the PCLATH register

	TMRFLAG VAR BYTE	Bank0			'Timer status flags

	DEFINE INTHAND INT_TIMER			'Tell PBP what code to use on an interrupt


	Tmrflag = 0 				'Stop all timers running
		

	GoTo Jump_past_timer				'Jump over Assembler Code



Asm 

	NOLIST
	CLIST
;****************************************************************************************
;*																						*
;*									DECLARE MACROS										*
;*																						*
;*								START AND PRESCALER CODE								*
;****************************************************************************************
	CLIST
TMR_GEN_MAC macro TIMER_TYPE, TIMER_VAR, TIMERFLAG, TIMER_PRE 
		local TIMER_EXIT			;' This enables labels to be generated independently every time macro called	

		btfss TIMERFLAG			;' Check if timer is running
		GoTo TIMER_EXIT			;' No, so exit now
		
	IF 	((TIMER_TYPE & 6) = 2)		;' If a 10:1 prescaler selected insert this code
		decfsz TIMER_PRE,f		;' Check if zero (prescaler count up)
		GoTo TIMER_EXIT			;' No so exit now
		movlw 10				;' Yes so reload prescaler and continue
		movwf TIMER_PRE
	EndIF
	
	IF 	((TIMER_TYPE & 6) = 4)		;' If a 50:1 prescaler selected insert this code
		decfsz TIMER_PRE,f		;' Check if zero (prescaler count up)	
		GoTo TIMER_EXIT			;' No so exit now
		movlw 50				;' Yes so reload prescaler and continue
		movwf TIMER_PRE
	EndIF
	
	IF 	((TIMER_TYPE & 6) = 6)		;' If a 100:1 prescaler selected insert this code
		decfsz TIMER_PRE,f		;' Check if zero (prescaler count up)	
		GoTo TIMER_EXIT			;' No so exit now
		movlw 100				;' Yes so reload prescaler and continue
		movwf TIMER_PRE

	EndIF

;****************************************************************************************
;*																						*
;*									TIMER MACRO											*
;*																						*
;****************************************************************************************

	CLIST
	IF ((TIMER_TYPE & 25) = 0)	;' If 8 bit timer required insert this code
		decfsz TIMER_VAR,f		;' Dec timer byte counter	
		GoTo TIMER_EXIT			;' If not zero exit
	EndIF
	
	IF 	((TIMER_TYPE & 25) = 8)	;' If 16 bit timer required insert this code
	    movlw   1
        subwf   TIMER_VAR,F
        btfss   STATUS, C       ;' Dec timer
        subwf   TIMER_VAR+1,F       
        movf    TIMER_VAR,W     ;  Now check if zero
        xorlw 	0x00
        btfss 	STATUS,Z        
        GoTo    TIMER_EXIT
        movf 	TIMER_VAR+1,W
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT
        
	EndIF
			
	IF 	((TIMER_TYPE & 25) = 16);' If 24 bit timer required insert this code
        subwf   TIMER_VAR,F
        btfss   STATUS, C       
        subwf   TIMER_VAR+1,F    ;' Dec timer 
        btfss   STATUS, C       
        subwf   TIMER_VAR+2,F   
        movf    TIMER_VAR,W     
        xorlw 	0x00
        btfss 	STATUS,Z        
        GoTo    TIMER_EXIT       ;  Now check if zero
        movf 	TIMER_VAR+1,W
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT       
        movf 	TIMER_VAR+2,W
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT
	EndIF
	
;****************************************************************************************
;*																						*
;*									COUNTER MACRO										*
;*																						*
;****************************************************************************************
	
	CLIST
	IF ((TIMER_TYPE & 25) = 1)	;' If 8 bit counter required insert this code
		incfsz TIMER_VAR,F		;' Inc counter lower byte
		GoTo TIMER_EXIT			;' If not rolled over to zero exit
	EndIF
	
	IF 	((TIMER_TYPE & 25) = 9)	;' If 16 bit counter required insert this code
	
        incf    TIMER_VAR
        btfsc   STATUS,Z
        incf    TIMER_VAR+1      ; incrument the timer
        movf    TIMER_VAR,W     
        xorlw 	0x00
        btfss 	STATUS,Z        
        GoTo    TIMER_EXIT
        movf 	TIMER_VAR+1,W    ;  Now check if zero
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT        

	EndIF
	
	IF 	((TIMER_TYPE & 25) = 17);' If 24 bit timer required insert this code
        incf    TIMER_VAR
        btfsc   STATUS,Z
        incf    TIMER_VAR+1
        btfsc   STATUS,Z
        incf    TIMER_VAR+2      ; incrument the timer
        movf    TIMER_VAR,W     
        xorlw 	0x00
        btfss 	STATUS,Z        
        GoTo    TIMER_EXIT       ;  Now check if zero
        movf 	TIMER_VAR+1,W
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT     
        movf 	TIMER_VAR+2,W
        xorlw 	0x00
        btfss 	STATUS,Z
        GoTo    TIMER_EXIT
	EndIF
	
	bcf TIMERFLAG				;'Timer countdown finished so set flag to say so
	
TIMER_EXIT

	endm						;End of macro definition
	
;****************************************************************************************
;*																						*
;*							PRESCALER VALUE INITIALISATION MACRO						*
;*																						*
;****************************************************************************************

	CLIST
Pre_var_mac macro TIMER_TYPE, TIMER_PRE 	; Macro to set the prescaler Vars
	IF 	((TIMER_TYPE & 6) = 2)		;' If a 10:1 prescaler was selected insert this code
		movlw 10			;' to pre load the prescaler
		movwf TIMER_PRE
	EndIF
	
	IF 	((TIMER_TYPE & 6) = 4)		;' If a 50:1 prescaler was selected insert this code
		movlw 50			;' to pre load the prescaler
		movwf TIMER_PRE
	EndIF
	
	IF 	((TIMER_TYPE & 6) = 6)		;' If a 100:1 prescaler was selected insert this code
		movlw 100			;' to pre load the prescaler
		movwf TIMER_PRE
	EndIF
	endm							;End of macro definition

;****************************************************************************************
;*																						*
;*							MAIN INTERRUPT CODE GENERATION ROUTINE						*
;*																						*
;****************************************************************************************



TMR1_Val =((65536+(12+4))-(OSC*2500))	;' Calculate OSC offset values

	
INT_TIMER

	LIST
	Movwf	Wsave				;' Save the W reg			
	Swapf	STATUS,w			;' Save the STATUS reg
	Clrf	STATUS
	Movwf	Ssave
	Movf	PCLATH,				;' Save the PCLATH reg
	Movwf	Psave
	Endm
	

	movlw Low TMR1_Val				;' Load the 16 bit TMR1 counters with the correct value
	movwf TMR1L				
	movlw High TMR1_Val				;' Restart TMR1 with ((65536-(12+4))-(OSC*2500))  
	movwf TMR1H				
	clrwdt					;' Clear watch dog timer
	NOLIST
	
	LIST
	CLIST
	ifdef TIMER_0				;' Check if TIMER_0 called for
	tmr_gen_mac TIMER_0, _TIMER0, _TMRFLAG.0, _TIMER0_PRE 
	EndIF
	
	ifdef TIMER_1				;' Check if TIMER_1 called for
	tmr_gen_mac TIMER_1, _TIMER1, _TMRFLAG.1, _TIMER1_PRE 
	EndIF
	
	ifdef TIMER_2				;' Check if TIMER_2 called for
	tmr_gen_mac TIMER_2, _TIMER2, _TMRFLAG.2, _TIMER2_PRE
	EndIF
	
	ifdef TIMER_3				;' Check if TIMER_3 called for
	tmr_gen_mac TIMER_3, _TIMER3, _TMRFLAG.3, _TIMER3_PRE
	EndIF
	
	ifdef TIMER_4				;' Check if TIMER_4 called for
	tmr_gen_mac TIMER_4, _TIMER4, _TMRFLAG.4, _TIMER4_PRE		
	EndIF
	
	ifdef TIMER_5				;' Check if TIMER_5 called for
	tmr_gen_mac TIMER_5, _TIMER5, _TMRFLAG.5, _TIMER5_PRE
	EndIF
		
	ifdef TIMER_6				;' Check if TIMER_6 called for
	tmr_gen_mac TIMER_6, _TIMER6, _TMRFLAG.6, _TIMER6_PRE
	EndIF
		
	ifdef TIMER_7				;' Check if TIMER_7 called for
	tmr_gen_mac TIMER_7, _TIMER7, _TMRFLAG.7, _TIMER7_PRE;  								
	EndIF
	
	

	bcf PIR1.0				;'Clear TMR1 interrupt flag
	
	
	Movf	Psave,w				; Restore the PCLATH reg
	Movwf	PCLATH
	Swapf	Ssave,w				; Restore the STATUS reg			
	Movwf	STATUS
	Swapf	Wsave,f
	Swapf	Wsave,w				; Restore W reg
	Retfie					; Exit the interrupt routine	

	EndAsm
	
Jump_past_timer:

	
	Asm		
;****************************************************************************************
;*																						*
;*							PRESCALER VALUE INITIALISATION ROUTINE						*
;*																						*
;****************************************************************************************
	
	LIST
	CLIST
	ifdef TIMER_0					;' Check TIMER_0 for prescalers
	Pre_var_mac TIMER_0, _TIMER0_PRE 
	EndIF
	
	ifdef TIMER_1				;' Check TIMER_1 for prescalers
	Pre_var_mac TIMER_1, _TIMER1_PRE 
	EndIF
	
	ifdef TIMER_2				;' Check TIMER_2 for prescalers
	Pre_var_mac TIMER_2, _TIMER2_PRE
	EndIF
	
	ifdef TIMER_3				;' Check TIMER_3 for prescalers
	Pre_var_mac TIMER_3, _TIMER3_PRE
	EndIF
	
	ifdef TIMER_4				;' Check TIMER_4 for prescalers
	Pre_var_mac TIMER_4, _TIMER4_PRE		
	EndIF
	
	ifdef TIMER_5				;' Check TIMER_5 for prescalers
	Pre_var_mac TIMER_5, _TIMER5_PRE
	EndIF
		
	ifdef TIMER_6				;' Check TIMER_6 for prescalers
	Pre_var_mac TIMER_6, _TIMER6_PRE
	EndIF
	
	ifdef TIMER_7				;' Check TIMER_7 for prescalers
	Pre_var_mac TIMER_7, _TIMER7_PRE   								
	EndIF
	
	
	LIST
	movlw Low TMR1_Val				;' Load the 16 bit TMR1 counters with the correct value
	movwf TMR1L				
	movlw High TMR1_Val				;' Restart TMR1 with ((65536+12+4))-(OSC*2500))  
	movwf TMR1H
	NOLIST
	EndAsm	

	
'****************************************************************************************
'*																						*
'*						INITIALISE TMR1													*
'*																						*
'****************************************************************************************	
	
		
	
		
	T1CON = %00000000			'Set up Tmr1 to have 1:1 prescaler and act as a timer
	PIR1.0 = 0				'Clear Tmr1 interrupt flag
	INTCON =  %11000000			'Global and Peripheral interrupts on
	PIE1.0 = 1				'Enable Tmr1 as peripheral interrupt source
	T1CON.0 = 1				'Enable Tmr1 interrupts

