'****************************************************************
'*  Name    : ReEnterPBP.pbp                                    *
'*  Author  : Timothy Box / Darrel Taylor                       *
'*  Date    : JAN 9, 2006                                       *
'*  Version : 3.2                                               *
'*  Notes   : Allows re-entry to PBP from an ASM interrupt      *
'*          : Must have DT_INTS-??.bas loaded first             *
'****************************************************************
'*  ver 3.2 : Bug Fix, RS1/RS2 were being restored incorrectly  *
'****************************************************************

DEFINE   ReEnterUsed  1

   VarsSaved   VAR BIT
   VarsSaved = 0

goto OverReEnter
   
' Save locations for PBP system Vars
    R0_Save     VAR WORD
    R1_Save     VAR WORD
    R2_Save     VAR WORD
    R3_Save     VAR WORD
    R4_Save     VAR WORD
    R5_Save     VAR WORD
    R6_Save     VAR WORD
    R7_Save     VAR WORD
    R8_Save     VAR WORD
    Flags_Save  VAR BYTE
    GOP_Save    VAR BYTE
    RM1_Save    VAR BYTE
    RM2_Save    VAR BYTE
    RR1_Save    VAR BYTE
    RR2_Save    VAR BYTE
    RS1_Save    VAR BYTE
    RS2_Save    VAR BYTE
    T1_Save     VAR WORD
    T2_Save     VAR WORD
    T3_Save     VAR WORD
    T4_Save     VAR WORD
   
SavePBP:                        ' Save all PBP system Vars
  if VarsSaved = 0 then
    R0_Save = R0        '  4/ 4
    R1_Save = R1        '  4/ 8
    R2_Save = R2        '  4/12
    R3_Save = R3        '  4/16
    R4_Save = R4        '  4/20
    R5_Save = R5        '  4/24
    R6_Save = R6        '  4/28
    R7_Save = R7        '  4/32
    R8_Save = R8        '  4/36
    Flags_Save = FLAGS  '  2/38
    GOP_Save = GOP      '  2/40
    RM1_Save = RM1      '  2/42
    RM2_Save = RM2      '  2/44
    RR1_Save = RR1      '  2/46
    RR2_Save = RR2      '  2/48
    ASM
        ifdef RS1
            MOVE?BB    RS1, _RS1_Save    ; 2/50
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_Save    ; 2/52
        endif

        ifdef T1
            MOVE?WW    T1, _T1_Save    ; 4/56
        endif
        ifdef T2
            MOVE?WW    T2, _T2_Save    ; 4/60
        endif
        ifdef T3
            MOVE?WW    T3, _T3_Save    ; 4/64
        endif
        ifdef T4
            MOVE?WW    T4, _T4_Save    ; 4/68    Save Delay = 68us @4mhz
        endif                          ;                    13.6us @20mhz
    ENDASM   
    VarsSaved = 1
  endif
@ INT_RETURN

RestorePBP:
  if VarsSaved = 1 then
    R0 = R0_Save
    R1 = R1_Save
    R2 = R2_Save
    R3 = R3_Save
    R4 = R4_Save
    R5 = R5_Save
    R6 = R6_Save
    R7 = R7_Save
    R8 = R8_Save
    FLAGS = Flags_Save
    GOP = GOP_Save
    RM1 = RM1_Save
    RM2 = RM2_Save
    RR1 = RR1_Save
    RR2 = RR2_Save
    ASM
        ifdef RS1
            MOVE?BB     _RS1_Save, RS1
        endif
        ifdef RS2
            MOVE?BB     _RS2_Save, RS2
        endif
        ifdef T1
            MOVE?WW     _T1_Save, T1
        endif
        ifdef T2
            MOVE?WW    _T2_Save, T2
        endif
        ifdef T3
            MOVE?WW    _T3_Save, T3
        endif
        ifdef T4
            MOVE?WW    _T4_Save, T4
        endif
        ifdef T5
            ERROR "Temp variables exceeding T4"
        endif
    ENDASM   
    VarsSaved = 0
  ENDIF
@ INT_RETURN

OverReEnter:
