
; PICBASIC PRO(TM) Compiler 2.47, (c) 1998, 2006 microEngineering Labs, Inc. All Rights Reserved.  
_USED			EQU	1

	INCLUDE	"C:\PBP\16F88.INC"


; Define statements.
#define		CODE_SIZE		 4
#define		INTHAND		  INT_ENTRY
#define		ReEnterUsed		  1

RAM_START       		EQU	00020h
RAM_END         		EQU	001EFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00110h
BANK2_END       		EQU	0016Fh
BANK3_START     		EQU	00190h
BANK3_END       		EQU	001EFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

wsave           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
_RetAddr         		EQU	RAM_START + 013h
FLAGS           		EQU	RAM_START + 015h
fsave           		EQU	RAM_START + 016h
GOP             		EQU	RAM_START + 017h
psave           		EQU	RAM_START + 018h
RM1             		EQU	RAM_START + 019h
RM2             		EQU	RAM_START + 01Ah
RR1             		EQU	RAM_START + 01Bh
RR2             		EQU	RAM_START + 01Ch
ssave           		EQU	RAM_START + 01Dh
_Time_Holder     		EQU	RAM_START + 01Eh
_Min_Holder      		EQU	RAM_START + 030h
_Message         		EQU	RAM_START + 039h
_Num             		EQU	RAM_START + 03Dh
_D_Number        		EQU	RAM_START + 041h
_R0_Save         		EQU	RAM_START + 043h
_R1_Save         		EQU	RAM_START + 045h
_R2_Save         		EQU	RAM_START + 047h
_R3_Save         		EQU	RAM_START + 049h
_R4_Save         		EQU	RAM_START + 04Bh
_R5_Save         		EQU	RAM_START + 04Dh
_R6_Save         		EQU	RAM_START + 04Fh
_R7_Save         		EQU	RAM_START + 051h
_R8_Save         		EQU	RAM_START + 053h
T1              		EQU	RAM_START + 055h
_T1_Save         		EQU	RAM_START + 057h
T2              		EQU	RAM_START + 059h
_T2_Save         		EQU	RAM_START + 05Bh
T3              		EQU	RAM_START + 05Dh
_BLINK           		EQU	RAM_START + 05Fh
wsave1          		EQU	RAM_START + 080h
_T3_Save         		EQU	RAM_START + 081h
T4              		EQU	RAM_START + 083h
_T4_Save         		EQU	RAM_START + 085h
_TMR1RunOn       		EQU	RAM_START + 087h
_ButtHold        		EQU	RAM_START + 089h
_Disp_Patt       		EQU	RAM_START + 08Ah
_DP              		EQU	RAM_START + 08Bh
_dummy           		EQU	RAM_START + 08Ch
_dummy1          		EQU	RAM_START + 08Dh
_dummy2          		EQU	RAM_START + 08Eh
_Flags_Save      		EQU	RAM_START + 08Fh
_GOP_Save        		EQU	RAM_START + 090h
_GP              		EQU	RAM_START + 091h
_Hours           		EQU	RAM_START + 092h
_Hr_Val          		EQU	RAM_START + 093h
_Hundredths      		EQU	RAM_START + 094h
_ind             		EQU	RAM_START + 095h
_ind2            		EQU	RAM_START + 096h
_LEDS            		EQU	RAM_START + 097h
_Min_Val         		EQU	RAM_START + 098h
_Minutes         		EQU	RAM_START + 099h
_MssgFlash       		EQU	RAM_START + 09Ah
_MssgFlash2      		EQU	RAM_START + 09Bh
_O_C             		EQU	RAM_START + 09Ch
PB01            		EQU	RAM_START + 09Dh
_remainder       		EQU	RAM_START + 09Eh
_RM1_Save        		EQU	RAM_START + 09Fh
_RM2_Save        		EQU	RAM_START + 0A0h
_RR1_Save        		EQU	RAM_START + 0A1h
_RR2_Save        		EQU	RAM_START + 0A2h
_RS1_Save        		EQU	RAM_START + 0A3h
_RS2_Save        		EQU	RAM_START + 0A4h
_RTC100s         		EQU	RAM_START + 0A5h
_RTCDate         		EQU	RAM_START + 0A6h
_RTCDay          		EQU	RAM_START + 0A7h
_RTCHour         		EQU	RAM_START + 0A8h
_RTCMin          		EQU	RAM_START + 0A9h
_RTCMonth        		EQU	RAM_START + 0AAh
_RTCSec          		EQU	RAM_START + 0ABh
_RTCYear         		EQU	RAM_START + 0ACh
_Seconds         		EQU	RAM_START + 0ADh
_SetUp_OK        		EQU	RAM_START + 0AEh
_Temp_Val        		EQU	RAM_START + 0AFh
_Temp_Val2       		EQU	RAM_START + 0B0h
_TMR1Cal         		EQU	RAM_START + 0B1h
_TMR1CalAR       		EQU	RAM_START + 0B2h
wsave2          		EQU	RAM_START + 00100h
wsave3          		EQU	RAM_START + 00180h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTA
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISA
_TMR1RunOn??HIGHBYTE		EQU	_TMR1RunOn + 001h
_TMR1RunOn??LOWBYTE		EQU	_TMR1RunOn
#define _Serviced        	 PB01, 004h
#define _VarsSaved       	 PB01, 006h
#define _MssgFlag        	 PB01, 002h
#define _MssgFlag2       	 PB01, 003h
#define _Butt_Flag       	 PB01, 000h
#define _Butt_Force      	 PB01, 001h
#define _TimeSet         	 PB01, 005h
#define _Digit3          	_PORTA??0
#define _Digit2          	_PORTA??1
#define _Digit1          	_PORTA??2
#define _Digit0          	_PORTA??3
#define _PS0             	_OPTION_REG??0
#define _PS1             	_OPTION_REG??1
#define _PS2             	_OPTION_REG??2
#define _PSA             	_OPTION_REG??3
#define _T0CS            	_OPTION_REG??5
#define _PORTA??0        	 PORTA, 000h
#define _PORTA??1        	 PORTA, 001h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _OPTION_REG??0   	 OPTION_REG, 000h
#define _OPTION_REG??1   	 OPTION_REG, 001h
#define _OPTION_REG??2   	 OPTION_REG, 002h
#define _OPTION_REG??3   	 OPTION_REG, 003h
#define _OPTION_REG??5   	 OPTION_REG, 005h
#define _PORTA??7        	 PORTA, 007h
#define _PORTB??7        	 PORTB, 007h
#define _PORTA??6        	 PORTA, 006h
#define _PORTA??4        	 PORTA, 004h
#define _RTCMin??0       	_RTCMin, 000h
#define _RTCMin??1       	_RTCMin, 001h
#define _RTCMin??2       	_RTCMin, 002h
#define _RTCMin??3       	_RTCMin, 003h
#define _RTCMin??4       	_RTCMin, 004h
#define _RTCMin??5       	_RTCMin, 005h
#define _RTCMin??6       	_RTCMin, 006h
#define _RTCHour??0      	_RTCHour, 000h
#define _RTCHour??1      	_RTCHour, 001h
#define _RTCHour??2      	_RTCHour, 002h
#define _RTCHour??3      	_RTCHour, 003h
#define _RTCHour??4      	_RTCHour, 004h
#define _RTCHour??5      	_RTCHour, 005h
#define _PORTA??5        	 PORTA, 005h
#define _T1CON??0        	 T1CON, 000h
#define _PIR1??0         	 PIR1, 000h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
_TMR1CalMax      		EQU	00064h
_TMR1Preset      		EQU	0D910h

; EEPROM data.
	ORG EEPROM_START

	ORG EEPROM_START + 000FDh
	DE	001h
	DE	04Bh
	DE	000h

	INCLUDE	"DC2397~1.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


	ASM?
 __CONFIG _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO ;_HS_OSC

	ENDASM?


	ASM?
 __CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF

	ENDASM?


	ASM?
 errorlevel -306

	ENDASM?


	ASM?

asm = 0
ASM = 0
pbp = 1
PBP = 1
YES = 1
yes = 1
NO = 0
no = 0


	ENDASM?


	ASM?

  #define INT_INT   INTCON,INTF     ;-- INT External Interrupt
  #define RBC_INT   INTCON,RBIF     ;-- RB Port Change Interrupt
  #define TMR0_INT  INTCON,T0IF   ; T0IF  -- TMR0 Overflow Interrupt 16F
  #define TMR1_INT  PIR1,TMR1IF     ;-- TMR1 Overflow Interrupt
  #define TMR2_INT  PIR1,TMR2IF     ;-- TMR2 to PR2 Match Interrupt
  #define TX_INT    PIR1,TXIF       ;-- USART Transmit Interrupt
  #define RX_INT    PIR1,RCIF       ;-- USART Receive Interrupt
  #define CMP_INT   PIR2,CMIF       ;-- Comparator Interrupt
  #define EE_INT    PIR2,EEIF       ;-- EEPROM/FLASH Write Operation Interrupt
  #define BUS_INT   PIR2,BCLIF      ;-- Bus Collision Interrupt
  #define PSP_INT   PIR1,PSPIF      ;-- Parallel Slave Port Read/Write Interrupt
  #define AD_INT    PIR1,ADIF       ;-- A/D Converter Interrupt
  #define SSP_INT   PIR1,SSPIF      ;-- Master Synchronous Serial Port Interrupt
  #define CCP1_INT  PIR1,CCP1IF     ;-- CCP1 Interrupt
  #define CCP2_INT  PIR2,CCP2IF     ;-- CCP2 Interrupt



	ENDASM?


	ASM?

INT_Source  macro  IFR, IFB, IER, IEB
    if ((IflagReg == IFR) && (IflagBit == IFB))
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
Found = YES
    endif
;  nolist  
    endm 


	ENDASM?


	ASM?

;-------------------------------------------------------------------------------
GetIntInfo  macro  IflagReg, IflagBit

Found = NO
; nolist
  ifdef INTF    ;----{ INT External Interrupt }----------------[INTCON, INTF]---
      INT_Source  INTCON, INTF, INTCON, INTE
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }--------------[INTCON, RBIF]---
      INT_Source  INTCON, RBIF, INTCON, RBIE
  endif
  ifdef T0IF    ;----{ TMR0 Overflow Interrupt }-------------[INTCON, TMR0IF]---
      INT_Source  INTCON, T0IF, INTCON, T0IE
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }---------------[PIR1, TMR1IF]---
      INT_Source  PIR1, TMR1IF, PIE1, TMR1IE
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }-----------[PIR1, TMR2IF]---
      INT_Source  PIR1, TMR2IF, PIE1, TMR2IE
  endif
  ifdef TXIF    ;----{ USART Transmit Interrupt }----------------[PIR1, TXIF]---
      INT_Source  PIR1, TXIF, PIE1, TXIE
  endif
  ifdef RCIF    ;----{ USART Receive Interrupt }------------------[PIR1 RCIF]---
          INT_Source  PIR1, RCIF, PIE1, RCIE
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }--------------------[PIR2, CMIF]---
      ifdef PIR2
          INT_Source  PIR2, CMIF, PIE2, CMIE
      else
          INT_Source  PIR1, CMIF, PIE1, CMIE
      endif
  endif
  ifdef EEIF    ;---{ EEPROM/FLASH Write Operation Interrupt }---[PIR2, EEIF]---
      ifdef PIR2
          INT_Source  PIR2, EEIF, PIE2, EEIE
      else
          INT_Source  PIR1, EEIF, PIE1, EEIE
      endif
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }----------------[PIR2, BCLIF]---
      INT_Source  PIR2, BCLIF, PIE2, BCLIE
  endif
  ifdef PSPIF   ;--{ Parallel Slave Port Read/Write Interrupt }--[PIR1, PSPIF]--
      INT_Source  PIR1, PSPIF, PIE1, PSPIE
  endif
  ifdef ADIF   ;----{ A/D Converter Interrupt }------------------[PIR1, ADIF]---
      INT_Source  PIR1, ADIF, PIE1, ADIE
  endif
  ifdef SSPIF  ;----{ Master Synchronous Serial Port Interrupt }--[PIR1, SSPIF]-
      INT_Source  PIR1, SSPIF, PIE1, SSPIE
  endif
  ifdef CCP1IF ;----{ CCP1 Interrupt }-------------------------[PIR1, CCP1IF]---
      INT_Source  PIR1, CCP1IF, PIE1, CCP1IE
  endif
  ifdef CCP2IF ;----{ CCP2 Interrupt Flag }--------------------[PIR2, CCP2IF]---
      INT_Source  PIR2, CCP2IF, PIE2, CCP2IE
  endif
    
  list
    endm
  list  


	ENDASM?


	ASM?

;---[Returns the Address of a Label as a Word]----------------------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[find correct bank for a BIT variable]--------------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    
;---[This creates the main Interrupt Service Routine (ISR)]---------------------
INT_CREATE  macro
  local OverCREATE
    goto OverCREATE
INT_ENTRY  
    IF (CODE_SIZE <= 2)
        movwf   wsave       ; 1 copy W to wsave register
        swapf   STATUS,W    ; 2 swap status reg to be saved into W
        clrf    STATUS      ; 3 change to bank 0 regardless of current bank
        movwf   ssave       ; 4 save status reg to a bank 0 register
        movf    PCLATH,W    ; 5 move PCLATH reg to be saved into W reg
        movwf   psave       ; 6 save PCLATH reg to a bank 0 register
    EndIF
    movf      FSR,W         ; 7 move FSR reg to be saved into W reg
    movwf     fsave         ; 8 save FSR reg to a bank 0 register
;    clrf    STATUS          ; BANK 0
PREV_BANK = 0

List_Start
    RST?RP
    CHKRP?T  _Serviced
    bcf      _Serviced

    INT_LIST                ; Expand the users list of interrupt handlers
                            ; INT_LIST macro must be defined in main program
    
    CHKRP?T  _Serviced
    btfsc    _Serviced
    goto List_Start

    ifdef ReEnterUsed       ; if ReEnterPBP.bas was included in the main program
        CHKRP?T  _VarsSaved
        btfss    _VarsSaved   ; if PBP system vars have been saved 
        goto     INT_EXIT
        GetAddress  INT_EXIT, _RetAddr
        L?GOTO   _RestorePBP   ; Restore PBP system Vars
    endif
    
INT_EXIT
    clrf    STATUS          ; BANK 0
PREV_BANK = 0
    MOVF    fsave,W         ; Restore the FSR reg
    MOVWF   FSR
    Movf    psave,w         ; Restore the PCLATH reg
    Movwf   PCLATH
    swapf   ssave,w         ; Restore the STATUS reg
    movwf   STATUS
    swapf   wsave,f
    swapf   wsave,w         ; Restore W reg
    Retfie                  ; Exit the interrupt routine

OverCREATE
    bsf      INTCON, 6      ; Enable Peripheral interrupts
    bsf      INTCON, 7      ; Enable Global interrupts
    endm
    


	ENDASM?


	ASM?

;---[Add an Interrupt Source to the user's list of INT Handlers]----------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterRestore, NoInt
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            CLRWDT
            CHK?RP   INT_Enable_Reg
            btfss    INT_Enable_Reg, INT_Enable_Bit  ; if the INT is enabled
            goto   NoInt
            CHK?RP   INT_Flag_Reg                    
            btfss    INT_Flag_Reg, INT_Flag_Bit      ; and the Flag set?
            goto     NoInt
    CHKRP?T  _Serviced
    bsf      _Serviced
            
            if (Type == PBP)                         ; If INT handler is PBP
                ifdef ReEnterUsed
                    GetAddress  AfterSave, _RetAddr  
                    L?GOTO  _SavePBP                 ; Save PBP system Vars
AfterSave                    
                    clrf    STATUS
PREV_BANK = 0
                else
                    error ReEnterPBP must be INCLUDEd to use PBP interrupts
                endif
            endif
            GetAddress  AfterRestore, _RetAddr       ; save return address
            L?GOTO   Label                           ; goto the users INT handler
AfterRestore
            clrf   STATUS
PREV_BANK = 0            
            if (Reset == YES)
                CHK?RP   INT_Flag_Reg
                bcf      INT_Flag_Reg, INT_Flag_Bit ; reset flag (if specified)
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
        clrf   STATUS
PREV_BANK = 0        
    endm

;---[Returns from a "goto" subroutine]------------(RetAddr must be set first)---
INT_RETURN  macro
      CHK?RP  _RetAddr
      movf    _RetAddr + 1, W  ; Set PCLATH with top byte of return address
      movwf   PCLATH
      movf    _RetAddr, W      ; Go back to where we were
      movwf   PCL
    endm    
    
;---[Enable an interrupt source]------------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Flag_Reg
          bcf     INT_Flag_Reg, INT_Flag_Bit        ; clear the flag first 
          CHK?RP  INT_Enable_Reg
          bsf     INT_Enable_Reg, INT_Enable_Bit    ; enable the INT source  
      else
          error Cannot Enable (IntFlagReg,IntFlagBit)
      endif
    endm    

;---[Disable an interrupt source]-----------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Enable_Reg
          bcf     INT_Enable_Reg, INT_Enable_Bit    ; disable the INT source  
      else
          error Cannot Disable (IntFlagReg,IntFlagBit)
      endif
    endm    

;---[Clear an interrupt Flag]---------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Flag_Reg
          bcf     INT_Flag_Reg, INT_Flag_Bit       ; clear the INT flag
      else
          error Cannot CLEAR (IntFlagReg,IntFlagBit)
      endif
    endm



	ENDASM?

	MOVE?CT	000h, _VarsSaved
	GOTO?L	_OverReEnter

	LABEL?L	_SavePBP	
	CMPNE?TCL	_VarsSaved, 000h, L00003
	MOVE?WW	R0, _R0_Save
	MOVE?WW	R1, _R1_Save
	MOVE?WW	R2, _R2_Save
	MOVE?WW	R3, _R3_Save
	MOVE?WW	R4, _R4_Save
	MOVE?WW	R5, _R5_Save
	MOVE?WW	R6, _R6_Save
	MOVE?WW	R7, _R7_Save
	MOVE?WW	R8, _R8_Save
	MOVE?BB	FLAGS, _Flags_Save
	MOVE?BB	GOP, _GOP_Save
	MOVE?BB	RM1, _RM1_Save
	MOVE?BB	RM2, _RM2_Save
	MOVE?BB	RR1, _RR1_Save
	MOVE?BB	RR2, _RR2_Save

	ASM?

        ifdef RS1
            MOVE?BB    RS1, _RS1_Save    ; 2/50
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_Save    ; 2/52
        endif

        ifdef T1
            MOVE?WW    T1, _T1_Save    ; 4/56
        endif
        ifdef T2
            MOVE?WW    T2, _T2_Save    ; 4/60
        endif
        ifdef T3
            MOVE?WW    T3, _T3_Save    ; 4/64
        endif
        ifdef T4
            MOVE?WW    T4, _T4_Save    ; 4/68    Save Delay = 68us @4mhz
        endif                          ;                    13.6us @20mhz
    

	ENDASM?

	MOVE?CT	001h, _VarsSaved
	LABEL?L	L00003	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_RestorePBP	
	CMPNE?TCL	_VarsSaved, 001h, L00005
	MOVE?WW	_R0_Save, R0
	MOVE?WW	_R1_Save, R1
	MOVE?WW	_R2_Save, R2
	MOVE?WW	_R3_Save, R3
	MOVE?WW	_R4_Save, R4
	MOVE?WW	_R5_Save, R5
	MOVE?WW	_R6_Save, R6
	MOVE?WW	_R7_Save, R7
	MOVE?WW	_R8_Save, R8
	MOVE?BB	_Flags_Save, FLAGS
	MOVE?BB	_GOP_Save, GOP
	MOVE?BB	_RM1_Save, RM1
	MOVE?BB	_RM2_Save, RM2
	MOVE?BB	_RR1_Save, RR1
	MOVE?BB	_RR2_Save, RR2

	ASM?

        ifdef RS1
            MOVE?BB     _RS1_Save, RS1
        endif
        ifdef RS2
            MOVE?BB     _RS2_Save, RS2
        endif
        ifdef T1
            MOVE?WW     _T1_Save, T1
        endif
        ifdef T2
            MOVE?WW    _T2_Save, T2
        endif
        ifdef T3
            MOVE?WW    _T3_Save, T3
        endif
        ifdef T4
            MOVE?WW    _T4_Save, T4
        endif
        ifdef T5
            ERROR "Temp variables exceeding T4"
        endif
    

	ENDASM?

	MOVE?CT	000h, _VarsSaved
	LABEL?L	L00005	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_OverReEnter	
	MOVE?CB	07Eh, OSCCON
	MOVE?CB	000h, ANSEL
	MOVE?CB	007h, CMCON
	MOVE?CB	070h, TRISA
	MOVE?CB	000h, TRISB
	MOVE?CB	000h, PORTA
	MOVE?CB	000h, PORTB
	CLEAR?	
	MOVE?CB	000h, _RTC100s
	MOVE?CB	000h, _RTCSec
	MOVE?CB	001h, _RTCDay
	MOVE?CB	000h, _RTCDate
	MOVE?CB	001h, _RTCMonth
	MOVE?CB	000h, _RTCYear
	MOVE?CT	000h, _PSA
	MOVE?CT	000h, _PS0
	MOVE?CT	000h, _PS1
	MOVE?CT	000h, _PS2
	MOVE?CT	000h, _T0CS
	PAUSE?C	001F4h
	MOVE?CB	001h, _ind
	LABEL?L	L00007	
	CMPGT?BCL	_ind, 009h, L00008
	READ?BW	_ind, T1
	SUB?BCW	_ind, 001h, T2
	AIN?WWW	T1, _Time_Holder, T2
	SUB?BCW	_ind, 001h, T2
	SUB?BCW	_ind, 001h, T1
	AOUT?WWW	_Time_Holder, T1, T1
	MUL?WCW	T1, 064h, T1
	AIN?WWW	T1, _Time_Holder, T2
	NEXT?BCL	_ind, 001h, L00007
	LABEL?L	L00008	
	MOVE?CB	00Ah, _ind
	LABEL?L	L00009	
	CMPGT?BCL	_ind, 012h, L00010
	READ?BW	_ind, T1
	SUB?BCW	_ind, 00Ah, T2
	AIN?BBW	T1, _Min_Holder, T2
	NEXT?BCL	_ind, 001h, L00009
	LABEL?L	L00010	
	MOVE?CB	000h, _ind
	LABEL?L	L00011	
	CMPGT?BCL	_ind, 008h, L00012
	AOUT?WBW	_Time_Holder, _ind, T1
	MUL?WCW	T1, 064h, T1
	AOUT?BBB	_Min_Holder, _ind, T2
	ADD?WBW	T1, T2, T2
	AIN?WWB	T2, _Time_Holder, _ind
	NEXT?BCL	_ind, 001h, L00011
	LABEL?L	L00012	

	ASM?


T0IF = TMR0IF
T0IE = TMR0IE

INT_LIST       macro    ; IntSource,        Label,  Type, ResetFlag?
               INT_Handler   TMR0_INT,     _TMR0_INT_HANDLER,   PBP,  yes
               INT_Handler   TMR1_INT,     _TMR1_INT_HANDLER,   PBP,  yes
;               INT_Handler    RX_INT,      _USART_ISR,    PBP,  yes
      endm
      INT_CREATE               ; Creates the interrupt processor
;    
;     INT_ENABLE   RX_INT     ; enable USART  interrupts
      INT_ENABLE   TMR0_INT
      INT_ENABLE   TMR1_INT


	ENDASM?

	GOSUB?L	_SetTimer

	LABEL?L	_START	
	CMPNE?BCL	_SetUp_OK, 000h, L00013
	MUL?BCW	_Hours, 064h, T1
	ADD?WBW	T1, _Minutes, _D_Number
	LABEL?L	L00013	
	MOVE?CB	001h, _ind2
	LABEL?L	L00015	
	CMPGT?BCL	_ind2, 009h, L00016
	SUB?BCW	_ind2, 001h, T1
	AOUT?WWW	_Time_Holder, T1, T1
	CMPNE?WWL	T1, _D_Number, L00017
	CMPEQ?BCL	_ind2, 001h, L00019
	MOD?BCB	_ind2, 002h, _remainder
	XOR?BCB	_remainder, 001h, _remainder
	CMPNE?TCL	_Butt_Force, 000h, L00021
	CMPNE?BCL	_SetUp_OK, 000h, L00023
	MOVE?BT	_remainder, _PORTA??7
	LABEL?L	L00023	
	LABEL?L	L00021	
	LABEL?L	L00019	
	CMPNE?BCL	_ind2, 001h, L00025
	CMPNE?TCL	_Butt_Force, 000h, L00027
	CMPNE?BCL	_SetUp_OK, 000h, L00029
	MOVE?CT	000h, _PORTA??7
	LABEL?L	L00029	
	LABEL?L	L00027	
	LABEL?L	L00025	
	LABEL?L	L00017	
	NEXT?BCL	_ind2, 001h, L00015
	LABEL?L	L00016	
	CMPNE?BCL	_SetUp_OK, 00Ah, L00031
	MUL?BCW	_Hours, 064h, T1
	ADD?WBW	T1, _Minutes, _D_Number
	LABEL?L	L00031	
	CMPEQ?BCL	_SetUp_OK, 000h, L00033
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00035
	MUL?BCW	_Hr_Val, 064h, T1
	ADD?WBW	T1, _Min_Val, _D_Number
	CMPLE?BCL	_Hr_Val, 018h, L00037
	MOVE?CW	000h, _D_Number
	LABEL?L	L00037	
	LABEL?L	L00035	
	LABEL?L	L00033	
	CMPEQ?BCL	_SetUp_OK, 000h, L00039
	CMPEQ?BBL	_dummy, _SetUp_OK, L00041
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00043
	MOVE?CB	009h, _ind
	LABEL?L	L00045	
	CMPLT?BCL	_ind, 001h, L00046
	CMPNE?BBL	_SetUp_OK, _ind, L00047
	MOVE?CB	000h, _MssgFlash
	MOVE?CT	001h, _MssgFlag
	LABEL?L	L00047	
	NEXTM?BCL	_ind, 001h, L00045
	LABEL?L	L00046	
	MOVE?CB	010h, _Message + 00003h
	MOVE?CB	00Ch, _Message + 00002h
	MOVE?CB	011h, _Message + 00001h
	MOVE?BB	_SetUp_OK, _Message
	LABEL?L	L00043	
	LABEL?L	L00041	
	MOVE?BB	_SetUp_OK, _dummy
	CMPEQ?BCL	_dummy, 000h, L00049
	MOVE?CB	064h, _dummy1
	LABEL?L	L00049	
	LABEL?L	L00039	
	CMPEQ?BCL	_SetUp_OK, 000h, L00051
	CMPEQ?BBL	_dummy2, _SetUp_OK, L00053
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00055
	CMPNE?TCL	_MssgFlag, 000h, L00057
	MOVE?CB	009h, _ind
	LABEL?L	L00059	
	CMPLT?BCL	_ind, 001h, L00060
	CMPNE?BBL	_SetUp_OK, _ind, L00061
	MOVE?CB	000h, _MssgFlash2
	MOVE?CT	001h, _MssgFlag2
	LABEL?L	L00061	
	NEXTM?BCL	_ind, 001h, L00059
	LABEL?L	L00060	
	MOVE?CB	000h, _ind2
	LABEL?L	L00063	
	CMPGT?BCL	_ind2, 009h, L00064
	CMPNE?BBL	_ind2, _SetUp_OK, L00065
	MOVE?CB	00Ah, _Message + 00003h
	MOVE?CB	00Fh, _Message + 00002h
	MOVE?CB	00Eh, _Message + 00001h
	MOVE?CB	00Ah, _Message
	LABEL?L	L00065	
	NEXT?BCL	_ind2, 002h, L00063
	LABEL?L	L00064	
	MOVE?CB	00Bh, _ind2
	LABEL?L	L00067	
	CMPLT?BCL	_ind2, 001h, L00068
	CMPNE?BBL	_ind2, _SetUp_OK, L00069
	MOVE?CB	00Fh, _Message + 00003h
	MOVE?CB	00Dh, _Message + 00002h
	MOVE?CB	00Dh, _Message + 00001h
	MOVE?CB	00Ah, _Message
	LABEL?L	L00069	
	NEXTM?BCL	_ind2, 002h, L00067
	LABEL?L	L00068	
	LABEL?L	L00057	
	LABEL?L	L00055	
	MOVE?BB	_SetUp_OK, _dummy2
	LABEL?L	L00053	
	LABEL?L	L00051	
	CMPNE?BCL	_SetUp_OK, 000h, L00071
	CMPEQ?BBL	_dummy1, _SetUp_OK, L00073
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00075
	CMPNE?BCL	_SetUp_OK, 000h, L00077
	MOVE?CT	001h, _MssgFlag
	MOVE?CB	00Bh, _Message + 00003h
	MOVE?CB	00Fh, _Message + 00002h
	MOVE?CB	00Eh, _Message + 00001h
	MOVE?CB	00Ch, _Message
	LABEL?L	L00077	
	LABEL?L	L00075	
	MOVE?BB	_SetUp_OK, _dummy1
	LABEL?L	L00073	
	LABEL?L	L00071	
	GOTO?L	_START

	LABEL?L	_TMR0_INT_HANDLER	
	CMPEQ?TCB	_MssgFlag, 001h, T1
	CMPEQ?TCB	_MssgFlag2, 001h, T2
	LOR?BBL	T1, T2, _MESSAGE_HANDLER
	MOVE?CB	003h, _LEDS
	LABEL?L	L00079	
	CMPLT?BCL	_LEDS, 000h, L00080
	DIG?WBW	_D_Number, _LEDS, T1
	AIN?WBB	T1, _Num, _LEDS
	CMPLE?WCL	_D_Number, 00937h, L00081
	AIN?CBB	00Bh, _Num, _LEDS
	LABEL?L	L00081	
	NEXTM?BCL	_LEDS, 001h, L00079
	LABEL?L	L00080	

	LABEL?L	_Mult_Int	
	AOUT?BBB	_Num, _O_C, T1
	LOOKUP?BCLB	T1, 00Ch, L00001, _Disp_Patt
	LURET?C	03Fh
	LURET?C	006h
	LURET?C	05Bh
	LURET?C	04Fh
	LURET?C	066h
	LURET?C	06Dh
	LURET?C	07Dh
	LURET?C	007h
	LURET?C	07Fh
	LURET?C	067h
	LURET?C	000h
	LURET?C	040h

	LABEL?L	L00001	
	CMPNE?BCL	_O_C, 000h, L00083
	MOVE?CT	000h, _Digit3
	MOVE?BB	_Disp_Patt, PORTB
	CMPNE?TCL	_PORTA??7, 001h, L00085
	MOVE?CT	001h, _PORTB??7
	GOTO?L	L00086
	LABEL?L	L00085	
	MOVE?CT	000h, _PORTB??7
	LABEL?L	L00086	
	MOVE?CT	001h, _Digit0
	LABEL?L	L00083	
	CMPNE?BCL	_O_C, 001h, L00087
	MOVE?CT	000h, _Digit0
	MOVE?BB	_Disp_Patt, PORTB
	CMPNE?BCL	_DP, 000h, L00089
	CMPGE?BCL	_BLINK, 07Dh, L00091
	MOVE?CT	001h, _PORTB??7
	LABEL?L	L00091	
	CMPLT?BCL	_BLINK, 07Dh, L00093
	MOVE?CT	000h, _PORTB??7
	LABEL?L	L00093	
	LABEL?L	L00089	
	CMPEQ?BCL	_DP, 000h, L00095
	MOVE?CT	001h, _PORTB??7
	LABEL?L	L00095	
	MOVE?CT	001h, _Digit1
	LABEL?L	L00087	
	CMPNE?BCL	_O_C, 002h, L00097
	MOVE?CT	000h, _Digit1
	MOVE?BB	_Disp_Patt, PORTB
	CMPNE?BCL	_DP, 000h, L00099
	CMPGE?BCL	_BLINK, 07Dh, L00101
	MOVE?CT	001h, _PORTB??7
	LABEL?L	L00101	
	CMPLT?BCL	_BLINK, 07Dh, L00103
	MOVE?CT	000h, _PORTB??7
	LABEL?L	L00103	
	LABEL?L	L00099	
	CMPEQ?BCL	_DP, 000h, L00105
	MOVE?CT	001h, _PORTB??7
	LABEL?L	L00105	
	MOVE?CT	001h, _Digit2
	LABEL?L	L00097	
	CMPNE?BCL	_O_C, 003h, L00107
	MOVE?CT	000h, _Digit2
	MOVE?BB	_Disp_Patt, PORTB
	MOVE?CT	001h, _Digit3
	LABEL?L	L00107	
	ADD?BCB	_O_C, 001h, _O_C
	CMPLT?BCL	_O_C, 004h, L00109
	MOVE?CB	000h, _O_C
	LABEL?L	L00109	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_MESSAGE_HANDLER	
	MOVE?CB	003h, _LEDS
	LABEL?L	L00111	
	CMPLT?BCL	_LEDS, 000h, L00112
	AOUT?BBB	_Message, _LEDS, T1
	AIN?BBB	T1, _Num, _LEDS
	NEXTM?BCL	_LEDS, 001h, L00111
	LABEL?L	L00112	
	AOUT?BBB	_Num, _O_C, T1
	LOOKUP?BCLB	T1, 012h, L00002, _Disp_Patt
	LURET?C	03Fh
	LURET?C	006h
	LURET?C	05Bh
	LURET?C	04Fh
	LURET?C	066h
	LURET?C	06Dh
	LURET?C	07Dh
	LURET?C	007h
	LURET?C	07Fh
	LURET?C	067h
	LURET?C	000h
	LURET?C	05Eh
	LURET?C	079h
	LURET?C	071h
	LURET?C	054h
	LURET?C	03Fh
	LURET?C	06Dh
	LURET?C	078h

	LABEL?L	L00002	
	CMPNE?BCL	_O_C, 000h, L00113
	MOVE?CT	000h, _Digit3
	MOVE?BB	_Disp_Patt, PORTB
	MOVE?CT	001h, _Digit0
	LABEL?L	L00113	
	CMPNE?BCL	_O_C, 001h, L00115
	MOVE?CT	000h, _Digit0
	MOVE?BB	_Disp_Patt, PORTB
	MOVE?CT	001h, _Digit1
	LABEL?L	L00115	
	CMPNE?BCL	_O_C, 002h, L00117
	MOVE?CT	000h, _Digit1
	MOVE?BB	_Disp_Patt, PORTB
	MOVE?CT	001h, _Digit2
	LABEL?L	L00117	
	CMPNE?BCL	_O_C, 003h, L00119
	MOVE?CT	000h, _Digit2
	MOVE?BB	_Disp_Patt, PORTB
	MOVE?CT	001h, _Digit3
	LABEL?L	L00119	
	ADD?BCB	_O_C, 001h, _O_C
	CMPLT?BCL	_O_C, 004h, L00121
	MOVE?CB	000h, _O_C
	LABEL?L	L00121	

	ASM?
 INT_RETURN   

	ENDASM?


	LABEL?L	_TMR1_INT_HANDLER	
	GOSUB?L	_SetTimer
	ADD?BCB	_Hundredths, 001h, _Hundredths
	ADD?BCB	_BLINK, 001h, _BLINK
	CMPNE?TCL	_MssgFlag, 001h, L00123
	ADD?BCB	_MssgFlash, 001h, _MssgFlash
	CMPLE?BCL	_MssgFlash, 095h, L00125
	MOVE?CB	000h, _MssgFlash
	MOVE?CT	000h, _MssgFlag
	CMPEQ?BCL	_dummy, 000h, L00127
	MOVE?CB	064h, _dummy2
	LABEL?L	L00127	
	LABEL?L	L00125	
	LABEL?L	L00123	
	CMPNE?TCL	_MssgFlag2, 001h, L00129
	ADD?BCB	_MssgFlash2, 001h, _MssgFlash2
	CMPLE?BCL	_MssgFlash2, 095h, L00131
	MOVE?CB	000h, _MssgFlash2
	MOVE?CT	000h, _MssgFlag2
	LABEL?L	L00131	
	LABEL?L	L00129	
	CMPLE?BCL	_BLINK, 0F9h, L00133
	MOVE?CB	000h, _BLINK
	LABEL?L	L00133	
	CMPNE?BCL	_Hundredths, 07Dh, L00135
	CMPNE?BCL	_SetUp_OK, 000h, L00137
	I2CDATA?T	_PORTA??6
	I2CCLOCK?T	_PORTA??4
	I2CWRITE?C	0D1h
	I2CWRITE?C	000h
	I2CREAD?B	_RTC100s
	I2CREAD?B	_RTCSec
	I2CREAD?B	_RTCMin
	I2CREAD?B	_RTCHour
	I2CREAD?B	_RTCDay
	I2CREAD?B	_RTCDate
	I2CREAD?B	_RTCMonth
	I2CREADS?B	_RTCYear
	MUL?TCW	_RTCMin??0, 001h, T1
	MUL?TCW	_RTCMin??1, 002h, T2
	ADD?WWW	T1, T2, T2
	MUL?TCW	_RTCMin??2, 004h, T3
	ADD?WWW	T2, T3, T3
	MUL?TCW	_RTCMin??3, 008h, T4
	ADD?WWB	T3, T4, _Temp_Val
	MUL?TCW	_RTCMin??4, 001h, T1
	MUL?TCW	_RTCMin??5, 002h, T2
	ADD?WWW	T1, T2, T2
	MUL?TCW	_RTCMin??6, 004h, T3
	ADD?WWB	T2, T3, _Temp_Val2
	MUL?BCB	_Temp_Val2, 00Ah, _Temp_Val2
	ADD?BBB	_Temp_Val, _Temp_Val2, _Minutes
	MUL?TCW	_RTCHour??0, 001h, T1
	MUL?TCW	_RTCHour??1, 002h, T2
	ADD?WWW	T1, T2, T2
	MUL?TCW	_RTCHour??2, 004h, T3
	ADD?WWW	T2, T3, T3
	MUL?TCW	_RTCHour??3, 008h, T4
	ADD?WWB	T3, T4, _Temp_Val
	MUL?TCW	_RTCHour??4, 001h, T1
	MUL?TCW	_RTCHour??5, 002h, T2
	ADD?WWB	T1, T2, _Temp_Val2
	MUL?BCB	_Temp_Val2, 00Ah, _Temp_Val2
	ADD?BBB	_Temp_Val, _Temp_Val2, _Hours
	CMPEQ?BBL	_GP, _Minutes, L00139
	MOVE?CB	001h, _ind
	LABEL?L	L00141	
	CMPGT?BCL	_ind, 009h, L00142
	READ?BW	_ind, T1
	SUB?BCW	_ind, 001h, T2
	AIN?WWW	T1, _Time_Holder, T2
	SUB?BCW	_ind, 001h, T2
	SUB?BCW	_ind, 001h, T1
	AOUT?WWW	_Time_Holder, T1, T1
	MUL?WCW	T1, 064h, T1
	AIN?WWW	T1, _Time_Holder, T2
	NEXT?BCL	_ind, 001h, L00141
	LABEL?L	L00142	
	MOVE?CB	00Ah, _ind
	LABEL?L	L00143	
	CMPGT?BCL	_ind, 012h, L00144
	READ?BW	_ind, T1
	SUB?BCW	_ind, 00Ah, T2
	AIN?BBW	T1, _Min_Holder, T2
	NEXT?BCL	_ind, 001h, L00143
	LABEL?L	L00144	
	MOVE?CB	000h, _ind
	LABEL?L	L00145	
	CMPGT?BCL	_ind, 008h, L00146
	AOUT?WBW	_Time_Holder, _ind, T1
	MUL?WCW	T1, 064h, T1
	AOUT?BBB	_Min_Holder, _ind, T2
	ADD?WBW	T1, T2, T2
	AIN?WWB	T2, _Time_Holder, _ind
	NEXT?BCL	_ind, 001h, L00145
	LABEL?L	L00146	
	MOVE?BB	_Minutes, _GP
	MOVE?CT	000h, _Butt_Force
	LABEL?L	L00139	
	LABEL?L	L00137	
	MOVE?CB	000h, _Hundredths
	LABEL?L	L00135	
	MOVE?CB	070h, TRISA
	CMPNE?BCL	_SetUp_OK, 000h, L00147
	CMPNE?TCL	_PORTA??5, 000h, L00149
	ADD?BCB	_ButtHold, 001h, _ButtHold
	CMPLE?BCL	_ButtHold, 0F9h, L00151
	MOVE?CT	001h, _Butt_Force
	MOVE?CB	000h, _ButtHold
	XOR?TCT	_PORTA??7, 001h, _PORTA??7
	LABEL?L	L00151	
	LABEL?L	L00149	
	LABEL?L	L00147	
	CMPNE?TCL	_PORTA??4, 000h, L00153
	CMPNE?BCL	_SetUp_OK, 000h, L00155
	MOVE?CB	000h, _Minutes
	ADD?BCB	_ButtHold, 001h, _ButtHold
	CMPLE?BCL	_ButtHold, 0F9h, L00157
	MOVE?CB	00Bh, _SetUp_OK
	MOVE?CB	000h, _ButtHold
	LABEL?L	L00157	
	LABEL?L	L00155	
	CMPEQ?BCL	_SetUp_OK, 000h, L00159
	MOVE?CT	001h, _Butt_Flag
	CMPNE?BCL	_ButtHold, 000h, L00161
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00163
	ADD?BCB	_SetUp_OK, 001h, _SetUp_OK
	LABEL?L	L00163	
	CMPNE?BCL	_SetUp_OK, 00Ah, L00165
	CMPNE?TCL	_TimeSet, 001h, L00167
	PAUSE?C	001F4h
	DIG?BCB	_Hours, 001h, _Temp_Val
	SHIFTL?BCB	_Temp_Val, 004h, _Temp_Val
	DIG?BCW	_Hours, 000h, T1
	ADD?BWB	_Temp_Val, T1, _RTCHour
	DIG?BCB	_Minutes, 001h, _Temp_Val
	SHIFTL?BCB	_Temp_Val, 004h, _Temp_Val
	DIG?BCW	_Minutes, 000h, T1
	ADD?BWB	_Temp_Val, T1, _RTCMin
	I2CDATA?T	_PORTA??6
	I2CCLOCK?T	_PORTA??4
	I2CWRITE?C	0D0h
	I2CWRITE?C	000h
	I2CWRITE?B	_RTC100s
	I2CWRITE?B	_RTCSec
	I2CWRITE?B	_RTCMin
	I2CWRITE?B	_RTCHour
	I2CWRITE?B	_RTCDay
	I2CWRITE?B	_RTCDate
	I2CWRITE?B	_RTCMonth
	I2CWRITES?B	_RTCYear
	MOVE?CT	000h, _TimeSet
	LABEL?L	L00167	
	MOVE?CB	000h, _SetUp_OK
	LABEL?L	L00165	
	CMPLE?BCL	_SetUp_OK, 00Ah, L00169
	MOVE?CB	001h, _SetUp_OK
	LABEL?L	L00169	
	READ?BB	_SetUp_OK, _Hr_Val
	ADD?BCW	_SetUp_OK, 009h, T1
	READ?WB	T1, _Min_Val
	LABEL?L	L00161	
	LABEL?L	L00159	
	LABEL?L	L00153	
	CMPEQ?BCL	_SetUp_OK, 000h, L00171
	CMPNE?TCB	_PORTA??5, 000h, T1
	CMPNE?TCB	_PORTA??6, 000h, T2
	LOR?BBW	T1, T2, T2
	CMPF?WL	T2, L00173
	CMPNE?TCL	_Butt_Flag, 001h, L00175
	ADD?BCB	_ButtHold, 001h, _ButtHold
	LABEL?L	L00175	
	CMPNE?BCL	_SetUp_OK, 001h, L00177
	CMPLE?BCL	_ButtHold, 095h, L00179
	MOVE?CB	000h, _ButtHold
	MOVE?CT	000h, _Butt_Flag
	LABEL?L	L00179	
	LABEL?L	L00177	
	CMPEQ?BCL	_SetUp_OK, 001h, L00181
	CMPLE?BCL	_ButtHold, 059h, L00183
	MOVE?CB	000h, _ButtHold
	MOVE?CT	000h, _Butt_Flag
	LABEL?L	L00183	
	LABEL?L	L00181	
	LABEL?L	L00173	
	LABEL?L	L00171	
	CMPNE?BCL	_SetUp_OK, 000h, L00185
	CMPNE?TCL	_PORTA??6, 000h, L00187
	ADD?BCB	_ButtHold, 001h, _ButtHold
	CMPLE?BCL	_ButtHold, 0F9h, L00189
	MOVE?CB	00Ah, _SetUp_OK
	MOVE?CT	001h, _TimeSet
	CMPLE?BCL	_SetUp_OK, 00Ah, L00191
	MOVE?CB	000h, _SetUp_OK
	LABEL?L	L00191	
	MOVE?CB	000h, _ButtHold
	LABEL?L	L00189	
	LABEL?L	L00187	
	LABEL?L	L00185	
	MOVE?BB	_SetUp_OK, _DP
	CMPEQ?BCL	_SetUp_OK, 000h, L00193
	CMPNE?TCL	_PORTA??6, 000h, L00195
	MOVE?CT	001h, _Butt_Flag
	CMPNE?BCL	_ButtHold, 000h, L00197
	CMPNE?BCL	_SetUp_OK, 00Ah, L00199
	ADD?BCB	_Hours, 001h, _Hours
	CMPLE?BCL	_Hours, 017h, L00201
	MOVE?CB	000h, _Hours
	LABEL?L	L00201	
	LABEL?L	L00199	
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00203
	ADD?BCB	_Hr_Val, 001h, _Hr_Val
	CMPEQ?BCL	_Hr_Val, 018h, L00205
	CMPEQ?BCL	_Hr_Val, 019h, L00207
	WRITE?BB	_SetUp_OK, _Hr_Val
	LABEL?L	L00207	
	LABEL?L	L00205	
	CMPNE?BCL	_Hr_Val, 018h, L00209
	MOVE?CB	018h, _Hr_Val
	MOVE?CB	018h, _Min_Val
	ADD?BCW	_SetUp_OK, 009h, T1
	WRITE?WB	T1, _Min_Val
	WRITE?BB	_SetUp_OK, _Hr_Val
	LABEL?L	L00209	
	CMPLT?BCL	_Hr_Val, 019h, L00211
	MOVE?CB	000h, _Hr_Val
	MOVE?CB	000h, _Min_Val
	ADD?BCW	_SetUp_OK, 009h, T1
	WRITE?WB	T1, _Min_Val
	WRITE?BB	_SetUp_OK, _Hr_Val
	LABEL?L	L00211	
	LABEL?L	L00203	
	LABEL?L	L00197	
	LABEL?L	L00195	
	CMPNE?TCL	_PORTA??5, 000h, L00213
	MOVE?CT	001h, _Butt_Flag
	CMPNE?BCL	_ButtHold, 000h, L00215
	CMPNE?BCL	_SetUp_OK, 00Ah, L00217
	ADD?BCB	_Minutes, 001h, _Minutes
	CMPLE?BCL	_Minutes, 03Bh, L00219
	MOVE?CB	000h, _Minutes
	LABEL?L	L00219	
	LABEL?L	L00217	
	CMPEQ?BCL	_SetUp_OK, 00Ah, L00221
	ADD?BCB	_Min_Val, 001h, _Min_Val
	CMPLE?BCL	_Min_Val, 03Bh, L00223
	MOVE?CB	000h, _Min_Val
	LABEL?L	L00223	
	ADD?BCW	_SetUp_OK, 009h, T1
	WRITE?WB	T1, _Min_Val
	LABEL?L	L00221	
	LABEL?L	L00215	
	LABEL?L	L00213	
	CMPEQ?TCL	_PORTA??4, 000h, L00225
	CMPNE?TCL	_Butt_Flag, 001h, L00227
	ADD?BCB	_ButtHold, 001h, _ButtHold
	LABEL?L	L00227	
	CMPLE?BCL	_ButtHold, 03Bh, L00229
	MOVE?CB	000h, _ButtHold
	MOVE?CT	000h, _Butt_Flag
	LABEL?L	L00229	
	LABEL?L	L00225	
	LABEL?L	L00193	

	ASM?
 INT_RETURN 

	ENDASM?


	LABEL?L	_SetTimer	
	MOVE?CT	000h, _T1CON??0
	MOVE?BB	TMR1H, _TMR1RunOn??HIGHBYTE
	MOVE?BB	TMR1L, _TMR1RunOn??LOWBYTE
	ADD?CWW	_TMR1Preset, _TMR1RunOn, _TMR1RunOn
	CMPNE?BCL	_TMR1CalAR, 000h, L00231
	ADD?WBW	_TMR1RunOn, _TMR1Cal, _TMR1RunOn
	GOTO?L	L00232
	LABEL?L	L00231	
	SUB?WBW	_TMR1RunOn, _TMR1Cal, _TMR1RunOn
	LABEL?L	L00232	
	MOVE?BB	_TMR1RunOn??HIGHBYTE, TMR1H
	MOVE?BB	_TMR1RunOn??LOWBYTE, TMR1L
	MOVE?CT	001h, _T1CON??0
	MOVE?CT	000h, _PIR1??0
	RETURN?	
	END?	

	END
