'****************************************************************
'*  Name    : UNTITLED.BAS                                      *
'*  Author  : [select VIEW...EDITOR OPTIONS]                    *
'*  Notice  : Copyright (c) 2008 [select VIEW...EDITOR OPTIONS] *
'*          : All Rights Reserved                               *
'*  Date    : 21/07/2008                                        *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
'	Set Hardware Directions
	'	-----------------------
	CMCON= 	7	' Disable Comparators
	ansel = 0
    TRISA=%00001111
    TRISB = %00000000	
    
eeprom 1,[31,28,31,30,31,30,31,31,30,31,30,31]  ' month days lookup

Define LCD_DREG PORTB
 'Set starting data bit
 Define LCD_DBIT 4 'rb4,rb5,rb6,rb7
 'Set LCD RS Port
 DEFINE LCD_RSREG portb
 'Set LCD RS Bit
 define LCD_RSBIT 3
 'Set LCD Enable Port
 Define LCD_EREG portb
 'Set LCD Enable Bit
 Define LCD_EBIT 2
 'Set number of LCD Lines
 Define LCD_LINES 2
 'Set Command Delay time in uS
 define LCD_COMMANUS 2000
 'Set Data delay time in uS
 define LCD_DATAUS 50
 
pause 100 'settle lcd

'setup hpwm
define ccp1_reg = portb
define ccp1_bit = 0


'--------------------------ds1820-2 setup-------------------------------
 DQ	VAR	PORTa.4			' One-wire data pin
 busy var bit
 r_temp var word
 tempc var word
 float var word
 cold_bit var r_temp.bit11
 dummy var byte
 deg con 223		
	
'------------------------------RTCsetup--------------------------------
DS_SCL VAR PORTA.3 	' I2C clock pin 
DS_SDA VAR PORTB.1 	' I2C data pin 
RTC CON %11010000 	' RTC device address (byte addressing)
 ' -------------- RTC definitions ----------------- 
SecReg 	CON $00 	' seconds address (00 - 59)' MSB of SecReg must be set to a 0 to enable RTC 
MinReg CON $01 	' minutes address (00 - 59) 
HourReg CON $02 	' hours address (01 - 12) or (00 - 23) 
DayReg CON $03 	' day address (1 - 7) 
DateReg CON $04 	' date address (01 - 28/29, 30, 31) 
MonthReg CON $05 	' month address (01 - 12) 
YearReg CON $06 	' year address (00 - 99) 
ContReg CON $07 	' control register 
RTCflag CON 0 		' RTC flag (location 0 of internal EEPROM) 
RTCset VAR BIT 	' bit to check if RTC has been set 
cntrl CON %00010000 	' sets the SQW/OUT to 1Hz pulse, logic level low

minutex    var byte
hourx  var byte
secondx   var byte
dayx    var byte
wdayx   var byte
monthx  var byte
yearx	var byte

    
    
    
    '
		
		'
    symbol up = porta.1
    symbol down = porta.2        'three button interface
    symbol enter = porta.0
	
    index0 var byte
	index1 var byte
	index2 var byte
	index0 = 0
	index1 = 0
	index2 = 0

    'var  for menu
    r_hour     var byte
    r_min      var byte
    r_onhour   var byte
    r_onmin    var byte
    r_offhour  var byte
    r_offmin   var byte
    r_year     var byte
    r_month    var byte
    r_day      var byte
    r_htarget  var word
    r_ltarget  var word
    
    r_hour     = 0
    r_min      = 0
    r_onhour   = 0
    r_onmin    = 0
    r_offhour  = 0
    r_offmin   = 0
    r_year     = 8
    r_month    = 1
    r_day      = 1
    r_htarget  = 300
    r_ltarget  = 200
    
    b1 var byte
    b2 var byte
    b3 var word
    
    real_temp var word
    mdays var byte
    daybit var bit
    heat_level var word
    daybit = 1
    pwmheat var byte

LCDOut 254,1		' Clear LCD
start: 
gosub check_time
If secondx.7=1 then goto menu    'has rtc got info in it? if not get some
lcdout 254,128, "Correct Y/N"
LCDOut 254,192, hex2 Hourx,":",hex2 Minutex," ",hex2 dayx,"/",hex2 monthx,"/",hex2 yearx 
if up = 1 then 
gosub read_t
lcdout 254,1 
goto mainloop
endif

if down = 1 then menu
goto start	
    


	

	index0 = 0		' Set to Start of Setup (seven steps from 0 to 6)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
menu:
	lcdout 254,1,"      Menu"
    LCDOut 254,192,"Set:"
	
SetupDisplayLoop:
	If index0=0 then
		LCDOut 254,196," Real Time "
		endif
	If index0=1 then 
		LCDOut 254,196," On Time   "
		endif
	If index0=2 then
		LCDOut 254,196," Off Time  "
		endif
	If index0=3 then 
		LCDOut 254,196," Date      "
		endif
	If index0=4 then
		LCDOut 254,196," Day Temp  "
		endif
	If index0=5 then
		LCDOut 254,196," Night Temp"
		endif
	If index0=6 then
		LCDOut 254,196," Exit      "
		endif
		
	If Enter = 1 then
        if index0 = 0 then 
        lcdout 254,1, "Set time"
        b1 = r_hour                       'preset display reg
        b2 = r_min
        pause 200
        goto Set_time
        endif
        
        If index0 = 1 Then 
        lcdout 254,1, "Set ON time"
        b1 = r_onhour
        b2 = r_onmin
        pause 200
        goto Set_time
        endif 
        
        if index0 = 2 Then 
        lcdout 254,1, "Set OFF time"
        b1 = r_offhour
        b2 = r_offmin
        pause 200
        goto Set_time
        endif
      
        if index0 = 3 Then 
        lcdout 254,1, "Enter date"
        b1 = r_day
        b2 = r_month
        b3 = r_year
        pause 200
        goto Set_Date
        endif
    
        if index0 = 4 Then 
        lcdout 254,1, "Set HI temp"
        pause 200
        b3 = r_htarget
        goto Set_temp
        endif
   
        if index0 = 5 Then 
        lcdout 254,1, "Set LOW temp"
        pause 200
        b3 = r_ltarget
        goto Set_temp
        endif

        if index0 = 6 Then 
        gosub convert
        gosub firei2c
        gosub save_t
        lcdout 254,1
        goto mainloop
        
        endif
  
	endif
	
IF UP = 1 THEN 
WHILE UP = 1 : WEND
 IF index0 < 6 THEN 
 index0 = index0 + 1
ENDIF
endif


IF DOWN = 1 THEN
while down = 1 : wend
 IF index0 > 0 THEN 
 index0 = index0 - 1
ENDIF
endif

goto setupdisplayLoop
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Set_time:
lcdout 254,192, dec2 b1,":",dec2 b2,"   24Hr"
gosub scan
goto set_time

Set_Date:
lcdout 254,192, dec2 b1,"/",dec2 b2,"/","20",dec2 b3
gosub scan

if index1 = 3 then    'exit ruitein for date
    pause 200
    index1      = 0 
    r_day       = b1
    r_month     = b2
    r_year      = b3
    goto menu
endif

goto Set_Date

Set_temp:
lcdout 254,192, dec2 b3/10,".",dec1 b3,deg,"C"
gosub scan
goto set_temp

''''''''''''''''''''menu button scan'''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
scan:
if up = 1 then
while up = 1 : wend
    if index0 = 0 or index0 = 1 or index0 = 2 then
        if index1 = 0 then                 'hour section
            if b1 < 23 then
            b1 = b1 + 1
            endif
        endif
        if index1 = 1 then                   'minute section
            if b2 < 59 then
            b2 = b2 + 1
            endif
        endif
    endif
    
    if index0 = 3 then                       'date year set
        if index1 = 0 then
            if b3 < 99 then
            b3 = b3 + 1
            endif
        endif
    endif
        
     if index0 = 3 then                       'date month set
        if index1 = 1 then
            if b2 < 12 then
            b2 = b2 + 1
            endif
        endif     
    endif
    
    if index0 = 3 then
        if index1 = 2 then
            if b1 < mdays then
            b1 = b1 + 1
            endif
        endif
    endif
    
    if index0 = 4 or index0 = 5 then         'traget temp if section
        if b3 > 500 then return
        b3 = b3 + 5
    endif 
endif
    


if down = 1 then
while down = 1 : wend
    
    if index0 = 0 or index0 = 1 or index0 = 2 then
        if index1 = 0 then
            if b1 = 0 then return
            b1 = b1 - 1
        endif
        if index1 = 1 then
            if b2 = 0 then 
            return
            else
            b2 = b2 - 1
            endif   
        endif
    endif
    
    if index0 = 3 then                      'date year section
        if index1 = 0 then
            if b3 = 0 then 
            return
            else
            b3 = b3 - 1
            endif
        endif
    endif
    
    if index0 = 3 then                      'date month section
        if index1 = 1 then
            if b2 = 1 then 
            return
            else
            b2 = b2 - 1
            endif
        endif
    endif
    
    if index0 = 3 then                      'date day section
        if index1 = 2 then
            if b1 = 1 then 
            return
            else
            b1 = b1 - 1
            endif
        endif
    endif
    
    
    
    
    if index0 = 4 or index0 = 5 then
        if b3 = 0 then return
        b3 = b3 - 5
    endif
endif





if enter = 1 then
pause 200
    if index0 = 0 then
    index1 = index1 + 1
        if index1 = 2 then
        index1 = 0
        r_hour      = b1
        r_min    = b2
        goto menu
        endif
    endif
    
    if index0 = 1 then
    index1 = index1 + 1
        if index1 = 2 then
        index1 = 0
        r_onhour      = b1
        r_onmin    = b2
        goto menu
        endif
    endif
    
    if index0 = 2 then
    index1 = index1 + 1
        if index1 = 2 then
        index1 = 0
        r_offhour      = b1
        r_offmin    = b2
        goto menu
        endif
    endif

    if index0 = 3 then                             ' setting date
    index1 = index1 + 1
    gosub check
    endif
    
    if index0 = 4 then
        r_htarget = b3
        goto menu
    endif
    
    if index0 = 5 then
        r_ltarget = b3
        goto menu
    endif
    
    
    
endif
return
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''    
check:  'This check module can be modified as desired. It can be alot more detailed, or more logical, or much shorter with a for loop. But it works as is.

    if b3=8 or b3=12 or b3=16 or b3=20 or b3=24 or b3=28 or b3=32 or b3=36 or b3=40 or b3=44 or b3=48 or b3=52 or b3=56 then 
        write 2,29              'Years with Feb=29 days (for 50 yrs.)
        pause 20
    else
        write 2, 28   
        pause 20
    endif
    read b2,mdays
    pause 20
    return
check_time:                                   ' update time reg
i2cread ds_sda, ds_scl, RTC, SecReg,  [secondx,minutex,hourx,wdayx,dayx,monthx,yearx]
return

firei2c: 

i2cwrite ds_sda, ds_scl, RTC, SecReg, [0,minutex,hourx,1,dayx,monthx,yearx,cntrl]
lcdout 254,1, "Entered"
lcdout 254,192, hex2 hourx,":",hex2 minutex," ",hex2 dayx,"/",hex2 monthx,"/",hex2 yearx 
pause 1000
return

convert:                            ' covert all to hex
b1 = r_hour
gosub converth
hourx = b2

b1 = r_min
gosub converth
minutex = b2

b1 = r_year
gosub converth
yearx = b2

b1 = r_month
gosub converth
monthx = b2

 b1 = r_day
gosub converth
dayx = b2

b1 = r_onmin
gosub converth
r_onmin = b2

b1 = r_onhour
gosub converth
r_onhour = b2                              'convert and to eeprom

b1 = r_offmin
gosub converth
r_offmin = b2

b1 = r_offhour
gosub converth
r_offhour = b2




return


ConvertH:                                ' convert to hex sub
b2 = b1 dig 1
b2 = b2<<4
b2 = b2+b1 dig 0
return   

save_t:
if r_htarget < r_ltarget then
lcdout 254,1, "Temp input"
lcdout 254,192, "Error"
pause 1000
goto menu
else
write 13,r_ltarget.lowbyte
pause 20
write 14,r_ltarget.highbyte                    'save to eeprom
pause 20
write 15,r_htarget.lowbyte
pause 20
write 16,r_htarget.highbyte
pause 20
write 17,r_onhour
pause 20
write 18,r_onmin
pause 20
write 19,r_offhour
pause 20
write 20,r_offmin
pause 20
endif

return                 'not sure

read_t
read 13,r_ltarget.lowbyte
pause 20
read 14,r_ltarget.highbyte                    'save to eeprom
pause 20
read 15,r_htarget.lowbyte
pause 20
read 16,r_htarget.highbyte
pause 20
read 17,r_onhour
pause 20
read 18,r_onmin
pause 20
read 19,r_offhour
pause 20
read 20,r_offmin
pause 20
return



    
            
mainloop:
gosub check_time
gosub check_temp
gosub check_sun
gosub check_level
hpwm 1,pwmheat,1000




lcdout 254,128 ,dec tempc,".",dec float,deg,"C"," ",dec daybit," ",dec3 pwmheat

LCDOut 254,192, hex2 Hourx,":",hex2 Minutex," ",hex2 dayx,"/",hex2 monthx,"/",hex2 yearx
goto mainloop



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
 
 check_temp:
  OWOut DQ, 1, [$CC, $44]       ' Start temperature conversion

waitloop: OWIn DQ, 4, [busy] 'read busy bit
if busy = 0 then waitloop
 OWOut DQ, 1, [$CC, $BE]		' skip rom read scratchpad
 OWIn DQ, 2, [r_temp.LOWBYTE, r_temp.HIGHBYTE]

'   now converting''''''''''''''''''''''''''''''''''
if cold_bit = 1 then
lcdout 254,1, "Below 0 C"
endif
dummy = 625 * r_temp
tempc = div32 10
tempc = (r_temp & $0ff0) >>4
Float = (((r_temp.lowbyte & $0f) * 625)/1000)
real_temp = (tempc * 10)+ float 
return

check_level:
if daybit = 1 then
    if  real_temp > r_htarget then
    heat_level = 0
    return
    else
    heat_level = r_htarget - real_temp
    endif
endif

if daybit = 0 then
    if real_temp > r_ltarget then
    heat_level = 0
    return
    else
    heat_level = r_ltarget - real_temp
    endif
endif
heat_level = heat_level * 10
if heat_level > 100 then
heat_level = 100
endif                    
if heat_level = 0 then
pwmheat = 0
else
pwmheat = (((heat_level / 10) * 255)/10)
endif



return




check_sun:
if r_onhour = hourx and r_onmin = minutex then
 daybit = 1
 endif
if r_offhour = hourx and r_offmin = minutex then
 daybit = 0
 endif
return
