;************************************************************************
;*	Register memory mapping file for 16c84				*
;*	by kfw								*
;************************************************************************

;main registers

w	equ	0x00		;data to w register
f	equ	0x01		;data to file register

;bank 0
indf	equ	0x00		;indirect file register
tmr0	equ	0x01		;timer0 register
pcl	equ	0x02		;program counter - low byte
status	equ	0x03		;status register
fsr	equ	0x04		;file select register
porta	equ	0x05		;porta register
portb	equ	0x06		;portb register
eedata	equ	0x08		;eeprom data
eeadr	equ	0x09		;eeprom address
pclath	equ	0x0a		;write buffer for upper 5-bits of PC
intcon	equ	0x0b		;interrupt control register

;bank 1
opt	equ	0x81		;options register
trisa	equ	0x85		;porta data direction register
trisb	equ	0x86		;portb data direction register
eecon1	equ	0x88		;eeprom control 1 register
eecon2	equ	0x89		;eeprom control 2 register

;status register bits
c	equ	0x00		;carry bit
dc	equ	0x01		;carry/borrow bit
z	equ	0x02		;zero bit
pd	equ	0x03		;power-down bit
to	equ	0x04		;watch-dog time-out bit
rp0	equ	0x05		;bank select bit
rp1	equ	0x06		;bank select bit
irp	equ	0x07		;bank select bit


;option register bits
ps0	equ	0x00		;prescaler rate select bit
ps1	equ	0x01		;prescaler rate select bit
ps2	equ	0x02		;prescaler rate select bit
psa	equ	0x03		;prescaler assignment bit
t0se	equ	0x04		;timer0 source edge select bit
t0cs	equ	0x05		;timer0 clock source select bit



;configuation word register

;config	equ	$0fxff		;configuration word register
fosc0	equ	0x00		;oscillator select bit
fosc1	equ	0x01		;oscillator select bit
wdte	equ	0x02		;watchdog enable bit
cp	equ	0x03		;code protection bit


