'****************************************************************
'*  Name    : swStack.inc                                       *
'*  Author  : Darrel Taylor                                     *
'*  Date    : 11/26/2003                                         *
'*  Version : 1.0                                               *
'*  Notes   : Software Stack for PicBasic Pro                   *
'*          : Allows up to 48 level Gosub Stack                 *
'*          :  on a PIC with an 8 level Hardware Stack          *
'*          : Tested with 16F877 on a LAB-X2                    *
'****************************************************************
'*  Many thanks to John Barrat for solving the                  *
'*    Forwand Declaration problem with nested macros            *
'****************************************************************
Stack         Var  Word[StackSize]  ' This is the Stack
StackPTR      Var  Byte     ' Pointer to Top of Stack
StackFull     Var  bit      ' if=1, you cannot do another swGosub
StackEmpty    var  bit      ' if=1, you cannot do a swReturn
SToverflow    var  bit      ' swGosub called when Stack was Full
STunderflow   var  bit      ' swReturn called when Stack was Empty
Address       Var  Word     ' internal use only

StackEmpty = 1              ' Start with an Empty Stack

goto OverStack

'------------GetAddress Macro - Location insensitive -------------------------
ASM
GetAddress macro Label, Wout       ; Returns the Address of a Label as a Word
    CHK?RP Wout
    movlw low Label
    movwf Wout
    movlw High Label
    movwf Wout + 1
    endm
ENDASM


'------------GOTO the address from a word variable.---------------------------
ASM
GotoAddress  macro Win             ; goto address specified by Win parameter
    CHK?RP   Win
    movf     Win + 1, W            
    movwf    PCLATH                ; Set PCH via PCLATH
    movf     Win, W
    RST?RP
    movwf    PCL                   ; Writing to PCL will also load PCLath
    endm                           ; into PCH
ENDASM


'------------Push Address onto the Stack--------------------------------------
Push:
    if StackFull = 0 then          ; If Stack isn't Full
       Stack[StackPTR] = Address   ; Add Address to the Stack
       StackPTR = StackPTR + 1     ; Point to next Stack level
       StackEmpty = 0              ; 0 - Since we just put something in it
    else
       SToverflow = 1              ; Stack was full, but you tried it again
    endif
    if StackPTR = StackSize then  StackFull = 1  ; Update Full status
return

'------------Pop Address from the Stack---------------------------------------
Pop:
    if StackPTR = 0 then  StackEmpty = 1  ; Update Empty status
    if StackEmpty = 0 then                ; If Stack isn't Empty
       Address = Stack[StackPTR-1]        ; Get last Address from the Stack
       StackPTR = StackPTR - 1            ; Point to Prior Stack level
       StackFull = 0                      ; 0 - Since we just removed 1
    else
       STunderflow = 1                    ; Stack was Empty on swReturn
    endif
    if StackPTR = 0 then  StackEmpty = 1  ; Update Empty status
return

'------------Gosub using Software Stack---------------------------------------
asm
swGosub  macro  Label
   local ReturnPoint                      ; Local label
     GetAddress   ReturnPoint, _Address   ; Get address of Return Point
     L?CALL       _Push                   ; Push Return Point on the Stack
     GetAddress   Label, _Address         ; Get address of the Subroutine
     GotoAddress  _Address                ; goto the Subroutine
ReturnPoint                               ; This is where swReturn will return to
     endm
endasm

'------------Return using Software Stack---------------------------------------
Asm
swReturn  macro
    L?CALL       _Pop          ; Pop last Return Point from the Stack
    GotoAddress  _Address      ; Goto the Return Point
    endm
Endasm


OverStack:

