'****************************************************************
'*  Name    : boxetimer.bas                                     *
'*  Author  : Davide Gironi                                     *
'*  Notice  : Copyright (c) 2008 Davide Gironi                  *
'*          : All Rights Reserved                               *
'*  Version : 0.2                                               *
'*  Notes   :                                                   *
'*          :                                                   *                             
'****************************************************************
INCLUDE "modedefs.bas"

DEFINE OSC 4 

W1      Var     BYTE
B0      VAR     BYTE
B1      VAR     BYTE
i       Var     Byte    ' debug use

ticks   var     byte    ' Define pieces of seconds variable
update  var     byte    ' Define variable to indicate update of LCD
timerA  VAR     BYTE
timerB  VAR     BYTE
timerS  VAR     BYTE
timerN  VAR     BYTE    ' Show the program running
reset   VAR     PORTA.4 ' reset button
timersl VAR     PORTB.7 ' timer selection
soundo  VAR     PORTA.3 ' sound out
soundgo VAR     BYTE    ' make sound by piezo - 1:beep, 2:beep, 3:beep
soundgo = 0
scale   VAR     BYTE    ' pot scale
scale = 16

timerAc  VAR    BYTE    ' Constant value for timerA
timerBc  VAR    BYTE    ' Constant value for timerB

TRISA = %00001000 'all output - 3 input
TRISB = %10000000 'all output - 7 input
    
'get the pot scale
'getscale:
'For scale = 1 To 255
'    POT timersl,scale,B0
'    If (B0 > 253) Then calibrated
'Next scale
'W1 = 999
'For i = 1 To 1000
'    GOSUB display3
'Next i 
'Stop
'calibrated:
'    For i = 1 To 1000
'        W1 = scale
'        GOSUB display3
'    Next i  
'    GOTO getscale

'get values for resistors and pot    
'valpot:
'    POT timersl,scale,B1
'    For i = 1 To 1000
'        W1 = B1
'        GOSUB display3
'    Next i
'    PAUSE 500
'    GOTO valpot

'get values for piezo freq
'piezofreq:
'    POT PORTB.7,scale,B1
'    SOUND PORTA.3,[B1,10]
'    PAUSE 500
'    GOTO piezofreq


Poke PORTA, $1F	' Turn off digit to prevent ghosting

' Set TMR0 to interrupt every 16.384 milliseconds
OPTION_REG = $55        ' Set TMR0 configuration and enable PORTB pullups
INTCON = $a0            ' Enable TMR0 interrupts
On Interrupt Goto tickint

GOSUB settimer 'set timer the first time

mainloop:
    IF(soundgo == 1) THEN
        SOUND soundo,[123,10]
        soundgo = 0    
    ENDIF
    IF(soundgo == 2) THEN
        SOUND soundo,[123,10]
        PAUSE 20
        SOUND soundo,[123,10]
        soundgo = 0    
    ENDIF
    IF(soundgo == 3) THEN
        SOUND soundo,[123,10]
        PAUSE 20
        SOUND soundo,[123,10]
        PAUSE 20
        SOUND soundo,[123,10]
        soundgo = 0    
    ENDIF
    IF(reset == 0) THEN
        PAUSE 100
        GOSUB settimer
    ENDIF
    IF(timerS == 1) THEN
        W1 = timerA
        GOSUB display3
    ENDIF
    IF(timerS == 2) THEN
        W1 = timerB
        'show only alf time (let know the user we are in timerB)
        IF(ticks < 30) THEN
            GOSUB display3
        ENDIF
    ENDIF
	GOTO mainloop


settimer:
    OPTION_REG = %10000000 ' disable option_reg
    INTCON = $80           ' disable interrupt
    
    B1 = 0
    POT timersl,scale,B1 ' read to clean the pin status
    PAUSE 100            ' wait
    POT timersl,scale,B1 ' read pot
    
    timerN = 0
    IF(B1 <= 255 AND b1 >= 243) THEN
        timerN = 1
        timerAc = 600
        timerBc = 180 
    ENDIF
    IF(B1 <= 242 AND b1 >= 219) THEN
        timerN = 2
        timerAc = 180
        timerBc = 60
    ENDIF
    IF(B1 <= 218 AND b1 >= 193) THEN
        timerN = 3
        timerAc = 120
        timerBc = 60 
    ENDIF
    IF(B1 <= 192 AND b1 >= 167) THEN
        timerN = 4      
        timerAc = 60
        timerBc = 60
    ENDIF
    IF(B1 <= 166 AND b1 >= 145) THEN
        timerN = 5
        timerAc = 60
        timerBc = 30 
    ENDIF
    IF(B1 <= 144 AND b1 >= 125) THEN
        timerN = 6
        timerAc = 40
        timerBc = 40        
    ENDIF
    IF(B1 <= 124 AND b1 >= 106) THEN
        timerN = 7
        timerAc = 30
        timerBc = 30
    ENDIF
    IF(B1 <= 105 AND b1 >= 81) THEN
        timerN = 8
        timerAc = 20
        timerBc = 20 
    ENDIF
    IF(B1 <= 80 AND b1 >= 60) THEN
        timerN = 9
        timerAc = 15
        timerBc = 15
    ENDIF
    IF(B1 <= 59 AND b1 >= 50) THEN
        timerN = 10
        timerAc = 10
        timerBc = 10
    ENDIF
    IF(B1 <= 49 AND b1 >= 41) THEN
        timerN = 11
        timerAc = 45
        timerBc = 15
    ENDIF
    IF(B1 <= 40 AND b1 >= 0) THEN
        timerN = 12
        timerAc = 30
        timerBc = 15
    ENDIF
    
    if(timerN == 0) THEN
        'reading error
        timerAc = 60
        timerBc = 60
    ENDIF
    
    For i = 1 To 2000 'show status
        W1 = timerN
        GOSUB display3
    Next i
    PAUSE 500
        
    timerA = timerAc
    timerB = timerBc
    timerS = 2 '1: timerA, 2: timerB
    
    PAUSE 500
    
    soundgo = 3
    
    ticks = 0 'reset ticks
    
    OPTION_REG = %01010101 ' enable option_reg
    INTCON = $a0           ' enable interrupt
    RETURN

	
' PICBASIC subroutine to send the binary number (0 - 999) in W1 to LEDs
display3:
	B0 = W1 / 100	' Find number of hundreds
	W1 = W1 // 100	' Remove hundreds from W1
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1B	' Turn on third digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting 
	B0 = W1 / 10	' Find number of tens
	W1 = W1 // 10	' Remove tens from W1
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1D	' Turn on second digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting 
	B0 = W1		    ' Get number of ones
	Gosub bin2seg	' Convert number to segments
	Poke PORTB, B0	' Send segments to LED
	Poke PORTA, $1E	' Turn on first digit
	Pause 1		    ' Leave it on 1 ms
	Poke PORTA, $1F	' Turn off digit to prevent ghosting
	Return		    ' Go back to caller
	
' Convert binary number in B0 to segments for LED
bin2seg:
    Lookup B0,[$40,$79,$24,$30,$19,$12,$02,$78,$00,$18],B0
	Return
	
	DISABLE
tickint:
    ticks = ticks + 1         ' Count pieces of seconds
    If(ticks < 61)Then tiexit ' 61 ticks per second (16.384ms per tick)
    ' One second elasped - update time
    ticks = 0
    IF(timerS == 1) THEN
        IF(timerA == 0) THEN
            soundgo = 2
            timerS = 2
            timerA = timerAc
        ELSE
            timerA = timerA - 1
        ENDIF
    ENDIF
    IF(timerS == 2) THEN
        IF(timerB == 0) THEN
            soundgo = 1
            timerS = 1
            timerB = timerBc
        ELSE
            timerB = timerB - 1
        ENDIF
    ENDIF
tiexit:
    INTCON.2 = 0    ' Reset timer interrupt flag
    Resume
    ENABLE
	
