'*****************************************************************************
'*****************************************************************************
' Thermostat F84 test sur EasyPic5
' Thermostat 16F877a + DS 18B20
' 1825 pas
'*****************************************************************************
'*****************************************************************************

'*****************************************************************************
'*****************************************************************************

@ __config _HS_OSC & _WDT_ON & _PWRTE_ON & _BODEN_ON & _LVP_OFF & _CP_OFF 

'*****************************************************************************
'*                  LCD Defines for EasyPic5                                 *
'*****************************************************************************
  
    DEFINE LCD_DREG PORTB               ' I/O port where LCD is connected
    DEFINE LCD_DBIT 0
    DEFINE LCD_RSREG PORTB
    DEFINE LCD_RSBIT 4                  ' Register select pin
    DEFINE LCD_EREG PORTB
    DEFINE LCD_EBIT 5                   ' Enable pin
    DEFINE LCD_BITS 4                   ' 4-bit data bus
    DEFINE LCD_LINES 2                  ' LCD has 2 character lines
 
    DEFINE OSC 8
    DEFINE BUTTON_PAUSE 100
    



Temp_Down     	VAR PortA.0    	 'Temp down button input port
Temp_Up      	VAR PortA.1    	 'Temp up button input port
G_LED         	VAR PortC.0   	  ' Green LED output cold needed
Relay_Cold		VAR PORTC.1
R_LED        	VAR PortC.6   	  ' Red LED output  hot needed
Relay_hot		VAR PortC.7
DQ           	VAR PortE.2   	  ' One-wire Data-Pin "DQ" on PortE.2


'Temp_Down    	VAR PortB.3    	 'Temp down button input port
'Temp_Up       	VAR PortB.2    	 'Temp up button input port
'R_LED        	VAR PortB.0   	  ' Red LED output
'G_LED        	VAR PortB.1   	  ' Green LED output
'DQ            	VAR PortC.0   	  ' One-wire Data-Pin "DQ" on PortC.0
'

'*****************************************************************************
'LCD DEFINES for PICBOARD
'*****************************************************************************

'	DEFINE LCD_DREG	PORTD
'	DEFINE LCD_DBIT	4
'	DEFINE LCD_RSREG PORTE
'	DEFINE LCD_RSBIT	0
'	DEFINE LCD_EREG	PORTE
'	DEFINE LCD_EBIT	1
'
'    DEFINE OSC 8
'    DEFINE BUTTON_PAUSE 100

'Temp_Down     	VAR PortA.0    	 'Temp down button input port
'Temp_Up      	VAR PortA.1    	 'Temp up button input port
'G_LED         	VAR PortC.0   	  ' Green LED output cold needed
'Relay_Cold		VAR PORTC.1
'R_LED        	VAR PortC.6   	  ' Red LED output  hot needed
'Relay_hot		VAR PortC.7
'DQ           	VAR PortE.2   	  ' One-wire Data-Pin "DQ" on PortE.2
'

'*****************************************************************************
' Variables
'*****************************************************************************

delay         	VAR BYTE       	 'Button working variable
Loscale			VAR BYTE
Hiscale			VAR BYTE
Decal			VAR BYTE

Tempeff			VAR WORD
Setpoint      	VAR WORD
R_Temp        	VAR WORD        	' RAW Temperature readings
TempC         	VAR WORD        	' Temp in deg C
Float         	VAR WORD       	' Holds remainder for + temp C display

ColdStart		VAR BIT
Sign			VAR BIT

'*****************************************************************************
'Configs
'*****************************************************************************

ADCON1 = 7			          	' Set PORTD and PORTE to digital
CMCON  = 7						' Comparators OFF

PORTA = %00000011
PORTB = 0
PORTC = 0
PORTD = 0
PORTE = 0

TRISA = %00000011
TRISB = 0
TRISC = 0
TRISD = 0
TRISE = %00000010


DS18B20_9bit  CON %00011111   	' 93.75ms, 0.5C
DS18B20_10bit CON %00111111   	' 187.5ms, 0.25C  <-- My favorite
DS18B20_11bit CON %01011111   	' 375ms,   0.125C
DS18B20_12bit CON %01111111   	' 750ms,   0.0625C  (default)

'*****************************************************************************
'Initialization
'*****************************************************************************
   
Setpoint = 200                                  'Default setpoint on start up
ColdStart = 1

    LCDOut  $FE,1                                     'Clear LCD     
    PAUSE 750
    
'Chargement motifs en CGRAM

  LCDOUT  $FE,$40,$00,$00,$00,$00,$00,$04,$04,$04  ' Cust Char #0
  LCDOUT  $FE,$48,$00,$00,$00,$04,$04,$04,$04,$04  ' Cust Char #1
  LCDOUT  $FE,$50,$04,$04,$04,$04,$04,$04,$04,$04  ' Cust Char #2
  LCDOUT  $FE,$58,$04,$04,$0E,$0E,$0E,$1F,$1B,$11  ' Cust Char #3
  LCDOUT  $FE,$60,$11,$1B,$1F,$0E,$0E,$0E,$04,$04  ' Cust Char #4
  LCDOUT  $FE,$68,$04,$04,$0E,$1F,$1F,$0E,$04,$04  ' Cust Char #5

  
  OWOUT DQ, 1, [$CC, $4E, 0, 0, DS18B20_10bit]    'Skip ROM search and write N_bits
  '                                                 resolution to scratch pad
        
'*****************************************************************************
'Program beginning
'*****************************************************************************
   
Start_Convert:

    OWOUT   DQ, 1, [$CC, $44]                       ' Skip ROM search & start temp conversion
    
    
    delay = 0
    Button Temp_Up,   0, 255, 0, delay, 1, Up_Loop1
    button Temp_Down, 0, 255, 0, delay, 1, Down_Loop1  
    
'*****************************************************************************
' Check for still busy converting ( ~ 4500 fois ... )
'*****************************************************************************

waitloop: 

	WHILE NOT DQ
	WEND
		
    
    OWOUT   DQ, 1, [$CC, $BE ]                       ' Skip ROM search & read scratchpad 														memory
    OWIN    DQ, 2, [R_Temp.Lowbyte, R_Temp.Highbyte]' Read two bytes / end comms
      
Convert_Temp:                                       

	IF R_Temp.15 THEN
	
		 R_Temp = ~R_Temp + 1
		 Sign = 1									'Signe -
		 
	ELSE			                       
	
   		 Sign = 0									'Sign  = "+"
   		 
   	ENDIF
   	
												
    TempC =  ( R_Temp & $7FF ) >> 4   				' Partie Entire
                  
    Float = ((R_Temp.Lowbyte & $0F ) * 25 )>> 2     ' Partie dcimale 100mes
    
    Tempeff = TempC*10 + Float/10					'Prparation 1/10 degrs

	gosub Aff
       
 GOTO    Start_Convert								' Let's go for another measure
    
                                                                 
Up_Loop:

    IF Temp_Up = 0 THEN
    
    	IF Temp_Down = 0 THEN Setpoint = 200 : GOTO Up_Loop1
        Setpoint = Setpoint + 5
        
Up_Loop1:											' Show only at first call

	 	lcdout $fe, $C0, "Setpoint = ", DEC2 (Setpoint/10),".",DEC1(SetPoint // 10)," " 
	 	Pause 700
	 
        Gosub Show
    Else
        Goto Start_Convert
    Endif
    
    GOTO Up_Loop
    
    
Down_Loop:
                
    IF Temp_down = 0 THEN
    
        IF Temp_Up = 0 THEN Setpoint = 200 : GOTO Down_Loop1
        Setpoint = Setpoint - 5
        
Down_Loop1:											' Show only at first call

	 	lcdout $fe, $C0, "Setpoint = ", DEC2 (Setpoint/10),".",DEC1(SetPoint // 10)," " 
	 	Pause 700
	 
        Gosub Show
    Else
        Goto Start_Convert
    Endif
    
    GOTO Down_Loop   
   


'*****************************************************************************
'*****************************************************************************
'                              AFFICHAGE
'*****************************************************************************
'*****************************************************************************

'Motifs

'Small bar     LCDOUT  $FE,$40,$00,$00,$00,$00,$00,$04,$04,$04  ' Cust Char #0
'Mid bar       LCDOUT  $FE,$48,$00,$00,$00,$04,$04,$04,$04,$04  ' Cust Char #1
'Big bar       LCDOUT  $FE,$50,$04,$04,$04,$04,$04,$04,$04,$04  ' Cust Char #2
'Arrow 		   LCDOUT  $FE,$58,$04,$04,$0E,$0E,$0E,$1F,$1B,$11  ' Cust Char #3
'Inv Arrow     LCDOUT  $FE,$60,$11,$1B,$1F,$0E,$0E,$0E,$04,$04  ' Cust Char #4
'Diamond	   LCDOUT  $FE,$68,$04,$04,$0E,$1F,$1F,$0E,$04,$04  ' Cust Char #5

'*****************************************************************************
Aff:'Affichage temp
'*****************************************************************************

'prparation chiffre : sign = 1 = valeur ngative

Decal	= ( TempC // 5 ) << 1 

IF NOT sign THEN

	Loscale = ( TempC /5 ) * 5 
	Hiscale = (( TempC /5 ) + 1) * 5
	
	IF Float > 25 AND Float <= 75 then Decal = Decal + 1
	IF Float > 75 Then Decal = Decal + 2
	
ELSE

	Loscale = (( TempC /5 + 1 ) * 5) * -1  
	Hiscale = ((TempC /5) * 5 )* -1 
	Decal = 10 - Decal
	
	IF Float > 25 AND Float <= 75 then Decal = Decal - 1
	IF Float > 75 Then Decal = Decal - 2
	
		TempC = TempC * -1
		
ENDIF


'Impression valeurs 1re ligne

IF Sign THEN

  LCDOUT	$FE, $80 ,SDEC2 Loscale,178,"C"
  IF TempC = 0 THEN LCDOUT "-" 
  LCDOUT SDEC TempC,".",dec2 Float
  IF ABS TempC < 10 then LCDOUT " "
  LCDOUT $FE,$80 + 11,SDEC2 Hiscale,178,"C"
  
ELSE
  
  LCDOUT	$FE, $81 ,SDEC2 Loscale,178,"C ",SDEC TempC,".",dec2 Float
  IF TempC < 10 then LCDOUT " "
  LCDOUT $FE,$80 + 12,SDEC2 Hiscale,178,"C" 
  
ENDIF 
  
  
'Impression chelle 2me ligne

 LCDOUT	$FE,$C0,$01,$00,$02,$00,$01,$00,$01,$00,$01,$00,$01,$00,$02,$00,$01,$00
  
'Impression index

 IF Tempeff < ( Setpoint - 5 ) THEN
 
	LCDOUT	$FE, $C2 + Decal,$03				'Index Chauffage
	
 ELSE
 
 	IF Tempeff > ( Setpoint + 5 ) THEN
 	
		LCDOUT	$FE, $C2 + Decal,$04				' Index Refroidissement
	
	ELSE
	
		LCDOUT	$FE, $C2 + Decal,$05				' Index Zone neutre
		
	ENDIF
	
ENDIF

Show:

 IF Tempeff < Setpoint THEN
   
	high R_LED                                   ' Turn on Red LED C0  and turn off Green 														LED C6
	low G_LED
	
	IF Coldstart THEN Relay_hot = 1 : Relay_cold = 0 : Coldstart = 0
                       
 ELSE
	
    High G_LED                                   ' Turn on Green LED C6 and turn off Red 														LED C0
    low R_LED
    
    IF Coldstart THEN Relay_hot = 0 : Relay_cold = 1 : coldstart = 0
                           
 ENDIF
  
'*****************************************************************************
Drive:
'*****************************************************************************
 	
	IF Tempeff < (Setpoint - 5) AND Relay_hot = 0 THEN Relay_hot = 1 : Relay_cold = 0  'C7
	  
	IF Tempeff > (Setpoint + 5) AND Relay_cold = 0 THEN Relay_hot = 0 : Relay_cold = 1	'C1
	  
RETURN

    END
