; ***************************************
; * Proximity kaardiga lukk Tipi jaoks  
; * felch@staff.ttu.ee				    
; 22.8.: mtsin kokku proximity ja siililuku softid. Natuke nagu ttab.. Seivib max. 31 kaarti. Saaks suurendada kui kaardis vtta 3 baiti nagu tegelikult.
; 24.8.: vrdlemise viga jpt. parandet. OK.
; 25.8.: INIT-ISSE viide ja ootab et DAT-otsad krgeks lheksid. Tunduvalt parem!
; 10.10.: avatuse aeg lhemaks (2s)
; ***************************************    
	INCLUDE "P12F629.inc"
	Errorlevel -302, -305
; ***** Definitions ***** 
max_kaarte_kokku	equ		0x1F				; suudame salvestada 31 kaardi numbrid	
; ***** constants *******
#define MaxBits		.36							; niimitut bitti ootame
#define MaxBytes	.5							; niimitut baiti ootame
#define T1timeL		00h							; lugejale pikem viide: 132mS
#define T1timeH		00h
; ***** Hardware ******** 
#define Dat0			GPIO,5					; Wiegandi D0 juhe (RF-10 lugejal roheline)
#define Dat1	      	GPIO,4	                ; Wiegandi D1 juhe (RF-10 lugejal valge)
#define	Lukk			GPIO,0					; Luku juhtotc, aktiivne LOW
#define	Register		GPIO,3					; Kaardi regamise nupp, aktiivne LOW
#define LED				GPIO,2					; Kaardilugeja LED, aktiivne LOW
#define	Cancel			GPIO,1					; Kaardi kustutamise nupp, aktiivne LOW
; ***** various flags ***
;#define	pulss			flags,2					; 1 kui pulss algas/kestab
#define	viga			flags,0					; 1 kui aega linud le 132mS aga bitid pole kohal
#define dataok		    flags,1                 ; 1 kui 36 bitti vastu vetud
#define CARRY           STATUS,C 
#define ZERO            STATUS,Z 
#define	pank			STATUS,RP0
; ***** RESET *****          
				org     0000h  
 	__CONFIG _INTRC_OSC_NOCLKOUT & _PWRTE_ON & _BODEN_ON & _MCLRE_OFF & _WDT_OFF & _CP_OFF & _CPD_OFF   
	
; ***** Variables Definitions *****    
RAMbase         equ     20h            
	cblock  	RAMbase                 
				W_Temp
				S_Temp
				flags                 
				temp0                 
				temp1                 
				temp2                 
				temp3 
				temp4                 
				temp5 
				tmp
				baitcount
				bitcount
				count
				temp
				dataport
				count1
				count2
				bitcnt			
				cards_regd						; niimitut kaarti ssteem tunneb (registreeritud)
		endc 
; ***** aadressid EEPROMis **************          
#define E_CARD0	        	0x00				 ; kaart 1
#define E_CARD1	        	0x04				 ; kaart 2
#define E_CARD2	        	0x08				 ; kaart 3
#define E_CARD3	        	0x0C				 ; kaart 4
#define E_CARD4	        	0x10				 ; kaart 5
#define E_CARD5	        	0x14				 ; kaart 6
#define E_CARD6	        	0x18				 ; kaart 7
#define E_CARD7	        	0x1C				 ; kaart 8
#define E_CARD8	        	0x20				 ; kaart 9
#define E_CARD9	        	0x24				 ; kaart 10
#define E_CARD10        	0x28				 ; kaart 11
#define E_CARD11        	0x2C				 ; kaart 12
#define E_CARD12        	0x30				 ; kaart 13
#define E_CARD13        	0x34				 ; kaart 14
#define E_CARD14        	0x38				 ; kaart 15
#define E_CARD15        	0x3C				 ; kaart 16
#define E_CARD16        	0x40				 ; kaart 17
#define E_CARD17        	0x44				 ; kaart 18
#define E_CARD18        	0x48				 ; kaart 19
#define E_CARD19        	0x4C				 ; kaart 20
#define E_CARD20        	0x50				 ; kaart 21
#define E_CARD21        	0x54				 ; kaart 22
#define E_CARD22        	0x58				 ; kaart 23
#define E_CARD23        	0x5C				 ; kaart 24
#define E_CARD24        	0x60				 ; kaart 25
#define E_CARD25        	0x64				 ; kaart 26
#define E_CARD26        	0x68				 ; kaart 27
#define E_CARD27        	0x6C				 ; kaart 28
#define E_CARD28        	0x70				 ; kaart 29
#define E_CARD29        	0x74				 ; kaart 30
#define E_CARD30        	0x78				 ; kaart 31
;#define E_CARD31        	0x7C				 ; kaart 32
#define E_next_free			0x7C				 ; esimese vaba kaardikoha aadress
#define	E_cards_regd		0x7D				; niimitu kaarti regatud
				org H'2100' 					; EEPROM'i vaikevrtused
				de 0x0F,0x2D,0x02,0x9F,0x0F,0x2D,0x02,0x82	; esimese 2 kaardi numbrid...on thjad
				de 0x0F,0x2D,0x02,0x81,0x0F,0x2D,0x02,0xA0	

				de 0x0F,0x2D,0x05,0x18,0x0F,0x2D,0x04,0x14	
				de 0x0F,0x2D,0x02,0x80,0x0F,0x2D,0x06,0x4E	

				de 0x0F,0x2D,0x02,0x8A,0x0F,0x2D,0x05,0x20	
				de 0x0F,0x2D,0x04,0x01,0x0F,0x2D,0x02,0x7F	

				de 0x0F,0x2D,0x05,0x54,0x0F,0x2D,0x02,0x01	
				de 0x0F,0x2D,0x05,0xCE,0x0F,0x2D,0x04,0x02	

				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	
				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	

				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	
				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	

				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	
				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	

				de 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00	
				de 0x00,0x00,0x00,0x00
				de 0x40										; 1. vaba koha aadress
				de 0x10										; registreeritud 0 kaarti

Reset:     		org		0x0000	
				goto    Main_Start       		; Alustame siis...
; ***** INTERRUPT *****  
; *************************************************************
; * T1 loeb pulsside kestust. >132mS => viga, lipp psti		  *
; *************************************************************
Interrupt:    	org     0004h 
Push:    		movwf   W_Temp           		; Save W         
				swapf   STATUS,W         
				movwf   S_Temp           		; Save STATUS         
				bcf     STATUS,RP0      		; Select Bank 0 
;				movf	GPIO,W
;				movwf	dataport
Disable_Int:   	bcf     INTCON,GIE       		; keela katckestused        
				btfsc   INTCON,GIE       		       
				goto    Disable_Int      		
         
				btfsc	INTCON,GPIF				; mingi daataots liigutas ennast?
				goto	daatatuleb				; jepp
				btfsc   PIR1,TMR1IF      		; Taimer1 (pulsiseeria pikkus)?         
				goto    Timer_Int        		; jah, anna viga
Pop:   			swapf   S_Temp,W         
				movwf   STATUS           		; Return STATUS         
				swapf   W_Temp,F         
				swapf   W_Temp,W         		; Return W         
				retfie                   		; vlja siit, jta intsid lubatux (GIE  !)
; *************************************************************************************************************
; ************************ GPIF datasisendite Interrupt *******************************************************
; *************************************************************************************************************
daatatuleb:		bsf		T1CON,TMR1ON			; taimer 1 paketi kestust valvama
				movf	GPIO,W
;				movwf	dataport
				bcf		INTCON,GPIF
				movf	baitcount,W 			; arvuta jooxva biti salvestamiseks vajaliku registri aadress
				sublw	temp4+.1
				movwf	FSR						; kirjutame sinna kaudselt
				btfss	Dat0					; daata 0 liigutas?
				goto	data0					; ttle 
; **** data 1 liigutas ****
				btfss	Dat1					; daata 1 liigutas?
				goto	data1					; ttle
				goto	Pop
data2:			movf	count,W					; 8 bitti tehtud?
				btfsc	ZERO
				goto	data6					; jah, lae uuesti
				decf	count,F					; ei, vhenda
				goto	data7

data6
				movlw	.7						; jah, taasta count
				movwf	count
				decf	baitcount,F
data7	
				decfsz	bitcount
				goto	Pop
data8
				bsf		dataok					; valmis!
				bcf		CARRY
				rlf		temp4,F					; korrigeerib viimast baiti
				rlf		temp4,F
				rlf		temp4,F
				rlf		temp4,F
;				rlf		temp3,F
;				rlf		temp3,F
				bcf		CARRY
				rlf		temp4,F
				rlf		temp3,F
				rlf		temp2,F
				rlf		temp1,F
				rlf		temp0,F
				movf	GPIO,W				
;				bcf		INTCON,GPIF
				bcf		INTCON,GPIE				; katkestus keelata kuni kaart tdeldud (ttleb, teeb reseti ja siis...)
				goto 	Pop
; **** data 1 ots liigutas ****
data1:			bsf		CARRY					; saime he
				goto	data0b					; kirjuta
; **** data 0 ots liigutas ****
data0:			bcf		CARRY				; saime nulli
; **** kirjutab dataflagis oleva pulsi mllu ****
data0b:			rlf		INDF,F					; nihuta kaardi bitt registrisse card_dat_x sisse
				goto	data2					; jtkame

; **** aeg sai otsa aga pulsse ikka pole (kiki)				
Timer_Int                                            
				bcf     STATUS,RP0      		; pank 0		 
				bcf     PIR1,T1IF    			; katkestuse nue maha   
				bcf		T1CON,TMR1ON			; stop taimer 1
				bsf		viga        			; vea lipp psti
				bsf     STATUS,RP0      		; pank 1		 
 				bcf     PIE1,T1IE 	    		; keela Timer1 Interruptsid
				bcf     STATUS,RP0      		; pank 0		 
				goto	Pop 
; *************************************************************************************************************
; ************************ ja hakkab pihta... *****************************************************************
; *************************************************************************************************************
Main_Start:		call	Init					; majapidamine korda
Main:			btfsc	Cancel					; mlemad nupud korraga vajutatuna avavad uxe
				goto	main_next				; ei ole korraga!
				btfss	Register
				goto	main_open				; lahtiste ukste pevake
main_loop:      btfsc	viga					; kik ok?
				goto	Main_7					; ei, siis vilguta ja tmba vesi peale
main_next:		btfss	dataok					; kaart loetud?
				goto	Main					; vara veel
				bcf		INTCON,GIE
				bcf		dataok					; loetud !!!
		      	btfsc	viga					; kik ok?
				goto	Main_7					; ei, siis vilguta ja tmba vesi peale
;				call	process					; tee kaardi numbriks
				
Main_1:			bcf		LED						; tuli plema
				btfsc	Register				; salvestame numbri?
				goto	Main_2
				call	reg_card				; salvesta number kui vabu kohti on
Main_exit:		bsf		LED						; tuli kustu
				goto    Main_Start         		; reset
Main_2:			btfsc	Cancel					; kustuta kaart?
				goto	Main_3					; seda ka mitte, vist taheti ust avada
				call	clear_card				; kustuta kaart
				goto	Main_exit
Main_3:			call	card_comp				; aga enna vaata, kas on ige kaart
				btfss	CARRY
				goto	Main_7					; vale matci tuppa ei lase
main_open:		bcf		INTCON,GIE
				bcf		LED
				bcf		Lukk					; uks lahti
				movlw	.16						; 16*131mS (2 sekundit) lahti
				movwf	count
Main_4:			clrf	TMR1L
				clrf	TMR1H
				bcf		PIR1,TMR1IF
				bsf		T1CON,TMR1ON
Main_5:			btfss	PIR1,TMR1IF
				goto	Main_5
				decfsz	count
				goto	Main_4
				goto	Main_6					; uksed lukku!
Main_7:			movlw	0x03					; vilgutame tuld 3*
				call	blink_W
Main_6:			bsf		Lukk					; uks kinni
				bsf		LED						; lase tuli ra ja
				goto	0x0000;Main_Start				; reset
; *************************************************************************************************************
; ************************ Funkcioonid ************************************************************************
; *************************************************************************************************************
; *************************************************************************************************************
; ***** tee temp0...temp4 kaardi numbriks; binary ja -> temp0 ... temp4 *****  
; *************************************************************************************************************
process:         								; esiteks teisendame saadud joru igeks binary koodiks
;				return
;				bcf		CARRY					; valmistume 1. baidi lugemiseks
;				rlf		temp0,F					; viskame EVEN paarsuse biti le parda
;				bcf		CARRY					; valmistume 2. baidi lugemiseks
;				rlf		temp1,F					; jlle nihe
;				btfsc	CARRY					; kas temp0-i tuleb 1 vi 0 ?
;				bsf		temp0,0					; oli 1
;				bcf		CARRY					; nii vi naa, jtkame 3.baidiga
;				rlf		temp2,F					; jlle nihe
;				btfsc	CARRY					; kas temp1-i tuleb 1 vi 0 ?
;				bsf		temp1,0					; oli 1
;				bcf		CARRY					; jtkame 4.baidiga
;				rlf		temp3,F					; nihe...
;				btfsc	CARRY					; kas temp2-i tuleb 1 vi 0 ?
;				bsf		temp2,0					; oli 1
;				return
; *************************************************************************************************************
; ****** Vrdle kaardi numbrit salvestatutega, Cy=1 kui ige kaart ********************************************
; *************************************************************************************************************
card_comp:		movf	cards_regd,W			; kontrollime niipalju numbrikomplekte
				btfsc	ZERO
				goto	c_comp_err1				; ei olegi regatud kaarte, rock off ;)				
				movwf	count
				movlw	.4						; numbrit kaardi koodis
				movwf	count1
				movlw   temp0		       		; loetud kaardi info puhvri pointer
				movwf   FSR             		
				movlw	E_CARD0					; EEPROMi pointer
				movwf	count2
c_comp_1:		bsf		pank	
				movwf	EEADR
				bsf		EECON1,RD			 	; loe bait!
				movf	EEDATA,W
				bcf     pank
				movwf	tmp
				movf	INDF,W					; kaardi number
				subwf	tmp,W					; vrdleme
				btfss	ZERO	
				goto	c_comp_err				; ei klapi, vta jrgmine number EEPROMist
				incf	FSR						; sobib, vrdleme edasi
				incf	count2
				movf	count2,W
				decfsz	count1					; kaardi number le vaadatud?
				goto	c_comp_1				; ei veel
				bsf		CARRY					; jah, oli ige kaart kah, liputame carry't
				return
c_comp_err:		decfsz	count					; kik komplektid le vaadatud?
				goto	c_comp_e2				; ei veel
c_comp_err1:	bcf		CARRY					; jah, ei leitud vastavusi -> vale kaart
				return
c_comp_e2:		movlw	temp0					; vaatame kaarti jlle algusest
				movwf	FSR
				movlw	.4						; kaardis endiselt 14 baiti
				movwf	count1
				movf	count,W					; arvutame uue komplekti aadressi EEPROMis
				subwf	cards_regd,W
				movwf	tmp
				clrf	count2
				movlw	0x04
c_comp_e3:		addwf	count2,F
				decfsz	tmp
				goto	c_comp_e3
				movf	count2,W
				goto	c_comp_1				; ja kukume vrdlema
				return
; *************************************************************************************************************
; ************************ salvestab loetud kaardinumbri EEPROMi **********************************************
; *************************************************************************************************************
reg_card:		movf	cards_regd,W			; kas ruumi on uuele kaardinumbrile?
				sublw	max_kaarte_kokku
				btfsc	ZERO
				goto	reg_0					; ei, kik on tis...
				movlw	E_next_free				; vaatame, kuhu kaardi numbri kirjutada annaks
				bsf		pank	
				movwf	EEADR
				bsf		EECON1,RD			 	; loe vaba mlu aadress
				movf	EEDATA,W
				bcf     pank
				movwf	tmp						; ajutine seiv
;				sublw	E_next_free				; mlu tis (viitab ssteemimuutuja pesale)?
;				btfss	ZERO
				goto	reg_1					; ruumi on
reg_0:			movlw	0x04					; tis jah, ei salvesta
				call	blink_W					; vilguta tulukest vea mrgiks
				return
			
reg_1:;			bcf		INTCON,GIE				; 
				movlw	0x04					; kirjutame 8 baiti
				movwf	count1
				movlw   temp0		       		; loetud kaardi info puhvri pointer
				movwf   FSR             		
reg_2:			movf	tmp,W					; taasta aadress
				bsf     pank 
				movwf	EEADR	
				bcf		pank
				movf	INDF,W					; loe kaardibait
				incf	FSR
				bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
reg_3:			btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	reg_3
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
				incf	tmp						; jrgmine EEPROMi aadress
				decfsz	count1					; tsykelda kuni 4 baiti kirjutatud
				goto	reg_2	
				movlw	E_next_free				; vrskendame vaba aaadressi viita
				bsf		pank	
				movwf	EEADR
				bcf		pank	
		 		movf	tmp,W
				bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
reg_4:			btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	reg_4
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
				incf	cards_regd,F			; nd 1 kaart rohkem
				movlw	E_cards_regd			; kirjutame EEPROMi kah
				bsf		pank
				movwf	EEADR
				bcf		pank
				movf	cards_regd,W
				bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
reg_5:			btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	reg_5
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
;				bsf		INTCON,GIE				; katkestused jlle ok
				call	delay					; las LED pleb natca	
				return  
; *************************************************************************************************************
; ************************ kustutab kaardinumbri EEPROMist ****************************************************
; *************************************************************************************************************
clear_card:		movf	cards_regd,W			; kas kaarte ldse on regatud?
				btfsc	ZERO
				goto	c_card_err				; ei, siis ei ole midagi kustutada, tulguta vilesid ja rock off ;)
				call	card_comp				; kas sellist kaarti ldse tuntakse?
				btfss	CARRY
				goto	c_card_err				; ei, vilgutame tuld ja anname tuld ;)
				movf	count2,W				; count2 viitab nd esimesele mber tsteatava baidi aadressile EEPROMis
				bsf		pank					
				movwf	EEADR					; see aadress EEPROMi
				bcf		pank
				movlw	0x04					; tstame 
				subwf	count2,W				; ja count teisaldatavate kaardinumbri kvartettide arvule
				movwf	bitcnt					; sihtkoha aadress
c_card_0:		movlw	0x04					; 4 baidi kaupa
				movwf	count1
c_card_1:		movf	count2,W				; count2 viitab nd esimesele mber tstetatava baidi aadressile EEPROMis
				bsf		pank					
				movwf	EEADR					; see aadress EEPROMi
				bsf		EECON1,RD			 	; loe bait!
				movf	EEDATA,W
				bcf     pank
				movwf	tmp						; ajutine seiv				
				movf	bitcnt,W				
				bsf		pank					
				movwf	EEADR					; sihtkoha aadress EEPROMi
				bcf		pank
				movf	tmp,W					; info
				bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
c_card_2:		btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	c_card_2
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
				incf	count2,F
				incf	bitcnt,F				; inkrementeerime EEPROMi viitasid
				decfsz	count1
				goto	c_card_1
				decfsz	count
				goto	c_card_0
; ssteemile teada olevate kaartide arvu arvutamine
				decf	cards_regd,F			; nd ssteemis 1 kaart vhem
				movlw	E_cards_regd			; EEPROMi kirja uus kaartide arv	
				bsf		pank	
				movwf	EEADR
				bcf		pank	
				movf	cards_regd,W
				bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
c_card_4:		btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	c_card_4
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
; uue vaba mlu viida arvutamine
				movlw	E_next_free				; uus vaba mlu aadress EEPROMi
				bsf		pank	
				movwf	EEADR
				bcf		pank	
				movf	cards_regd,W			; uus aadress=cards_regd * 4
				btfsc	ZERO					; ei htegi?
				goto	c_card_5				; ei htegi!
				goto	c_card_6
c_card_5:		clrw
				goto	c_card_7
c_card_6:		movwf	tmp
				clrw
c_card_6a:		addlw	0x04
				decfsz	tmp
				goto	c_card_6a
c_card_7:		bsf     pank 
				movwf	EEDATA
				bsf		EECON1,WREN				; luba kirjutamine
				movlw	55h						; lukust lahti
				movwf	EECON2
				movlw	0AAh
				movwf	EECON2
				bsf		EECON1,WR					
c_card_3:		btfsc	EECON1,WR 				; ootame kirjutamise lppu
				goto	c_card_3
				bcf		EECON1,WREN				; keela kirjutamine
				bcf     pank 
				return  
c_card_err:		movlw	0x03					; vilgutame tuld 3*
				call	blink_W
				return
; *************************************************************************************************************
; ************************ vilgutame LEDi W korda *************************************************************
; *************************************************************************************************************
blink_W:		bcf		INTCON,GIE
				movwf	count2
blink_1:		bcf		LED
				call	delay_a
				bsf		LED
				movlw	0x01
				call	delay
				decfsz	count2
				goto	blink_1
				return
; *************************************************************************************************************
; *************************	Wiide W*1/2 sekundit **************************************************************		       
; *************************************************************************************************************
delay_a:		movlw	.1
				movwf	count1
				goto	delay_1
delay:			movlw	.4
				movwf	count1
delay_1			clrf	TMR1L
				movlw	0x77
				movwf	TMR1H
				bcf		PIR1,TMR1IF
				bsf		T1CON,TMR1ON
delay_2:		btfss	PIR1,TMR1IF
				goto	delay_2
				bcf		T1CON,TMR1ON
				decfsz	count1
				goto	delay_1
				return
; *************************************************************************************************************
; *************************	Majapidamine korda ****************************************************************		       
; *************************************************************************************************************
; **** kalibreeri sisemine gener ****
Init:			bsf     STATUS,RP0      		 
				call 	3FFh 					
				movwf 	OSCCAL 					; Kalibreeri sisemine taktigene
; **** taimerid ****
				bcf     STATUS,RP0      		; pank 0 
				bcf     INTCON,T0IE     		; keela Timer0 Interruptsid
				bcf     INTCON,T0IF            
; **** konf ****
				bsf     STATUS,RP0      		; pank 1 
				movlw   b'00000000'         
				movwf   OPTION_REG      		; 1:1 prescaler T0-le, sisemine takt, WPU lubatud 
; **** pordid ****
				bcf     STATUS,RP0      		; pank 0 
				clrf	GPIO					; pordid nulli
				movlw 	07h 					; analoog komparaator vlja
				movwf 	CMCON 
				bsf     STATUS,RP0      		; pank 1 
				movlw	3Ah						; 
				movwf 	TRISIO 
				movlw	3Ah						; WPU-d
				movwf	WPU
				movlw	30h						; int on change kaardilugeja otstele
				movwf	IOCB
				bcf     STATUS,RP0      		; pank 0 
				movlw	3Fh						; port sellisesse lhteseisu
				movwf 	GPIO 
				call	delay_a					; oota tibakene (35mS)
; **** variaablid ****
				clrf	temp0	      		
				clrf	temp1	      		
				clrf	temp2	      		
				clrf	temp3
				clrf	temp4
				clrf	temp5
				movlw	MaxBits	      		
				movwf	bitcount
				movlw	MaxBytes
				movwf	baitcount
				movlw	7
				movwf	count
				clrf	flags    		
; **** kaardid ****
				movlw	E_cards_regd			; registreeritud kaartide arv
				bsf		pank	
				movwf	EEADR
				bsf		EECON1,RD			 	; loe 
				movf	EEDATA,W
				bcf     pank
				movwf	cards_regd				; kirjuta ssteemi muutujax
; **** ootab, kuni lugeja viigud krged ****
init_1:			btfss	Dat0
				goto	init_1
				btfss	Dat1
				goto	init_1
; **** katkestused ****
				bsf		INTCON,PEIE				; luba peripheral ints
				bcf		INTCON,T0IE				; clear int. flags
				movf	GPIO,W					; read port to reset int condition
				bcf		INTCON,GPIF				; port change flag
				bsf		INTCON,GPIE				; enable port on change int
; **** Timer 1 ****
				movlw	b'00010100'				; 1/2 prescaler, int osc, seisma
				movwf	T1CON
				bcf		PIR1,TMR1IF				; letit. lipp
				bsf     STATUS,RP0      		; pank 1 
				bsf		PIE1,TMR1IE				; luba T1 int
				bcf     STATUS,RP0      		; pank 0 
				movlw	T1timeL					; lae T1
				movwf	TMR1L
				movlw	T1timeH
				movwf	TMR1H
; **** lubame intsid ****
				bsf     INTCON,GIE        		; Enable Interrupts Global 
    			return  

				org		03FFh
				retlw	b'10010100'				; dummy OSCCAL
	END  
