GOTO OVER_SUBS

'--- INITIALIZE LCD ------------------------------------------------------------
LCD_INIT_SUB:
 DelayMS 50        ' DELAY 50MS AFTER VDD IS ON
 Low LCD_RST       ' RESET PIN ACTIVE LOW
 DelayMS 50        ' KEEP RESET PIN LOW
 High LCD_RST      ' REVERT FROM RESET CONDITION
' Low LCD_CS        ' ENABLE LCD
 Low LCD_DC
 SHOut LCD_SDIN,LCD_CLK,msbfirst,[$21,$C8,$02,$5,$20,$0C] '[$21,$C8,$06,$13,$20,$0C]
 High LCD_DC
RETURN
'-------------------------------------------------------------------------------

'--- CLEAR SCREEN --------------------------------------------------------------
LCD_CLEAR_SUB:
 High LCD_DC
 For TEMP = 1 To 504
  LCD_CMD=0
  SHOut LCD_SDIN,LCD_CLK,msbfirst,[LCD_CMD]
 Next
 clrf LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- SCREEN NORMAL MODE --------------------------------------------------------
LCD_NORMAL_SUB:
 Low LCD_DC
 LCD_CMD = %00001100
 SHOut LCD_SDIN,LCD_CLK,msbfirst,[LCD_CMD]
 High LCD_DC
 clrf LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- ACTIVATE ALL SEGMENTS -----------------------------------------------------
LCD_SEGMENTS_SUB:
 Low LCD_DC
 LCD_CMD = %00001001
 SHOut LCD_SDIN,LCD_CLK,msbfirst,[LCD_CMD]
 High LCD_DC
 clrf LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- SET CURSOR X POSITION -----------------------------------------------------
LCD_CURSORX_SUB:   ' 0 <= X <= 83
 LOW LCD_DC
 LCD_CMD = 0x80 + XPOS
 SHOUT LCD_SDIN, LCD_CLK, MSBFIRST, [LCD_CMD]
 HIGH LCD_DC
 CLRF LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- SET CURSOR Y POSITION -----------------------------------------------------
LCD_CURSORY_SUB:   ' 0 <= Y <= 5 LINES
 LOW LCD_DC
 LCD_CMD = 0x40 + YPOS
 SHOUT LCD_SDIN, LCD_CLK, MSBFIRST, [LCD_CMD]
 HIGH LCD_DC
 CLRF LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- SEND DATA TO LCD ----------------------------------------------------------
LCD_SEND_SUB:
 HIGH LCD_DC
 LCD_CMD = %00000001
 SHOUT LCD_SDIN, LCD_CLK, MSBFIRST, [LCD_CMD]
 CLRF LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'--- PUT PIXEL ON X/Y ----------------------------------------------------------
LCD_PUTPIXEL_SUB:
 LOW LCD_DC
 LCD_CMD = 0x80 | (XPOS-1)
 SHOUT LCD_SDIN, LCD_CLK, MSBFIRST, [LCD_CMD]
 LCD_CMD = 0x40 | ((YPOS-1)/8)
 SHOUT LCD_SDIN, LCD_CLK, MSBFIRST, [LCD_CMD]
 HIGH LCD_DC
 CLRF LCD_CMD
RETURN
'-------------------------------------------------------------------------------

'Low Lcd_DC
'Lcd_Offset_1 =PosY - ((PosY / 8) * 8)-1;
'
'Lcd_Data=%01000000 | ((PosY-1)/8) :GoSub Lcd_SentByte 'Y
'Lcd_Data=%10000000 | (PosX-1) :GoSub Lcd_SentByte 'X

'SETUP
'    lcd_send(0x21, LCD_CMD);  // LCD Extended Commands
'    lcd_send(0xC8, LCD_CMD);  // Set LCD Vop(Contrast)
'    lcd_send(0x06, LCD_CMD);  // Set Temp coefficent
'    lcd_send(0x13, LCD_CMD);  // LCD bias mode 1:48
'    lcd_send(0x20, LCD_CMD);  // Standard Commands, Horizontal addressing
'    lcd_send(0x0C, LCD_CMD);  // LCD in normal mode
'
'CONTRAST
'    lcd_send(0x21, LCD_CMD);                // LCD Extended Commands
'    lcd_send(0x80 | contrast, LCD_CMD);        // Set LCD Vop(Contrast)
'    lcd_send(0x20, LCD_CMD);                // LCD std cmds, hori addr mode

OVER_SUBS: