; File name: LCDTest1.asm
; Date: April 13, 2006
; Author: Julio Sanchez
; Processor: 16F84A
;
; Description:
; Program to exercises 8-bit PIC-to-LCD interface.
; Code assumes that LCD is driven by Hitachi HD44780
; controller and that the display supports two lines
; each one with 16 characters. The wiring and base
; address of each display line is stored in #define
; statements. These statements can be edited to
; accomodate a different set-up.
; Program uses delay loops for interface timing.
; WARNING:
; Code assumes 4Mhz clock. Delay routines must be
; edited for faster clock

; Displays: Minnesota State, Mankato
;
;===========================
; switches
;===========================
; Switches used in __config directive:
; _CP_ON Code protection ON/OFF
; * _CP_OFF
; * _PWRTE_ON Power-up timer ON/OFF
; _PWRTE_OFF
; _WDT_ON Watchdog timer ON/OFF
; * _WDT_OFF
; _LP_OSC Low power crystal occilator
; * _XT_OSC External parallel resonator/crystal ocillator
; _HS_OSC High speed crystal resonator (8 to 10 MHz)
; Resonator: Murate Erie CSA8.00MG = 8 MHz
; _RC_OSC Resistor/capacitor ocillator (simplest, 20% error)
; |
; |_____ * indicates setup values

;=========================
; setup and configuration
;=========================
  processor 16f84A
	include <p16f84A.inc>
	__config _XT_OSC & _WDT_OFF & _PWRTE_ON & _CP_OFF

;================================================= ====
; constant definitions
; for PIC-to-LCD pin wiring and LCD line addresses
;================================================= ====
#define E_line 1 ;|
#define RS_line 2 ;| -- from wiring diagram
#define RW_line 3 ;|
; LCD line addresses (from LCD data sheet)
#define LCD_1 0x80 ; First LCD line constant
#define LCD_2 0xc0 ; Second LCD line constant
; Note: The constant that define the LCD display line
; addresses have the high-order bit set in
; order to faciliate the controller command
;
;================================================= ====
; variables in PIC RAM
;================================================= ====
; Reserve 16 bytes for string buffer
	cblock 0x0c
	strData
	endc
; Leave 16 bytes and Continue with local variables
	cblock 0x1d ; Start of block
	count1 ; Counter # 1
	count2 ; Counter # 2
	count3 ; Counter # 3
	pic_ad ; Storage for start of text area
; (labeled strData) in PIC RAM
	J ; counter J
	K ; counter K
	index ; Index into text table (also used
		; for auxiliary storage)
	endc

;================================================= ===========
; program
;================================================= ===========
	org 0 ; start at address
	goto main
; Space for interrupt handlers
	org 0x08

main:
	movlw b'00000000' ; All lines to output
	movwf TRISA ; in port A
	movwf TRISB ; and port B
	movlw b'00000000' ; All outputs ports low
	movwf PORTA
	movwf PORTB
; Wait and initialize HD44780
	call delay_5ms ; Allow LCD time to initialize itself
	call initLCD ; Then do forced initialization
	call delay_5ms ; (Wait probably not necessary)
; Store base address of text buffer in PIC RAM
	movlw 0x0c ; Start address of text buffer
	movwf pic_ad ; to local variable
;======================
; first LCD line
;======================
; Store 16 blanks in PIC RAM, starting at address stored
; in variable pic_ad
	call blank16
; Call procedure to store ASCII characters for message
; in text buffer
	movlw d'3' ; Offset into buffer
	call storeMN
; Set DDRAM address to start of first line
	call line1
; Call procedure to display 16 characters in LCD
	call display16
;========================
; second LCD line
;========================
	call delay_125mcs ; Wait for termination
	call blank16 ; Blank buffer
; Call procedure to store ASCII characters for message
; in text buffer
	movlw d'1' ; Offset into buffer
	call storeUniv
	call line2 ; DDRAM address of LCD line 2
	call display16
;=======================
; done!
;=======================
loopHere:
	goto loopHere ;done

;************************************************* ***********
; INITIALIZE LCD PROCEDURE
;************************************************* ***********
initLCD
; Initialization for Densitron LCD module as follows:
; 8-bit interface
; 2 display lines of 16 characters each
; cursor on
; left-to-right increment
; cursor shift right
; no display shift
;***********************|
; COMMAND MODE |
;***********************|
	bcf PORTA,E_line ; E line low
	bcf PORTA,RS_line ; RS line low for command
	bcf PORTA,RW_line ; Write mode
	call delay_125mcs ;delay 125 microseconds
;***********************|
; FUNCTION SET |
;***********************|
	movlw 0x38 ; 0 0 1 1 1 0 0 0 (FUNCTION SET)
; | | | |__ font select:
; | | | 1 = 5x10 in 1/8 or 1/11 dc
; | | | 0 = 1/16 dc
; | | |___ Duty cycle select
; | | 0 = 1/8 or 1/11
; | | 1 = 1/16 (multiple lines)
; | |___ Interface width
; | 0 = 4 bits
; | 1 = 8 bits
; |___ FUNCTION SET COMMAND
	movwf PORTB ;0011 1000
	call pulseE ;pulseE and delay

;***********************|
; DISPLAY OFF |
;***********************|
	movlw 0x08 ; 0 0 0 0 1 0 0 0 (DISPLAY ON/OFF)
; | | | |___ Blink character at cursor
; | | | 1 = on, 0 = off
; | | |___ Curson on/off
; | | 1 = on, 0 = off
; | |____ Display on/off
; | 1 = on, 0 = off
; |____ COMMAND BIT

	movwf PORTB
	call pulseE ;pulseE and delay

;***********************|
; DISPLAY AND CURSOR ON |
;***********************|
	movlw 0x0e ; 0 0 0 0 1 1 1 0 (DISPLAY ON/OFF)
; | | | |___ Blink character at cursor
; | | | 1 = on, 0 = off
; | | |___ Curson on/off
; | | 1 = on, 0 = off
; | |____ Display on/off
; | 1 = on, 0 = off
; |____ COMMAND BIT
	movwf PORTB
	call pulseE ;pulseE and delay

;***********************|
; ENTRY MODE SET |
;***********************|
	movlw 0x06 ; 0 0 0 0 0 1 1 0 (ENTRY MODE SET)
; | | |___ display shift
; | | 1 = shift
; | | 0 = no shift
; | |____ cursor increment mode
; | 1 = left-to-right
; | 0 = right-to-left
; |___ COMMAND BIT
	movwf PORTB ;00000110
	call pulseE

;***********************|
; CURSOR/DISPLAY SHIFT |
;***********************|
	movlw 0x14 ; 0 0 0 1 0 1 0 0 (CURSOR/DISPLAY SHIFT)
; | | | |_|___ don't care
; | |_|__ cursor/display shift
; | 00 = cursor shift left
; | 01 = cursor shift right
; | 10 = cursor and display
; | shifted left
; | 11 = cursor and display
; | shifted right
; |___ COMMAND BIT
	movwf PORTB ;0001 1111
	call pulseE

;***********************|
; CLEAR DISPLAY |
;***********************|
	movlw 0x01 ; 0 0 0 0 0 0 0 1 (CLEAR DISPLAY)
; |___ COMMAND BIT
	movwf PORTB ;0000 0001
;
	call pulseE
	call delay_5ms ;delay 5 milliseconds after init
	return
;************************************************* ***********
; DELAY AND PULSE PROCEDURES
;************************************************* ***********
;=======================
; Procedure to delay
; 42 microseconds
;=======================
delay_125mcs
	movlw D'42' ; Repeat 42 machine cycles
	movwf count1 ; Store value in counter
repeat
	decfsz count1,f ; Decrement counter
	goto repeat ; Continue if not 0
	return ; End of delay
;------------------------------------------------------------
;=======================
; Procedure to delay
; 5 milliseconds
;=======================
delay_5ms
	movlw D'41' ; Counter = 41
	movwf count2 ; Store in variable 
delay
	call delay_125mcs ; Delay
	decfsz count2,f ; 40 times = 5 milliseconds
	goto delay
	return ; End of delay
;========================
; pulse E line
;========================
pulseE
	bsf PORTA,E_line ;pulse E line
	bcf PORTA,E_line
	call delay_125mcs ;delay 125 microseconds
	return

;=============================
; long delay sub-routine
; (for debugging)
;=============================
long_delay
	movlw D'200' ; w = 200 decimal
	movwf J ; J = w
jloop: movwf K ; K = w
kloop: decfsz K,f ; K = K-1, skip next if zero
	goto kloop
	decfsz J,f ; J = J-1, skip next if zero
	goto jloop
	return

	end