'****************************************************************
'*  Name    : ELAPSED-T2.BAS                                    *
'*  Author  : Darrel Taylor                                     *
'*  Notice  : Copyright (c) 2008 - 2194                         *
'*          : All Rights Reserved                               *
'*  Date    : 4/24/2008                                         *
'*  Version : 1.0                                               *
'*  Notes   :                                                   *
'*          :                                                   *
'****************************************************************
DISABLE DEBUG

Ticks            var byte
Seconds          var byte
Minutes          var byte
Hours            var byte
Days             var word

SecondsChanged   var bit
MinutesChanged   var bit
HoursChanged     var bit
DaysChanged      var bit

TickCount        CON EXT
TMR2ON           VAR T2CON.2

ASM
Prescaler = 16
T2Count = 250
    if OSC <= 20
        variable Postscaler = 5
    else
        if OSC <= 40
            variable Postscaler = 10
        else
            if OSC = 44
                variable Postscaler = 11
            else
                variable Postscaler = 15
            endif
        endif    
    endif

TickCount = OSC*1000000/4/Prescaler/T2Count/Postscaler    
T2CONval = ((Postscaler-1) << 3) | 3
    MOVE?CB  T2Count-1, PR2
    MOVE?CB  T2CONval, T2CON 
ENDASM

GOSUB ResetTime
Goto OverElapsed_T2


' ------[ This is the Interrupt Handler ]-------------------------------------
ClockCount:
    Ticks = Ticks + 1
    if Ticks = TickCount then
       Ticks = 0
       Seconds = Seconds + 1
       SecondsChanged = 1
       if Seconds = 60 then
          Minutes = Minutes + 1
          MinutesChanged = 1
          Seconds = 0
       endif
       if Minutes = 60 then
          Hours = Hours + 1
          HoursChanged = 1
          Minutes = 0
       endif
       if Hours = 24 then
          Days = Days + 1
          DaysChanged = 1
          Hours = 0
       endif
    endif
@ INT_RETURN                      ; return from interrupt

'-----====[ END OF TMR2 Interrupt Handler ]====-------------------------------

StartTimer:
    TMR2ON = 1
return

; -----------------
StopTimer:
    TMR2ON = 0                    ; Turn OFF Timer2
return

; -----------------
ResetTime:
    TMR2 = 0
    Ticks = 0
    Seconds = 0
    Minutes = 0
    Hours = 0
    Days = 0
    SecondsChanged = 1
    MinutesChanged = 1
    HoursChanged = 1
    DaysChanged = 1
return

OverElapsed_T2:

