
; PICBASIC PRO(TM) Compiler 2.50 Beta, (c) 1998, 2007 microEngineering Labs, Inc. All Rights Reserved.  
_USED			EQU	1

	INCLUDE	"C:\PBP\18F4455.INC"


; Define statements.
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00049	    DEFINE OSC 48          
#define		OSC		 48          

RAM_START       		EQU	00000h
RAM_END         		EQU	003FFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00060h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0005Fh

; C:\PBP\PBPPIC18.RAM      	00028	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP\PBPPIC18.RAM      	00012	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 001h
; C:\PBP\PBPPIC18.RAM      	00013	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 003h
; C:\PBP\PBPPIC18.RAM      	00014	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 005h
; C:\PBP\PBPPIC18.RAM      	00015	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 007h
; C:\PBP\PBPPIC18.RAM      	00016	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 009h
; C:\PBP\PBPPIC18.RAM      	00017	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Bh
; C:\PBP\PBPPIC18.RAM      	00018	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Dh
; C:\PBP\PBPPIC18.RAM      	00019	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Fh
; C:\PBP\PBPPIC18.RAM      	00020	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 011h
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00001	    '   
T1              		EQU	RAM_START + 013h
; C:\PBP\PBPPIC18.RAM      	00027	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC18.RAM      	00023	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC18.RAM      	00026	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 017h
; C:\PBP\PBPPIC18.RAM      	00021	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 018h
; C:\PBP\PBPPIC18.RAM      	00024	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 019h
; C:\PBP\PBPPIC18.RAM      	00022	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 01Ah
; C:\PBP\PBPPIC18.RAM      	00025	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 01Bh
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00093	    USBBufferCount      Var Byte    '
_USBBufferCount  		EQU	RAM_START + 01Ch
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00096	    DataToSend          var byte[8] ' store ADCs & pushButton data to send to USB
_DataToSend      		EQU	RAM_START + 01Dh
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00097	    String1             var byte[8] ' hold 'USB DEMO' string       
_String1         		EQU	RAM_START + 025h
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00094	    USBBufferIn         var byte[8] ' store incomming USB data
_USBBufferIn     		EQU	RAM_START + 02Dh
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00095	    USBBufferOut        Var Byte[8] ' store outgoing USB data       
_USBBufferOut    		EQU	RAM_START + 035h
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00027	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00028	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00029	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00030	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
#define _TMR0IF          	_INTCON??2
#define _TMR0ON          	_T0CON??7
#define _TMR0IE          	_INTCON??5
#define _GoDone          	_ADCON0??1
#define _INTCON??2       	 INTCON, 002h
#define _T0CON??7        	 T0CON, 007h
#define _INTCON??5       	 INTCON, 005h
#define _ADCON0??1       	 ADCON0, 001h
#define _ADCON0??2       	 ADCON0, 002h
#define _PORTA??2        	 PORTA, 002h
#define _PORTA??3        	 PORTA, 003h
#define _PORTA??4        	 PORTA, 004h
#define _PORTA??5        	 PORTA, 005h
#define _CCP1CON??5      	 CCP1CON, 005h
#define _Duty1??1        	 Duty1, 001h
#define _CCP1CON??4      	 CCP1CON, 004h
#define _Duty1??0        	 Duty1, 000h
#define _CCP2CON??5      	 CCP2CON, 005h
#define _Duty2??1        	 Duty2, 001h
#define _CCP2CON??4      	 CCP2CON, 004h
#define _Duty2??0        	 Duty2, 000h

; Constants.
_USBBufferSizeTX 		EQU	00008h
_USBBufferSizeRX 		EQU	00008h

; EEPROM data.


	INCLUDE	"USBDEM~1.MAC"
	INCLUDE	"C:\PBP\PBPUSB18.LIB"


; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00012	BANKA   $0000, $005F
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00013	BANK0   $0060, $00FF
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00014	BANK1   $0100, $01FF
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00015	BANK2   $0200, $02FF
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00016	BANK3   $0300, $03FF
; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00023	LIBRARY "PBPUSB18"

; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00025	        include "PIC18EXT.BAS"

; C:\PBP_PROG\USBDEM~3\PICBAS~1\18F4455.BAS	00032	        include "PBPPIC18.RAM"

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00032	    asm

	ASM?

    __CONFIG    _CONFIG1L, _PLLDIV_1_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L  
                            ;              ;                      ; USB clock source comes from the 96 MHz PLL divided by 2
                            ;              ; [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]
                            ; No prescale (4 MHz oscillator input drives PLL directly)


    __CONFIG    _CONFIG1H, _FOSC_XTPLL_XT_1H & _FCMEN_OFF_1H & _IESO_OFF_1H 
                            ;                  ;               ; Oscillator Switchover mode disabled
                            ;                  ; Fail-Safe Clock Monitor disabled
                            ; XT oscillator, PLL enabled, XT used by USB
                            
    __CONFIG    _CONFIG2L, _PWRT_ON_2L & _BOR_ON_2L  & _BORV_2_2L  & _VREGEN_ON_2L   
    __CONFIG    _CONFIG2H, _WDT_OFF_2H 
    __CONFIG    _CONFIG3H, _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_ON_3H 
    __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _XINST_OFF_4L & _DEBUG_OFF_4L 
    

	ENDASM?

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00049	    DEFINE OSC 48          

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00057	    PORTB   =   0
	MOVE?CB	000h, PORTB

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00058	    PORTC   =   0
	MOVE?CB	000h, PORTC

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00059	    TRISB   =   0
	MOVE?CB	000h, TRISB

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00060	    TRISC   =   0
	MOVE?CB	000h, TRISC

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00061	    TRISA   =   $FF
	MOVE?CB	0FFh, TRISA

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00065	    ADCON0  =   %00000001       ' A/D converter on, CH0 selected
	MOVE?CB	001h, ADCON0

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00066	    ADCON1  =   %00001101       ' AN<1:0> Analog, other digital
	MOVE?CB	00Dh, ADCON1

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00067	    ADCON2  =   %10010110       ' FOSC/64, 4 TAD, right justified
	MOVE?CB	096h, ADCON2

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00071	    CCP1CON =   %00001100       ' CCP1, PWM mode
	MOVE?CB	00Ch, CCP1CON

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00072	    CCP2CON =   %00001100       ' CCP2, PWM mode
	MOVE?CB	00Ch, CCP2CON

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00073	    PR2     =   249             ' 12khz PWM Freq
	MOVE?CB	0F9h, PR2

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00074	    T2CON   =   %00000101       ' TMR2 on, prescaler 1:4
	MOVE?CB	005h, T2CON

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00078	    UCFG    =   %00010100       ' enable internal USB pull-up, Full speed USB
	MOVE?CB	014h, UCFG

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00085	    INTCON  =   %10100000       ' Enable global and TMR0 interrupts
	MOVE?CB	0A0h, INTCON

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00086	    T0CON   =   %10000000       ' TMR0, CLK internal, prescaler 1:2, T0ON
	MOVE?CB	080h, T0CON
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00091	    USBBufferSizeTX     con 8       ' input 
; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00092	    USBBufferSizeRX     con 8       ' output

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00098	        string1[0]="U"
	MOVE?CB	055h, _String1

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00099	        string1[1]="S"
	MOVE?CB	053h, _String1 + 00001h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00100	        string1[2]="B"
	MOVE?CB	042h, _String1 + 00002h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00101	        string1[3]=" "
	MOVE?CB	020h, _String1 + 00003h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00102	        string1[4]="D"
	MOVE?CB	044h, _String1 + 00004h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00103	        string1[5]="E"
	MOVE?CB	045h, _String1 + 00005h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00104	        string1[6]="M"                                                                        
	MOVE?CB	04Dh, _String1 + 00006h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00105	        string1[7]="O"  
	MOVE?CB	04Fh, _String1 + 00007h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00107	    @ADRead = ADRESL                 ; use to read both ADCs register in one shot

	ASM?
ADRead = ADRESL                 ; use to read both ADCs register in one shot

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00110	    @Duty1=_USBBufferIn+1            ; use to read both Duty bytes from specifics

	ASM?
Duty1=_USBBufferIn+1            ; use to read both Duty bytes from specifics

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00111	    @Duty2=_USBBufferIn+3            ;     USBBufferIn locations in one shot

	ASM?
Duty2=_USBBufferIn+3            ;     USBBufferIn locations in one shot

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00126	    goto SwHwInit           ' skip macros        
	GOTO?L	_SwHwInit

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00127	    asm 

	ASM?
 
Reload_TMR0 macro
    ;   Use to stop, reload, clear overflow flag and restart TMR0
    BCF     _TMR0ON         ; stop timer
    MOVE?CW d'65000',TMR0L  ; reload for timebase ~100uSec
    BCF     _TMR0IF         ; clear overflow flag
    BSF     _TMR0ON         ; start timer
    ENDM

SendUSB macro array
    ;   Use to Copy an specific array to USBBufferOut AND send it
    ;   to USB bus
    variable i=0
    while i<8
        MOVE?BB (array+i),(_USBBufferOut+i)
i+=1
    endw
    L?CALL _DoUSBOut
    endm
    

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00151	SwHwInit:

	LABEL?L	_SwHwInit	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00152	    pause 500               ' Settle delay
	PAUSE?C	001F4h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00153	    usbinit                 ' initialise USB 
	USBINIT?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00154	@   Reload_TMR0             ; Reload timer0

	ASM?
   Reload_TMR0             ; Reload timer0

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00155	    ON INTERRUPT GOTO DoUSBService
	ONINT?LL	_DoUSBService, L00001

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00160	Start: 

	LABEL?L	_Start	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00172	    if (PORTA>>2)!=0 then
	ICALL?L	L00001
	SHIFTR?BCW	PORTA, 002h, T1
	CMPEQ?WCL	T1, 000h, L00002

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00173	@       SendUSB _String1               

	ASM?
       SendUSB _String1               

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00174	        endif
	ICALL?L	L00001
	LABEL?L	L00002	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00178	    ADCON0.2=ADCON0.2 ^ 1               ' Switch between AN0 & AN1
	ICALL?L	L00001
	XOR?TCT	_ADCON0??2, 001h, _ADCON0??2

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00179	    PAUSEUS 10                          ' arbitrary SamplingTime
	ICALL?L	L00001
	PAUSEUS?C	00Ah

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00180	    GODONE=1                            ' start conversion
	ICALL?L	L00001
	MOVE?CT	001h, _GoDone

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00181	    WHILE GODONE : WEND                 ' wait 'till finish
	ICALL?L	L00001
	LABEL?L	L00004	
	CMPF?TL	_GoDone, L00005

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00181	    WHILE GODONE : WEND                 ' wait 'till finish
	ICALL?L	L00001
	GOTO?L	L00004
	LABEL?L	L00005	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00182	    DATATOSEND[ADCON0.2]=(ADREAD>>2)    ' save it to DataToSend array
	ICALL?L	L00001
	SHIFTR?WCW	ADRead, 002h, T1
	AIN?WBT	T1, _DataToSend, _ADCON0??2

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00186	    datatosend[2] = PORTA.2
	ICALL?L	L00001
	MOVE?TB	_PORTA??2, _DataToSend + 00002h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00187	    datatosend[3] = PORTA.3
	ICALL?L	L00001
	MOVE?TB	_PORTA??3, _DataToSend + 00003h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00188	    datatosend[4] = PORTA.4
	ICALL?L	L00001
	MOVE?TB	_PORTA??4, _DataToSend + 00004h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00189	    datatosend[5] = PORTA.5
	ICALL?L	L00001
	MOVE?TB	_PORTA??5, _DataToSend + 00005h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00190	    datatosend[6] = 0
	ICALL?L	L00001
	MOVE?CB	000h, _DataToSend + 00006h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00191	    datatosend[7] = 0
	ICALL?L	L00001
	MOVE?CB	000h, _DataToSend + 00007h

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00195	@   SendUSB _DataToSend 

	ASM?
   SendUSB _DataToSend 

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00199	    gosub dousbin
	ICALL?L	L00001
	GOSUB?L	_dousbin

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00203	    goto start                                     
	ICALL?L	L00001
	GOTO?L	_Start

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00211	DoUSBIn:

	LABEL?L	_dousbin	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00218	    tmr0ie = 0                                      ' disbale TMR0 int
	ICALL?L	L00001
	MOVE?CT	000h, _TMR0IE

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00219	    USBBufferCount = USBBufferSizeRX                ' RX buffer size
	ICALL?L	L00001
	MOVE?CB	_USBBufferSizeRX, _USBBufferCount

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00220	    USBService                                      ' keep connection alive
	ICALL?L	L00001
	USBSERVICE?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00221	    USBIn 1, USBBufferin, USBBufferCount, Timeout   ' read data, if available
	ICALL?L	L00001
	USBIN?CBBL	001h, _USBBufferIn, _USBBufferCount, _Timeout

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00222	Timeout:                                            '

	LABEL?L	_Timeout	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00223	@   Reload_TMR0            

	ASM?
   Reload_TMR0            

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00224	    tmr0ie = 1              ' re-enable TMR0 int
	ICALL?L	L00001
	MOVE?CT	001h, _TMR0IE

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00225	    PORTB  = USBBUFFERIN[0] ' output to PORTB
	ICALL?L	L00001
	MOVE?BB	_USBBufferIn, PORTB

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00227	    CCP1CON.5=DUTY1.1       ' load CCP1 duty value            
	ICALL?L	L00001
	MOVE?TT	_Duty1??1, _CCP1CON??5

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00228	    CCP1CON.4=DUTY1.0       '      with Duty1 
	ICALL?L	L00001
	MOVE?TT	_Duty1??0, _CCP1CON??4

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00229	    CCPR1L=DUTY1>>2         '
	ICALL?L	L00001
	SHIFTR?WCB	Duty1, 002h, CCPR1L

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00231	    CCP2CON.5=DUTY2.1       ' load CCP2 duty value            
	ICALL?L	L00001
	MOVE?TT	_Duty2??1, _CCP2CON??5

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00232	    CCP2CON.4=DUTY2.0       '      with Duty2
	ICALL?L	L00001
	MOVE?TT	_Duty2??0, _CCP2CON??4

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00233	    CCPR2L=DUTY2>>2         '
	ICALL?L	L00001
	SHIFTR?WCB	Duty2, 002h, CCPR2L

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00234	    return
	ICALL?L	L00001
	RETURN?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00238	DoUSBOut:

	LABEL?L	_DoUSBOut	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00242	    TMR0IE = 0                                      ' Disable TMR0 interrupt
	ICALL?L	L00001
	MOVE?CT	000h, _TMR0IE

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00243	    WaitPC:                                         '

	LABEL?L	_WaitPC	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00244	    USBBufferCount = USBBufferSizeTX                ' TX buffer size
	ICALL?L	L00001
	MOVE?CB	_USBBufferSizeTX, _USBBufferCount

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00245	    USBService                                      ' keep connection alive
	ICALL?L	L00001
	USBSERVICE?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00246	    USBOut 1, USBBufferOut, USBBufferCount, Waitpc  ' if bus available, transmit data
	ICALL?L	L00001
	USBOUT?CBBL	001h, _USBBufferOut, _USBBufferCount, _WaitPC

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00247	@   Reload_TMR0                                     

	ASM?
   Reload_TMR0                                     

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00248	    tmr0ie=1                                        ' Re-Enable TMR0 interrupt    
	ICALL?L	L00001
	MOVE?CT	001h, _TMR0IE

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00249	    return
	ICALL?L	L00001
	RETURN?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00251	DISABLE
	DISABLE?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00252	DoUSBService:

	LABEL?L	_DoUSBService	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00253	    usbservice  ' keep connection alive
	USBSERVICE?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00254	@   Reload_TMR0 ; reload timer

	ASM?
   Reload_TMR0 ; reload timer

	ENDASM?


; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00255	    RESUME      ' getout of here
	RESUME?	

; C:\PBP_PROG\USBDEM~3\PICBAS~1\USBDEM~1.PBP	00256	ENABLE    
	ENABLE?	

	END
