'******************************************************
'* RILEVAZIONE GPS CON SCARICAMENTO CAMPI SEQUENZA RMC
'* SU SD IN FORMATO TXT
'* Autore: 
'******************************************************
'* STRUTTURA EEPROM 24LC64
'* BLOCCO 0000-01FF RISERVATO A BOOT SECTOR 64MB
'* BLOCCO 0200-03FF RISERVATO A BOOT SECTOR 128MB
'* BLOCCO 0400-05FF RISERVATO A ROOT DIRECTORY
'* BLOCCO 0600-07FF RISERVATO A FAT1
'* BLOCCO 0800-09FF RISERVATO A DATI CONFIGURAZIONE
'******************************************************

@ device pic16F876, hs_osc, wdt_off, pwrt_off, bod_off, lvp_off, cpd_off, wrt_off, protect_off

DEFINE OSC 20           'Clock PIC
DEFINE HSER_BAUD  4800  'Velocita di comunicazione RS232 con GPS
DEFINE HSER_CLROERR  1
CTL  con %10100000  'Byte di controllo EEPROM

include "modedefs.bas"

'**********************************************
'* Dichiarazione variabili linee di connessione
'* con la SDCard
'**********************************************
SS   var PORTC.2   'SELEZIONE-CARD PIN1
SCK  var PORTC.3   'CLOCK-CARD PIN5
SDO  var PORTC.4   'DATI-USCITA-CARD PIN7
SDI  var PORTC.5   'DATI-ENTRATA-CARD PIN2

'**********************************************
'* Dichiarazione variabili led di segnalazione
'**********************************************
LEDR var PORTB.7   'LED ROSSO
LEDV var PORTB.3   'LED VERDE
LEDG var PORTB.1   'LED GIALLO

'**********************************************
'* Dichiarazione linea input per avviare
'* registrazione
'**********************************************
REC var  PORTA.1   'LINEA AVVIO
                   'SE =0 FERMA REGISTRAZIONE+DISTACCA BATTERIA
                   'SE =1 AVVIA REGISTRAZIONE+COLLEGA BATTERIA

'**********************************************
'* Dichiarazione linea GPS ON/OFF
'**********************************************
GPSOFF var PORTA.4  'LINEA ACCENSIONE/SPEGNIMENTO GPS
                    'SE =1 GPS OFF
                    'SE =0 GPS ON

'**********************************************
'* Dichiarazione linea SENSORE DI MOVIMENTO
'**********************************************
SMOV    var word     'MOVIMENTO VEICOLO
                     'SE = 0 IN MOVIMENTO
                     'SE != 0 IN SOSTA

'**********************************************
'* Dichiarazione linea TENSIONE BATTERIA
'**********************************************
TENSOFF var PORTB.2 'LINEA BATTERIA
                    'SE =1 TENSIONE BATTERIA
                    'SE =0 TENSIONE PRIMARIA

'**********************************************
'* Dichiarazione variabili configurazione
'**********************************************
RIT   var  word     'FREQUENZA DI POLLING IN SEC
NOFIX var  byte     'Flag se = 0 registra solo punti FIX 
                    '     se = 1 registra tutti i punti
SENSMOV var byte    'Flag se = 1 registra solo in movimento
                    '     se = 0 registra sempre
TDOPOMOV var word   'TEMPO REGISTRAZIONE DOPO MOVIMENTO IN SEC
SINCMOV  var word   'TIMER PER REGISTRAZIONE DOPO MOVIM IN SEC

ANTGPS   var byte   'Flag se = 1 antenna GPS viene spenta
                    '            dopo tot tempo senza movimento
                    '     se = 0 antenna GPS sempre accesa
TOFFGPS  var word   'TEMPO DI SOSTA PER SPEGNIMENTO GPS
SINCOFF  var word   'TIMER PER SPEGNIMENTO DOPO SOSTA

'**********************************************
'* Dichiarazione variabili linee di connessione
'* con la EEPROM 24LC64
'**********************************************
SCL  var PORTC.1   'CLOCK EEPROM
SDA  var PORTC.0   'DATI  EEPROM

'**********************************************
'* Dichiarazione variabili necessarie all 
'* elaborazione delle informazioni da e per la
'* SDCard
'**********************************************
RISP1 var byte     'RISPOSTA TIPO R1 DA CARD (8bit)
RISP2 var word     'RISPOSTA TIPO R2 DA CARD (16bit)
IND1 var word      'INDIRIZZO SDCARD WORD ALTA  BIT 16-31
IND0 var word      'INDIRIZZO SDCARD WORD BASSA BIT 0-15
CONTA1 var word    'CONTATORE
CONTA2 var word    'CONTATORE
CONTA3 var word    'CONTATORE
CONTA4 var word    'CONTATORE
X      var byte    'INDICE VETTORI
QX     var byte    'ANALISI 4 Bit Risposta Dati

'**********************************************
'* Dichiarazione variabili necessarie alla 
'* gestione FAT16
'**********************************************
XCLUST  var word     'PUNTATORE CLUSTER
CCLUST var byte     'CONTA I 4 SETTORI PER CLUSTER
TBYTEALTA var word  'WORD ALTA TOTALE BYTE FILE
TBYTEBASSA var word 'WORD BASSA TOTALE BYTE FILE

'**********************************************
'* Dichiarazione variabili record RMC 
'**********************************************
UTC    var byte[10]   'Campo Orario UTC
FLAG   var byte       'A=rec aggiornato V=rec non aggiornato
LAT    var byte[9]    'Campo Latitudine
EMI    var byte       'Emisfero N=Nord S=Sud
LON    var byte[10]   'Campo Longitudine
EOVE   var byte       'E=Est W=Ovest
DAT    var byte[6]    'Campo Data

'**********************************************
'* Dichiarazione variabili conversione MIN -> GRADI DECIMALI 
'**********************************************
CONV   var byte       'Valore di conversione a  8bit
RES    var byte       'Resto della divisione


GOTO INIZIO

'**********************************************
'* Sottoprocedure
'**********************************************
'---------------------------------
'* VERIFICA PARAMETRI IN MOVIMENTO E NON
'---------------------------------
VPARA:
       IF SMOV = 0 THEN             'Se sono in movimento

       IF SENSMOV=1 THEN
       SINCMOV = 0               'e devo registare solo dopo movim
       ENDIF                     'azzero il timer 
       
       IF ANTGPS=1  THEN
       SINCOFF = 0               'e devo spegnere dopo la sosta
       ENDIF                     'azzero il timer di spegnimento

       ELSE

       IF SENSMOV=1 THEN         'e devo registrare solo dopo movim
       SINCMOV=SINCMOV+1         'incremento timer
       ENDIF

       IF ANTGPS=1 THEN          'e devo spegnere dopo la sosta
       SINCOFF=SINCOFF+1         'incremento timer
       ENDIF

       ENDIF

       RETURN

'---------------------------------
'* LEGGI SENSORE DI MOVIMENTO
'---------------------------------
LEGGIMOV:
       SMOV = 0
       ADCON0.2 = 1              'Inizia conversione
CNV:
       IF ADCON0.2 = 1 THEN GOTO CNV
       SMOV.BYTE1 = ADRESH
       SMOV.BYTE0 = ADRESL

       RETURN

'---------------------------------
'* INIZIO TRANSAZIONE DI SCRITTURA
'* VERSIONE PICBASIC
'* SCRIVE LA SDCARD A PARTIRE DALL'INDIRIZZO
'* A 32 BIT COMPOSTO DA IND1 IND0
'---------------------------------

INISCRIVI:
        SS=1
        SHIFTOUT SDI,SCK,MSBFIRST,[$FF]
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
'Invio CMD24 scrittura blocco su SDCard 
        SS=0
        SHIFTOUT SDI,SCK,MSBFIRST,[$58,IND1.BYTE1,IND1.BYTE0,IND0.BYTE1,IND0.BYTE0,$FF]
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        CONTA2 = 0
'Risposta per vedere se la card  pronta a ricevere dati
        WHILE RISP1 != 0
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        CONTA2 = CONTA2 + 1
        IF CONTA2 >= 5000 THEN
        GOTO ERRORE
        ENDIF
        WEND
'Invio Start Block %11111110=$FE
        SHIFTOUT SDI,SCK,MSBFIRST,[$FE]
        RETURN

'---------------------------------
'* FINE TRANSAZIONE DI SCRITTURA
'* VERSIONE PICBASIC
'* FINALIZZA L'OPERAZIONE ATTRAVERSO
'* L'INVIO DEL CRC E IL CONTROLLO DI STATUS
'---------------------------------

FINSCRIVI:
'Invio CRC
        SHIFTOUT SDI,SCK,MSBFIRST,[$FF,$FF]
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]

'Ricevo la risposta al comando di scrittura estraggo i 4 bit meno signif
'0101 Dati accettati
'1011 Dati rifiutati per errore CRC
'1101 Dati rifiutati per errore scrittura
        QX = %00000000
        QX = RISP1 & $0F
        IF QX != %00000101 THEN
        GOTO ERRORE
        ENDIF

'Ricevo il bit busy della card mentre scrive
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        CONTA2=0
        WHILE RISP1 = 0
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        CONTA2 = CONTA2 + 1
        IF CONTA2 >= 5000 THEN
        GOTO ERRORE
        ENDIF
        WEND

'Appena la card ha finito di scrivere verifico lo stato della card
'Invio il CMD13
        SS=1
        SHIFTOUT SDI,SCK,MSBFIRST,[$FF]
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        SS=0
        SHIFTOUT SDI,SCK,MSBFIRST,[$4D,$00,$00,$00,$00,$FF]
'Ricevo lo status a 16 bit risposta formato 2
        SHIFTIN SDO,SCK,MSBPRE,[RISP2\16]
        CONTA2=0
        WHILE RISP2.BYTE0 != 0
        SHIFTIN SDO,SCK,MSBPRE,[RISP2\16]
        CONTA2 = CONTA2 + 1
        IF CONTA2 >= 5000 THEN
        GOTO ERRORE2
        ENDIF
        WEND

        RETURN

INIZIO:

'**********************************************
'* Inizio Elaborazione con impostazione delle
'* variabili
'**********************************************
        ADCON0 = %11000001   'Modulo A/D ON
        ADCON1 = %10001110   'PIN RA0 Analogico/ Resto Digitali
                             'Vref+ Vdd / Vref- Vss
        TRISA=%00000011
        TRISC=%10010000
        TRISB=%00000100
        LEDR = 0
        LEDG = 0
        LEDV = 0

        'Attendo parametri di configurazione per 5 sec
        LEDG = 1
        HSERIN 5000,LEGGI,[WAIT("TAU")]
        HSERIN [DEC4 RIT, DEC1 NOFIX, DEC1 SENSMOV, DEC4 TDOPOMOV, DEC1 ANTGPS, DEC4 TOFFGPS]
        I2CWRITE SDA,SCL,CTL,$0800,[RIT.HIGHBYTE]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0801,[RIT.LOWBYTE]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0802,[NOFIX]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0803,[SENSMOV]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0804,[TDOPOMOV.HIGHBYTE]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0805,[TDOPOMOV.LOWBYTE]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0806,[ANTGPS]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0807,[TOFFGPS.HIGHBYTE]
        PAUSE 10
        I2CWRITE SDA,SCL,CTL,$0808,[TOFFGPS.LOWBYTE]
        PAUSE 10
        HSEROUT[79,75]                               'Invio OK in risposta
        GOTO AVANTI
LEGGI:
        'Altrimenti li carico dalla EEPROM
        I2CREAD SDA,SCL,CTL,$0800,[RIT.HIGHBYTE]
        I2CREAD SDA,SCL,CTL,$0801,[RIT.LOWBYTE]
        I2CREAD SDA,SCL,CTL,$0802,[NOFIX]
        I2CREAD SDA,SCL,CTL,$0803,[SENSMOV]
        I2CREAD SDA,SCL,CTL,$0804,[TDOPOMOV.HIGHBYTE]
        I2CREAD SDA,SCL,CTL,$0805,[TDOPOMOV.LOWBYTE]
        I2CREAD SDA,SCL,CTL,$0806,[ANTGPS]
        I2CREAD SDA,SCL,CTL,$0807,[TOFFGPS.HIGHBYTE]
        I2CREAD SDA,SCL,CTL,$0808,[TOFFGPS.LOWBYTE]
AVANTI:
        LEDG = 0        'Spegni LED GIALLO

        LEDR=1          'Accensione LED ROSSO

'**********************************************
'* Invio 80 cicli DUMMY CLOCK
'* Vedi raccomandazione HanBit e SPI Specification
'**********************************************
        SS=1
        FOR CONTA1 = 1 TO 10
        SHIFTOUT SDI,SCK,MSBFIRST,[$FF]  'Invio cicli di clock a vuoto
        NEXT CONTA1
        SS=0
        PAUSE 50


'**********************************************
'* CMD0 mantenendo SS a 0
'* Se non fa il reset e non avvia  il  processo
'* di inizializzazione segnalo l'errore ed esco
'* Inserito ciclo di verifica entrata in  idle-
'* state  RISP1 = 1  per  evitare  problemi  di
'* inizializzazione
'**********************************************

        SHIFTOUT SDI, SCK, MSBFIRST, [$40,$00,$00,$00,$00,$95]  'Invio CMD0
        SHIFTIN SDO, SCK, MSBPRE, [RISP1]  'Leggo risposta R1 da Card
        CONTA1 = 0
        WHILE RISP1 != 1
        SHIFTIN SDO, SCK, MSBPRE, [RISP1]  'Leggo risposta R1 da Card
        CONTA1 = CONTA1 + 1
        IF CONTA1 >= 5000 THEN  'Superato Time-Out esco
        GOTO ERRORE
        ENDIF
        WEND
        SS=1
        PAUSE 50
        SS=0


'**********************************************
'* Invio ripetutamente CMD1 finche' la risposta
'* e' 0 cioe' la Card termina l'inizializzazione
'* Nel  caso  non  diventi  mai  zero  segnalo
'* l'errore ed esco dal pgm
'**********************************************

        CONTA1 = 0
        RISP1 = 1
        WHILE RISP1 != 0
        SS=1
        SHIFTOUT SDI,SCK,MSBFIRST,[$FF]
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        SS=0
        PAUSE 50
        SHIFTOUT SDI,SCK,MSBFIRST,[$41,$00,$00,$00,$00,$FF,$FF] 'Invio CMD1
        SHIFTIN SDO,SCK,MSBPRE,[RISP1]
        CONTA1 = CONTA1 + 1
        IF CONTA1 >= 5000 THEN  'Superato Time-Out Esco
        GOTO ERRORE
        ENDIF
        WEND

'**********************************************
'* FORMATTAZIONE CARD
'**********************************************
'CANCELLA SETTORI

       IND0 = $0000                    'CANCELLO I PRIMI 384 SETTORI
       IND1 = $0000
       WHILE IND1 <= $0002

       GOSUB INISCRIVI                 'INIZIO TRANSAZ SCRITTURA SU SD

       FOR CONTA3 = 0 TO 511
       SHIFTOUT SDI,SCK,MSBFIRST,[$00]
       NEXT CONTA3                     'AGGIORNA CONTA BYTE

       GOSUB FINSCRIVI                 'FINALIZZA TRANSAZIONE

       IND0 = IND0 + $0200
       IF IND0 = $0000 THEN
       IND1 = IND1 + 1
       ENDIF
       WEND

'SETTORE BOOT

       IND0   = $0000                  'SCRIVO SETTORE 0
       IND1   = $0000                  'PER CARD DA 64MB
       GOSUB INISCRIVI

       FOR CONTA3 = $0000 to $01FF
       I2CREAD SDA,SCL,CTL,CONTA3,[RES]
       SHIFTOUT SDI,SCK,MSBFIRST,[RES]
       NEXT CONTA3

       GOSUB FINSCRIVI


'SETTORE FAT1

       IND0   = $0200                  'SCRIVO SETTORE 1
       IND1   = $0000                  'PER CARD DA 64MB
       GOSUB INISCRIVI

       FOR CONTA3 = $0600 to $07FF
       I2CREAD SDA,SCL,CTL,CONTA3,[RES]
       SHIFTOUT SDI,SCK,MSBFIRST,[RES]
       NEXT CONTA3

       GOSUB FINSCRIVI


'SETTORE ROOT

       IND0   = $D200               'SCRIVO SETTORE 233
       IND1   = $0001               'PER CARD DA 64MB
       GOSUB INISCRIVI

       FOR CONTA3 = $0400 to $05FF
       I2CREAD SDA,SCL,CTL,CONTA3,[RES]
       SHIFTOUT SDI,SCK,MSBFIRST,[RES]
       NEXT CONTA3

       GOSUB FINSCRIVI

       LEDR = 0                     'SPENGO LED ROSSO 

       IND0   = $1200               'SCRIVO DAL SETTORE 265
       IND1   = $0002               'PER CARD DA 64MB

       SINCMOV = 0                  'AZZERO TIMER MOVIMENTO
       SINCOFF = 0                  'AZZERO TIMER SPEGNIMENTO

       REPEAT                       'ATTENDO AVVIO REGISTRAZIONE
       UNTIL (TENSOFF=0)            'SW1 su ON

       GPSOFF=0                     'Accendo GPS

       LEDG = 1                     'ACCENDO LED GIALLO
       PAUSE 3000                   'accensione e boot antenna gps

       XCLUST = 0                 'NR CLUSTER SCRITTI
       CCLUST = 0                 'NR SETTORI PER CLUSTER SCRITTI

       WHILE (IND1<= $03C0)         'Registro entro limiti card

       CONTA3 = 0
       GOSUB INISCRIVI
 
RICEVI:
       X = 0                        'Azzero indice
       HSERIN 2000,FINEREC,[WAIT("RMC,"),UTC[X]] 'Attendo inizio sequenza
                                    'Se entro 2 sec non ricevo nulla
                                    'manca tensione primaria
       WHILE UTC[X] != ","          'Leggo caratteri fino alla ,
       IF UTC[X] != "." THEN
       X = X + 1
       ENDIF
       HSERIN [UTC[X]]
       WEND
       HSERIN [FLAG, SKIP 1]        'Leggo carattere del campo FLAG
       IF (FLAG != "A") THEN        'Se il record non e aggiornato
       GOTO PAX                     'Se record void verifico parametri
       ENDIF

       X = 0                        'Azzero indice
       HSERIN [LAT[X]]              'Leggo carattere del campo LATITUDINE
       WHILE LAT[X] != ","          'Leggo caratteri fino alla ,
       IF LAT[X]!="." THEN
       X = X + 1
       ENDIF
       HSERIN [LAT[X]]
       WEND
       HSERIN [EMI, SKIP 1]         'Leggo carattere del campo EMISFERO
       X = 0                        'Azzero indice
       HSERIN [LON[X]]              'Leggo carattere del campo LONGITUDINE
       WHILE LON[X] != ","          'Leggo caratteri fino alla ,
       IF LON[X] != "." THEN
       X = X + 1
       ENDIF
       HSERIN [LON[X]]
       WEND
       HSERIN [EOVE, SKIP 1]        'Leggo carattere del campo EST/OVEST

PROX:
       HSERIN [WAIT(","),WAIT(",")] 'Salto velocita e il campo TMG
       X = 0                       'Azzero indice
       HSERIN [DAT[X]]             'Leggo carattere del campo DATA
       WHILE DAT[X] != ","         'Leggo caratteri fino alla ,
       X = X + 1
       HSERIN [DAT[X]]
       WEND

PAX:
       IF (REC = 0) OR (TENSOFF = 1) THEN 'Se SW2 su REC-OFF chiudo
       GOTO FINEREC                       'Se sw1 su OFF chiudo
       ENDIF

       GOSUB LEGGIMOV

       GOSUB VPARA

       IF (ANTGPS = 1) AND (SINCOFF > TOFFGPS) THEN
       GPSOFF = 1                'spengo GPS
       GOSUB LEGGIMOV
       WHILE SMOV != 0
       IF (REC = 0) OR (TENSOFF = 1) THEN  'se SW2 su REC-OFF chiudo
       GOTO FINEREC                        'se SW1 su OFF chiudo
       ENDIF
       GOSUB LEGGIMOV
       WEND
       SINCMOV=0                 'azzero timer movimento
       SINCOFF=0                 'azzero timer spegnimento
       GPSOFF=0                  'accendo GPS
       PAUSE 2000
       GOTO RICEVI               'appena si muove torno a ricevere
       ENDIF

       IF (SENSMOV = 1) AND (SINCMOV >= TDOPOMOV) THEN
       SINCMOV=TDOPOMOV        'se supero tempo dopo movimento
       GOTO RICEVI             'torno a ricevere
       ENDIF

       IF (SMOV = 0) AND (NOFIX = 0) THEN  'Se sono in movimento
       GOTO RICEVI                         'e devo registrare solo FIX
       ENDIF                               'torno a ricevere

       IF (FLAG != "A") THEN        'Se il record non e aggiornato
       GOTO RICEVI                  'Se record void leggo RMC successiva
       ENDIF                        'dopo aver verificato i parametri



'******* CAMPO LATITUDINE

       IF LAT[0] = ","  THEN        'Il campo latitudine manca 
       SHIFTOUT SDI,SCK,MSBFIRST,["+"]
       FOR X = 0 TO 1
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       SHIFTOUT SDI,SCK,MSBFIRST,["."]
       FOR X = 2 TO 6
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       ELSE
       IF EMI = "N" THEN              'Emisfero NORD=+  SUD=-
       SHIFTOUT SDI,SCK,MSBFIRST,["+"]
       ELSE
       SHIFTOUT SDI,SCK,MSBFIRST,["-"]
       ENDIF
       FOR X = 0 TO 1               'Prime due cifre campo latitudine
       SHIFTOUT SDI,SCK,MSBFIRST,[LAT[X]]
       NEXT X
       SHIFTOUT SDI,SCK,MSBFIRST,["."]
       X = 3
       CONV = 0                     'Risultato divisione per conversione
       RES = LAT[2] - $30           'Resto divisione per conversione
       WHILE X <= 7                 'Conversione minuti in decimali di grado
       CONV = (RES * 10 + (LAT[X] - $30)) / 6
       RES  = (RES * 10 + (LAT[X] - $30)) // 6
       CONV = CONV + $30
       SHIFTOUT SDI,SCK,MSBFIRST,[CONV]
       X = X + 1
       WEND
       ENDIF
       SHIFTOUT SDI,SCK,MSBFIRST,[","]

'******* CAMPO LONGITUDINE

       IF LON[0] = ","  THEN        'Il campo longitudine manca 
       SHIFTOUT SDI,SCK,MSBFIRST,["+"]
       FOR X = 0 TO 2
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       SHIFTOUT SDI,SCK,MSBFIRST,["."]
       FOR X = 3 TO 7
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       ELSE
       IF EOVE = "E" THEN             'Campo EST=+  OVEST=-
       SHIFTOUT SDI,SCK,MSBFIRST,["+"]
       ELSE
       SHIFTOUT SDI,SCK,MSBFIRST,["-"]
       ENDIF
       FOR X = 0 TO 2               'Prime tre cifre campo longitudine
       SHIFTOUT SDI,SCK,MSBFIRST,[LON[X]]
       NEXT X
       SHIFTOUT SDI,SCK,MSBFIRST,["."]
       X = 4
       CONV = 0                     'Risultato divisione per conversione
       RES = LON[3] - $30           'Resto divisione per conversione
       WHILE X <= 8                 'Conversione minuti in decimali di grado
       CONV = (RES * 10 + (LON[X] - $30)) / 6
       RES  = (RES * 10 + (LON[X] - $30)) // 6
       CONV = CONV + $30
       SHIFTOUT SDI,SCK,MSBFIRST,[CONV]
       X = X + 1
       WEND
       ENDIF
       SHIFTOUT SDI,SCK,MSBFIRST,[","]

'******* CAMPO DATA

       IF DAT[0] = ","  THEN       'Il campo Data manca 
       FOR X = 0 TO 7
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       ELSE
       SHIFTOUT SDI,SCK,MSBFIRST,["2","0"]
       FOR X = 4 TO 5
       SHIFTOUT SDI,SCK,MSBFIRST,[DAT[X]]
       NEXT X
       FOR X = 2 TO 3               'Mese
       SHIFTOUT SDI,SCK,MSBFIRST,[DAT[X]]
       NEXT X
       FOR X = 0 TO 1               'Giorno
       SHIFTOUT SDI,SCK,MSBFIRST,[DAT[X]]
       NEXT X
       ENDIF
       SHIFTOUT SDI,SCK,MSBFIRST,[","]

'******* CAMPO ORARIO UTC

       IF UTC[0] = ","  THEN       'Il campo Orario manca 
       FOR X = 0 TO 5
       SHIFTOUT SDI,SCK,MSBFIRST,["0"]
       NEXT X
       ELSE
       FOR X = 0 TO 5
       SHIFTOUT SDI,SCK,MSBFIRST,[UTC[X]]
       NEXT X
       ENDIF

'******** FINE RECORD

       SHIFTOUT SDI,SCK,MSBFIRST,[$0D,$0A]

       CONTA3 = CONTA3 + 38                 'Aggiorno byte scritti

       IF CONTA3 != 494 THEN

       FOR X = 2 TO RIT               'Ritardo configurato della 
       PAUSE 1000                     'fase ricezione RMC
       GOSUB VPARA

       IF (ANTGPS=1) AND (SINCOFF>=TOFFGPS) THEN
       GPSOFF=1
       REPEAT
       IF (REC = 0) OR (TENSOFF = 1) THEN  'se SW2 su REC-OFF chiudo
       GOTO FINEREC                        'se SW1 su OFF chiudo
       ENDIF
       GOSUB LEGGIMOV
       IF X<=RIT THEN
       X=X+1
       ENDIF
       PAUSE 1000
       UNTIL SMOV=0
       SINCMOV=0
       SINCOFF=0
       GPSOFF=0                       'Accendo GPS
       PAUSE 2000
       ENDIF

       IF (REC = 0) OR (TENSOFF = 1) THEN   'Se SW2 su REC-OFF chiudo
       GOTO FINEREC                         'Se sw1 su OFF chiudo
       ENDIF

       NEXT X

       GOTO RICEVI

       ELSE

       FOR CONTA3 = 495 to 503        'SALTA RIGHE
       SHIFTOUT SDI,SCK,MSBFIRST,[$0D]
       SHIFTOUT SDI,SCK,MSBFIRST,[$0A]
       NEXT CONTA3

       GOSUB FINSCRIVI                'FINALIZZA SETTORE

       CCLUST = CCLUST + 1            'AGGIORNA CONTA SETTORI PER CLUSTER
       IF CCLUST = 4 THEN             'SCRITTI 4 SETTORI AGGIORNO CLUSTER
       XCLUST = XCLUST + 1
       CCLUST = 0                     'AZZERO CONTA SETTORI PER CLUSTER
       ENDIF

       IND0 = IND0 + $0200
       IF IND0 = $0000 THEN           'AGGIORNA WORD ALTA OGNI 128 SETTORI
       IND1 = IND1 + 1
       ENDIF

       FOR X = 2 TO RIT               'Ritardo configurato
       PAUSE 1000                     
       GOSUB VPARA
       IF (ANTGPS=1) AND (SINCOFF>=TOFFGPS) THEN
       GPSOFF=1

       REPEAT
       IF (REC = 0) OR (TENSOFF = 1) THEN  'se SW2 su REC-OFF chiudo
       GOTO FINEREC                        'se SW1 su OFF chiudo
       ENDIF
       GOSUB LEGGIMOV
       IF X<=RIT THEN
       X=X+1
       ENDIF
       PAUSE 1000
       UNTIL SMOV=0
       SINCMOV=0
       SINCOFF=0
       GPSOFF=0                      'ACCENDO GPS
       PAUSE 2000
       ENDIF

       IF (REC = 0) OR (TENSOFF = 1) THEN   'SE SW2 SU REC-OFF CHIUDO
       GOTO FINEREC                         'SE SW1 SU OFF CHIUDO
       ENDIF

       NEXT X

       ENDIF

       WEND                          'FINE CICLO PRINCIPALE

'**********************************************
'* Scrittura Terminata
'* Calcolo cluster scritti
'* Aggiorno ROOT
'* Aggiorno FAT1
'**********************************************

FINEREC:

       GPSOFF=1                     'SPEGNIMENTO GPS
       LEDG = 0                     'SPEGNIMENTO LED GIALLO
       LEDR = 1                     'ACCENSIONE LED ROSSO

       IF CONTA3 != 503 THEN        'SETTORE DA COMPLETARE
       CONTA3 = (512 - CONTA3) / 2
       FOR CONTA4 = 1 TO CONTA3     'SALTA RIGHE
       SHIFTOUT SDI,SCK,MSBFIRST,[$0D]
       SHIFTOUT SDI,SCK,MSBFIRST,[$0A]
       NEXT CONTA4

       GOSUB FINSCRIVI                'FINALIZZA SETTORE

       CCLUST = CCLUST + 1            'AGGIORNA CONTA SETTORI PER CLUSTER
       IF CCLUST = 4 THEN             'SCRITTI 4 SETTORI AGGIORNO CLUSTER
       XCLUST = XCLUST + 1
       CCLUST = 0                     'AZZERO CONTA SETTORI PER CLUSTER
       ENDIF


       ENDIF

       TBYTEBASSA = ((4 * XCLUST) + CCLUST) * 512
       TBYTEALTA = ((4 * XCLUST) + CCLUST) ** 512

'Aggiorno settore ROOT con numero byte scritti

       IND0   = $D200                  'SCRIVO SETTORE 233
       IND1   = $0001                  'PER CARD DA 64MB
       GOSUB INISCRIVI

       FOR CONTA3 = $0400 to $041B     'BYTES INIZIALI SETTORE ROOT   
       I2CREAD SDA,SCL,CTL,CONTA3,[RES]   
       SHIFTOUT SDI,SCK,MSBFIRST,[RES]
       NEXT CONTA3

                                                    'SCRIVO I 4BYTE CONTENENTI
       SHIFTOUT SDI,SCK,MSBFIRST,[TBYTEBASSA.BYTE0] 'IL NR TOT BYTES DEL FILE
       SHIFTOUT SDI,SCK,MSBFIRST,[TBYTEBASSA.BYTE1]
       SHIFTOUT SDI,SCK,MSBFIRST,[TBYTEALTA.BYTE0]
       SHIFTOUT SDI,SCK,MSBFIRST,[TBYTEALTA.BYTE1]

       FOR CONTA3 = $0420 to $05FF     'BYTES FINALI SETTORE ROOT
       SHIFTOUT SDI,SCK,MSBFIRST,[$00]
       NEXT CONTA3

       GOSUB FINSCRIVI

'Aggiorno settore FAT1 con catene cluster scritti

       XCLUST = XCLUST + 5              'INIZIA DA CLUSTER 3
       CONTA4 = $0003                 'CLUSTER INIZIALE
       IND0 = $0200                   'SETTORE1 = FAT1
       IND1 = $0000
       GOSUB INISCRIVI
       SHIFTOUT SDI,SCK,MSBFIRST,[$F8]  'SCRIVO LA LABEL F8 FF FF FF
       FOR CONTA3 = 1 to 3
       SHIFTOUT SDI,SCK,MSBFIRST,[$FF]
       NEXT CONTA3

       CONTA3 = 4                     'NR DI BYTE SCRITTI

       WHILE CONTA4 < XCLUST
       SHIFTOUT SDI,SCK,MSBFIRST,[CONTA4.BYTE0] 'SCRIVO IL PUNTATORE
       SHIFTOUT SDI,SCK,MSBFIRST,[CONTA4.BYTE1]
       CONTA3 = CONTA3 + 2            'AGGIORNO NR BYTE SCRITTI
       CONTA4 = CONTA4 + 1            'AGGIORNO PUNTATORE FAT1
       IF CONTA3 = 512 THEN
       GOSUB FINSCRIVI
       CONTA3 = 0
       IND0 = IND0 + $0200
       IF IND0 = $0000 THEN           'AGGIORNA WORD ALTA OGNI 128 SETTORI
       IND1 = IND1 + 1
       ENDIF
       GOSUB INISCRIVI                'NUOVA TRANSAZIONE
       ENDIF
       WEND

       SHIFTOUT SDI,SCK,MSBFIRST,[$FF]   'FINE FILE
       SHIFTOUT SDI,SCK,MSBFIRST,[$FF]   

       CONTA3 = CONTA3 + 2

       WHILE CONTA3 < 512             'SCRIVO I RESTANTI BYTE DEL SETTORE
       SHIFTOUT SDI,SCK,MSBFIRST,[$00]   
       CONTA3 = CONTA3 + 1
       WEND

       GOSUB FINSCRIVI

       LEDR = 0
       LEDV = 1

       END

ERRORE:
        GOTO FINE
ERRORE2:
        GOTO FINE
FINE:

        LEDG=1 'Accensione di tutti e tre i led
        LEDV=1
        LEDR=1

        END

