'*****************************************************************************
'ALMVoltTX: Alarme de tension pour Batterie TX LiPo 3 lments.
'*****************************************************************************
'
' Compensation de la tension d'alerte en fonction de la temprature 
'( 20 mV/lt/C entre -10 et 23C )
'
' PIC 12F675 @ 4Mhz, Horloge interne
'
'
'*****************************************************************************
'Config Processeur
'
'
@ __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _MCLRE_ON & _PWRTE_ON & _BODEN_OFF &_CP_ON 


'*****************************************************************************
' Config Timer 1 : Dbordement toutes les 262144 S
'
T1CON	= %00100100	' No gate, Prescaler 1/4, internal clock, Stop


'*****************************************************************************
' Config ADC

ADCON0 	= %11000000	' Justif Droite, VRef pin

ANSEL 	= %01111011 ' RC Osc, ADAA


'*****************************************************************************
' Config Comparateur

CMCON	= 7


'*****************************************************************************
'Config Interruptions

INTCON	= %00000000

PIR1	= %00000000

PIE1	= %00000000


'***************************************************************************** 
' DEFINES
'
'
DEFINE OSC 4

DEFINE OSCCAL_1K 1	'Ajustage fin Horloge

DEFINE ADC_BITS 10 ' Set number of bits in result (8, 10 or 12)

DEFINE ADC_CLOCK 3 ' Set clock source (rc = 3)

DEFINE ADC_SAMPLEUS 50 ' Set sampling time in microseconds


'*****************************************************************************
'Dfinition des E/S
'
'
Batt_	var GPIO.0
Vref_	var GPIO.1
Buzz_	var GPIO.2
Temp_	var GPIO.4
Led_	var GPIO.5

GPIO 	= 0
TRISIO 	= %11011011


'*****************************************************************************
' Variables
'
'
MesMoy	var WORD			' 0  5106 counts
VoltCor var WORD			' 9000  12600 mV
DTemp	var WORD			' 2630  3000  mV	( 10* K ...)
Ubatt	var WORD			' 9000  12600 mV
UTemp	var WORD			' 0  1023 counts ...
Delay	var WORD

Index	var Byte
I 		var Byte


'*****************************************************************************
'Constantes
Batt	con 0
VRef	con 1
Temp	con 3

nbel	con 3				' nb d'lments 12v = 3 LiPos ...


'*****************************************************************************
'*****************************************************************************
'Mise en route 


PAUSE 1000 					' Stabilisation  l'allumage TX
								' et Allumage Led
Led_ = 1

'*****************************************************************************
Mesure:

	MesMoy = 0
	
FOR i = 1 to 5

	ADCIN Batt, UBatt		' rsultat en mV = 4* N * 4.096/1024

	MesMoy =  MesMoy + ( UBatt / 5 )
	
NEXT I

	UBatt = 16*MesMoy 		' en mV batterie
				
	MesMoy = 0
	
FOR I = 1 to 5	

	ADCIN Temp, UTemp		' rsultat en 1/10 degrs = 4* N * 4.096/1024
	
	Mesmoy = MesMoy + ( UTemp / 5 )
	
NEXT I

	DTemp = 4*MesMoy
	

'*****************************************************************************
'Correction de tension en fonction de la temprature ( + 20 mv / lt /C )

IF DTemp >= 2960 THEN 

	VoltCor = UBatt			' Pas de correction au dessus de 23C
	
ELSE

VoltCor = UBatt + (20* nbel *( 2960 - DTemp )/10)	' + 60 mV / C en dessous de 23C

ENDIF

'WRITE 1, Ubatt.Highbyte
'WRITE 2, Ubatt.Lowbyte
'
'WRITE 4, Voltcor.HighByte
'WRITE 5, Voltcor.Lowbyte
'
'WRITE 7, Dtemp.Highbyte
'WRITE 8, Dtemp.lowbyte
'
'STOP

'*****************************************************************************
'Signalisation

IF  VoltCor <= 11100 THEN


	IF VoltCor >= 10950 THEN		' plage haute
	
		 Delay = (VoltCor/10) - 1080 
	
	LED_ 	= 0
	BUZZ_ 	= 1
	
	PAUSE ( 300 + (30*Delay))
	
	LED_ 	= 1
	BUZZ_	= 0
	
	PAUSE ( 300 + (30*Delay))
	
	GOTO Bouclage
	ENDIF
		
	
	IF VoltCor >= 10800 THEN		' plage basse
	
		Delay = (VoltCor/10) - 1080 
		 
	ENDIF
	
	LED_ 	= 0
	BUZZ_ 	= 1
	
	PAUSE ( 60 + (46*Delay))
	
	IF VoltCor < 10800 THEN MESURE	'Buzzer ET Led en continu ...
	
	LED_ 	= 1
	BUZZ_	= 0
	
	PAUSE ( 60 + (46*Delay))
		
ELSE								'Flash 2ms/1000ms

	BUZZ_ = 0
	
	Led_ = 0
	PAUSE 2
	Led_ = 1
	PAUSE 1000
	
ENDIF

'*****************************************************************************
Bouclage:


GOTO Mesure

END



	





