
   ' Microchip C18 USB loader modified & re-compiled for use
   ' with 18F2550

   ' Switch & LED connections for Microchip USB loader
   ' RB0 ----/\/\/----|>|----gnd
   ' RB1 ----/\/\/----|>|----gnd
   ' /MCLR should have pull-up resistor with switch to ground for reset
   ' RB6 ----/\/\/----|>|----gnd. LED for code example below
   
   ' RB4. install a 10K pullup on RB4 and a switch to gnd
   ' on switch press RB4 is grounded.
        
   ' Program 2550_Loader.hex into 18F2550 then install PIC on your board
   ' Make sure you have a 20MHz crystal installed
   
   ' Connect board to USB port. Press & hold switch on RB4 while pressing
   ' and releasing switch on /MCLR. LEDs on RB0 & RB1 should alternate blinking
   ' on/off
   
   ' Start Microchip USB PC software. Select the board. LEDs should now toggle on/off
   ' together indicating the board is recognized & ready to boot-load.
   
   ' Compile the sample below. Use the Microchip USB PC loader software to open the
   ' USB_2550.hex file.
   
   ' Click Program Device.
   
   ' You can use the on-screen USB loader software Execute button or press the reset
   ' button on /MCLR to run the user program.
   
    DEFINE OSC 48          
    DEFINE  RESET_ORG 800h  ' Reset vector when using Microchip USB boot-loader
    
    X VAR BYTE
    ADCON1 = 15
    
Main:
    FOR X = 50 TO 255 STEP 5
      HIGH PORTB.6
      PAUSE X
      LOW PORTB.6
      PAUSE X
    NEXT X
    GOTO Main
      
    END
