unit FormMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, _GClass, AbLED, AbSwitch, AbGearDial, AbDial, AbClock;

const

   // input and out buffer size constants...
   BufferInSize  = 8;
   BufferOutSize = 8;
type

   // input and output buffers...
   TBufferIn = array[0..BufferInSize] of byte;
   TBufferOut = array[0..BufferOutSize] of byte;

   // main form
   TForm1 = class(TForm)
    AbLED1: TAbLED;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    ProgressBar1: TProgressBar;
    GroupBox2: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    AbClock1: TAbClock;
    AbGearDial1: TAbGearDial;
    AbGearDial2: TAbGearDial;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    AbLED2: TAbLED;
    AbLED3: TAbLED;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure AbGearDial1ValueChange(Sender: TObject);
    procedure AbGearDial2ValueChange(Sender: TObject);
    procedure AbGearDial2MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure AbGearDial1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
   private
      FBufferIn:TBufferIn;
      FBufferOut:TBufferOut;
      function USBEvent(var Msg: TMessage): Boolean;
   public
   end;

var
  Form1: TForm1;

implementation

uses
   cUSBInterface,
   cUSBInterfaceTypes;

const

   // vendor and product ID constants...
   VENDOR_ID           = 6017;
   PRODUCT_ID          = 2000;

{$R *.DFM}

{
****************************************************************************
* Name    : Create                                                         *
* Purpose : Create the main form                                           *
****************************************************************************
}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.HookMainWindow(USBEvent);
  Connect(Application.Handle);

  Button1Click(Sender); //Setup values in PIC 

end;
{
****************************************************************************
* Name    : Destroy                                                        *
* Purpose : Free the main form                                             *
****************************************************************************
}
procedure TForm1.FormDestroy(Sender: TObject);
begin
   Application.UnHookMainWindow(USBEvent);
end;
{
****************************************************************************
* Name    : USBEvent                                                       *
* Purpose : DLL message handler hook                                       *
****************************************************************************
}
function TForm1.USBEvent(var Msg: TMessage): Boolean;
var
   DevHandle:cardinal;
   TextBuffer:array[0..255] of char;
begin
  result := False;
  if Msg.Msg = WM_HID_EVENT then
  begin
     case Msg.WParam of

        // a HID device has been plugged in...
        NOTIFY_PLUGGED :
        begin

           // is it our HID device...
           DevHandle := Msg.LParam; // handle of HID device in this message
           if (GetVendorID(DevHandle) = VENDOR_ID) and (GetProductID(DevHandle) = PRODUCT_ID) then
           begin
              // add your code here, for example...
              GetProductName(DevHandle, TextBuffer, 256);
              Label1.Caption := string(TextBuffer);
              GetVendorName(DevHandle, TextBuffer, 256);
              Label1.Caption := Label1.Caption + ' --- ' + string(TextBuffer);
              AbLED1.Checked := True;
           end;
           result := true;
        end;

        // a HID device has been device removed...
        NOTIFY_UNPLUGGED :
        begin

           // is it our HID device...
           DevHandle := Msg.LParam; // handle of HID device in this message
           if (GetVendorID(DevHandle) = VENDOR_ID) and (GetProductID(DevHandle) = PRODUCT_ID) then
           begin
              // add you code here
              Label1.Caption := 'No USB device present';
              AbLED1.Checked := False;
           end;
           result := true;
        end;

        // a HID device has been attached or removed. This event is fired after
        // either NotifyPlugged or NotifyUnplugged.
        NOTIFY_CHANGED :
        begin
           // get the handle of the device we are interested in
           // and set it's read notification flag to true...
           DevHandle := GetHandle(VENDOR_ID,PRODUCT_ID);
           SetReadNotify(DevHandle,true);
           result := true;
        end;

        // a HID device has sent some data..
        NOTIFY_READ :
        begin
           DevHandle := Msg.LParam; // handle of HID device in this message
           if (GetVendorID(DevHandle) = VENDOR_ID) and (GetProductID(DevHandle) = PRODUCT_ID) then
           begin
               // read the data - remember that first byte is report ID...
               // Report ID, Pot1, PORTB?
               Read(DevHandle,@FBufferIn);
               ProgressBar1.Position := FBufferIn[1];
               Edit1.Text :=  Chr(FBufferIn[2]) + Chr(FBufferIn[3]); //'Testing';
               if (FBufferIn[2]=0) then
                 AbLED3.Checked := True else
                 AbLED3.Checked := False;
               if (FBufferIn[3]=0) then
                 AbLED2.Checked := True else
                 AbLED2.Checked := False;

               // process data here...
           end;
           result := true;
        end;
     end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  index: Integer;
  DevHandle:cardinal;
begin
  FBufferOut[0] := $0;
  for index := 1 to BufferOutSize do
    FBufferOut[index] := 0;

  if CheckBox1.Checked then
    FBufferOut[1] := FBufferOut[1] or $01 else
    FBufferOut[1] := FBufferOut[1] or $00;
  if CheckBox2.Checked then
    FBufferOut[1] := FBufferOut[1] or $02 else
    FBufferOut[1] := FBufferOut[1] or $00;

  FBufferOut[2] := AbGearDial1.Digit and $00FF;
  FBufferOut[3] := trunc(AbGearDial1.Digit / 256);

  FBufferOut[4] := AbGearDial2.Digit;

  DevHandle := GetHandle(VENDOR_ID, PRODUCT_ID);
  Write(DevHandle,@FBufferOut);

end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TForm1.AbGearDial1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  (Sender as TAbGearDial).SetFocus;
end;

procedure TForm1.AbGearDial1ValueChange(Sender: TObject);
begin
  Label2.Caption := 'PWM ' + AbGearDial1.DigitStr;
  Button1Click(Sender);
end;

procedure TForm1.AbGearDial2MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  (Sender as TAbGearDial).SetFocus;
end;

procedure TForm1.AbGearDial2ValueChange(Sender: TObject);
begin
  Label3.Caption := 'Frequency ' + AbGearDial2.DigitStr;
  Button1Click(Sender);
end;



end.


