'
'
'*********************************
'*  Name    : Pr_SCOPE.pbp       *
'*  Author  : Gianni             *
'*  Date    : 21/12/07           *
'*  Version : 2.0  29/12/07      *
'*********************************
'
'
 @ DEVICE PIC16F690,INTOSCIO,WDT_OFF,PWRT_ON,MCLR_OFF,PROTECT_OFF
 @ DEVICE PIC16F690,BOD_OFF,CPD_OFF,IESO_OFF,FCMEN_OFF
'
 DEFINE OSC 8           'internal oscillator
'
' DEFINE INTHAND Myint   'define interrupt handler
 DEFINE LCD_BITS 4      ' Set LCD bus size (4 or 8 bits)
 DEFINE LCD_LINES 2     ' linee display
'
 DEFINE LCD_DREG  PortC
 DEFINE LCD_DBIT  0     ' bit 0-3  bus x display
 DEFINE LCD_RSREG PortC '
 DEFINE LCD_RSBIT 4     ' R/S  PortC.4
 DEFINE LCD_EREG PortC  '
 DEFINE LCD_EBIT 7      ' En  PortC.7
'
'    NON cambiare l'ordine obbligatorio per la conversione bin>BCD
reg0        var   byte $74         'lsd del valore binario da convertire
reg1        var   byte $75         'vengono tutti portati ad FF
reg2        var   byte $76
reg3        var   byte $77         'msd
'         risultato conversione 32bit bcd
Dig0        var   byte $78        'BCD lsd
Dig1        var   byte $79        'rappresentazione in BCD del contatore 32 bit
Dig2        var   byte $7a
Dig3        var   byte $7b
Dig4        var   byte $7c        'BCD msd
'
Wsave       var   byte $7D  SYSTEM      'uso interrupt  sono visibili sempre
Ssave       var   byte $7E  SYSTEM      'nei 3 banchi
Psave       var   byte $7F  SYSTEM      'fino a 7F
'
'
TmpW        var   word
TmpW2       var   word
NumW        var   word
Dum1        var   word
'
Hicntr      var   word            '32bit frequency counter
Locntr      var   word
'
'
Timbase     var   byte            'copia sampling rate A/D
Rate        var   byte            'counter sampling rate
'
Index       var   byte
Vmin        var   byte
Vpp         var   byte
Voffset     var   byte
Previous    var   byte
Row         var   byte
IndxBT      var   byte            'pointer tabella base tempi
'
Tmp1        var   byte            'temporanee
Tmp2        var   byte
Sbr1        var   byte            'uso in sub
Sbr2        var   byte
Sbr3        var   byte
'
'
Flag_V      var   byte        'flag vari
'
Fl_Tmp      var   Flag_V.0      '
'l_1        var   Flag_V.1      '
'l_2        var   Flag_V.2      '
'l_3        var   Flag_V.3      '
'l_4        var   Flag_V.4      '
'           var   Flag_V.5      '
'           var   Flag_V.6      '
'           var   Flag_V.7      '
'
BufABcd     var   byte[09]      'bank0    'buffer Ascii conversione 32bit
Adbuf       var   byte[63] bank1    'deposito acquisizioni A/D & lcd user char.
Pixi        var   byte[39] bank2    'buffer bit map
'
'
'Vcc                        pin 1
'Gnd                        pin 20
'                PortA.7   'na
'                PortA.6   'na
TrigIN      var  PortA.5   'pin 2   input Timer1 counter
'           var  PortA.4   'pin 3   output
Push_But    var  PortA.3   'pin 4   input Button
'           var  PortA.2   'pin 17  output
LedB        var  PortA.1   'pin 18  output Led
'           var  PortA.0   'pin 19  analog input A/D
'
'Tx         var  PortB.7   'pin 10  output
'           var  PortB.6   'pin 11  output
'Rx         var  PortB.5   'pin 12  input
'           var  PortB.4   'pin 13  output
'                PortB.3   'na
'                PortB.2   'na
'                PortB.1   'na
'                PortB.0   'na
'
'           var  PortC.7   'pin 9   output display En
'           var  PortC.6   'pin 8   output
'           var  PortC.5   'pin 5   output
'           var  PortC.4   'pin 6   output display R/S
'           var  PortC.3   'pin 7   output display D7
'           var  PortC.2   'pin 14  output    "    D6
'           var  PortC.1   'pin 15  output    "    D5
'           var  PortC.0   'pin 16  output    "    D4
'
'
'---------- COSTANTI
'
Cr          con   13
Lf          con   10
Negativo    con   128
LedOn       con   1
LedOFF      con   0
'
'posizioni memoria valori in eeprom
VrefAD      con   2            'posizione eeprom v.alimentazione
AdjFreq     con   4            'adj frequency measure
Rates       con   16           'start sample rate table
'--------------------------------
'
'
        Goto inizio            ' Skip around interrupt handler
'
asm
;
;valore da convertire in reg0-4 risultato in dig4-0
;conversione a 32bit da binario a bcd
_cv_bi2bcd
        movlw   32
        movwf   r0              ;bit counter
        clrf    _dig0           ;lsd
        clrf    _dig1
        clrf    _dig2
        clrf    _dig3
        clrf    _dig4           ;msd
b2bcdl
        movlw   _dig0            ;point at first bcd
        movwf   FSR
b2bcdil
        movlw   33h
        addwf   INDF,f          ;add to low and high nybbles
        btfsc   INDF,3
        andlw   0f0h            ;low result >7 . OK (take the 3 out)
        btfsc   INDF,7
        andlw   0fh             ;hi > 7 OK.
        subwf   INDF,f          ;any results <=7, subtract back.
        incf    FSR,f           ;Inc. pointer for next time
        movlw   Wsave
        subwf   FSR,w
        btfss   STATUS,C
        goto    b2bcdil         ;If not done, do the inner loop again.
;
        rlf     _reg0,f
        rlf     _reg1,f
        rlf     _reg2,f
        rlf     _reg3,f         ;Get another bit out of bin.
        rlf     _dig0,f         ;Put bit into bcd.
        rlf     _dig1,f
        rlf     _dig2,f
        rlf     _dig3,f
        rlf     _dig4,f
        decfsz  r0,f            ;Do more?
        goto    b2bcdl          ;Yes.
        return
;
endasm
'
Pk_Pk:
      Index = 0
      Sbr1 = 255        'min --> max
      Sbr2 = 0          'max --> min
      repeat
            Sbr3 = Adbuf[Index]              'ricerca max,min
            if Sbr3 > Sbr2 then Sbr2 = Sbr3  'attuale > max
            if Sbr3 < Sbr1 then Sbr1 = Sbr3  'attuale < min
            Index = Index + 1
      until Index > 39
      Vpp = Sbr2 - Sbr1                      'calcola delta
      Voffset = Sbr1                         'save offset
'toglie offset ai valori acquisiti
      Index = 0
      repeat
            Sbr3 = Adbuf[Index] - Sbr1       'scala valori acquisiti
            Adbuf[Index] = Sbr3              'save again
            Index = Index + 1
      until Index > 39
      return
'
'crea una immagine bitmap trova il punto da mettere sul grafico
' punto =  Ad*8/256   adatto per scala 0-255
'ritorna valori tra 0 e 7
'N.B. le letture sono scalate dell'offset per avere massima risoluzione
'         TmpW = Adbuf[Index] * 8           'riporta lettura in range x pixel
'         tmpW = tmpW >> 8                  'scala 0 255
'         Tmpw = TmpW /(Vpp+1)              'scala dinamica
Make_Bit_Map:
'ricerca fattore scala x adattare valori
                        if Vpp < 32 then
                           Dum1 = 32
                        else
                           Dum1 = Vpp + 1
                        endif
      Index = 0
      repeat
         Sbr1 = (Adbuf[Index] * 8) / Dum1
'deve avere un valore da 0 a 7 che indica il pixel da accende
         lookup Sbr1,[1,2,4,8,16,32,64,128],Sbr2
'sostituisce il pixel con il suo peso binario
         Pixi[Index] = Sbr2
         Index = Index + 1
      until Index > 39
'join punti sul grafico
      Previous = Pixi[0]                  'primo punto
      Index = 1
      repeat
         Sbr1 = Pixi[Index]               'punto attuale
         if Sbr1 = Previous then Succ_t   'orrizzontale  skip test
         if Sbr1 > Previous then          'linea in salita
'line up
            Sbr2 = Sbr1                   'copia x fill bit risultato
            Sbr3 = Previous << 1          'inizia da un punto sopra al precedente
            while Sbr3 < Sbr1             'fino a raggiungere l'attuale
               Sbr2 = Sbr2 | Sbr3         'aggiunge nuovo pixel
               Sbr3 = Sbr3 << 1           'sale
            wend
         else                             'linea in discesa
'line down
            Sbr2 = Sbr1                   'copia x fill bit risultato
            Sbr3 = Previous >> 1          'inizia da un punto sotto al preced.
            while  Sbr3 > Sbr1            'fino a raggiungere l'attuale
               Sbr2 = Sbr2 | Sbr3         'aggiunge nuovo pixel
               Sbr3 = Sbr3 >> 1           'scende
            wend
         endif
         Pixi[Index] = Sbr2               'aggiorna immagine
Succ_t:
         Previous = Sbr1                  'punto attuale diventa precedente
         Index = Index + 1
      until Index > 39                    'scan tutte locazioni
'
'converte rappresentazione grafica della forma d'onda
'in formato compatibile per display. scandisce in orrizzontale la bitmap
'a gruppi di 5 colonne e costruisce il pattern per custom user characters
'produce 64 bytes per gli 8 caratteri definibili dall'utente
Make_user_char:
     Row = 0                       ' pointer char da inviare a display
     Index = 0                     'pointer lettura
     repeat
       Sbr1 = 128                  'inizia da pixel in alto
       repeat
         Tmp2 = 0                  'dato da inviare
         Sbr3 = Index              'usa una copia
         Sbr2 = 16                 'scansione orriz. dei bit
         repeat
            Tmp1 = Pixi[Sbr3]
            Tmp1 = Tmp1 & Sbr1     'isola bit da d7 a d0
            if Tmp1 > 0 then
               Tmp2 = Tmp2 | Sbr2     'produce dato uscita
            endif
            Sbr2 = Sbr2 >> 1        '16,8,4,2,1
            Sbr3 = Sbr3 + 1         'x 5 colonne
         until Sbr2 = 0
'in Tmp2 pronto dato  del primo carattere
         AdBuf(row) = Tmp2
         row = row + 1              'scende di una riga
         Sbr1 = Sbr1 >> 1           '128,64,32,16,8,4,2,1
       until Sbr1 = 0
       Index = Index + 5            'al gruppo  seguente
     until Index > 39
     return
'
'Quick explanation on how to implement user-defined characters:
'First you will need to make a pixel definition for the characters
'you want to use.  Below is the pixel definition for an underlined
'0' (char code 0x30) based on a 5x7 dots character definition:
'       |   bits    | byte
'  row  | 76543210  | value
'  ------------------------
'  000  |     xxx   | 0x0E
'  001  |    x   x  | 0x11
'  010  |    x  xx  | 0x13
'  011  |    x x x  | 0x15
'  100  |    xx  x  | 0x19
'  101  |    x   x  | 0x11
'  110  |     xxx   | 0x0E
'  111  |    xxxxx  | 0x1F
'The byte values need to be loaded into CGRAM address 00cccrrr
'-  ccc = user-defined character number (0..7)
'-  rrr = row number of the user-defined character (0..7)
'
Update_CGRAM:
      Row = 0                 'buffer pointer
      Sbr3 = 0                'user definable counter
      repeat
         Sbr2 = Sbr3 + 64     'comando scrittura cgram
         lcdout $FE,Sbr2      'N^ user defined to command register
         Sbr2 = 0
         repeat
            Sbr1 = AdBuf(Row)
            lcdout Sbr1       'user defined
            Row = Row + 1
            Sbr2 = Sbr2 + 1
         until Sbr2 > 7       'x 8 row
         Sbr3 = Sbr3 + 8      'next character
      until Sbr3 > 56
'      lcdout 0,1,2,3,4,5,6,7
      return
'
'
Cls:
      lcdout $FE,1
      return
'
'==========================================
' misura frequenza usando tmr1 come contatore e tmr0 come gate di misura
Freqy:
         LedB = LedON
         Hicntr = 0
'         option_reg = %11000111     'prescaler 256
         read AdjFreq,TmpW2.byte1   'recupera aggiustamento gate time
         read (AdjFreq+1),TmpW2.byte0
'adjust for precise 1sec. gate time
'tmr0 tic = 2e6 / 32768 = 16,384mS   0,999424S + 576uS = 1S   61tic
'           2e6 / 65536 = 32,768mS   0,98304S + 16,96mS = 1S  30tic
'
'no gate control no prescale no sync  external clock source
         t1con = %00000010             'stop tmr1
         Sbr1 = 0                      'gate counter
         tmr0 = 0
         tmr1l = 0
         tmr1h = 0                     'clr counter
         intcon.2 = 0                  'clr tmr0if
         pir1.0 = 0                    'clr tmr1if
         tmr0 = 0                      'start gate misura
         t1con.0 = 1                   'start tmr1
         repeat
               if pir1.0 = 1 then      'tmr1 overflow ?
                   pir1.0 = 0          'clr overflow
                   Hicntr = Hicntr + 1
               endif
               if intcon.2 = 1 then    'Tmr0 overflow ?
                   intcon.2 = 0        'clr overflow
                   Sbr1 = Sbr1 + 1     'gate counter
               endif
         until Sbr1 > 29               '32,768mS * 30 = 0,98304S.
         pauseus TmpW2                 '0,98304 + 16960uS = 1S
         t1con.0 = 0                   'stop tmr1
         if pir1.0 = 1 then            'tmr1 overflow ?
               Hicntr = Hicntr + 1
         endif
         Locntr.byte0 = tmr1l
         Locntr.byte1 = tmr1h
         LedB = LedOFF
         return
'
'converte in mv la lettura dell' A/D
Make_volt:
       read VrefAD,TmpW2.byte1            'recupera vref da eeprom
       read (VrefAd+1),TmpW2.byte0
       numW = TmpW * TmpW2               'tutto in mv.
       TmpW2 = DIV32 256                 '(A/D*5000)/256
       Lcdout dec TmpW2 dig 3,".",dec TmpW2 dig 2
       return
'
'
Zero_blank:
     Index = 0
     Sbr1 = dig0         'lsd
     gosub Bcd_split
     Sbr1 = Dig1
     gosub Bcd_split
     Sbr1 = dig2
     gosub Bcd_split
     Sbr1 = dig3
     gosub Bcd_split
     Sbr1 = dig4         'msd
     gosub Bcd_split
     Index = 9
     Fl_Tmp = 0
     while index > 0
           if BufAbcd[Index] > 0 or Fl_Tmp = 1 then
              BufAbcd[Index] = BufAbcd[Index] + "0"   'ascii 0
              Fl_Tmp = 1
           else
              BufAbcd[Index] = " "         'space
           endif
           index = index - 1
     wend
     BufAbcd[Index] = BufAbcd[Index] + "0"   'lsd non blank
     return
'
Bcd_split:
     BufAbcd[Index] = Sbr1 & %00001111
     Index = Index + 1
     Sbr1 = Sbr1 >> 4
     BufAbcd[Index] = Sbr1
     Index = Index + 1
     return
'
'
'==========================================
Inizio:
'
        TRISA = %11101001        'portA configura direzione
        TRISB = %00101111        'portB configura direzione  0=out 1=in
        TRISC = %00000000        'portC configura direzione
        PortA = %11111111        '
        PortB = %10111111        'preset uscite
        PortC = %00000000
        Osccon = %01110001       'select 8MHz internal clock source
'disable pullup
        WpuA = %00000000
        WpuB = %00000000
'disable comparators
        CM1CON0 = 0
        CM2CON0 = 0
        CM2CON1 = 0
'Init timer1
        T1CON = %00000000         'prescale=1,Internal source,Tmr1 stop
'Init eusart
'        RCSTA = %10010000        'Enable serial port and continuous receive
'        TXSTA = %00100000        'Enable transmit  BRGH = 0
'        SPBRGH = 00              '
'        SPBRG = 12               '38400 @8MHz
'        BAUDCTL.3 = 1            ' Enable 16 bit baudrate generator
'Init A/D
        Ansel = %00000001        'portA digital  An0
        AnselH = %00000000       'portC digital
'        Adcon1 = %01010000       'clock conversione Fosc/16 = 2uS
        Adcon0 = %00000000       'left justified,Vref = Vdd,An0,ADC stop
'no pullup,rising edge, fosc/4, prescaler=1:256
        option_reg = %11000111
        intcon = 0               'no interrupt
'        Tmp1 = RCREG             'scarica uart receiver
'        Tmp1 = RCREG             'scarica uart receiver
        pause 200                'wait for display
        gosub cls
        lcdout " Poor SCOPE v.2"
        pause 1000
        lcdout $FE,12              'cursor off
        Adcon0 = %00000001          'adc on
'        Adcon1 = %00010000         'clock conversione Fosc/8 = 1uS
        Adcon1 = %01010000          'clock conversione Fosc/16 = 2uS
        IndxBT = 0                  'pointer Time Base divider  Max speed
        Timbase = 0                 'Max speed
'--------------
P_scope:
         pause 20
         if Push_But = 0 then             'Button On
            IndxBT = IndxBT + 1
            if IndxBT > 09 then IndxBT = 0
            Sbr1 = IndxBT + Rates         'add offset
            read Sbr1,Timbase             'get sampling rate divider
            gosub cls
            lcdout " S. Rate = ",dec Timbase
            pause 400                    'display
            while Push_But = 0           'rilascia tasto
               pause 10
            wend
        endif
        Index = 0                      'A/D buffer pointer
        Dum1 = 0                       'timeout
'wait for level 0 or timeout
         repeat
              if Push_But = 0 then P_scope     'user quit
              Dum1 = Dum1 + 1             'timeout counter
              LedB = Tmr0.7               'flash led
         until Trigin = 0 or Dum1 = 0     'attende livello 0  o timeout
         Dum1 = 0                          'timeout
'wait for rising edge trigger or timeout
         repeat                            'loop su livello 0
            if Push_But = 0 then P_scope   'user quit
             LedB = Tmr0.7                 'flash led
             Dum1 = Dum1 + 1               'timeout counter
         until Trigin = 1  or Dum1 = 0    'triggered or timeout
'start acquisizione
         ADCON0.1 = 1
         repeat
              Rate = 0                'sample rate divider
              repeat
                  while ADCON0.1 = 1      'A/D ready ?
                  wend                    'wait eoc
                  Rate = Rate + 1
                  ADCON0.1 = 1            'start new conversion
              until Rate > Timbase
              Adbuf[Index] = ADRESH       'get & save  8 bit
              Index = Index + 1
         until Index > 39                 'fill buffer 40 samples
'acquisizione completata
         gosub Pk_Pk                     'rileva Vpp
         gosub Make_Bit_Map              'crea immagine
         gosub Make_user_char            'converte per display
         gosub Update_CGRAM              'invia bitmap al display
         gosub Freqy                     'misura frequenza
'---
         gosub Cls
         lcdout "Vpp          Vof"
         lcdout $FE,132                  'locate cursor
         lcdout 0,1,2,3,4,5,6,7          'display bitmap
         lcdout $FE,$C0                  'locate cursor
         TmpW = Vpp
         gosub Make_volt                 'convert to mV  & display Vpp
         lcdout $FE,$CD                  'locate cursor
         TmpW = Voffset
         gosub Make_volt                 'convert to mV  & display Voffset
         reg3=hicntr.byte1               'binary to string conversion
         reg2=hicntr.byte0
         reg1=locntr.byte1
         reg0=locntr.byte0
         call cv_bi2bcd                  'binary 2 bcd
         gosub Zero_Blank
         lcdout $FE,$C4                  'locate cursor
         Index = 5                       'display 6 digit
         repeat
            lcdout BufAbcd[Index]       'display frequency
            index = Index - 1
         until Index > negativo          '5-4-3-2-1-0
'       lcdout hex2 dig2,hex2 dig1,hex2 dig0
'       lcdout hex4 hicntr,hex4 locntr
         lcdout "Hz"
         pause 100
         goto P_scope
'
'
        data @00 ,$FF   'non usato
        data @01 ,$FF   'non usato
' Vref conv. A/D nominale 5000mV  V. alimentazione
        eeprom VrefAD,[$13,$88]    ' hi,lo  5000
'Frequency counter gate time adj
        eeprom AdjFreq,[$42,$40]    'hi,lo  16960
'A/D Sample rate divider
        eeprom Rates,[0,1,2,4,8,16,32,64,128,192]
'
        eeprom [255,255,255]       'non usato
'

