' -----[ Title ]-----------------------------------------------------------
'
' File...... Waypoint.bas
' Purpose... Read data from supersentence and display and send waypoint
' MPU ...... Pic 16F88
' Author.... Tom Gonser
' Started... Feb 12, 2005
' Updated .. March 5, 2005 - TG - started working TracID
' Updated .. March 7, 2005 to fit in 4000b memeory
' BUGS:
'		TracID not working
'		Checksum not working right (I think)
'     
' -----[ Program Description ]---------------------------------------------
' 
' This program will read data from the airlink over the serial port, reversing
' the pins normally used so we can use standard serial cables.  The variables for pinin
' and pinout can be used to change this gloabally if needed. 
'
' The pic reads data in, looking for the start bits (Dec 02 and 47).  then it 
' reads the rest of the SS into an array called SSMAX(p).  From there, we can read
' any of the array we want in order to display the data, or do calculations.
'
' The program also will take the data collected and form a 'waypoint sentence' which
' will be OUTPUT over a second serial port which can be connected to a GPS.  It will
' output this 'waypoint sentence' every 5 seconds, so the unit tracked will show up 
' on a GPS screen.
'
' PIC16F88 port over from PICF876A - hardware connections
' PIC		External
' ----		---------
' RB2	 	- out to RXBase
' RB1		- in from RXBase   
' RA0		tx to LCD at 9600b
' RA1	    tx to Hyperterm at 4800b     
' MCLR		5v         
' Vdd		5v
' Vss		gnd
' Gnd		DB9-pin 5 (gnd)


' -----[ Revision History ]------------------------------------------------
'
' 
' -----[ Includes/Defines ]---------------------------------------------------------
'
include "modedefs.bas"	'include serout defines
'define loader_used 1		Used for bootloader only

@__config _CONFIG1, _INTRC_IO & _WDT_OFF & _PWRTE_ON & _LVP_OFF & _CP_OFF

DEFINE OSC 8		
OSCCON=%01111000		 '8 Mhz
ANSEL=3 'set a.0 and a.1 as digital input

' -----[ Constants ]-------------------------------------------------------
'

' -----[ Variables ]-------------------------------------------------------
'
RX 				var byte				'Receive byte
STX		 		var Byte 				'Recieve byte for LCD

Cpinin 			var PortB.1				' reversed for maxstream direct connection - in from radio
Cpinout 		var PortB.2				' reversed for maxstream direct connection - out to radio

Apinout			var PortA.0				' out to LCD - changed this
AGPSout 		var PortA.1				' out to GPS

'TID_array		var byte [39]			' array for CAN conversion
TID				var byte		    	' TID = CAN conversion byte
SSMAX       	var byte [34] 			' the big matrix
Wpt_Array		var byte [28]			' used for creating checksum for waypoint

Dec_temp	 	var word				' temperature
Dec_tempf	 	var word				' temperature
Dec_mb			var word				' millibars
Dec_lat1		var word				' first part of lat
Dec_lat2		var word				' second part of lat
Dec_long1		var word				' first part of long
Dec_long2		var word				' second part of long
Dec_timeSS		var byte				' time ss
Dec_timeSS1		var byte				'
Dec_timeMM		var byte				' time mm
Dec_timeMM1		var byte
Dec_timeHH		var byte				' time hh
Dec_timeHH1		var byte
Dec_volt		var word				' volts
Dec_speed		var word				' speed (mph)
wpt				var word				' waypoint - 6 letters max
CANvalue		var	byte				' value of the can
TracID			var word				' tracid - used in waypoint

Cksum			var byte				' aggregator
'Way1			var byte				' first waypoint
'WayNext			var byte				' next to XOR

'SSD6        	var byte				' used to convert to decimal
'SSD5        	var byte				' used to convert to decimal
SSD4        	var byte				' used to convert to decimal
SSD3        	var byte				' used to convert to decimal
SSD2        	var byte				' used to convert to decimal
SSD1        	var byte				' used to convert to decimal

flagbit			var	byte				' [2] contains elements of status ****************************
E_True			var flagbit.0			' see below
S_True			var flagbit.1			' see below
Panic			var flagbit.7			' see below
E_Byte			var byte				' container for the letter
S_Byte			var byte				' container for the letter
								' System Status/Information Flags
								' Bit 7 (most significant) indicates the PANIC input 
								' Bit 6  State of MPU RB7
								' Bit 5  State of MPU RB6 
								' Bit 4  State of MPU RA5
								' Bit 3, if set, indicates GPS Altitude is negative
								' Bit 2, if set, indicates Vertical Speed is negative
								' Bit 1, if set, indicates South Latitude
								' Bit 0, if set, indicates East Longitude
' ***************************************************************************************
Num_sat			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D
Fix_mod			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D


' --------------------for serial display-------------------------------
symbol I = 254
Symbol CLR = 1
'Symbol Line2 =192
Symbol L1_C1 = 128
Symbol L1_C9 = 136
Symbol L1_C11 = 139
Symbol L2_C1 = 192		
'Symbol L2_C8 =199	
' --------------------------------------------------------------------
' loop variables
'x			var	byte				
't 			var byte		
p			var byte				
'j			var byte
wp			var byte			


' -----[ Initialization ]--------------------------------------------------
'
Init:

PORTA = %00000			'Initialize PortA to all zeros - all output
TRISA = %00000			'All port A output 

PORTB = %00000010		'Initialize PortB
TRISB = %00000010		'Port 2 input

' -----[ Main Code ]-------------------------------------------------------
Gosub Initialize1
Menu:' ****** [Main Program Loop] *****************************************************************
		gosub counter		' main counter routine
		gosub getdata		' go get data
		gosub calcvalue		' calculate values
		gosub displayit		' display information
		if wp > 1 then
			gosub waypoint
		endif

goto menu

'*************************************************************************************************
'************************* [First Screen] *****************
initialize1:
	wp= 0
	serout2 Apinout, 16468, [I,CLR]
	serout2 Apinout, 16468, [I,L1_C1]
	serout2 Apinout, 16468, [" MicroTracker"]
	serout2 Apinout, 16468, [I,CLR]
	serout2 Apinout, 16468, [I,L2_C1]
	serout2 Apinout, 16468, ["(C)05 GPSFlight"]
	
	serout2 AGPSout, 16572,[27,91,50,74]			' clear screen vt-100
	serout2 AGPSout, 16572,[27,91,#10,59,#10,72]	' 10 th row, 10 column
	serout2 AGPSout, 16572,["GPSFlight MicroTracker"]
	serout2 AGPSout, 16572,[27,91,#12,59,#3,72]		' 5 th row, 3rd column
	serout2 AGPSout, 16572,["GPS Waypoint Port 4800-8-1-n"]
	serout2 AGPSout, 16572,[27,91,#13,59,#3,72]		' 5 th row, 3rd column
	serout2 AGPSout, 16572,["Connect GPS to this port to recieve waypoints"]
	
	serout2 cpinout, 84,[27,91,50,74]				' clear screen vt-100
	serout2 cpinout, 84,[27,91,53,59,51,72]			' 5 th row, 3rd column
	serout2 cpinout, 84,["GPSFlign MicroTracker (C) 2005 GPSFlight, Inc.",10, 13]

	serout2 AGPSout, 16572,[27,91,50,74]			' clear screen vt-100
	serout2 cpinout, 84,[27,91,50,74]				' clear screen vt-100
	Pause 2000
Return
'------------------------------------------------------------------------------------------------
counter:
	wp= wp+1
Return

'------------------------------------------------------------------------------------------------
getdata:
	Cksum = %0
	Serin2 Cpinin,84,1000,nodata,[wait($02,$47), STR SSMAX\34]
return
'************************* [No Data from airlink] *****************
nodata:
	serout2 Apinout, 16468, [I,CLR]
	serout2 Apinout, 16468,[I,L1_C1]
	serout2 Apinout, 16468, ["No TracIDs Found"]
goto getdata

'------------------------------------------------------------------------------------------------
displayit:
' write to LCD serial screen
	serout Apinout, N9600, [I,CLR]
	serout2 Apinout, 16468,[I,L1_C1]
	serout2 Apinout, 16468, ["MB:",#Dec_mb dig 4,#Dec_mb dig 3, #Dec_mb dig 2,#Dec_mb dig 1, "."_
	,dec1 Dec_mb,"F:",#Dec_tempf dig 3, #Dec_tempf dig 2,#Dec_tempf dig 1, ".",dec1 Dec_Tempf]
	serout2 Apinout, 16468,[I,L2_C1]
		Select Case Fix_mod
		Case 1
			serout2 Apinout, 16468, ["No Lock ",#Fix_mod]
		Case 2
			serout2 Apinout, 16468, ["2D ",#Fix_mod]
		Case 3
			serout2 Apinout, 16468, ["3D ",#Fix_mod]
		Case Else
			serout2 Apinout, 16468, ["Error ",#Fix_mod]
	end select

' write to a PC screen
' VT-100 screen controls

' 1 - 27 = escape
' 2 - 91 = [
' 3 - line on screen 49=1, etc
' 4 - 59 = ;
' 5 - row on screen - 49=1, etc
' 6 - 72 - end of command 'H'
	
Return
	
'************************* [Send Waypoint to GPS] *****************
waypoint:
' create checksum '**************                                          Checksum
	WPT_array[1]="G"
	WPT_array[2]="P"
	WPT_array[3]="W"
	WPT_array[4]="P"
	WPT_array[5]="L"
	WPT_array[6]=","	
	WPT_array[7]=Dec_lat1.byte0
	WPT_array[8]=Dec_lat1.byte1
	WPT_array[9]="."
	WPT_array[10]=Dec_lat2.byte0
	WPT_array[11]=Dec_lat2.byte1
	WPT_array[12]=","
	WPT_array[13]=S_byte
	WPT_array[14]=","
	WPT_array[15]=Dec_long1.byte0
	WPT_array[16]=Dec_long1.byte1
	WPT_array[17]="."
	WPT_array[18]=Dec_lat2.byte0
	WPT_array[19]=Dec_lat2.byte1
	WPT_array[20]="."	
	WPT_array[21]=E_byte
	WPT_array[22]=","
	WPT_array[23]=TracID.byte0
	WPT_array[24]=TracID.byte1
	WPT_array[25]=","
	' Implied      *  not computed	
	p=0
	cksum = %00000000
	for p = 1 to 25
		cksum = cksum^(WPT_array[p])
	Next P
		serout2 AGPSout, 16572,["$GPWPL,",#Dec_lat1,".",#Dec_lat2,",",S_Byte,","]
		serout2 AGPSout, 16572,[#Dec_long1,".",#Dec_long2,",",E_Byte,",",#TracID,"*",HEX Cksum,10,13]
		wp=%0
Return

'***********************[Calculate values]**************************
calcvalue:
' Calculate the variables from the array

' read data for temperature                                          Temp
	SSD4= (ssmax[24]>>4)
	SSD3= (ssmax[24] & $f) 
	SSD2= (ssmax[23]>>4)
	SSD1= (ssmax[23] & $f) 

	Dec_temp=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

	Dec_tempf= (Dec_temp*18 + 320 ) / 10			'conv to F
	

' read data for MB Pressure 	                                    Pressure
	SSD4= (ssmax[22]>>4)
	SSD3= (ssmax[22] & $f) 
	SSD2= (ssmax[21]>>4)
	SSD1= (ssmax[21] & $f) 

	Dec_mb=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' read data for long **************

' read data for Long1 - left of decimal
	SSD4= (ssmax[7]>>4)
	SSD3= (ssmax[7] & $f) 
	SSD2= (ssmax[6]>>4)
	SSD1= (ssmax[6] & $f) 

	Dec_long1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data for Long2 - right of decimal
	SSD4= (ssmax[9]>>4)
	SSD3= (ssmax[9] & $f) 
	SSD2= (ssmax[8]>>4)
	SSD1= (ssmax[8] & $f) 

	Dec_long2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data for lat ************

' read data for Lat1 - left of decimal
	SSD4= (ssmax[11]>>4)
	SSD3= (ssmax[11] & $f) 
	SSD2= (ssmax[10]>>4)
	SSD1= (ssmax[10] & $f) 

	Dec_lat1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' read data for Lat2 - right of decimal                                  
	SSD4= (ssmax[13]>>4)
	SSD3= (ssmax[13] & $f) 
	SSD2= (ssmax[12]>>4)
	SSD1= (ssmax[12] & $f) 

	Dec_lat2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec

' North/South East/West ******                                          North/S/E/W
	flagbit= (ssmax[2])

	Select Case E_True
		Case %1
			E_Byte= "E"
		Case Else
			E_Byte = "W"
	End Select

	Select Case S_true
		Case %1
			S_Byte= "S"
		Case Else
			S_Byte = "N"
	End Select

' read number of sats in view ****                                        Sats, Fix Mode

	Num_sat = (ssmax[14]>>4)
	Fix_mod = (ssmax[14] & $f)

		
' read TracID *********************                                        TracID
'Initialize CAN array once I can figure out how to do this
	TracID.byte0 = "1"
	TracID.byte1 = "1"

' read data Hspeed - 16 bit *******                                         Speed
	SSD4= (ssmax[18]>>4)
	SSD3= (ssmax[18] & $f) 
	SSD2= (ssmax[17]>>4)
	SSD1= (ssmax[17] & $f) 

	Dec_speed=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec

' read data time - 3 bytes ********                                         Time

	Dec_timeSS = (ssmax[3]>>4)			' second1
	Dec_timeSS1= (ssmax[3] & $f)		' second2
	Dec_timeMM = (ssmax[4]>>4)			' MM1
	Dec_timeMM1= (ssmax[4] & $f)		' MM2
	Dec_timeHH = (ssmax[5]>>4)			' H1
	Dec_timeMM1= (ssmax[5] & $f)		' H2

' read data volts - 8 bit

	SSD2= (ssmax[25]>>4)
	SSD1= (ssmax[25] & $f) 

	Dec_volt=(ssd2*16)+ssd1		' convert to dec

' **************************************************************************************
return
