
; PicBasic Pro Compiler 2.44, (c) 1998, 2003 microEngineering Labs, Inc. All Rights Reserved. 
MPASMWIN_USED			EQU	1

	INCLUDE	"C:\PBP\16F88.INC"


; Define statements.
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00052	DEFINE OSC 8		
#define		OSC		 8		

RAM_START       		EQU	00020h
RAM_END         		EQU	001EFh
RAM_BANKS       		EQU	00004h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000EFh
BANK2_START     		EQU	00120h
BANK2_END       		EQU	0016Fh
BANK3_START     		EQU	001A0h
BANK3_END       		EQU	001EFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	021FFh

; C:\PBP\PBPPIC14.RAM      	00012	R0      VAR     WORD BANK0 SYSTEM       ' System Register
R0              		EQU	RAM_START + 000h
; C:\PBP\PBPPIC14.RAM      	00013	R1      VAR     WORD BANK0 SYSTEM       ' System Register
R1              		EQU	RAM_START + 002h
; C:\PBP\PBPPIC14.RAM      	00014	R2      VAR     WORD BANK0 SYSTEM       ' System Register
R2              		EQU	RAM_START + 004h
; C:\PBP\PBPPIC14.RAM      	00015	R3      VAR     WORD BANK0 SYSTEM       ' System Register
R3              		EQU	RAM_START + 006h
; C:\PBP\PBPPIC14.RAM      	00016	R4      VAR     WORD BANK0 SYSTEM       ' System Register
R4              		EQU	RAM_START + 008h
; C:\PBP\PBPPIC14.RAM      	00017	R5      VAR     WORD BANK0 SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Ah
; C:\PBP\PBPPIC14.RAM      	00018	R6      VAR     WORD BANK0 SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Ch
; C:\PBP\PBPPIC14.RAM      	00019	R7      VAR     WORD BANK0 SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Eh
; C:\PBP\PBPPIC14.RAM      	00020	R8      VAR     WORD BANK0 SYSTEM       ' System Register
R8              		EQU	RAM_START + 010h
T1              		EQU	RAM_START + 012h
T2              		EQU	RAM_START + 014h
T3              		EQU	RAM_START + 016h
; C:\PBP\PBPPIC14.RAM      	00026	FLAGS   VAR     BYTE BANK0 SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 018h
; C:\PBP\PBPPIC14.RAM      	00025	GOP     VAR     BYTE BANK0 SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 019h
; C:\PBP\PBPPIC14.RAM      	00022	RM1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 01Ah
; C:\PBP\PBPPIC14.RAM      	00024	RM2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 01Bh
; C:\PBP\PBPPIC14.RAM      	00021	RR1     VAR     BYTE BANK0 SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 01Ch
; C:\PBP\PBPPIC14.RAM      	00023	RR2     VAR     BYTE BANK0 SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 01Dh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00072	SSMAX       	var byte [34] 			' the big matrix
_SSMAX           		EQU	RAM_START + 01Eh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00073	Wpt_Array		var byte [28]			' used for creating checksum for waypoint
_Wpt_Array       		EQU	RAM_START + 040h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00078	Dec_lat1		var word				' first part of lat
_Dec_lat1        		EQU	RAM_START + 05Ch
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00079	Dec_lat2		var word				' second part of lat
_Dec_lat2        		EQU	RAM_START + 05Eh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00080	Dec_long1		var word				' first part of long
_Dec_long1       		EQU	RAM_START + 080h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00081	Dec_long2		var word				' second part of long
_Dec_long2       		EQU	RAM_START + 082h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00077	Dec_mb			var word				' millibars
_Dec_mb          		EQU	RAM_START + 084h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00089	Dec_speed		var word				' speed (mph)
_Dec_speed       		EQU	RAM_START + 086h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00075	Dec_temp	 	var word				' temperature
_Dec_temp        		EQU	RAM_START + 088h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00076	Dec_tempf	 	var word				' temperature
_Dec_tempf       		EQU	RAM_START + 08Ah
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00088	Dec_volt		var word				' volts
_Dec_volt        		EQU	RAM_START + 08Ch
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00092	TracID			var word				' tracid - used in waypoint
_TracID          		EQU	RAM_START + 08Eh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00090	wpt				var word				' waypoint - 6 letters max
_wpt             		EQU	RAM_START + 090h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00091	CANvalue		var	byte				' value of the can
_CANvalue        		EQU	RAM_START + 092h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00094	Cksum			var byte				' aggregator
_Cksum           		EQU	RAM_START + 093h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00086	Dec_timeHH		var byte				' time hh
_Dec_timeHH      		EQU	RAM_START + 094h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00087	Dec_timeHH1		var byte
_Dec_timeHH1     		EQU	RAM_START + 095h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00084	Dec_timeMM		var byte				' time mm
_Dec_timeMM      		EQU	RAM_START + 096h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00085	Dec_timeMM1		var byte
_Dec_timeMM1     		EQU	RAM_START + 097h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00082	Dec_timeSS		var byte				' time ss
_Dec_timeSS      		EQU	RAM_START + 098h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00083	Dec_timeSS1		var byte				'
_Dec_timeSS1     		EQU	RAM_START + 099h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00109	E_Byte			var byte				' container for the letter
_E_Byte          		EQU	RAM_START + 09Ah
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00122	Fix_mod			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D
_Fix_mod         		EQU	RAM_START + 09Bh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00105	flagbit			var	byte				' [2] contains elements of status ****************************
_flagbit         		EQU	RAM_START + 09Ch
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00121	Num_sat			var byte				' [14] upper 4 bits is # sats, lower 4 bits is fixmode - 1=N , 2=2D , 3=3D
_Num_sat         		EQU	RAM_START + 09Dh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00138	p			var byte				
_p               		EQU	RAM_START + 09Eh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00061	RX 				var byte				'Receive byte
_RX              		EQU	RAM_START + 09Fh
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00110	S_Byte			var byte				' container for the letter
_S_Byte          		EQU	RAM_START + 0A0h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00103	SSD1        	var byte				' used to convert to decimal
_SSD1            		EQU	RAM_START + 0A1h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00102	SSD2        	var byte				' used to convert to decimal
_SSD2            		EQU	RAM_START + 0A2h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00101	SSD3        	var byte				' used to convert to decimal
_SSD3            		EQU	RAM_START + 0A3h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00100	SSD4        	var byte				' used to convert to decimal
_SSD4            		EQU	RAM_START + 0A4h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00062	STX		 		var Byte 				'Recieve byte for LCD
_STX             		EQU	RAM_START + 0A5h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00071	TID				var byte		    	' TID = CAN conversion byte
_TID             		EQU	RAM_START + 0A6h
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00140	wp			var byte			
_wp              		EQU	RAM_START + 0A7h
; C:\PBP\16F88.BAS         	00021	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\16F88.BAS         	00022	PORTH   VAR     PORTA
_PORTH           		EQU	 PORTA
; C:\PBP\16F88.BAS         	00023	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\16F88.BAS         	00024	TRISH   VAR     TRISA
_TRISH           		EQU	 TRISA
_Dec_lat1_BYTE0  		EQU	_Dec_lat1
_Dec_lat1_BYTE1  		EQU	_Dec_lat1 + 001h
_Dec_lat2_BYTE0  		EQU	_Dec_lat2
_Dec_lat2_BYTE1  		EQU	_Dec_lat2 + 001h
_Dec_long1_BYTE0 		EQU	_Dec_long1
_Dec_long1_BYTE1 		EQU	_Dec_long1 + 001h
_TracID_BYTE0    		EQU	_TracID
_TracID_BYTE1    		EQU	_TracID + 001h
#define _Cpinin          	_PORTB_1
#define _Cpinout         	_PORTB_2
#define _Apinout         	_PORTA_0
#define _AGPSout         	_PORTA_1
#define _E_True          	_flagbit_0
#define _S_True          	_flagbit_1
#define _Panic           	_flagbit_7
#define _PORTB_1         	 PORTB, 001h
#define _PORTB_2         	 PORTB, 002h
#define _PORTA_0         	 PORTA, 000h
#define _PORTA_1         	 PORTA, 001h
#define _flagbit_0       	_flagbit, 000h
#define _flagbit_1       	_flagbit, 001h
#define _flagbit_7       	_flagbit, 007h

; Constants.
_T2400           		EQU	00000h
_T1200           		EQU	00001h
_T9600           		EQU	00002h
_T300            		EQU	00003h
_N2400           		EQU	00004h
_N1200           		EQU	00005h
_N9600           		EQU	00006h
_N300            		EQU	00007h
_OT2400          		EQU	00008h
_OT1200          		EQU	00009h
_OT9600          		EQU	0000Ah
_OT300           		EQU	0000Bh
_ON2400          		EQU	0000Ch
_ON1200          		EQU	0000Dh
_ON9600          		EQU	0000Eh
_ON300           		EQU	0000Fh
_MSBPRE          		EQU	00000h
_LSBPRE          		EQU	00001h
_MSBPOST         		EQU	00002h
_LSBPOST         		EQU	00003h
_LSBFIRST        		EQU	00000h
_MSBFIRST        		EQU	00001h
_CLS             		EQU	00000h
_HOME            		EQU	00001h
_BELL            		EQU	00007h
_BKSP            		EQU	00008h
_TAB             		EQU	00009h
_CR              		EQU	0000Dh
_UnitOn          		EQU	00012h
_UnitOff         		EQU	0001Ah
_UnitsOff        		EQU	0001Ch
_LightsOn        		EQU	00014h
_LightsOff       		EQU	00010h
_Dim             		EQU	0001Eh
_Bright          		EQU	00016h
_I               		EQU	000FEh
_CLR             		EQU	00001h
_L1_C1           		EQU	00080h
_L1_C9           		EQU	00088h
_L1_C11          		EQU	0008Bh
_L2_C1           		EQU	000C0h
	INCLUDE	"GPSFWAYPOINT-F88.MAC"
	INCLUDE	"C:\PBP\PBPPIC14.LIB"


; C:\PBP\16F88.BAS         	00012	BANK0   $0020, $007F
; C:\PBP\16F88.BAS         	00013	BANK1   $00A0, $00EF
; C:\PBP\16F88.BAS         	00014	BANK2   $0120, $016F
; C:\PBP\16F88.BAS         	00015	BANK3	$01A0, $01EF
; C:\PBP\16F88.BAS         	00016	EEPROM  $2100, $21FF
; C:\PBP\16F88.BAS         	00017	LIBRARY "PBPPIC14"

; C:\PBP\16F88.BAS         	00019	        include "PIC14EXT.BAS"

; C:\PBP\16F88.BAS         	00026	        include "PBPPIC14.RAM"

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00047	include "modedefs.bas"	'include serout defines
; C:\PBP\MODEDEFS.BAS      	00014	Symbol T2400  = 0       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00015	Symbol T1200  = 1       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00016	Symbol T9600  = 2       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00017	Symbol T300   = 3       ' Driven True
; C:\PBP\MODEDEFS.BAS      	00019	Symbol N2400  = 4       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00020	Symbol N1200  = 5       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00021	Symbol N9600  = 6       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00022	Symbol N300   = 7       ' Driven Inverted
; C:\PBP\MODEDEFS.BAS      	00024	Symbol OT2400 = 8       ' Open True
; C:\PBP\MODEDEFS.BAS      	00025	Symbol OT1200 = 9       ' Open True
; C:\PBP\MODEDEFS.BAS      	00026	Symbol OT9600 = 10      ' Open True
; C:\PBP\MODEDEFS.BAS      	00027	Symbol OT300  = 11      ' Open True
; C:\PBP\MODEDEFS.BAS      	00029	Symbol ON2400 = 12      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00030	Symbol ON1200 = 13      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00031	Symbol ON9600 = 14      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00032	Symbol ON300  = 15      ' Open Inverted
; C:\PBP\MODEDEFS.BAS      	00036	Symbol MSBPRE = 0       ' MSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00037	Symbol LSBPRE = 1       ' LSB first, sample before clock
; C:\PBP\MODEDEFS.BAS      	00038	Symbol MSBPOST = 2      ' MSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00039	Symbol LSBPOST = 3      ' LSB first, sample after clock
; C:\PBP\MODEDEFS.BAS      	00042	Symbol LSBFIRST = 0     ' LSB first
; C:\PBP\MODEDEFS.BAS      	00043	Symbol MSBFIRST = 1     ' MSB first
; C:\PBP\MODEDEFS.BAS      	00047	Symbol CLS = 0
; C:\PBP\MODEDEFS.BAS      	00048	Symbol HOME = 1
; C:\PBP\MODEDEFS.BAS      	00049	Symbol BELL = 7
; C:\PBP\MODEDEFS.BAS      	00050	Symbol BKSP = 8
; C:\PBP\MODEDEFS.BAS      	00051	Symbol TAB = 9
; C:\PBP\MODEDEFS.BAS      	00052	Symbol CR = 13
; C:\PBP\MODEDEFS.BAS      	00056	Symbol UnitOn = %10010
; C:\PBP\MODEDEFS.BAS      	00057	Symbol UnitOff = %11010
; C:\PBP\MODEDEFS.BAS      	00058	Symbol UnitsOff = %11100
; C:\PBP\MODEDEFS.BAS      	00059	Symbol LightsOn = %10100
; C:\PBP\MODEDEFS.BAS      	00060	Symbol LightsOff = %10000
; C:\PBP\MODEDEFS.BAS      	00061	Symbol Dim = %11110
; C:\PBP\MODEDEFS.BAS      	00062	Symbol Bright = %10110

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00050	@__config _CONFIG1, _INTRC_IO & _WDT_OFF & _PWRTE_ON & _LVP_OFF & _CP_OFF

	ASM?
__config _CONFIG1, _INTRC_IO & _WDT_OFF & _PWRTE_ON & _LVP_OFF & _CP_OFF

	ENDASM?

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00052	DEFINE OSC 8		

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00053	OSCCON=%01111000		 '8 Mhz
	MOVE?CB	078h, OSCCON

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00054	ANSEL=3 'set a.0 and a.1 as digital input
	MOVE?CB	003h, ANSEL
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00126	symbol I = 254
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00127	Symbol CLR = 1
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00129	Symbol L1_C1 = 128
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00130	Symbol L1_C9 = 136
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00131	Symbol L1_C11 = 139
; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00132	Symbol L2_C1 = 192		

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00145	Init:

	LABEL?L	_Init	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00147	PORTA = %00000			'Initialize PortA to all zeros - all output
	MOVE?CB	000h, PORTA

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00148	TRISA = %00000			'All port A output 
	MOVE?CB	000h, TRISA

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00150	PORTB = %00000010		'Initialize PortB
	MOVE?CB	002h, PORTB

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00151	TRISB = %00000010		'Port 2 input
	MOVE?CB	002h, TRISB

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00154	Gosub Initialize1
	GOSUB?L	_Initialize1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00155	Menu:' ****** [Main Program Loop] *****************************************************************

	LABEL?L	_Menu	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00156			gosub counter		' main counter routine
	GOSUB?L	_counter

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00157			gosub getdata		' go get data
	GOSUB?L	_getdata

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00158			gosub calcvalue		' calculate values
	GOSUB?L	_calcvalue

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00159			gosub displayit		' display information
	GOSUB?L	_displayit

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00160			if wp > 1 then
	CMPLE?BCL	_wp, 001h, L00002

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00161				gosub waypoint
	GOSUB?L	_waypoint

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00162			endif
	LABEL?L	L00002	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00164	goto menu
	GOTO?L	_Menu

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00168	initialize1:

	LABEL?L	_Initialize1	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00169		wp= 0
	MOVE?CB	000h, _wp

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00170		serout2 Apinout, 16468, [I,CLR]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_CLR

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00171		serout2 Apinout, 16468, [I,L1_C1]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_L1_C1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00172		serout2 Apinout, 16468, [" MicroTracker"]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	020h
	SEROUT2?C	04Dh
	SEROUT2?C	069h
	SEROUT2?C	063h
	SEROUT2?C	072h
	SEROUT2?C	06Fh
	SEROUT2?C	054h
	SEROUT2?C	072h
	SEROUT2?C	061h
	SEROUT2?C	063h
	SEROUT2?C	06Bh
	SEROUT2?C	065h
	SEROUT2?C	072h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00173		serout2 Apinout, 16468, [I,CLR]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_CLR

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00174		serout2 Apinout, 16468, [I,L2_C1]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_L2_C1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00175		serout2 Apinout, 16468, ["(C)05 GPSFlight"]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	028h
	SEROUT2?C	043h
	SEROUT2?C	029h
	SEROUT2?C	030h
	SEROUT2?C	035h
	SEROUT2?C	020h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	046h
	SEROUT2?C	06Ch
	SEROUT2?C	069h
	SEROUT2?C	067h
	SEROUT2?C	068h
	SEROUT2?C	074h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00177		serout2 AGPSout, 16572,[27,91,50,74]			' clear screen vt-100
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2?C	032h
	SEROUT2?C	04Ah

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00178		serout2 AGPSout, 16572,[27,91,#10,59,#10,72]	' 10 th row, 10 column
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	00Ah
	SEROUT2DEC?	
	SEROUT2?C	03Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	00Ah
	SEROUT2DEC?	
	SEROUT2?C	048h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00179		serout2 AGPSout, 16572,["GPSFlight MicroTracker"]
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	046h
	SEROUT2?C	06Ch
	SEROUT2?C	069h
	SEROUT2?C	067h
	SEROUT2?C	068h
	SEROUT2?C	074h
	SEROUT2?C	020h
	SEROUT2?C	04Dh
	SEROUT2?C	069h
	SEROUT2?C	063h
	SEROUT2?C	072h
	SEROUT2?C	06Fh
	SEROUT2?C	054h
	SEROUT2?C	072h
	SEROUT2?C	061h
	SEROUT2?C	063h
	SEROUT2?C	06Bh
	SEROUT2?C	065h
	SEROUT2?C	072h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00180		serout2 AGPSout, 16572,[27,91,#12,59,#3,72]		' 5 th row, 3rd column
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	00Ch
	SEROUT2DEC?	
	SEROUT2?C	03Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	003h
	SEROUT2DEC?	
	SEROUT2?C	048h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00181		serout2 AGPSout, 16572,["GPS Waypoint Port 4800-8-1-n"]
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	020h
	SEROUT2?C	057h
	SEROUT2?C	061h
	SEROUT2?C	079h
	SEROUT2?C	070h
	SEROUT2?C	06Fh
	SEROUT2?C	069h
	SEROUT2?C	06Eh
	SEROUT2?C	074h
	SEROUT2?C	020h
	SEROUT2?C	050h
	SEROUT2?C	06Fh
	SEROUT2?C	072h
	SEROUT2?C	074h
	SEROUT2?C	020h
	SEROUT2?C	034h
	SEROUT2?C	038h
	SEROUT2?C	030h
	SEROUT2?C	030h
	SEROUT2?C	02Dh
	SEROUT2?C	038h
	SEROUT2?C	02Dh
	SEROUT2?C	031h
	SEROUT2?C	02Dh
	SEROUT2?C	06Eh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00182		serout2 AGPSout, 16572,[27,91,#13,59,#3,72]		' 5 th row, 3rd column
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	00Dh
	SEROUT2DEC?	
	SEROUT2?C	03Bh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?C	003h
	SEROUT2DEC?	
	SEROUT2?C	048h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00183		serout2 AGPSout, 16572,["Connect GPS to this port to recieve waypoints"]
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	043h
	SEROUT2?C	06Fh
	SEROUT2?C	06Eh
	SEROUT2?C	06Eh
	SEROUT2?C	065h
	SEROUT2?C	063h
	SEROUT2?C	074h
	SEROUT2?C	020h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	020h
	SEROUT2?C	074h
	SEROUT2?C	06Fh
	SEROUT2?C	020h
	SEROUT2?C	074h
	SEROUT2?C	068h
	SEROUT2?C	069h
	SEROUT2?C	073h
	SEROUT2?C	020h
	SEROUT2?C	070h
	SEROUT2?C	06Fh
	SEROUT2?C	072h
	SEROUT2?C	074h
	SEROUT2?C	020h
	SEROUT2?C	074h
	SEROUT2?C	06Fh
	SEROUT2?C	020h
	SEROUT2?C	072h
	SEROUT2?C	065h
	SEROUT2?C	063h
	SEROUT2?C	069h
	SEROUT2?C	065h
	SEROUT2?C	076h
	SEROUT2?C	065h
	SEROUT2?C	020h
	SEROUT2?C	077h
	SEROUT2?C	061h
	SEROUT2?C	079h
	SEROUT2?C	070h
	SEROUT2?C	06Fh
	SEROUT2?C	069h
	SEROUT2?C	06Eh
	SEROUT2?C	074h
	SEROUT2?C	073h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00185		serout2 cpinout, 84,[27,91,50,74]				' clear screen vt-100
	SEROUT2DPIN?T	_Cpinout
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2?C	032h
	SEROUT2?C	04Ah

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00186		serout2 cpinout, 84,[27,91,53,59,51,72]			' 5 th row, 3rd column
	SEROUT2DPIN?T	_Cpinout
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2?C	035h
	SEROUT2?C	03Bh
	SEROUT2?C	033h
	SEROUT2?C	048h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00187		serout2 cpinout, 84,["GPSFlign MicroTracker (C) 2005 GPSFlight, Inc.",10, 13]
	SEROUT2DPIN?T	_Cpinout
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	046h
	SEROUT2?C	06Ch
	SEROUT2?C	069h
	SEROUT2?C	067h
	SEROUT2?C	06Eh
	SEROUT2?C	020h
	SEROUT2?C	04Dh
	SEROUT2?C	069h
	SEROUT2?C	063h
	SEROUT2?C	072h
	SEROUT2?C	06Fh
	SEROUT2?C	054h
	SEROUT2?C	072h
	SEROUT2?C	061h
	SEROUT2?C	063h
	SEROUT2?C	06Bh
	SEROUT2?C	065h
	SEROUT2?C	072h
	SEROUT2?C	020h
	SEROUT2?C	028h
	SEROUT2?C	043h
	SEROUT2?C	029h
	SEROUT2?C	020h
	SEROUT2?C	032h
	SEROUT2?C	030h
	SEROUT2?C	030h
	SEROUT2?C	035h
	SEROUT2?C	020h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	053h
	SEROUT2?C	046h
	SEROUT2?C	06Ch
	SEROUT2?C	069h
	SEROUT2?C	067h
	SEROUT2?C	068h
	SEROUT2?C	074h
	SEROUT2?C	02Ch
	SEROUT2?C	020h
	SEROUT2?C	049h
	SEROUT2?C	06Eh
	SEROUT2?C	063h
	SEROUT2?C	02Eh
	SEROUT2?C	00Ah
	SEROUT2?C	00Dh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00189		serout2 AGPSout, 16572,[27,91,50,74]			' clear screen vt-100
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2?C	032h
	SEROUT2?C	04Ah

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00190		serout2 cpinout, 84,[27,91,50,74]				' clear screen vt-100
	SEROUT2DPIN?T	_Cpinout
	SEROUT2MODE?C	054h
	SEROUT2PACE?C	000h
	SEROUT2?C	01Bh
	SEROUT2?C	05Bh
	SEROUT2?C	032h
	SEROUT2?C	04Ah

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00191		Pause 2000
	PAUSE?C	007D0h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00192	Return
	RETURN?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00194	counter:

	LABEL?L	_counter	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00195		wp= wp+1
	ADD?BCB	_wp, 001h, _wp

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00196	Return
	RETURN?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00199	getdata:

	LABEL?L	_getdata	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00200		Cksum = %0
	MOVE?CB	000h, _Cksum

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00201		Serin2 Cpinin,84,1000,nodata,[wait($02,$47), STR SSMAX\34]
	SERIN2DPIN?T	_Cpinin
	SERIN2MODE?C	054h
	SERIN2TIME?C	003E8h

	LABEL?L	L00001	
	SERIN2WAIT?CLL	002h, L00001, _nodata
	SERIN2WAIT?CLL	047h, L00001, _nodata
	SERIN2COUNT?C	022h
	SERIN2STR?BL	_SSMAX, _nodata

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00202	return
	RETURN?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00204	nodata:

	LABEL?L	_nodata	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00205		serout2 Apinout, 16468, [I,CLR]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_CLR

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00206		serout2 Apinout, 16468,[I,L1_C1]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_L1_C1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00207		serout2 Apinout, 16468, ["No TracIDs Found"]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	04Eh
	SEROUT2?C	06Fh
	SEROUT2?C	020h
	SEROUT2?C	054h
	SEROUT2?C	072h
	SEROUT2?C	061h
	SEROUT2?C	063h
	SEROUT2?C	049h
	SEROUT2?C	044h
	SEROUT2?C	073h
	SEROUT2?C	020h
	SEROUT2?C	046h
	SEROUT2?C	06Fh
	SEROUT2?C	075h
	SEROUT2?C	06Eh
	SEROUT2?C	064h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00208	goto getdata
	GOTO?L	_getdata

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00211	displayit:

	LABEL?L	_displayit	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00213		serout Apinout, N9600, [I,CLR]
	SERPIN?T	_Apinout
	SERMODE?C	_N9600
	SEROUT?C	_I
	SEROUT?C	_CLR

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00214		serout2 Apinout, 16468,[I,L1_C1]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_L1_C1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00216		,dec1 Dec_mb,"F:",#Dec_tempf dig 3, #Dec_tempf dig 2,#Dec_tempf dig 1, ".",dec1 Dec_Tempf]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	04Dh
	SEROUT2?C	042h
	SEROUT2?C	03Ah
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_mb, 004h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_mb, 003h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_mb, 002h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_mb, 001h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2?C	02Eh
	SEROUT2COUNT?C	001h
	SEROUT2NUM?W	_Dec_mb
	SEROUT2DEC?	
	SEROUT2?C	046h
	SEROUT2?C	03Ah
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_tempf, 003h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_tempf, 002h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2COUNT?C	000h
	DIG?WCW	_Dec_tempf, 001h, T1
	SEROUT2NUM?W	T1
	SEROUT2DEC?	
	SEROUT2?C	02Eh
	SEROUT2COUNT?C	001h
	SEROUT2NUM?W	_Dec_tempf
	SEROUT2DEC?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00217		serout2 Apinout, 16468,[I,L2_C1]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	_I
	SEROUT2?C	_L2_C1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00218			Select Case Fix_mod

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00219			Case 1
	CMPNE?BCL	_Fix_mod, 001h, L00006

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00220				serout2 Apinout, 16468, ["No Lock ",#Fix_mod]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	04Eh
	SEROUT2?C	06Fh
	SEROUT2?C	020h
	SEROUT2?C	04Ch
	SEROUT2?C	06Fh
	SEROUT2?C	063h
	SEROUT2?C	06Bh
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_Fix_mod
	SEROUT2DEC?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00221			Case 2
	GOTO?L	L00005
	LABEL?L	L00006	
	CMPNE?BCL	_Fix_mod, 002h, L00007

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00222				serout2 Apinout, 16468, ["2D ",#Fix_mod]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	032h
	SEROUT2?C	044h
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_Fix_mod
	SEROUT2DEC?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00223			Case 3
	GOTO?L	L00005
	LABEL?L	L00007	
	CMPNE?BCL	_Fix_mod, 003h, L00008

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00224				serout2 Apinout, 16468, ["3D ",#Fix_mod]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	033h
	SEROUT2?C	044h
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_Fix_mod
	SEROUT2DEC?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00225			Case Else
	GOTO?L	L00005
	LABEL?L	L00008	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00226				serout2 Apinout, 16468, ["Error ",#Fix_mod]
	SEROUT2DPIN?T	_Apinout
	SEROUT2MODE?C	04054h
	SEROUT2PACE?C	000h
	SEROUT2?C	045h
	SEROUT2?C	072h
	SEROUT2?C	072h
	SEROUT2?C	06Fh
	SEROUT2?C	072h
	SEROUT2?C	020h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_Fix_mod
	SEROUT2DEC?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00227		end select
	LABEL?L	L00005	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00239	Return
	RETURN?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00242	waypoint:

	LABEL?L	_waypoint	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00244		WPT_array[1]="G"
	MOVE?CB	047h, _Wpt_Array + 00001h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00245		WPT_array[2]="P"
	MOVE?CB	050h, _Wpt_Array + 00002h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00246		WPT_array[3]="W"
	MOVE?CB	057h, _Wpt_Array + 00003h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00247		WPT_array[4]="P"
	MOVE?CB	050h, _Wpt_Array + 00004h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00248		WPT_array[5]="L"
	MOVE?CB	04Ch, _Wpt_Array + 00005h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00249		WPT_array[6]=","	
	MOVE?CB	02Ch, _Wpt_Array + 00006h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00250		WPT_array[7]=Dec_lat1.byte0
	MOVE?BB	_Dec_lat1_BYTE0, _Wpt_Array + 00007h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00251		WPT_array[8]=Dec_lat1.byte1
	MOVE?BB	_Dec_lat1_BYTE1, _Wpt_Array + 00008h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00252		WPT_array[9]="."
	MOVE?CB	02Eh, _Wpt_Array + 00009h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00253		WPT_array[10]=Dec_lat2.byte0
	MOVE?BB	_Dec_lat2_BYTE0, _Wpt_Array + 0000Ah

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00254		WPT_array[11]=Dec_lat2.byte1
	MOVE?BB	_Dec_lat2_BYTE1, _Wpt_Array + 0000Bh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00255		WPT_array[12]=","
	MOVE?CB	02Ch, _Wpt_Array + 0000Ch

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00256		WPT_array[13]=S_byte
	MOVE?BB	_S_Byte, _Wpt_Array + 0000Dh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00257		WPT_array[14]=","
	MOVE?CB	02Ch, _Wpt_Array + 0000Eh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00258		WPT_array[15]=Dec_long1.byte0
	MOVE?BB	_Dec_long1_BYTE0, _Wpt_Array + 0000Fh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00259		WPT_array[16]=Dec_long1.byte1
	MOVE?BB	_Dec_long1_BYTE1, _Wpt_Array + 00010h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00260		WPT_array[17]="."
	MOVE?CB	02Eh, _Wpt_Array + 00011h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00261		WPT_array[18]=Dec_lat2.byte0
	MOVE?BB	_Dec_lat2_BYTE0, _Wpt_Array + 00012h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00262		WPT_array[19]=Dec_lat2.byte1
	MOVE?BB	_Dec_lat2_BYTE1, _Wpt_Array + 00013h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00263		WPT_array[20]="."	
	MOVE?CB	02Eh, _Wpt_Array + 00014h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00264		WPT_array[21]=E_byte
	MOVE?BB	_E_Byte, _Wpt_Array + 00015h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00265		WPT_array[22]=","
	MOVE?CB	02Ch, _Wpt_Array + 00016h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00266		WPT_array[23]=TracID.byte0
	MOVE?BB	_TracID_BYTE0, _Wpt_Array + 00017h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00267		WPT_array[24]=TracID.byte1
	MOVE?BB	_TracID_BYTE1, _Wpt_Array + 00018h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00268		WPT_array[25]=","
	MOVE?CB	02Ch, _Wpt_Array + 00019h

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00270		p=0
	MOVE?CB	000h, _p

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00271		cksum = %00000000
	MOVE?CB	000h, _Cksum

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00272		for p = 1 to 25
	MOVE?CB	001h, _p
	LABEL?L	L00009	
	CMPGT?BCL	_p, 019h, L00010

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00273			cksum = cksum^(WPT_array[p])
	AOUT?BBB	_Wpt_Array, _p, T1
	XOR?BBB	_Cksum, T1, _Cksum

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00274		Next P
	NEXT?BCL	_p, 001h, L00009
	LABEL?L	L00010	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00275			serout2 AGPSout, 16572,["$GPWPL,",#Dec_lat1,".",#Dec_lat2,",",S_Byte,","]
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2?C	024h
	SEROUT2?C	047h
	SEROUT2?C	050h
	SEROUT2?C	057h
	SEROUT2?C	050h
	SEROUT2?C	04Ch
	SEROUT2?C	02Ch
	SEROUT2COUNT?C	000h
	SEROUT2NUM?W	_Dec_lat1
	SEROUT2DEC?	
	SEROUT2?C	02Eh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?W	_Dec_lat2
	SEROUT2DEC?	
	SEROUT2?C	02Ch
	SEROUT2?B	_S_Byte
	SEROUT2?C	02Ch

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00276			serout2 AGPSout, 16572,[#Dec_long1,".",#Dec_long2,",",E_Byte,",",#TracID,"*",HEX Cksum,10,13]
	SEROUT2DPIN?T	_AGPSout
	SEROUT2MODE?C	040BCh
	SEROUT2PACE?C	000h
	SEROUT2COUNT?C	000h
	SEROUT2NUM?W	_Dec_long1
	SEROUT2DEC?	
	SEROUT2?C	02Eh
	SEROUT2COUNT?C	000h
	SEROUT2NUM?W	_Dec_long2
	SEROUT2DEC?	
	SEROUT2?C	02Ch
	SEROUT2?B	_E_Byte
	SEROUT2?C	02Ch
	SEROUT2COUNT?C	000h
	SEROUT2NUM?W	_TracID
	SEROUT2DEC?	
	SEROUT2?C	02Ah
	SEROUT2COUNT?C	000h
	SEROUT2NUM?B	_Cksum
	SEROUT2HEX?	
	SEROUT2?C	00Ah
	SEROUT2?C	00Dh

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00277			wp=%0
	MOVE?CB	000h, _wp

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00278	Return
	RETURN?	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00281	calcvalue:

	LABEL?L	_calcvalue	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00285		SSD4= (ssmax[24]>>4)
	SHIFTR?BCB	_SSMAX + 00018h, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00286		SSD3= (ssmax[24] & $f) 
	AND?BCB	_SSMAX + 00018h, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00287		SSD2= (ssmax[23]>>4)
	SHIFTR?BCB	_SSMAX + 00017h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00288		SSD1= (ssmax[23] & $f) 
	AND?BCB	_SSMAX + 00017h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00290		Dec_temp=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_temp

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00292		Dec_tempf= (Dec_temp*18 + 320 ) / 10			'conv to F
	MUL?WCW	_Dec_temp, 012h, T1
	ADD?WCW	T1, 00140h, T1
	DIV?WCW	T1, 00Ah, _Dec_tempf

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00296		SSD4= (ssmax[22]>>4)
	SHIFTR?BCB	_SSMAX + 00016h, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00297		SSD3= (ssmax[22] & $f) 
	AND?BCB	_SSMAX + 00016h, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00298		SSD2= (ssmax[21]>>4)
	SHIFTR?BCB	_SSMAX + 00015h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00299		SSD1= (ssmax[21] & $f) 
	AND?BCB	_SSMAX + 00015h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00301		Dec_mb=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_mb

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00306		SSD4= (ssmax[7]>>4)
	SHIFTR?BCB	_SSMAX + 00007h, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00307		SSD3= (ssmax[7] & $f) 
	AND?BCB	_SSMAX + 00007h, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00308		SSD2= (ssmax[6]>>4)
	SHIFTR?BCB	_SSMAX + 00006h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00309		SSD1= (ssmax[6] & $f) 
	AND?BCB	_SSMAX + 00006h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00311		Dec_long1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_long1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00314		SSD4= (ssmax[9]>>4)
	SHIFTR?BCB	_SSMAX + 00009h, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00315		SSD3= (ssmax[9] & $f) 
	AND?BCB	_SSMAX + 00009h, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00316		SSD2= (ssmax[8]>>4)
	SHIFTR?BCB	_SSMAX + 00008h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00317		SSD1= (ssmax[8] & $f) 
	AND?BCB	_SSMAX + 00008h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00319		Dec_long2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_long2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00324		SSD4= (ssmax[11]>>4)
	SHIFTR?BCB	_SSMAX + 0000Bh, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00325		SSD3= (ssmax[11] & $f) 
	AND?BCB	_SSMAX + 0000Bh, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00326		SSD2= (ssmax[10]>>4)
	SHIFTR?BCB	_SSMAX + 0000Ah, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00327		SSD1= (ssmax[10] & $f) 
	AND?BCB	_SSMAX + 0000Ah, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00329		Dec_lat1=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_lat1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00332		SSD4= (ssmax[13]>>4)
	SHIFTR?BCB	_SSMAX + 0000Dh, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00333		SSD3= (ssmax[13] & $f) 
	AND?BCB	_SSMAX + 0000Dh, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00334		SSD2= (ssmax[12]>>4)
	SHIFTR?BCB	_SSMAX + 0000Ch, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00335		SSD1= (ssmax[12] & $f) 
	AND?BCB	_SSMAX + 0000Ch, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00337		Dec_lat2=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_lat2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00340		flagbit= (ssmax[2])
	MOVE?BB	_SSMAX + 00002h, _flagbit

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00342		Select Case E_True

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00343			Case %1
	CMPNE?TCL	_E_True, 001h, L00013

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00344				E_Byte= "E"
	MOVE?CB	045h, _E_Byte

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00345			Case Else
	GOTO?L	L00012
	LABEL?L	L00013	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00346				E_Byte = "W"
	MOVE?CB	057h, _E_Byte

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00347		End Select
	LABEL?L	L00012	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00349		Select Case S_true

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00350			Case %1
	CMPNE?TCL	_S_True, 001h, L00016

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00351				S_Byte= "S"
	MOVE?CB	053h, _S_Byte

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00352			Case Else
	GOTO?L	L00015
	LABEL?L	L00016	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00353				S_Byte = "N"
	MOVE?CB	04Eh, _S_Byte

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00354		End Select
	LABEL?L	L00015	

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00358		Num_sat = (ssmax[14]>>4)
	SHIFTR?BCB	_SSMAX + 0000Eh, 004h, _Num_sat

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00359		Fix_mod = (ssmax[14] & $f)
	AND?BCB	_SSMAX + 0000Eh, 00Fh, _Fix_mod

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00364		TracID.byte0 = "1"
	MOVE?CB	031h, _TracID_BYTE0

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00365		TracID.byte1 = "1"
	MOVE?CB	031h, _TracID_BYTE1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00368		SSD4= (ssmax[18]>>4)
	SHIFTR?BCB	_SSMAX + 00012h, 004h, _SSD4

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00369		SSD3= (ssmax[18] & $f) 
	AND?BCB	_SSMAX + 00012h, 00Fh, _SSD3

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00370		SSD2= (ssmax[17]>>4)
	SHIFTR?BCB	_SSMAX + 00011h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00371		SSD1= (ssmax[17] & $f) 
	AND?BCB	_SSMAX + 00011h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00373		Dec_speed=(ssd4*4096)+(ssd3*256)+(ssd2*16)+ssd1	' convert to dec
	MUL?BCW	_SSD4, 01000h, T1
	MUL?BCW	_SSD3, 00100h, T2
	ADD?WWW	T1, T2, T2
	MUL?BCW	_SSD2, 010h, T3
	ADD?WWW	T2, T3, T3
	ADD?WBW	T3, _SSD1, _Dec_speed

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00377		Dec_timeSS = (ssmax[3]>>4)			' second1
	SHIFTR?BCB	_SSMAX + 00003h, 004h, _Dec_timeSS

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00378		Dec_timeSS1= (ssmax[3] & $f)		' second2
	AND?BCB	_SSMAX + 00003h, 00Fh, _Dec_timeSS1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00379		Dec_timeMM = (ssmax[4]>>4)			' MM1
	SHIFTR?BCB	_SSMAX + 00004h, 004h, _Dec_timeMM

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00380		Dec_timeMM1= (ssmax[4] & $f)		' MM2
	AND?BCB	_SSMAX + 00004h, 00Fh, _Dec_timeMM1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00381		Dec_timeHH = (ssmax[5]>>4)			' H1
	SHIFTR?BCB	_SSMAX + 00005h, 004h, _Dec_timeHH

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00382		Dec_timeMM1= (ssmax[5] & $f)		' H2
	AND?BCB	_SSMAX + 00005h, 00Fh, _Dec_timeMM1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00386		SSD2= (ssmax[25]>>4)
	SHIFTR?BCB	_SSMAX + 00019h, 004h, _SSD2

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00387		SSD1= (ssmax[25] & $f) 
	AND?BCB	_SSMAX + 00019h, 00Fh, _SSD1

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00389		Dec_volt=(ssd2*16)+ssd1		' convert to dec
	MUL?BCW	_SSD2, 010h, T1
	ADD?WBW	T1, _SSD1, _Dec_volt

; G:\BASIC\PGMS\WAYPOINT\PICCODE\GPSFWAYPOINT-F88.BAS	00392	return
	RETURN?	

	END
