'*****************************************************************************
'Tracteur.bas Enregistreur/Afficheur p/ Tracteur
'
'Le 09/08/2007
'Le 28/08/2007 Ok sauf Entretien ( affichage  chaque fois ...)
'Le 31/08/2007 OK Entretien affich 1 Fois
'Le 28/10/2007 Comptage de temps Moteur en marche.
'
'*****************************************************************************
'*****************************************************************************
'
'PIC 16F452 @ 4Mhz + Horloge EXT 32 768 Hz sur TMR1 ( interruptions @ 1Hz )
'Compte-Tours avec Capture sur TMR3 avec Horloge systme / 8.
'
'Afficheur LCD 2*16 sur PORTD
'
' 4037 Lignes assembleur
'
'*****************************************************************************
'*****************************************************************************
'
'Defines
'*****************************************************************************

DEFINE OSC 4
DEFINE BUTTON_PAUSE 50 
DEFINE ADC_BITS 10


' Define LCD connections

DEFINE LCD_DREG PORTD   	' Set LCD Data port
DEFINE LCD_DBIT 4       	' Set starting Data bit (0 or 4) if 4-bit bus
DEFINE LCD_RSREG PORTD  	' Set LCD Register Select port
DEFINE LCD_RSBIT 2      	' Set LCD Register Select bit
DEFINE LCD_EREG PORTD   	' Set LCD Enable port
DEFINE LCD_EBIT 3      		' Set LCD Enable bit
DEFINE LCD_BITS 4       	' Set LCD bus size (4 or 8 bits)

'
'
'*****************************************************************************
' Constantes
'*****************************************************************************

ExtOSC 		con 32768		'Quartz Horloge "temps" en Hz

Tension_ 	con 0			'Correspondance pour Canaux ADC
TempA_		con 1
TempH_		con 2
PressH_		con 4
Dureetonte	con 1		' de -1h  +59 mn ... ( 1/2 dure !!! )
ScaleP		con 1
Kelvin		con 273

'***************************  seuils Alarmes  ********************************
			
AlmVolt		con 15	* 100	'>=		Tension trop leve			1/100 V
AlmRpm		con 3600 		'>=		Rgime trop lev			T/Mn
AlmAir		con 80  + 273	'>=		Temp Air Trop leve		K
AlmHuileL	con 0   + 273	'<=		Temp Huile trop basse		K
AlmHuileH	con 120 + 273	'>=		Temp Huile trop leve		K
AlmPress	con 1	* 100	'<=		Pression Huile trop basse	1/100 Bar

'**************  Periodicits d'Entretien ( ordre croissant ! )  *************

Service1	con 10 ' Heures				
Service2	con 25
Service3	con 50
Service4	con 100
Service5	con 300

DATA (0),0 (29) 'Raz des Mmoires si reprogrammation

VERSION		con 1			'N de la rvision

'*****************************************************************************
'*****************************************************************************
'Config processeur
'*****************************************************************************
'

'@  __CONFIG    _CONFIG1L, _WDT_OFF_1L & _WDTPS_128_1L
@   __CONFIG    _CONFIG1H, _OSCS_OFF_1H & _XT_OSC_1H
@	__CONFIG	_CONFIG2L, _BOR_OFF_2L & _BORV_27_2L & _PWRT_ON_2L
@   __CONFIG    _CONFIG2H, _WDT_OFF_2H & _WDTPS_128_2H
'@  __CONFIG    _CONFIG3L, _WDT_OFF_3L & _WDTPS_128_3L
@   __CONFIG    _CONFIG3H, _CCP2MX_OFF_3H
@   __CONFIG    _CONFIG4L, _STVR_OFF_4L & _LVP_OFF_4L & _DEBUG_OFF_4L
'@  __CONFIG    _CONFIG4H, _WDT_ON_4H & _WDTPS_128_4H
@   __CONFIG    _CONFIG5L, _CP0_OFF_5L & _CP1_OFF_5L & _CP2_OFF_5L & _CP3_OFF_5L
@   __CONFIG    _CONFIG5H, _CPB_OFF_5H & _CPD_OFF_5H
@   __CONFIG    _CONFIG6L, _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L
@   __CONFIG    _CONFIG6H, _WRTC_OFF_6H & _WRTB_OFF_6H & _WRTD_OFF_6H 
@   __CONFIG    _CONFIG7L, _EBTR0_OFF_7L & _EBTR1_OFF_7L & _EBTR2_OFF_7L & _EBTR3_OFF_7L
@   __CONFIG    _CONFIG7H, _EBTRB_OFF_7H 

'*****************************************************************************
'Config TIMERs

T0CON = %00000010	' 16Bits 1/8 prescaler, Horloge Systme, OFF

T1CON = %00001010	'1/1 prescaler, Quartz 32,768

T3CON = %01110001	' ccp SUR TMR3,1/8 prescaler,Horloge systme,ON

'*****************************************************************************
'Config CCP1 arret CCP2

CCP1CON = %00000101	' Capture sur front montant 

CCP2CON = %00000000	'inhibition module CCP2

'*****************************************************************************
'Inhibition SSP

SSPCON1.5 = 0

'*****************************************************************************
'Config Interruptions

INTCON  = %10000000
INTCON2 = %11110000
INTCON3 = %00000000

PIE1    = %00000100
PIE2    = %00000000

IPR1    = %00000001
IPR2	= %00000000

RCON	= %10000000

'*****************************************************************************
'Config ADC
'*****************************************************************************

ADCON0 = %11000000
ADCON1 = %10000011

'*****************************************************************************
'*****************************************************************************
'Config et Prepositionnement E/S
'*****************************************************************************

PORTA	= %00000000
PORTB 	= %00000100
PORTC	= 0
PORTD	= 0
PORTE	= 0

TRISA 	= %00111111
TRISB	= %11100110
TRISC	= %00000111
TRISD	= %00000000
TRISE	= %00000000
'
'*****************************************************************************
'Alias E/S
'*****************************************************************************

'MCLR/ sur Broche 1 par R/C/D

Voltage		var PORTA.0		'TENSION Batterie / 4
TempA		var PORTA.1		'LM335
TempH		var PORTA.2		'LM335
Vref		var PORTA.3		'TL431 = 4.096v ...
Raz			var PORTA.4		'JUMPER Raz/Programmation
PressH		var PORTA.5		'MPX5700

'			var PORTB.0	
Contact		var PORTB.1		' + 12 v sous cl ( / 3.3 = 3 - 5 v !!! )
Selection 	var PORTB.2		'Poussoir slection Affichage
'			var PORTB.3
AlLCD		var PORTB.4		'Alimentation LCD FQU11P6 !!! 0 = ON : 1 = OFF
'			var PORTB.5
'			var PORTB.6
'			var PORTB.7

'			var PORTC.0
'			var PORTC.1
Speed		var PORTC.2		'Entre compte-tours 1C/4T
Alm			var PORTC.3		'Alarmes
'			var PORTC.4
'			var PORTC.5
'			var PORTC.6
'			var PORTC.7

Signal		var PORTD.0		'Voyant Survitesse
Buzzer		var PORTD.1		'Sortie commande Buzzer
RS			var PORTD.2
E			var PORTD.3
D4			var PORTD.4
D5			var PORTD.5
D6			var PORTD.6
D7			var PORTD.7

'			var PORTE.0
'			var PORTE.1
AlRef		var PORTE.2

'*****************************************************************************
'Types Variables
'*****************************************************************************
'
Result		var WORD

Volt		var WORD
Tension		var WORD
Tensionmoy	var WORD

Tair		var WORD
TAMax		var WORD		' Valeur Maxi Split
TairMax		var WORD		' Valeur Maxi mmorise

Thuile		var WORD
THMax		var WORD		' Valeur Maxi Split
THuileMax	var WORD		' Valeur Maxi mmorise

Dummy		var WORD
Capture		var WORD
CaptureOld	var WORD
Vitesse		var WORD
Vitessemoy	var WORD
VitesseMax	var WORD		' Valeur Maxi mmorise
VitMaxSpl	var	WORD		' Valeur Maxi Split

Pression	var WORD
OffsetP		var WORD

Periode		var WORD
Periode2	var WORD
MaxPeriode	var WORD		' Pour calcul DIV32 ...

HoursT		var WORD		' Memorisation Heures totales
HoursG		var WORD
Service		var WORD



LSelect		var BYTE

SecondsT	var BYTE		' Mmorisation Secondes Totales
MinutesT	var BYTE		' Mmorisation Minutes Totales
AddH		var BYTE		' Retenue 60M ...
AddM		var BYTE		' Retenue 60s

Delay		var BYTE
I			var BYTE


RazT		var BIT
Buzz		var BIT
Reveil		var BIT
Flagged		var BIT
Display		var BIT


INTCON.7 = 0				'Dsactivation interruptions

AlLCD = 0 					'Mise sous tension LCD
Alref = 1 					'Mise sous tension rfrence

PAUSE  500
LCDOUT $FE,1                ' Initialize LCD

CLEAR

Periode2 = 3000
dummy = 5000*Periode2 		'Juste Pour viter de ralentir l'interruption ...
MaxPeriode = DIV32 AlmRpm

WRITE 0,VERSION

'*****************************************************************************
'Includes
'*****************************************************************************

INCLUDE "DT_INTS-18.bas"
INCLUDE "ReEnterPBP-18.bas"
INCLUDE "Elapsed_INT-18_ExtOsc.bas"  ; Elapsed Timer Routines

ASM
INT_LIST_H  macro    ; IntSource,        Label,  Type, ResetFlag?

        INT_Handler    TMR1_INT,  _ClockCount,   PBP,  yes
    	INT_Handler	   CCP1_INT,  _Period,       PBP,  yes
       
    endm
    INT_CREATE_H            ; Creates the interrupt processor
ENDASM


INTCON.7 = 0				' Pour tre sur !!!
'
'*****************************************************************************
'Chargement / Remise  Zero Mmoire - Zro Pression
'*****************************************************************************

Delay = 0
BUTTON Contact,0,255,0,Delay,1,Jump
Reveil = 1							'Si contact  la mise sous tension
									' pause de 3s affichage initial

Jump:

Delay = 0
BUTTON Raz,0,255,0,Delay,0,Load		'Raz en l'air(1) = pas de raz

LCDOUT $FE,1,  " ** ATTENTION **"                  
LCDOUT $FE,$C0," * CALIBRATION *"

PAUSE 2000

Delay = 0
BUTTON Raz,0,255,0,Delay,0,Load     'Enlever cavalier pour Annulation

	
For I = 16 to 0	Step -1					

	LCDOUT 	$FE,$C0,REP "*"\I," "			'Vous avez	...  8s 
	Buzzer = 1						
	PAUSE 250
	Buzzer = 0
	PAUSE 250
	
NEXT I

Delay = 0
BUTTON Raz,0,255,0,Delay,0,Load		'C'est parti !!!


'Les interruptions sont dj inhibes ...

									' Effacement des Mmoires
FOR I = 6 TO 28

	WRITE I,0

NEXT I

	WRITE 4,1						' Autorisation affichage
	
	Buzzer = 1						'Confirmation Effacement
	PAUSE 1000
	Buzzer = 0
	
'*****************************************************************************
'Offset Pression ; L'offset moy est de 0.2-0.3 v
'*****************************************************************************

	TensionMoy = 0
	
	FOR I = 1 to 10
	
		ADCIN 4 , Result
	
		IF Result < 10 THEN	Result = 0
		
			Tensionmoy =  Tensionmoy + ( Result / 10 )
		
	NEXT I
	
	OffsetP = Tensionmoy			'OffsetP en "counts" ~ 60 counts
		
	WRITE 18,OffsetP.Lowbyte
	WRITE 20,OffsetP.HighByte
		
	LCDOUT $FE,1,  " * CALIBRATION *"                  
	LCDOUT $FE,$C0,"*** TERMINEE ***"	
		
	FOR I = 1 to 3						'Confirmation Zero
	
		Buzzer = 1
		PAUSE 200
		Buzzer = 0
		PAUSE 300
		
	NEXT I
	

'*****************************************************************************
Load:' Chargement dernires valeurs

READ  4,Display
READ  6,HoursT.Lowbyte
READ  8,HoursT.Highbyte
READ 10,MinutesT
READ 12,SecondsT
READ 14,Vitessemax.lowbyte
READ 16,Vitessemax.Highbyte
READ 18,OffsetP.LowByte
READ 20,OffsetP.HighByte
READ 22,TairMax.lowbyte
READ 24,TairMax.highbyte
READ 26,THuileMax.lowbyte
READ 28,THuileMax.HighByte	


GOTO Affinit


'*****************************************************************************
'*****************************************************************************
'Interruptions


'****************************************************************************
Period: 'Capture CCP1
'****************************************************************************
'

Capture.Highbyte = CCPR1H
Capture.Lowbyte  = CCPR1L

T0CON.7	= 0						'arret et remise  Zero TMR0

TMR0H	= 0
TMR0L	= 0

T0CON.7 = 1 					'redmarrage TMR0

IF INTCON.2 THEN				' Sous rgime

	Signal   = 1
	Vitesse  = 0
	INTCON.2 = 0
	CaptureOld = Capture
	GOTO noRpm
	
ENDIF

IF Captureold <= Capture THEN	'Pas d'Overflow TMR3

	Periode = Capture - CaptureOld
	
	
ELSE
		
	Periode =  65535 - CaptureOld + Capture + 1
		
ENDIF

		CaptureOld = Capture
				
IF Periode < 1500 THEN 		' Dpassement affichage
	Vitesse = 9999
	Signal  = 1
	GOTO noRpm
	
ENDIF

IF Periode <= MaxPeriode THEN 
	Signal = 1				' Dpassement Seuil
	GOTO RPM

ENDIF
	
	Signal = 0		
		
'*****************************************************************************
RPM: 'Calcul de la vitesse
'*****************************************************************************

	Periode	 = Periode / 2  		'   2^15 Maxi !
	
	Dummy	 = 2500*Periode2		'Prdiviseur  8 !!!
	Vitesse  = DIV32 Periode

noRpm:

@ INT_RETURN


'*****************************************************************************
'*****************************************************************************
'*****************************************************************************

'*****************************************************************************
Affinit: 'Affichage initial
'*****************************************************************************	

AlLCD = 0 						'Mise sous tension LCD
AlRef = 1						'Mise sous tension rfrence

PAUSE  500

	LCDOUT $FE,1                    ' Initialize LCD

	LCDOUT $FE,2, "Tot H:" ,DEC4 HoursT," M:", DEC2 MinutesT

PAUSE 500

'*****************************************************************************
Attente: 'Attente de la mise contact / mesure continue de la tension   
	
	Tensionmoy = 0
		
	FOR I = 1 to 4
	
		ADCIN Tension_ , Result
	
		IF Result < 10 THEN	Result = 5550
	
		Volt = Result * 40 / 25	' 124  = ( 12.400 / 4 ) /100 * 4
		
		IF Volt DIG 0 > 5 THEN Volt = Volt + 10
		
		Tensionmoy = Tensionmoy + ( Volt/4 )
		
	NEXT I
	
		Volt = Tensionmoy
			
     	LCDOUT $FE,$C0, "Tension:" , DEC2 Volt/100 ,".",DEC1 Volt/10," V"

    PAUSE 300

IF Reveil THEN

 	PAUSE 3000
 	Reveil = 0
 	
 ENDIF
 
     	
Delay = 0
BUTTON Contact,1,255,0,Delay,1,Suite

GOTO Attente

'****************************************************************************
Suite: 'Reset et lancement Horloges
'****************************************************************************

	T3CON.0	= 1				' Lancement TMR3
	
@	INT_CLEAR	TMR1_INT
@   INT_ENABLE  TMR1_INT  ; Autorisation interruptions Timer 1 

GOSUB ResetTime           	' Reset Time to  0000:00:00
'GOSUB StartTimer          	' Dmarrer le Timer

@ 	INT_ENABLE  CCP1_INT ; Autorisation interruptions CCP1

INTCON.7 	= 1				'Valider les Interruptions



'*****************************************************************************
'*****************************************************************************
'*****************************************************************************
'*****************************************************************************
Main: 'Programme principal

'*****************************************************************************
' Affichage et Enregistrement Vitesse MAX
'*****************************************************************************

IF INTCON.2 THEN 			' Si l'on est  l'arret

	Signal = 1
	Vitesse = 0
	
	IF T1CON.0  THEN T1CON.0 = 0				'arret timer1
	GOTO Jump2
	
ELSE

	IF NOT T1CON.0  THEN T1CON.0 = 1			'Sinon, dmarrer timer1
	
ENDIF


IF Vitesse = 9999 THEN Jump2		' c'est une erreur ...

VitesseMax 	= VitesseMax MAX Vitesse
VitMaxSpl	= VitesseMax

'*****************************************************************************
Jump2:'Mesure Tension
'*****************************************************************************

	TensionMoy = 0
		
	FOR I = 1 to 3
	
		ADCIN Tension_ , Result
	
		IF Result < 10 THEN	Result = 5550
	
		Volt = Result * 40 / 25	' 124  = ( 12.400 / 4 ) /100 * 4
		
		IF Volt DIG 0 > 5 THEN Volt = Volt + 10
		
		Tensionmoy = Tensionmoy + ( Volt / 3 )
		
		Volt = Tensionmoy		' volt en 10mV !!!
		
	NEXT I
		


'*****************************************************************************
TA:'Mesure Temprature air
'*****************************************************************************

	ADCIN Tempa_, Result
	
	IF Result < 10 THEN
	
		 Tair = 888
		 GOTO TH
		 
	ENDIF
	
	Tair = Result * 4 ' Result en mV
	
	IF Tair DIG 0 >5 THEN Tair = Tair + 10 'Arrondi au  le plus proche
	
	Tair = Tair /10 - 273		 ' Tair en C - Attention au ngatif !!!

	IF Result > 682 THEN TAMAx = TAMax MAX Tair
	
'*****************************************************************************
TH:'Mesure Temprature Huile
'*****************************************************************************

	ADCIN TempH_ , Result
	
	IF Result < 10 THEN
	
	 	THuile = 888
	 	GOTO PH
	 	
	 ENDIF
		 
	THuile = Result *4 ' Result en mV

	IF THuile DIG 0 >5 THEN THuile = THuile + 10 'Arrondi au  le plus proche
	
	THuile = THuile/10 - 273 		' THuile en C

	IF Result > 682 THEN THMax = THMax MAX THuile


'*****************************************************************************
PH:'Mesure Pression Huile
'*****************************************************************************

	ADCIN PressH_ , Result

	IF Result < 10 THEN
	
	 	Pression = 000
	 	GOTO ALarm
	 	
	 ENDIF
	 	
' Offset de ~ 0.2v ... 6 Bars pour 4 v ( 1000 counts )
	 	
	Pression = ( Result - OffsetP ) * 6 /10		'	Pression en Bar * 100
	
'	Pression =  Pression / ScaleP 				'   Si ncessaire
	
	IF Pression DIG 0 > 5 THEN Pression = Pression + 10 'Arrondi au plus proche
	
	
'*****************************************************************************
ALarm:'Alarmes
'*****************************************************************************

IF (( Volt > AlmVolt ) OR ( Tair + Kelvin > AlmAir ) OR ( Thuile + Kelvin < _
AlmHuileL ) OR ( THuile + Kelvin > AlmHuileH ) OR ( Vitesse<> 0 AND Pression _
< AlmPress )) THEN

	Alm 	= 1
	TOGGLE Buzzer
	
ELSE

	Alm     = 0
	Buzzer  = 0
	
ENDIF
		
		
'*****************************************************************************
' Test Slection
'*****************************************************************************

Delay	= 0
BUTTON Selection,0,255,0,Delay,1,Wait1
	
	GOTO Affichage
	
Wait1: ' Attente relachement
	Delay = 0
	BUTTON Selection,0,255,0,Delay,1,Wait1
	
	LSelect =  LSelect + 1
	
	IF LSelect > 2 THEN LSelect = 0 

 
'*****************************************************************************
Affichage: 'Affichage toutes les secondes
'*****************************************************************************

SELECT CASE LSelect

	Case 0
	
		GOTO AFF_SplitSpeed
		
	Case 1
	
		GOTO AFF_TempATempH
		
	Case 2
	
		GOTO AFF_TempPress
		
END SELECT



'*****************************************************************************
AFF_SplitSpeed:

	IF SecondsChanged = 1 THEN  		'Mise  jour Toutes les secondes
     	SecondsChanged = 0
     
     	
     	LCDOUT $FE,1, "Spl H:" ,DEC4 Hours," M:", DEC2 Minutes
     	
     	IF Service <> 0 AND Display = 1 AND Seconds.0 THEN
     	
     		LCDOUT "*" ' Marque Entretien
     	
     	ENDIF
     	
     	LCDOUT $FE,$C0, "Speed: " , DEC Vitesse," T/Mn"
     	
  	ENDIF
  
GOTO Sommeil0


'***************************************************************************** 
AFF_TempaTempH:

	IF SecondsChanged = 1 THEN  		'Mise  jour Toutes les secondes
     	SecondsChanged = 0
     
     	LCDOUT $FE,1, "Tension: " , DEC2 Volt/100 ,".",DEC1 Volt/10," V" 
     	
     	LCDOUT $FE,$C0, "TA:",SDEC2 Tair,"C TH:",SDEC3 Thuile,"C"
     	
  	ENDIF
  	
GOTO Sommeil0


'*****************************************************************************  
AFF_TempPress:

	IF SecondsChanged = 1 THEN  		'Mise  jour Toutes les secondes
     	SecondsChanged = 0
     
     	LCDOUT $FE,1, "TA:",SDEC2 Tair,"C: TH:",SDEC3 Thuile,"C"
     	
     	LCDOUT $FE,$C0, "P Huile: ",DEC1 Pression/100 ,".",DEC1 Pression/10," Bar "
     	
     ENDIF
     
     
'*****************************************************************************
Sommeil0:' Enregistrement Entretien  et Mise en sommeil 
'			: Si contact coup >> mise en sommeil
'*****************************************************************************


IF HoursT = 0 AND Hours <= Dureetonte  THEN Jump3 'on saute 0 Heures

	
'*****************************************************************************
'Correction Minutes et secondes

IF SecondsT + Seconds >= 60 THEN

	AddM = 1
ELSE
	AddM = 0
ENDIF

IF MinutesT + Minutes + AddM >= 60 THEN 

	AddH = 1
ELSE
	AddH = 0
	
ENDIF


'*****************************************************************************
'Plages d'entretien

HoursG = HoursT + Hours + AddH

IF  HoursG // Service5 <  Dureetonte _
	OR  HoursG // Service5 >=  Service5 - Dureetonte  THEN

	Service = Service5
	Flagged = 1
	GOTO Jump3
	 
ENDIF
	
IF  HoursG // Service4 <  Dureetonte _
	OR  HoursG // Service4 >=  Service4 - Dureetonte  THEN

	IF Service < Service4 THEN	Service = Service4

	Flagged = 1
	GOTO Jump3
		 
ENDIF

IF  HoursG // Service3 <  Dureetonte _
	OR  HoursG // Service3 >=  Service3 - Dureetonte  THEN 

	IF Service < Service3 THEN	Service = Service3
	
	Flagged = 1
	GOTO Jump3
		 
ENDIF

IF  HoursG // Service2 <  Dureetonte  _
	OR  HoursG // Service2 >=  Service2 - Dureetonte  THEN 

	IF Service < Service2 THEN	Service = Service2
	
	Flagged = 1
	GOTO Jump3
		 
ENDIF

IF  HoursG // Service1 <  Dureetonte  _
	OR  HoursG // Service1 >= Service1 - Dureetonte  THEN 

	IF Service < Service1 THEN	Service = Service1
	
	Flagged = 1
	GOTO Jump3
	
ENDIF

	Flagged = 0
	
Jump3:

IF Flagged = 0 THEN Display = 1		' Hors plages: On peut Afficher  nouveau
 									'               la maintenance
 								
 								
Delay = 0
BUTTON Contact,1,255,0,Delay,1,Main	' Nouveau cycle
 

'*****************************************************************************
'Arret interruptions

	INTCON.7 = 0 		' Ne pas perturber l'Arret 
						' et redmarrage sans interruptions
	
@ 	INT_DISABLE  CCP1_INT ; Disable CCP1 Interrupt
@	INT_CLEAR	 CCP1_INT
@ 	INT_DISABLE  TMR1_INT ; Disable TMR1 Interrupt
@	INT_CLEAR	 TMR1_INT

'*****************************************************************************
'Mise  jour Temps Total
 	
 	 SecondsT = SecondsT + Seconds
     
     IF SecondsT >= 60 THEN
     
     MinutesT = MinutesT + 1
     SecondsT = SecondsT - 60
     
     ENDIF
     
     MinutesT = MinutesT + Minutes
     
     IF MinutesT >= 60 THEN
     
     HoursT = HoursT + 1
     MinutesT = MinutesT - 60
     
     ENDIF
     
     HoursT = HoursT + Hours 
     
'*****************************************************************************
'Affichage ENTRETIEN

Buzzer = 0

IF NOT Display THEN Total 

SELECT CASE Service

	CASE Service5
	 	LCDOUT $FE,$C0 + 11, DEC3 Service5," H"

	CASE Service4
	 	LCDOUT $FE,$C0 + 11, DEC3 Service4," H"

	CASE Service3 
		LCDOUT $FE,$C0 + 11, DEC3 Service3," H"

	CASE Service2
	 	LCDOUT $FE,$C0 + 11, " ",DEC2 Service2," H" 

	CASE Service1
		LCDOUT $FE,$C0 + 11, " ",DEC2 Service1," H" 

	
CASE ELSE
	GOTO Total
	
END SELECT

  
'*****************************************************************************
ArretBuzz: 'Arret du Buzzer

    	
    LCDOUT $FE,2, "**H Tot:" ,DEC4 HoursT," H**" 	'Affichage gn. 1 ligne
    LCDOUT $FE,$C0, "ENTRETIEN: "					'Affichage gn. 2 ligne
     
TOGGLE Buzzer
PAUSE 500

Delay	= 0
BUTTON Selection,0,255,0,Delay,0,ArretBuzz

IF Flagged THEN Display	= 0
Buzzer 	= 0
Service = 0		' N'effacer que si arret ...

'*****************************************************************************
Total:'Enregistrement en EEPROM des Paramtres
'*****************************************************************************

'Les interruptions sont dj inhibes ...


WRITE  4,Display

WRITE  6,HoursT.Lowbyte
WRITE  8,HoursT.Highbyte

WRITE 10,MinutesT

WRITE 12,SecondsT


READ  14,Vitessemax.lowbyte
READ  16,Vitessemax.Highbyte

IF VitMaxSpl > VitesseMax THEN

WRITE 14,VitMaxSpl.lowbyte
WRITE 16,VitMaxSpl.Highbyte

ENDIF



READ 22,TairMax.lowbyte
READ 24,TairMax.highbyte

IF TaMax > TairMax  THEN

WRITE 22,TaMax.lowbyte
WRITE 24,TaMax.highbyte

ENDIF


READ 26,THuileMax.lowbyte
READ 28,THuileMax.HighByte
	
IF THMax > THuileMax  THEN

WRITE 26,THMax.lowbyte
WRITE 28,THMax.Highbyte

ENDIF

'*****************************************************************************
'Affichage HHHH:MM Total + Volt
 
     LCDOUT $FE,2, "Tot H:" ,DEC4 HoursT,":", DEC2 MinutesT,":",DEC2 SecondsT
    
     LCDOUT $FE,$C0, "VMax: " , DEC4 VitMaxSpl," T/Mn "
	
PAUSE 10000

	

Sommeil:

	LCDOUT $FE,1, "!!*BYE - BYE*!!"

	For I = 16 to 0	Step -1					'Animation arret
	
		LCDOUT 	$FE,$C0,REP "*"\I," "			'	...  4s 			
		PAUSE 250
		
	NEXT I
	


	PORTD = %00000000			' PortD  0
	AlLCD = 1					' Coupure LCD
	ADCON0.0 = 0				' Dsactivation ADC
	AlRef = 0					' Coupure Vref
	
	
	T3CON.0	= 0				' arret TMR3
	T1CON.0	= 0				' arret TMR1
	T0CON.7 = 0				' arret TMR0
	
	INTCON.7 = 0			' Wakeup sans interruptions
	
	INTCON3.0 = 0						' reset flag INT1
	INTCON3.3 = 1			' validation INT1 pour rveil

			
@ SLEEP
@ Nop						' Redmarrage par mise du contact


	INTCON3.3 = 0			'Neutralisation INT1
	INTCON3.0 = 0			'Reset Flag INT1

'*****************************************************************************
Wakeup: 'Dbut du Programme - reveil du PIC / Affichage Memoire
'*****************************************************************************
'
FLAGS 	= 0					' Validation Reset LCD
PORTD	= 0
Reveil 	= 1
LSelect	= 0
	
GOTO Load				'Rechargement mmoires et Affichage de Dpart

'*****************************************************************************
'*****************************************************************************
END


