;****************************************************************************
;*	Microchip Technology Inc. 2006					*
;*	Filename: Main.asm									*
;*																*
;****************************************************************************

	list			p=16f877a				; list directive to define processor
	#include		<p16f877a.inc>			; processor specific variable definitions
	errorlevel  -302           				; suppress message 302 from list file
	__CONFIG _CP_OFF&_WDT_OFF&_HS_OSC&_LVP_OFF&_BODEN_OFF&_DEBUG_OFF&_PWRTE_OFF
;****************************************************************************

	#define	scroll_dir	TRISA,4
	#define	scroll		PORTA,4				; Push-button RA4 on PCB
	#define	select_dir	TRISB,0		
	#define	select		PORTB,0				; Push-button RB0 on PCB

	#define	Buff_size .23
	#define	_C	STATUS, C
	#define	_Z	STATUS, Z
	#define neg 0
	#define deg 1

	#define simulating      				; set simulation "on" so LCD
											;  rutines aren't run during simulation
											; comment out when compiled for hardware
												
	EXTERN	LCDInit, temp_wr, d_write, i_write, LCDLine_1, LCDLine_2
	EXTERN	X_L, X_H, Y_L, Y_H, Z_L, Z_H, SHIFT
	EXTERN	SINCOS, Shifter, ATAN

FSR_ptr	macro	addr						; This macro is used to point the FSR
	banksel	addr							; at a specified address
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movlw		LOW addr
	movwf		FSR
			endm

APP				UDATA
POT1_cal_H		RES 1
POT1_cal_L		RES 1
Counter0			RES 1
flag				RES 1
Angle_H			RES 1
Angle_L			RES 1

TenK				RES 1	
Thou				RES 1
Hund				RES 1
Tens				RES 1
Ones				RES 1
NumH				RES 1
NumL				RES 1
LSD				RES 1
MsD				RES 1
MSD				RES 1

TMP0				RES 1
TMP1				RES 1
TMP2				RES 1
TMP3				RES 1
TMP4				RES 1
TMP5				RES 1
TMP6				RES 1
TMP7				RES 1

BuffX				UDATA
MyXBuff_ptr		RES 1
MyXBuff			RES (Buff_size*.2)	;(16 bit data)

BuffY				UDATA
MyYBuff_ptr 	RES 1
MyYBuff			RES (Buff_size*.2)

BuffZ1			UDATA
MyZ1Buff_ptr	RES 1
MyZ1Buff			RES (Buff_size*.2)

BuffZ2			UDATA
MyZ2Buff_ptr	RES 1
MyZ2Buff			RES (Buff_size*.2)
	; Made global for use in the Data Monitor and Control Interface tool
	GLOBAL		MyXBuff, MyYBuff, MyZ1Buff, MyZ2Buff	
;****************************************************************************

RST_VECTOR	CODE	0x000					; processor reset vector
  	pagesel	start
  	goto    	start

Pgrm0			CODE
start
clr_all_variables
	banksel	POT1_cal_H
	clrf		POT1_cal_H	
	clrf		POT1_cal_L	
	clrf		Counter0
	clrf		flag
	clrf		Angle_H	
	clrf		Angle_L	
	clrf		TenK		
	clrf		Thou		
	clrf		Hund		
	clrf		Tens	
	clrf		Ones	
	clrf		NumH	
	clrf		NumL		
	clrf		LSD		
	clrf		MsD			
	clrf		MSD			
	clrf		TMP0
	clrf		TMP1
	clrf		TMP2
	clrf		TMP3
	clrf		TMP4
	clrf		TMP5
	clrf		TMP6
	clrf		TMP7

	call		ResetBuff
ifndef simulating
  	call 		LCDInit
endif
	
	banksel	TXSTA					; Initialize USART		
	movlw		B'10100100'			; Master mode, 8-bit, Async, High speed
	movwf		TXSTA					; 9.6Kbaud @ 20MHz
	movlw		.129					
	movwf		SPBRG
	banksel	RCSTA
	movlw		B'10010000'
	movwf		RCSTA
	
	banksel	TRISA				
	bsf		TRISA, 4				; make switch RA4 an Input
	bsf		TRISB, 0				; make switch RB0 an Input

	banksel	ADCON0				; RIGH JUSTIFIED, VSS AND VDD AS REFS, AN0
	movlw		B'10000001'			; SELECT A/Di CONVERSION CLOCK FOSC/32
	movwf		ADCON0				; CONVERSION TIME IS 2uSECS
	banksel	ADCON1
	movlw		B'10001110'			
	movwf		ADCON1				

	banksel	POT1_cal_H			; set the calibration value
	movlw		HIGH .500
	movwf		POT1_cal_H
	movlw		LOW .500
	movwf		POT1_cal_L
;****************************************************************************

Main_loop
	banksel	ADCON0				; Read A/D
	bsf		ADCON0, GO_DONE		
AD_WAIT
	btfsc		ADCON0, GO_DONE
	goto		AD_WAIT

	banksel	ADRESL
	movfw		ADRESL
	banksel	POT1_cal_L
	subwf		POT1_cal_L, W
	banksel	Angle_L
	movwf		Angle_L
	banksel	ADRESH
	movfw		ADRESH
	btfss		STATUS, C
	incf		ADRESH, W			
	banksel	POT1_cal_H
	subwf		POT1_cal_H, W
	banksel	Angle_H
	movwf		Angle_H				; Read Angle

	banksel	Z_H
	movwf		Z_H
	banksel	Angle_L
	movfw		Angle_L
	banksel	Z_L
	movwf		Z_L					; Load Angle into Z

	call		Log_Z1				; Log input angle Z to buffer Z1
	call		SINCOS				; Calculate SIN and COS
	call		Log_XY				; Log output X and Y to buffer

ifndef simulating
	call		LCDLine_1			; place curser on line 1
	call		disp_xy				; Display X and Y on LCD
endif

	banksel	TXREG					; Send CarriageReturn command to terminal
	movlw		"\r"				
	movwf		TXREG
	banksel	TXSTA
	btfss		TXSTA,TRMT		
	goto		$-1
	banksel	TXREG					; Send NewLine command to terminal
	movlw		"\n"				
	movwf		TXREG
	banksel	TXSTA
	btfss		TXSTA,TRMT		
	goto		$-1

	call		ATAN					; Calculate ATAN of X/Y
	call		Log_Z2				; Log output angle Z to buffer Z2

	banksel	Z_H
	movfw		Z_H
	banksel	TMP0
	movwf		TMP0
	banksel 	Z_L
	movfw		Z_L
	banksel 	TMP1
	movwf		TMP1
ifndef simulating
	call		LCDLine_2			; place curser on line 2
	call		disp_z1				; Display input angle Z in degrees on LCD
	call		disp_z2				; Display output angle Z in degrees on LCD
endif

	call		delay0				; Short delay

	banksel	TXREG					; Send NewPage command to terminal
	movlw		0x0C				
	movwf		TXREG
	banksel	TXSTA
	btfss		TXSTA,TRMT			
	goto		$-1

	banksel	Counter0
	incf		Counter0, F
	movfw		Counter0
	sublw		Buff_size			
	btfsc		STATUS, Z
	call		ResetBuff			; Reset the Buffer every 23 (Buff_size) loops
	goto 		Main_loop
;****************************************************************************

disp_z1
	banksel	temp_wr			; Display Z1:
	movlw		'Z'
	movwf		temp_wr
	call		d_write
	movlw		'1'
	movwf		temp_wr
	call		d_write
	movlw		':'
	movwf		temp_wr
	call		d_write
	banksel	Angle_H			; Load input angle into Num
	movfw		Angle_H
	banksel	NumH
	movwf		NumH
	banksel	Angle_L
	movfw		Angle_L
	banksel	NumL
	movwf		NumL				
	goto		disp_z			
disp_z2				
	banksel	temp_wr			; Display Z2:
	movlw		'Z'
	movwf		temp_wr
	call		d_write
	movlw		'2'
	movwf		temp_wr
	call		d_write
	movlw		':'
	movwf		temp_wr
	call		d_write
	banksel	Z_H				; Load output angle Z into Num
	movfw		Z_H
	banksel	NumH
	movwf		NumH
	banksel	Z_L
	movfw		Z_L
	banksel	NumL
	movwf		NumL
disp_z
	call		LSBdeg			; This function converts Num into degrees 
	banksel	flag
	bsf		flag, deg		; Indicate degrees are being displayed
	call		LCD_disp
	return

LSBdeg							; This function converts Z into degrees 
	banksel	NumH				; by multiplying by .351563 deg/lsb (degree per LSB)
	movfw		NumH				; .351563 dec = .0101101 bin
	banksel	TMP0				; Create four instances of Z
	movwf		TMP0				; shift one by 2, another by 4, another by 6, 
	movwf		TMP2				; and another by 7, then add them together
	movwf		TMP4
	movwf		TMP6
	banksel	NumL
	movfw		NumL
	banksel	TMP1
	movwf		TMP1
	movwf		TMP3
	movwf		TMP5
	movwf		TMP7
	banksel	SHIFT
	movlw		0x2				
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	TMP1				; Load FSR
	call		Shifter			; Execute shift
	banksel	SHIFT
	movlw		0x4				
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	TMP3				; Load FSR
	call		Shifter			; Execute shift
	banksel	SHIFT
	movlw		0x5				
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	TMP5				; Load FSR
	call		Shifter			; Execute shift
	banksel	SHIFT
	movlw		0x7				
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	TMP7				; Load FSR
	call		Shifter			; Execute shift							
	banksel	TMP3				; Now add all four 16bit TMP values
	movfw		TMP3
	addwf		TMP1,F
	movfw		TMP2
	btfsc		_C
	incf		TMP2,w
	addwf		TMP0,F
	movfw		TMP5
	addwf		TMP1,F
	movfw		TMP4
	btfsc		_C
	incf		TMP4,w
	addwf		TMP0,F
	movfw		TMP7
	addwf		TMP1,F
	movfw		TMP6
	btfsc		_C
	incf		TMP6,w
	addwf		TMP0,F			
	movfw		TMP0				; Place result in Num 
	banksel	NumH				
	movwf		NumH
	banksel	TMP1
	movfw		TMP1
	banksel	NumL
	movwf		NumL
	return

disp_xy							
	banksel	temp_wr			; Display X:
	movlw		'X'
	movwf		temp_wr
	call		d_write
	movlw		':'
	movwf		temp_wr
	call		d_write
	banksel	X_H				; Load X into Num
	movfw		X_H
	banksel	NumH
	movwf		NumH
	banksel	X_L
	movfw		X_L
	banksel	NumL
	movwf		NumL
	call		LCD_disp			; Display X value
	banksel	temp_wr			; Display Y:
	movlw		'Y'
	movwf		temp_wr
	call		d_write
	movlw		':'
	movwf		temp_wr
	call		d_write
	banksel	Y_H				; Load Y into Num
	movfw		Y_H
	banksel	NumH
	movwf		NumH
	banksel	Y_L
	movfw		Y_L
	banksel	NumL
	movwf		NumL
	call		LCD_disp			; Display Y value
	return

LCD_disp							; The Num value is displayed on the LCD
	banksel	flag
	bcf		flag, neg
	banksel	NumH
	btfss		NumH, 7
	goto		bcd
		banksel	flag			; If Num negative, set neg flag and make positive
		bsf		flag, neg
		banksel	NumL
		comf		NumL, F			
		comf		NumH, F
		movlw		01H
		addwf		NumL, F
		btfsc		STATUS,C
		incf		NumH, F
bcd
	call		bin16_bcd		; convert from binary to BCD for display
	banksel	flag
	btfss		flag, neg
	goto		spacer
		movlw		'-'			; If neg, display a negative sign
		banksel	temp_wr
		movwf		temp_wr
		call		d_write
		goto		LCD_disp_num
spacer
	movlw		' '				; Otherwise, display a space
	banksel	temp_wr
	movwf		temp_wr
	call		d_write
LCD_disp_num
	banksel	flag
	btfsc		flag, deg
	goto		degree			; Showing degrees? Degrees only require 3 digits
		banksel	TenK			; Display 1's digit 
		movf		TenK, W
		call		bin_bcd
		banksel	LSD
		movf		LSD, W				
		banksel	temp_wr
		movwf		temp_wr
		call		d_write
		movlw		'.'			; Display decimal point "."
		banksel	temp_wr
		movwf		temp_wr
		call		d_write
		banksel	Thou			; Display 1/10's digit
		movf		Thou,w
		call		bin_bcd
		banksel	LSD
		movf		LSD,w			
		banksel	temp_wr
		movwf		temp_wr
		call		d_write
degree	
	banksel	Hund				; Display 1/100's digit (degree's 100's digit)
	movf		Hund, W			
	call		bin_bcd
	banksel	LSD
	movf		LSD, W	
	banksel	temp_wr
	movwf		temp_wr
	call		d_write
	banksel	Tens				; Display 1/1000's digit (degree's 10's digit)
	movf		Tens,w			
	call		bin_bcd
	banksel	LSD
	movf		LSD,w	
	banksel	temp_wr
	movwf		temp_wr
	call		d_write
	banksel	flag				; If not displaying degree's then done
	btfss		flag, deg
	goto		disp_done	
		banksel	Ones			; Display degree's 1's digit
		movf		Ones,w
		call		bin_bcd
		banksel	LSD
		movf		LSD,w		
		banksel	temp_wr
		movwf		temp_wr
		call		d_write
		movlw		' '
		movwf		temp_wr
		call		d_write
disp_done
	banksel	flag
	bcf		flag, deg
	return

;---------------- Binary (16-bit) to BCD -----------------------
bin16_bcd			 			
	banksel	NumH				; Takes number in NumH:NumL
   swapf   	NumH,w 			; Returns decimal in TenK:Thou:Hund:Tens:Ones
   andlw   	0x0F             
   addlw   	0xF0             
   movwf   	Thou 
   addwf   	Thou, F
   addlw   	0xE2 
   movwf   	Hund 
   addlw   	0x32 
   movwf   	Ones 
	movf    	NumH, W
	andlw   	0x0F 
	addwf   	Hund, F
	addwf   	Hund, F 
	addwf   	Ones, F
	addlw   	0xE9 
	movwf   	Tens 
	addwf   	Tens, F
	addwf   	Tens, F
	swapf   	NumL, W 
	andlw   	0x0F 
	addwf   	Tens, F
	addwf   	Ones, F
	rlf     	Tens, F
	rlf     	Ones, F
	comf    	Ones, F
	rlf     	Ones, F
	movf    	NumL, W
	andlw   	0x0F 
	addwf   	Ones, F
	rlf     	Thou, F
	movlw   	0x07 
	movwf   	TenK 
   movlw   	0x0A                         
Lb1: 
	addwf   	Ones, F
	decf    	Tens, F
	btfss   	3,0 
	goto   	Lb1 
Lb2: 
	addwf   	Tens, F
	decf    	Hund, F
	btfss   	3,0 
	goto   	Lb2 
Lb3: 
	addwf   	Hund, F
	decf    	Thou, F
	btfss   	3,0 
	goto   	Lb3 
Lb4: 
	addwf   	Thou, F
	decf    	TenK, F
	btfss   	3,0 
	goto   	Lb4 
	retlw   	0

;---------------- Binary (8-bit) to BCD -----------------------
bin_bcd							; 255 = highest possible result
	banksel	MSD
	clrf		MSD
	clrf		MsD
	movwf		LSD				; move value to LSD
ghundreth	
	movlw		.100				; subtract 100 from LSD
	subwf		LSD, W	
	btfss		_C					; is value greater then 100
	goto		gtenth			; NO goto tenths
	movwf		LSD				; YES, move subtraction result into LSD
	incf		MSD, F			; increment hundreths
	goto		ghundreth	
gtenth
	movlw		.10				; take care of tenths
	subwf		LSD, W
	btfss		_C
	goto		over				; finished conversion
	movwf		LSD
	incf		MsD,f				; increment tenths position
	goto		gtenth
over								; 0 - 9, high nibble = 3 for LCD
	movf		MSD, W			; get BCD values ready for LCD display
	xorlw		0x30				; convert to LCD digit
	movwf		MSD
	movf		MsD, W
	xorlw		0x30				; convert to LCD digit
	movwf		MsD
	movf		LSD, W
	xorlw		0x30				; convert to LCD digit
	movwf		LSD
	retlw		0

delay0							; Short delay
	banksel	TMP0
	movlw		0xFF
	movwf		TMP0
	movwf		TMP1
	movlw		0x04
	movwf		TMP2
	decfsz	TMP0,f
	goto		$-1
	decfsz	TMP1,f
	goto		$-3
	decfsz	TMP2,f
	goto		$-5
	return

Log_Z1
	banksel	MyZ1Buff_ptr
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movfw		MyZ1Buff_ptr
	movwf		FSR
	banksel	Z_L
	movfw		Z_L
	movwf		INDF
	incf		FSR,f
	banksel	Z_H
	movfw		Z_H
	movwf		INDF
	banksel	MyZ1Buff_ptr
	incf		MyZ1Buff_ptr, F
	incf		MyZ1Buff_ptr, F
	return

Log_Z2
	banksel	MyZ2Buff_ptr
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movfw		MyZ2Buff_ptr
	movwf		FSR
	banksel	Z_L
	movfw		Z_L
	movwf		INDF
	incf		FSR, F
	banksel	Z_H
	movfw		Z_H
	movwf		INDF
	banksel	MyZ2Buff_ptr
	incf		MyZ2Buff_ptr, F
	incf		MyZ2Buff_ptr, F
	return

Log_XY
	banksel	MyXBuff_ptr
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movfw		MyXBuff_ptr
	movwf		FSR
	banksel	X_L
	movfw		X_L
	movwf		INDF
	incf		FSR,f
	movfw		X_H
	movwf		INDF
	banksel	MyXBuff_ptr
	incf		MyXBuff_ptr, F
	incf		MyXBuff_ptr, F
	banksel	MyYBuff_ptr
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movfw		MyYBuff_ptr
	movwf		FSR
	banksel	Y_L
	movfw		Y_L
	movwf		INDF
	incf		FSR, F
	movfw		Y_H
	movwf		INDF
	banksel	MyYBuff_ptr
	incf		MyYBuff_ptr, F
	incf		MyYBuff_ptr, F
	return

ResetBuff
	banksel	Counter0
	clrf		Counter0
	banksel	MyXBuff
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	banksel	MyXBuff_ptr
	movlw		LOW MyXBuff
	movwf		MyXBuff_ptr
	movwf		FSR
R_BuffX_loop
	clrf		INDF
	incf		FSR, F
	movfw		FSR
	sublw		LOW (MyXBuff + (Buff_size*.2))
	btfss		STATUS,Z
	goto		R_BuffX_loop
	banksel	MyYBuff
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	banksel	MyYBuff_ptr
	movlw		LOW MyYBuff
	movwf		MyYBuff_ptr
	movwf		FSR
R_BuffY_loop
	clrf		INDF
	incf		FSR, F
	movfw		FSR
	sublw		LOW (MyYBuff + (Buff_size*.2))
	btfss		STATUS, Z
	goto		R_BuffY_loop
	banksel	MyZ1Buff
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movlw		LOW MyZ1Buff
	movwf		MyZ1Buff_ptr
	movwf		FSR
R_BuffZ1_loop
	clrf		INDF
	incf		FSR, F
	movfw		FSR
	sublw		LOW (MyZ1Buff + (Buff_size*.2))
	btfss		STATUS, Z
	goto		R_BuffZ1_loop
	banksel	MyZ2Buff
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movlw		LOW MyZ2Buff
	movwf		MyZ2Buff_ptr
	movwf		FSR
R_BuffZ2_loop
	clrf		INDF
	incf		FSR, F
	movfw		FSR
	sublw		LOW (MyZ2Buff + (Buff_size*.2))
	btfss		STATUS, Z
	goto		R_BuffZ2_loop
	return

	END
