	list		p=16f877a		; list directive to define processor
	#include	<p16f877a.inc>	; processor specific variable definitions
	errorlevel  -302       	; suppress message 302 from list file

FSR_ptr	macro	addr
	banksel	addr
	bcf		STATUS,IRP
	btfsc		STATUS,RP1
	bsf		STATUS,IRP
	movlw		LOW addr
	movwf		FSR
			endm

SINCOS_VAR	UDATA
ITERATION	RES 1
X_H			RES 1
X_L			RES 1
Y_H			RES 1
Y_L			RES 1
Z_H			RES 1
Z_L			RES 1
X_TMP_H		RES 1
X_TMP_L		RES 1
Y_TMP_H		RES 1
Y_TMP_L		RES 1
ITERAT_TMP	RES 1
Di				RES 1
COSCH			RES 1
COSCL			RES 1
Counter1		RES 1
SHIFT			RES 1
	GLOBAL	X_L, X_H, Y_L, Y_H, Z_L, Z_H, SHIFT

	#define 	Dir	Di,0
	#define 	RV		Di,1
	#define	_C		STATUS,0
	#define	_Z		STATUS,2

MathAlg	CODE	0x100
Z_stepH_tbl
	addwf	PCL,f
	dt	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
Z_stepL_tbl
	addwf	PCL,f
	dt	0x80,0x4C,0x28,0x14,0x0A,0x05,0x03,0x01
Z_NstepH_tbl
	addwf	PCL,f
	dt	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
Z_NstepL_tbl
	addwf	PCL,f
	dt	0x80,0xB4,0xD8,0xEC,0xF6,0xFB,0xFD,0xFF

ATAN
	banksel	Z_H				; Z_H & Z_L is loaded with 0x0000
	movlw		0x00				; Y & X is the input
	movwf		Z_H				; X(i+1)	=	Xi - Yi*Di*2^-i
	movlw		0x00				; Y(I+1)	=	Yi + Xi*Di*2^-i
	movwf		Z_L				; Z(i+1)	=	Zi - Di*ATAN(2^-i)
	banksel	Di					; Di		=	1 if Yi < 0 ELSE Di	=	0
	bsf		RV					; Set Vectoring Mode
	goto		CORDIC_Alg		
	GLOBAL 	ATAN
SINCOS
	banksel	Y_L				; Z_H & Z_L is the input
	movlw		0x00				; Y_H & Y_L is loaded with 0x0000	
	movwf		Y_L				; X_H & X_L is loaded with 6070 (1/An constant)
	movlw		0x00			
	movwf		Y_H			
	movlw		LOW .6070	
	movwf		X_L				; X(i+1)	=	Xi - Yi*Di*2^-i
	movlw		HIGH .6070		; Y(I+1)	=	Yi + Xi*Di*2^-i
	movwf		X_H				; Z(i+1)	=	Zi - Di*ATAN(2^-i)
	banksel	Di					; Di		=	0 if Zi < 0 ELSE Di	=	1
	bcf		RV					; Set Rotational Mode

CORDIC_Alg
	banksel	ITERATION
	clrf		ITERATION
Rotation_loop						
BUFF_X_Y							; Buffers both X & Y into temporary registers 
	banksel 	Y_L
	movf		Y_L, W			; Move Y --> T_TEMP
	movwf		Y_TMP_L
	movf		Y_H, W
	movwf		Y_TMP_H
	movf		X_L, W			; Move Y --> T_TEMP
	movwf		X_TMP_L
	movf		X_H, W
	movwf		X_TMP_H

	banksel	Di					; Vectoring or Rotational Mode?
	bcf		Dir
	btfsc		RV
	goto		Rot
Vec
	btfss		Z_H, 7			; Determine the state of Di (1 OR -1)
	bsf		Dir				; Di=1 when Z_H is pos
	goto		Cordic
Rot
	btfsc		Y_H, 7			; Determine the state of Di (1 OR -1)
	bsf		Dir				; Di=1 when Y_H is neg

Cordic
	movfw		ITERATION
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	Y_TMP_L			; Load FSR
	call		Shifter			; Execute shift

	btfsc		Dir
	call		COM_YTEMP		; Get the 2's complement of teh TEMP register 
SUM_X								; Calculate X(i+1)
	movf		Y_TMP_H, W		
	addwf		X_H, F
	movf		Y_TMP_L, W
	addwf		X_L, F
	btfsc		_C
	incf		X_H, F
	
	movfw		ITERATION
	movwf		SHIFT				; Load number of shifts
	bsf		SHIFT,7			; Shift right (Division)
	FSR_ptr	X_TMP_L			; Load FSR
	call		Shifter			; Execute shift

	btfss		Dir
	call		COM_XTEMP		; Get the 2's complement of teh TEMP register
SUM_Y								; Calulate Y(i+1)
	movf		X_TMP_H, W		
	addwf		Y_H, F
	movf		X_TMP_L, W
	addwf		Y_L, F
	btfsc		_C
	incf		Y_H, F

	btfss		Dir
	goto		ADD_Z

	movlw		HIGH Z_NstepH_tbl	
	movwf		PCLATH
 	movfw		ITERATION		; Fetch appropriate value from table
	call		Z_NstepH_tbl	
	addwf		Z_H, F
	movlw		HIGH Z_NstepL_tbl
	movwf		PCLATH
 	movfw		ITERATION
	call		Z_NstepL_tbl	
	addwf		Z_L, F
	btfsc		_C
	incf		Z_H, F
	goto		Rot_Loop_out

ADD_Z
	movlw		HIGH Z_stepL_tbl
	movwf		PCLATH
 	movfw		ITERATION
	call		Z_stepH_tbl
	addwf		Z_H, F
	movlw		HIGH Z_stepH_tbl
	movwf		PCLATH
 	movfw		ITERATION
	call		Z_stepL_tbl
	addwf		Z_L, F
	btfsc		_C
	incf		Z_H, F

Rot_Loop_out
	incf		ITERATION,f
	btfsc		ITERATION,3
	return
	goto		Rotation_loop
	GLOBAL	SINCOS

COM_YTEMP
	comf		Y_TMP_L, F		; Complememt Y_TMP
	comf		Y_TMP_H, F
	movlw		01H
	addwf		Y_TMP_L, F
	btfsc		_C
	incf		Y_TMP_H, F
	return 
COM_XTEMP
	comf		X_TMP_L, F		; Complememt X_TMP
	comf		X_TMP_H, F
	movlw		01H
	addwf		X_TMP_L, F
	btfsc		_C
	incf		X_TMP_H, F
	return

Shifter							; Function for shifting 16bit signed REG i times 
	banksel	SHIFT				;  left/right MUL/DIV
	movfw		SHIFT				; INPUTS: FSR & IRP are pointing to LOW REG
	andlw		0x0F				; SHIFT = d000 XXXX where XXXX = # of shifts 
	btfsc		_Z					; 	and d = dir of shift
	return						; check for zero interations
	movwf		Counter1
	btfss		SHIFT,0x7
	goto		MUL
DIV
	rrf		INDF, F			; Divide INDF/2 INDF --> low byte
	bcf		INDF, 7
	decf 		FSR, F
	rrf		INDF, F	 
	incf 		FSR, F
	btfsc		_C
	bsf		INDF, 7			; Carry from the upper byte to the lower byte
	decf 		FSR, F
	bcf		INDF, 7			; Check to see if TEMP should be a positive number
	btfsc		INDF, 6
	bsf		INDF, 7			; Was a negative number, force it negative again 
	incf 		FSR, F
	decfsz	Counter1, F
	goto		DIV
	return
MUL
	bcf		_C
	rlf		INDF, F
	decf 		FSR, F
	rlf		INDF, F
	bcf		INDF, 7
	btfsc		_C
	bsf		INDF, 7
	incf 		FSR, F
	decfsz	Counter1, F
	goto		MUL
	return
	GLOBAL	Shifter

	END
