
' Autodemo
' 16F873A
' ****************************** Initialize Hardware *********************************************
trisc = %10111111       							' Set TX (PortC.6) to out, rest in
spbrg = 25            								' Set baud rate to 9600  25 AT 4 MHZ/64 at 10 MHZ
rcsta = %10010000       							' Enable serial port and continuous receive
txsta = %00100100       							' Enable transmit and asynchronous mode/brgh = 1
intcon = %11000000									' Enable GIE & PEIE interrupt bits for USART interrupt
'***************************** Declarations *******************************************
random_delay var word								' Delay for dataout
control_byte var byte								' Control bytes from Pc
datain1 var word									' Data 
status_bits var byte								' Status bits to Pc
serial_delay var word								' Delay to output serial data
Xmit_Start var bit									' Start serial data transmission
ID var byte											' Identifier byte 
'**************************** Presets ***************************************************
random_delay = 0									' Delay for dataout
control_byte = 0									' Control bytes from Pc				
datain1 = 0											' Data 
status_bits = 0										' Status bits to Pc							
serial_delay = 0									' Delay to output serial data
Xmit_Start = 0										' Start serial data transmission
ID = 66												' Set ID number
' **************************** Interrupt Setup ****************************************
INCLUDE "DT_INTS-14.bas"     					' Base Interrupt System
INCLUDE "ReEnterPBP.bas"     					' Include if using PBP interrupts

ASM
INT_LIST  macro    ; IntSource,   Label,  Type, ResetFlag?
        INT_Handler    RX_INT,  _RxData,   PBP,  yes
    endm
    INT_CREATE               ; Creates the interrupt processor
ENDASM

@   INT_ENABLE   RX_INT     ; enable external (INT) interrupts

'********************************* Main Program *****************************************
Main:
	' Signals from pc 
	if control_byte = 49 then 
		status_bits.2 = 1
		status_bits.5 = 1
	endif 	
	if control_byte = 50 then 
		status_bits.7 = 1
		status_bits.4 = 1
	endif 	
	if control_byte = 51 then 
		status_bits.7 = 0
		status_bits.2 = 0
		status_bits.5 = 0
		status_bits.4 = 0
	endif
	' Data out delay
	random_delay = random_delay + 1
	if random_delay = 2000 then
		datain1 = datain1 + 22
		if datain1 > 6000 then
			datain1 = 10
		endif
		random_delay = 0
	endif 
	' Xmit Start signal from interface begins serial data out
	if Xmit_Start = 0 then Main								
	gosub Dataout											
goto Main

' ******************************** Serial Output To Pc *************************
DataOut:
	serial_delay = serial_delay + 1
	if serial_delay > 1000 then 
		' Serial output to PC
		hserout [ID,status_bits,datain1.highbyte,datain1.lowbyte]	
		serial_delay = 0
	endif
	return

' ************************* Serial Port Rx Interrupt ********************************************
RxData:
	' Wait for MX ;receive a string of characters
	hserin 1000,RxTimeOut,[wait("MX"),control_byte]
	' Start serial data out 
	if control_byte = 56 then Xmit_Start = 1	    
	' Stop serial data out 
	if control_byte = 57 then Xmit_Start = 0	    
RxTimeOut:
@ INT_RETURN


