
; PICBASIC PRO(TM) Compiler 2.47, (c) 1998, 2006 microEngineering Labs, Inc. All Rights Reserved.  
MPASMWIN_USED			EQU	1

	INCLUDE	"C:\PICBASIC\16F873A.INC"


; Define statements.
#define		CODE_SIZE		 4
#define		INTHAND		  INT_ENTRY
#define		ReEnterUsed		  1

RAM_START       		EQU	00020h
RAM_END         		EQU	000FFh
RAM_BANKS       		EQU	00002h
BANK0_START     		EQU	00020h
BANK0_END       		EQU	0007Fh
BANK1_START     		EQU	000A0h
BANK1_END       		EQU	000FFh
EEPROM_START    		EQU	02100h
EEPROM_END      		EQU	0217Fh

wsave           		EQU	RAM_START + 000h
R0              		EQU	RAM_START + 001h
R1              		EQU	RAM_START + 003h
R2              		EQU	RAM_START + 005h
R3              		EQU	RAM_START + 007h
R4              		EQU	RAM_START + 009h
R5              		EQU	RAM_START + 00Bh
R6              		EQU	RAM_START + 00Dh
R7              		EQU	RAM_START + 00Fh
R8              		EQU	RAM_START + 011h
_RetAddr         		EQU	RAM_START + 013h
FLAGS           		EQU	RAM_START + 015h
fsave           		EQU	RAM_START + 016h
GOP             		EQU	RAM_START + 017h
psave           		EQU	RAM_START + 018h
RM1             		EQU	RAM_START + 019h
RM2             		EQU	RAM_START + 01Ah
RR1             		EQU	RAM_START + 01Bh
RR2             		EQU	RAM_START + 01Ch
ssave           		EQU	RAM_START + 01Dh
_datain1         		EQU	RAM_START + 01Eh
_R0_Save         		EQU	RAM_START + 020h
_R1_Save         		EQU	RAM_START + 022h
_R2_Save         		EQU	RAM_START + 024h
_R3_Save         		EQU	RAM_START + 026h
_R4_Save         		EQU	RAM_START + 028h
_R5_Save         		EQU	RAM_START + 02Ah
_R6_Save         		EQU	RAM_START + 02Ch
_R7_Save         		EQU	RAM_START + 02Eh
_R8_Save         		EQU	RAM_START + 030h
_random_delay    		EQU	RAM_START + 032h
_serial_delay    		EQU	RAM_START + 034h
_T1_Save         		EQU	RAM_START + 036h
_T2_Save         		EQU	RAM_START + 038h
_T3_Save         		EQU	RAM_START + 03Ah
_T4_Save         		EQU	RAM_START + 03Ch
_control_byte    		EQU	RAM_START + 03Eh
_Flags_Save      		EQU	RAM_START + 03Fh
_GOP_Save        		EQU	RAM_START + 040h
_ID              		EQU	RAM_START + 041h
PB01            		EQU	RAM_START + 042h
_RM1_Save        		EQU	RAM_START + 043h
_RM2_Save        		EQU	RAM_START + 044h
_RR1_Save        		EQU	RAM_START + 045h
_RR2_Save        		EQU	RAM_START + 046h
_RS1_Save        		EQU	RAM_START + 047h
_RS2_Save        		EQU	RAM_START + 048h
_status_bits     		EQU	RAM_START + 049h
wsave1          		EQU	RAM_START + 080h
_PORTL           		EQU	 PORTB
_PORTH           		EQU	 PORTC
_TRISL           		EQU	 TRISB
_TRISH           		EQU	 TRISC
_datain1??HIGHBYTE		EQU	_datain1 + 001h
_datain1??LOWBYTE		EQU	_datain1
#define _Xmit_Start      	 PB01, 002h
#define _Serviced        	 PB01, 000h
#define _VarsSaved       	 PB01, 001h
#define _status_bits??2  	_status_bits, 002h
#define _status_bits??5  	_status_bits, 005h
#define _status_bits??7  	_status_bits, 007h
#define _status_bits??4  	_status_bits, 004h
	INCLUDE	"AUTODEMO.MAC"
	INCLUDE	"C:\PICBASIC\PBPPIC14.LIB"

	MOVE?CB	0BFh, TRISC
	MOVE?CB	019h, SPBRG
	MOVE?CB	090h, RCSTA
	MOVE?CB	024h, TXSTA
	MOVE?CB	0C0h, INTCON
	MOVE?CW	000h, _random_delay
	MOVE?CB	000h, _control_byte
	MOVE?CW	000h, _datain1
	MOVE?CB	000h, _status_bits
	MOVE?CW	000h, _serial_delay
	MOVE?CT	000h, _Xmit_Start
	MOVE?CB	042h, _ID

	ASM?

asm = 0
ASM = 0
pbp = 1
PBP = 1
YES = 1
yes = 1
NO = 0
no = 0


	ENDASM?


	ASM?

  #define INT_INT   INTCON,INTF     ;-- INT External Interrupt
  #define RBC_INT   INTCON,RBIF     ;-- RB Port Change Interrupt
  #define TMR0_INT  INTCON,T0IF     ;-- TMR0 Overflow Interrupt 16F
  #define TMR1_INT  PIR1,TMR1IF     ;-- TMR1 Overflow Interrupt
  #define TMR2_INT  PIR1,TMR2IF     ;-- TMR2 to PR2 Match Interrupt
  #define TX_INT    PIR1,TXIF       ;-- USART Transmit Interrupt
  #define RX_INT    PIR1,RCIF       ;-- USART Receive Interrupt
  #define CMP_INT   PIR2,CMIF       ;-- Comparator Interrupt
  #define EE_INT    PIR2,EEIF       ;-- EEPROM/FLASH Write Operation Interrupt
  #define BUS_INT   PIR2,BCLIF      ;-- Bus Collision Interrupt
  #define PSP_INT   PIR1,PSPIF      ;-- Parallel Slave Port Read/Write Interrupt
  #define AD_INT    PIR1,ADIF       ;-- A/D Converter Interrupt
  #define SSP_INT   PIR1,SSPIF      ;-- Master Synchronous Serial Port Interrupt
  #define CCP1_INT  PIR1,CCP1IF     ;-- CCP1 Interrupt
  #define CCP2_INT  PIR2,CCP2IF     ;-- CCP2 Interrupt



	ENDASM?


	ASM?

INT_Source  macro  IFR, IFB, IER, IEB
    if ((IflagReg == IFR) && (IflagBit == IFB))
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
Found = YES
    endif
;  nolist  
    endm 


	ENDASM?


	ASM?

;-------------------------------------------------------------------------------
GetIntInfo  macro  IflagReg, IflagBit

Found = NO
; nolist
  ifdef INTF    ;----{ INT External Interrupt }----------------[INTCON, INTF]---
      INT_Source  INTCON, INTF, INTCON, INTE
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }--------------[INTCON, RBIF]---
      INT_Source  INTCON, RBIF, INTCON, RBIE
  endif
  ifdef T0IF    ;----{ TMR0 Overflow Interrupt }-------------[INTCON, TMR0IF]---
      INT_Source  INTCON, T0IF, INTCON, T0IE
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }---------------[PIR1, TMR1IF]---
      INT_Source  PIR1, TMR1IF, PIE1, TMR1IE
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }-----------[PIR1, TMR2IF]---
      INT_Source  PIR1, TMR2IF, PIE1, TMR2IE
  endif
  ifdef TXIF    ;----{ USART Transmit Interrupt }----------------[PIR1, TXIF]---
      INT_Source  PIR1, TXIF, PIE1, TXIE
  endif
  ifdef RCIF    ;----{ USART Receive Interrupt }------------------[PIR1 RCIF]---
          INT_Source  PIR1, RCIF, PIE1, RCIE
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }--------------------[PIR2, CMIF]---
      ifdef PIR2
          INT_Source  PIR2, CMIF, PIE2, CMIE
      else
          INT_Source  PIR1, CMIF, PIE1, CMIE
      endif
  endif
  ifdef EEIF    ;---{ EEPROM/FLASH Write Operation Interrupt }---[PIR2, EEIF]---
      ifdef PIR2
          INT_Source  PIR2, EEIF, PIE2, EEIE
      else
          INT_Source  PIR1, EEIF, PIE1, EEIE
      endif
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }----------------[PIR2, BCLIF]---
      INT_Source  PIR2, BCLIF, PIE2, BCLIE
  endif
  ifdef PSPIF   ;--{ Parallel Slave Port Read/Write Interrupt }--[PIR1, PSPIF]--
      INT_Source  PIR1, PSPIF, PIE1, PSPIE
  endif
  ifdef ADIF   ;----{ A/D Converter Interrupt }------------------[PIR1, ADIF]---
      INT_Source  PIR1, ADIF, PIE1, ADIE
  endif
  ifdef SSPIF  ;----{ Master Synchronous Serial Port Interrupt }--[PIR1, SSPIF]-
      INT_Source  PIR1, SSPIF, PIE1, SSPIE
  endif
  ifdef CCP1IF ;----{ CCP1 Interrupt }-------------------------[PIR1, CCP1IF]---
      INT_Source  PIR1, CCP1IF, PIE1, CCP1IE
  endif
  ifdef CCP2IF ;----{ CCP2 Interrupt Flag }--------------------[PIR2, CCP2IF]---
      INT_Source  PIR2, CCP2IF, PIE2, CCP2IE
  endif
    
  list
    endm
  list  


	ENDASM?


	ASM?

;---[Returns the Address of a Label as a Word]----------------------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[find correct bank for a BIT variable]--------------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    
;---[This creates the main Interrupt Service Routine (ISR)]---------------------
INT_CREATE  macro
  local OverCREATE
    goto OverCREATE
INT_ENTRY  
    IF (CODE_SIZE <= 2)
        movwf   wsave       ; 1 copy W to wsave register
        swapf   STATUS,W    ; 2 swap status reg to be saved into W
        clrf    STATUS      ; 3 change to bank 0 regardless of current bank
        movwf   ssave       ; 4 save status reg to a bank 0 register
        movf    PCLATH,W    ; 5 move PCLATH reg to be saved into W reg
        movwf   psave       ; 6 save PCLATH reg to a bank 0 register
    EndIF
    movf      FSR,W         ; 7 move FSR reg to be saved into W reg
    movwf     fsave         ; 8 save FSR reg to a bank 0 register
;    clrf    STATUS          ; BANK 0
PREV_BANK = 0

List_Start
    RST?RP
    CHKRP?T  _Serviced
    bcf      _Serviced

    INT_LIST                ; Expand the users list of interrupt handlers
                            ; INT_LIST macro must be defined in main program
    
    CHKRP?T  _Serviced
    btfsc    _Serviced
    goto List_Start

    ifdef ReEnterUsed       ; if ReEnterPBP.bas was included in the main program
        CHKRP?T  _VarsSaved
        btfss    _VarsSaved   ; if PBP system vars have been saved 
        goto     INT_EXIT
        GetAddress  INT_EXIT, _RetAddr
        L?GOTO   _RestorePBP   ; Restore PBP system Vars
    endif
    
INT_EXIT
    clrf    STATUS          ; BANK 0
PREV_BANK = 0
    MOVF    fsave,W         ; Restore the FSR reg
    MOVWF   FSR
    Movf    psave,w         ; Restore the PCLATH reg
    Movwf   PCLATH
    swapf   ssave,w         ; Restore the STATUS reg
    movwf   STATUS
    swapf   wsave,f
    swapf   wsave,w         ; Restore W reg
    Retfie                  ; Exit the interrupt routine

OverCREATE
    bsf      INTCON, 6      ; Enable Peripheral interrupts
    bsf      INTCON, 7      ; Enable Global interrupts
    endm
    


	ENDASM?


	ASM?

;---[Add an Interrupt Source to the user's list of INT Handlers]----------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterRestore, NoInt
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            CLRWDT
            CHK?RP   INT_Enable_Reg
            btfss    INT_Enable_Reg, INT_Enable_Bit  ; if the INT is enabled
            goto   NoInt
            CHK?RP   INT_Flag_Reg                    
            btfss    INT_Flag_Reg, INT_Flag_Bit      ; and the Flag set?
            goto     NoInt
    CHKRP?T  _Serviced
    bsf      _Serviced
            
            if (Type == PBP)                         ; If INT handler is PBP
                ifdef ReEnterUsed
                    GetAddress  AfterSave, _RetAddr  
                    L?GOTO  _SavePBP                 ; Save PBP system Vars
AfterSave                    
                    clrf    STATUS
PREV_BANK = 0
                else
                    error ReEnterPBP must be INCLUDEd to use PBP interrupts
                endif
            endif
            GetAddress  AfterRestore, _RetAddr       ; save return address
            L?GOTO   Label                           ; goto the users INT handler
AfterRestore
            clrf   STATUS
PREV_BANK = 0            
            if (Reset == YES)
                CHK?RP   INT_Flag_Reg
                bcf      INT_Flag_Reg, INT_Flag_Bit ; reset flag (if specified)
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
        clrf   STATUS
PREV_BANK = 0        
    endm

;---[Returns from a "goto" subroutine]------------(RetAddr must be set first)---
INT_RETURN  macro
      CHK?RP  _RetAddr
      movf    _RetAddr + 1, W  ; Set PCLATH with top byte of return address
      movwf   PCLATH
      movf    _RetAddr, W      ; Go back to where we were
      movwf   PCL
    endm    
    
;---[Enable an interrupt source]------------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Flag_Reg
          bcf     INT_Flag_Reg, INT_Flag_Bit        ; clear the flag first 
          CHK?RP  INT_Enable_Reg
          bsf     INT_Enable_Reg, INT_Enable_Bit    ; enable the INT source  
      else
          error Cannot Enable (IntFlagReg,IntFlagBit)
      endif
    endm    

;---[Disable an interrupt source]-----------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Enable_Reg
          bcf     INT_Enable_Reg, INT_Enable_Bit    ; disable the INT source  
      else
          error Cannot Disable (IntFlagReg,IntFlagBit)
      endif
    endm    

;---[Clear an interrupt Flag]---------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          CHK?RP  INT_Flag_Reg
          bcf     INT_Flag_Reg, INT_Flag_Bit       ; clear the INT flag
      else
          error Cannot CLEAR (IntFlagReg,IntFlagBit)
      endif
    endm



	ENDASM?

	MOVE?CT	000h, _VarsSaved
	GOTO?L	_OverReEnter

	LABEL?L	_SavePBP	
	CMPNE?TCL	_VarsSaved, 000h, L00002
	MOVE?WW	R0, _R0_Save
	MOVE?WW	R1, _R1_Save
	MOVE?WW	R2, _R2_Save
	MOVE?WW	R3, _R3_Save
	MOVE?WW	R4, _R4_Save
	MOVE?WW	R5, _R5_Save
	MOVE?WW	R6, _R6_Save
	MOVE?WW	R7, _R7_Save
	MOVE?WW	R8, _R8_Save
	MOVE?BB	FLAGS, _Flags_Save
	MOVE?BB	GOP, _GOP_Save
	MOVE?BB	RM1, _RM1_Save
	MOVE?BB	RM2, _RM2_Save
	MOVE?BB	RR1, _RR1_Save
	MOVE?BB	RR2, _RR2_Save

	ASM?

        ifdef RS1
            MOVE?BB    RS1, _RS1_Save    ; 2/50
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_Save    ; 2/52
        endif

        ifdef T1
            MOVE?WW    T1, _T1_Save    ; 4/56
        endif
        ifdef T2
            MOVE?WW    T2, _T2_Save    ; 4/60
        endif
        ifdef T3
            MOVE?WW    T3, _T3_Save    ; 4/64
        endif
        ifdef T4
            MOVE?WW    T4, _T4_Save    ; 4/68    Save Delay = 68us @4mhz
        endif                          ;                    13.6us @20mhz
    

	ENDASM?

	MOVE?CT	001h, _VarsSaved
	LABEL?L	L00002	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_RestorePBP	
	CMPNE?TCL	_VarsSaved, 001h, L00004
	MOVE?WW	_R0_Save, R0
	MOVE?WW	_R1_Save, R1
	MOVE?WW	_R2_Save, R2
	MOVE?WW	_R3_Save, R3
	MOVE?WW	_R4_Save, R4
	MOVE?WW	_R5_Save, R5
	MOVE?WW	_R6_Save, R6
	MOVE?WW	_R7_Save, R7
	MOVE?WW	_R8_Save, R8
	MOVE?BB	_Flags_Save, FLAGS
	MOVE?BB	_GOP_Save, GOP
	MOVE?BB	_RM1_Save, RM1
	MOVE?BB	_RM2_Save, RM2
	MOVE?BB	_RR1_Save, RR1
	MOVE?BB	_RR2_Save, RR2

	ASM?

        ifdef RS1
            MOVE?BB     _RS1_Save, RS1
        endif
        ifdef RS2
            MOVE?BB     _RS2_Save, RS2
        endif
        ifdef T1
            MOVE?WW     _T1_Save, T1
        endif
        ifdef T2
            MOVE?WW    _T2_Save, T2
        endif
        ifdef T3
            MOVE?WW    _T3_Save, T3
        endif
        ifdef T4
            MOVE?WW    _T4_Save, T4
        endif
;        ifdef T5
;            ERROR "Temp variables exceeding T4"
;        endif
    

	ENDASM?

	MOVE?CT	000h, _VarsSaved
	LABEL?L	L00004	

	ASM?
 INT_RETURN

	ENDASM?


	LABEL?L	_OverReEnter	

	ASM?

INT_LIST  macro    ; IntSource,   Label,  Type, ResetFlag?
        INT_Handler    RX_INT,  _RxData,   PBP,  yes
    endm
    INT_CREATE               ; Creates the interrupt processor


	ENDASM?


	ASM?
   INT_ENABLE   RX_INT     ; enable external (INT) interrupts

	ENDASM?


	LABEL?L	_Main	
	CMPNE?BCL	_control_byte, 031h, L00006
	MOVE?CT	001h, _status_bits??2
	MOVE?CT	001h, _status_bits??5
	LABEL?L	L00006	
	CMPNE?BCL	_control_byte, 032h, L00008
	MOVE?CT	001h, _status_bits??7
	MOVE?CT	001h, _status_bits??4
	LABEL?L	L00008	
	CMPNE?BCL	_control_byte, 033h, L00010
	MOVE?CT	000h, _status_bits??7
	MOVE?CT	000h, _status_bits??2
	MOVE?CT	000h, _status_bits??5
	MOVE?CT	000h, _status_bits??4
	LABEL?L	L00010	
	ADD?WCW	_random_delay, 001h, _random_delay
	CMPNE?WCL	_random_delay, 007D0h, L00012
	ADD?WCW	_datain1, 016h, _datain1
	CMPLE?WCL	_datain1, 01770h, L00014
	MOVE?CW	00Ah, _datain1
	LABEL?L	L00014	
	MOVE?CW	000h, _random_delay
	LABEL?L	L00012	
	CMPEQ?TCL	_Xmit_Start, 000h, _Main
	GOSUB?L	_Dataout
	GOTO?L	_Main

	LABEL?L	_Dataout	
	ADD?WCW	_serial_delay, 001h, _serial_delay
	CMPLE?WCL	_serial_delay, 003E8h, L00016
	HSEROUT?B	_ID
	HSEROUT?B	_status_bits
	HSEROUT?B	_datain1??HIGHBYTE
	HSEROUT?B	_datain1??LOWBYTE
	MOVE?CW	000h, _serial_delay
	LABEL?L	L00016	
	RETURN?	

	LABEL?L	_RxData	
	HSERINTIME?C	003E8h

	LABEL?L	L00001	
	HSERINWAIT?CLL	04Dh, L00001, _RxTimeOut
	HSERINWAIT?CLL	058h, L00001, _RxTimeOut
	HSERIN?BL	_control_byte, _RxTimeOut
	CMPNE?BCL	_control_byte, 038h, L00018
	MOVE?CT	001h, _Xmit_Start
	LABEL?L	L00018	
	CMPNE?BCL	_control_byte, 039h, L00020
	MOVE?CT	000h, _Xmit_Start
	LABEL?L	L00020	

	LABEL?L	_RxTimeOut	

	ASM?
 INT_RETURN

	ENDASM?


	END
