
    ' Slave PIC
    ' =========
    '
    ' File name : SlavePic.bas
    ' Company : Mister E 
    ' Programmer : Steve Monfette
    ' Date : 04/02/2005
    ' Device : PIC16F628


    ' This program will display on PORTB the data coming from the slave
    ' only if the SelectSlave setting match to the master SlaveSetting
  
    ' PIC programming mode
    ' ====================
    '
@ __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _PWRTE_ON & _MCLRE_OFF & _LVP_OFF & _BODEN_ON 
    ' Internal Oscillator
    ' Enable watch dog timer
    ' Enable power up timer
    ' Disable MCLR pin
    ' Disable low voltage programming
    ' Enable brown out detect
    
    ' Hardware setting
    ' ================
    '
    TRISB = 0         ' Set PORTB as output on all pins
    TRISA = 255       ' Set PORTA as input on all pins

    CMCON = 7         ' Disable analog comparator
    
    ' Variable, Constant & Alias definition
    ' =====================================
    '
    SerialInput     var     PORTA.3
    SlaveSelect     var     BYTE
    DataToDisplay   var     byte
    
    T2400           con     396 ' Baudrate Variable for
                                ' 2400 Bauds
                                ' True driven mode
    
    ' Main Program
    ' ============
    '
Start :

    SlaveSelect=PORTA & $07  ' Get the Slave Select by masking
                             ' PORTA<3:0>

    ' wait for the right header
    ' =========================
    '
    serin2 serialinput,t2400,[WAIT ("SLAVE",slaveselect),datatodisplay]                

    ' Once we have the right header, display on PORTB
    ' ===============================================
    '
    PORTB = datatodisplay
    goto Start
